<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<!-- can't use 3.2 since we can't do without the "archive" element for applets, and for some reason the w3c validator no longer does 4.0 transitional, so... -->
<?php
    $width = 512;
    $height = 512;
    $symbol = "7^3"; # default to use
    $Symbol = "(3,6,6,6)^1 (0 1)[2](3)"; # default form input value
    $drawPrimal = "true";
    $drawDual = "true";
    $drawSnub = "false";
    $maxIsometries = 500;
    if (isset($HTTP_GET_VARS['size']))
    {
        # XXX can't handle non-square yet
        $width = $height = $HTTP_GET_VARS['size'];
    }
    if (isset($HTTP_GET_VARS['symbol']))
    {
        $symbol = $HTTP_GET_VARS['symbol'];
        $Symbol = $HTTP_GET_VARS['symbol'];
    }
    if (isset($HTTP_GET_VARS['maxIsometries']))
    {
        $maxIsometries = $HTTP_GET_VARS['maxIsometries'];
    }
    if (isset($HTTP_GET_VARS['drawPrimal']))
    {
        $drawSnub = $HTTP_GET_VARS['drawPrimal'];
    }
    if (isset($HTTP_GET_VARS['drawDual']))
    {
        $drawSnub = $HTTP_GET_VARS['drawDual'];
    }
    if (isset($HTTP_GET_VARS['drawSnub']))
    {
        $drawSnub = $HTTP_GET_VARS['drawSnub'];
    }
?>
<html>
    <head>
        <title>
            Hyperbolic Tesselations Applet
        </title>
    </head>
    <body bgcolor="#CC9999">

        Hyperbolic Tesselations Applet
        <br>

        <applet
            code="HyperbolicApplet.class"
            archive="HyperbolicApplet.jar"
            codebase="."
            <?php print("width=$width height=$height\n"); ?>
            alt="Your browser understands Java but can't seem to run this applet, sorry."
        >
            <?php print("<param name=\"symbol\" value=\"$symbol\">\n"); ?>
            <?php print("<param name=\"drawPrimal\" value=\"$drawPrimal\">\n"); ?>
            <?php print("<param name=\"drawDual\" value=\"$drawDual\">\n"); ?>
            <?php print("<param name=\"drawSnub\" value=\"$drawSnub\">\n"); ?>
            <param name="eventVerbose" value="0">
            <param name="maxLevels" value="100">
            <?php print("<param name=\"maxIsometries\" value=\"$maxIsometries\">\n"); ?>
        </applet>

        <br>
        The following keys and mouse actions do interesting things:
        <br>
        (NOTE: you may have to click on the applet once before it will accept
        keyboard input.  On some browsers (mozilla) you may have to leave and re-enter the browser window.)
        <pre>
    What:
        'p' - increment p (number of sides of each polygon)
        'P' - decrement p
        'q' - increment q (number of polygons surrounding each vertex)
        'Q' - decrement q
        'o' - cycle operation through the following list:
                Truncate=0 (primal)
                Truncate=.5
                Truncate=1
                Truncate=1.5
                Truncate=2
                Truncate=2.5
                Truncate=3
                Truncate=3.5
                Truncate=4 (dual)
                halfway between dual and runcinated
                Runcinated
                halfway between runcinated and primal
                Omnitruncated
        'O' - cycle operation backwards through above list
        Right mouse - change to Omnitruncated and drag vertex around

        Ctrl-'p' : toggle drawing of primal (initially on)
        Ctrl-'d' : toggle drawing of dual (initially on)
        Ctrl-'s' : toggle drawing of snub (initially off) (only interesting when omnitruncated)
            Ctrl-Shift-'S' : switch handedness of snub
            Ctrl-'o' : move vertex so that snub is uniform

    Where:
        Left mouse drag - change orientation
        'r' - reset orientation

    How:
        'm' - toggle model between Poincare disk and Klein disk
        'i' - increment max isometries (how much to draw) by 10
                (Ctrl-'i' to increment by 1)
        'I' - decrement max isometries (how much to draw) by 10
                (Ctrl-Shift-'I' to decrement by 1)
        'u' - cycle quality/speed tradeoff:
                0: fast (straight segment approximations)
                1: fast when moving, good when stopped (default)
                2: good (properly curved segments)

    Debugging (stuff you don't care about):
        'V' - cycle event debug level (output to java console window).
        'B' - toggle double buffering
        'J' - toggle random jitter of each edge (to see what's getting drawn multiple times)
        'L' - cycle isometry labels style (off, label isometries, label arms)
        ' ' - just repaint

    New bleeding edge:
        Ctrl-'x': encapsulated postscript dump with black&white swapped
                  to file "PSDUMP.eps"
                  (only works when run locally, not as an applet in a browser)
        </pre>

        Soon to come:
        <ul>
            <li> antialiasing
            <li> resizable
            <li> friendly gui instead of these lame key controls
            <li> high-quality image or postscript dumps
            <li> filled and colored faces
        </ul>

        <hr>
        <h4>For experts:</h4>

        You can also specify a general uniform tiling,
        using a simplified version of the
        Burgiel/Conway/Goodman-Strauss (BCGS) orbifold symbol,
        which will be explained below.
        For example, here are three different tilings
        that all have the same list of faces
        around each vertex
        (a triangle and three hexagons):
        <ol>
            <?php
                foreach (array(
                    "(3,6,6,6)^1 [0][1][2][3]",   # good
                    "(3,6,6,6)^1 [0][1](2)(3)",   # good, different
                    "(3,6,6,6)^1 (0 1)[2](3)",    # good
                    ) as $s)
                {
                    $sencoded = ereg_replace(" ", "_", $s);
                    print("<li><a href=\"?symbol=$sencoded\"><tt>$s</tt></a>\n");
                }
            ?>
        </ol>
        Explanation of the notation:
        <ul>
            <li>
                The edges surrounding the central vertex
                are numbered 0,1,2,... counterclockwise with edge 0
                pointing to the left (unlike John Conway's
                drawings, which go clockwise with edge 0 pointing up).
            <li>
                The first part of the symbol ( <tt>(3,6,6,6)^1</tt> in the above
                examples) is the face list surrounding the vertex.
                The face between edges 0&amp;1 is listed first,
                then 1&amp;2, etc.  The list is repeated
                the number of times specified in the exponent;
                for example <tt>(6,7,8)^2</tt> would produce the following
                actual faces around a vertex: 6,7,8,6,7,8.
            <li>
                The second part of the symbol is a permutation
                of the edges (not including replication by the exponent),
                the purpose of which is to describe
                where each edge appears in the corresponding
                neighbor vertex's edge list.
                The permutation is specified by its
                cycles, each of which must be of length 1 or 2.
                For example, the permutation <tt>(0 3)(1)(2)</tt> would mean
                that 0 goes to 3, 3 goes to 0, and each of 1 and 2
                remains fixed.
                Each cycle is surrounded by either [] or ()
                according to whether the neighbor vertex
                along that edge is a mirror image or a rotated image
                of the central vertex.
            <li>
                Note that the "*" that appears in the
                BCGS orbifold symbol, denoting a mirror through the vertex,
                is not recognized;
                you must specify the full permutation on all the edges
                (not replicated by the exponent) instead.
            <li>
                You can use &lt;&gt; in the permutation part
                if you like (in the orbifold symbol,
                this represents an edge that is split along its length
                by a mirror symmetry, i.e. "both [] and ()").
                It is implemented as [].  (This only matters
                if it turns out that the tiling didn't really
                have all the symmetries implied by the &lt;&gt; after all.)
                <br>
                You may also put &lt;&gt; around one or two single entries
                in the face list if you like
                (to denote that a mirror through the vertex
                passes through the face).
                These are currently ignored by the program,
                but you might want to use them
                if you want to express all the symmetry information
                from the BCGS orbifold symbol.
            <li>
                Notes: An exponent of <tt>^1</tt> may be omitted.
                Cycles of length 1 surrounded by []
                may be omitted from the permutation.
                (In particular, if all edge-reversing reflections
                are isometries of the tiling, then the permutation part
                may be omitted entirely.)
                The right brackets or parens of the cycles may be omitted;
                this can be convenient when experimenting (it's easier
                to change one character than two).
                For example, "<tt>(3,6,6,6)^1 (0 1)[2](3)</tt>"
                may be abbreviated as either "<tt>(3,6,6,6) (0 1[2(3</tt>"
                or "<tt>(3,6,6,6) (0 1(3</tt>".
                Underscores may be used instead of spaces throughout
                (this can be useful if you are embedding this notation
                in a URL which is not allowed to contain space characters).

        </ul>
        <form method="get" action="">
            Okay, ready?  Enter your symbol below, and hit Enter:
            <br>
            <input type="text" name="symbol" size="30" value="<?php print("$Symbol");?>">
            <input type="submit" value="Enter">
        </form>

        <p>
        <ul>
            <li>
                Note: Some of the keyboard shortcuts listed
                earlier on this page will not work with these general
                (non-regular) uniform tilings.
                You will can still drag a vertex
                around using the right mouse button
                (giving a kaleidoscope-like effect),
                but only when the symbol is of the form (2a,2b,2c,...)
                (with no permutation part, meaning all the edge-reversing
                symmetries are reflections, as noted above)--
                this restriction is necessary in order to form the
                kaleidoscope.
                In this case the 'o' key has reduced functionality--
                it simply resets the kaleidoscoped vertex to its original (pre-dragged)
                position.
            <li>
                Some minimal sanity checking is done on the permutation
                (printing error messages to the Java console,
                which it is useful to have open),
                but mostly you're on your own.  If you mess up,
                you'll get a mess, or the program
                won't run at all.  To debug your symbol, you will
                probably want to reduce the number of vertices drawn,
                using the Shift-I and Ctrl-Shift-I keys as described above.
                It may also be helpful to use Shift-L, which
                causes labels to be placed
                on the isometries or arms in various ways.
        </ul>
        <!--


        <?php
            foreach (array(
                "[0][1][2][3]",   # good
                #"(0_1)[2][3]",    # good, but same as [0][1][2][3]
                #"[0][1](2_3)",    # good
                #"(0_1)(2_3)",     # good

                "[0][1](2)(3)",   # good, different
                #"(0_1)(2)(3)",    # good
                #"[0][1][2_3]",    # good
                #"(0_1)[2_3]",     # good

                "(0_1)[2](3)",    # good
                #"[0][1][2](3)",       # bad
                #"[0](1)[2][3]",       # bad
                #"[0](1)[2](3)",       # bad
                #"[0](1)(2)[3]",       # bad
                #"[0](1)(2)(3)",       # bad
                #"(0)(1)[2][3]",       # bad
                #"(0)(1)[2](3)",       # bad
                #"(0)(1)(2)(3)",       # bad
                #"[0_1][2][3]",       # bad
                #"[0_1][2](3)",       # bad
                #"[0_1](2)(3)",       # bad
                #"[0](1)[2_3]",       # bad
                #"(0)(1)[2_3]",       # bad
                #"[0](1)(2_3)",       # bad
                #"(0)(1)(2_3)",       # bad
                #"[0_1][2_3]",        # bad
                #"[0_1](2_3)",        # bad
                     ) as $s)
            {
                $symbol = "3,6,6,6^1_$s";
                print("<a href=\"?symbol=$symbol\">$symbol</a>\n");
                ?>
                    <applet
                        code="HyperbolicApplet.class"
                        archive="HyperbolicApplet.jar"
                        codebase="."
                        <?php print("            width=200 height=200\n"); ?>
                        alt="Your browser understands Java but can't seem to run this applet, sorry."
                    >
                        <?php print("            <param name=\"symbol\" value=\"$symbol\">\n"); ?>
                        <param name="eventVerbose" value="0">
                        <param name="maxLevels" value="100">
                        <?php print("            <param name=\"maxIsometries\" value=\"$maxIsometries\">\n"); ?>
                    </applet>
                    <br>
                <?php
            }
        ?>

        -->

        <hr>
        Download
        <a href="HyperbolicApplet.jar">source code</a>
        for this applet
        (compressed jar file contains class files and source)

        <hr>
        <table width="100%">  <!-- use full width of page -->
            <tr>
                <td align="left">
                    <?php include("../hitcounter.php"); ?>
                    <br>
                    Last Modified:
Mon Sep 20 04:26:54 PDT 2004
                    <address>
                    Don Hatch
                    <br>
                    <a href="mailto:hatch@plunk.org">hatch@plunk.org</a>
                    </address>
                <td align="right">
                        <!--
                        The original:
                            src="http://www.w3.org/Icons/valid-html40"
                        But netscape doesn't do png transparency right, so:
                            src="http://www.w3.org/Icons/valid-html40.gif"
                        -->
                    <a href="http://validator.w3.org/check/referer"><img
                        border="0"
                        src="../images/valid-html40.gif"
                        alt="Valid HTML 4.0!" height="31" width="88"></a>
        </table>

        <center>
            <font size=-1>
                <a href="http://www.plunk.org/~hatch/">
                    Back to Don Hatch's home page.
                </a>
            </font>
        </center>

    </body>
</html>
