/*
 * Decompiled with CFR 0.152.
 */
public class PickableSchwarzPolygon {
    public Complex[] SchwarzPolygon = null;

    public void setVertices(double[][] vertices, Isometry2 I) {
        if (vertices == null) {
            this.SchwarzPolygon = null;
        } else {
            int n = vertices.length;
            this.SchwarzPolygon = new Complex[n];
            int i = 0;
            while (i < n) {
                this.SchwarzPolygon[i] = I.apply(new Complex(vertices[i][0], vertices[i][1]));
                ++i;
            }
        }
    }

    public void setVerticesFromDoubles(Complex[] vertices, Isometry2 I) {
        if (vertices == null) {
            this.SchwarzPolygon = null;
        } else {
            int n = vertices.length;
            this.SchwarzPolygon = new Complex[n];
            int i = 0;
            while (i < n) {
                this.SchwarzPolygon[i] = I.apply(vertices[i]);
                ++i;
            }
        }
    }

    public boolean pick(Complex p, Isometry2 return_IsometryThatSendsPointInsideSchwarzPolygon, int verbose, int[] return_nFlips) {
        Isometry2 curI = Isometry2.identity;
        Complex curP = p;
        if (verbose >= 1) {
            System.out.println("    Trying to send point " + curP + " to inside schwarz polygon " + this);
        }
        int n = this.SchwarzPolygon.length;
        double eps = 1.0E-6;
        if (HyperbolicUtils.pointIsToRightSideOfLinePoincare(this.SchwarzPolygon[2], this.SchwarzPolygon[0], this.SchwarzPolygon[1], eps)) {
            Arrays.reverse(this.SchwarzPolygon, this.SchwarzPolygon);
        }
        Isometry2[] reflections = new Isometry2[n];
        int totalIterationsLimit = 200;
        int nInside = 0;
        int totalFlips = 0;
        int i = 0;
        int totalIterations = 0;
        while (totalIterations < totalIterationsLimit) {
            if (HyperbolicUtils.pointIsToRightSideOfLinePoincare(curP, this.SchwarzPolygon[i], this.SchwarzPolygon[(i + 1) % n], eps)) {
                if (verbose >= 1) {
                    System.out.println("            outside side " + i);
                }
                if (reflections[i] == null) {
                    reflections[i] = Isometry2.reflectionAcrossLine(this.SchwarzPolygon[i], this.SchwarzPolygon[(i + 1) % n]);
                }
                Isometry2 incI = reflections[i];
                curI = Isometry2.mul(incI, curI);
                curP = incI.apply(curP);
                if (verbose >= 1) {
                    System.out.println("        -> " + curP);
                }
                ++totalFlips;
                nInside = 0;
            } else {
                if (verbose >= 3) {
                    System.out.println("            inside side " + i);
                }
                if (++nInside == n) {
                    if (verbose >= 1) {
                        System.out.println("        got it! (iteration " + totalIterations + ")\n");
                    }
                    return_IsometryThatSendsPointInsideSchwarzPolygon.set(curI);
                    if (return_nFlips != null) {
                        return_nFlips[0] = totalFlips;
                    }
                    return true;
                }
            }
            i = (i + 1) % n;
            ++totalIterations;
        }
        System.out.println("        ARGH! pick reached " + totalIterations + " iterations");
        return false;
    }

    public String toString() {
        String s = "[";
        int n = this.SchwarzPolygon.length;
        int i = 0;
        while (i < n) {
            s = s + '(' + this.SchwarzPolygon[i].x + ',' + this.SchwarzPolygon[i].y + ')';
            if (i + 1 < n) {
                s = s + ", ";
            }
            ++i;
        }
        s = s + ']';
        return s;
    }
}

