/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PSMyGraphics
extends MyGraphics {
    private PrintWriter writer;
    private Color currentColor;
    private boolean inPath;
    private Dimension gsize;
    private double scaleX;
    private double scaleY;
    private double translateX;
    private double translateY;
    public int verbose;

    private final void writePrologue() {
        String dateString = new SimpleDateFormat("EEE MMM dd H:MM:ss yyyy").format(new Date());
        this.writer.println("%!PS-Adobe-2.0 EPSF-2.0");
        this.writer.println("%%Title: template");
        this.writer.println("%%Creator: HyperbolicApplet Version foo Patchlevel bar");
        this.writer.println("%%CreationDate: " + dateString);
        this.writer.println("%%For: rdlyons@probable.math.indiana.edu (Russell Lyons)");
        this.writer.println("%%BoundingBox: 0 0 421 421");
        this.writer.println("%%Magnification: 1.0000");
        this.writer.println("%%EndComments");
        this.writer.println();
        this.writer.println();
        this.writer.println("/n {newpath} bind def");
        this.writer.println("/s {stroke} bind def");
        this.writer.println("/m {moveto} bind def");
        this.writer.println("/l {lineto} bind def");
        this.writer.println("/a {arc} bind def");
        this.writer.println();
        this.writer.println("421 2 div 421 2 div translate");
        this.writer.println(".5  420 2 div  div setlinewidth");
        this.writer.println("420 2 div 420 2 div scale");
        this.writer.println();
        this.writer.println("% We are now in a local coordinate system");
        this.writer.println("% in which the circle will be centered at 0,0 and have radius 1.");
    }

    public void fillWindow() {
        this.endPathIfInPath();
        this.writer.println("n -1.1 -1.1 m 1.1 -1.1 l 1.1 1.1 l -1.1 1.1 l fill s  % fill background");
    }

    public void drawLineNonClipped(double x0, double y0, double x1, double y1, boolean antiAlias) {
        this.newPathIfNotInPath();
        this.writer.println("" + (float)(x0 * this.scaleX + this.translateX) + ' ' + (float)(y0 * this.scaleY + this.translateY) + " m " + (float)(x1 * this.scaleX + this.translateX) + ' ' + (float)(y1 * this.scaleY + this.translateY) + " l");
    }

    public void drawPoint(double x, double y, int nPixels) {
        int x0 = (int)(x * this.scaleX + this.translateX - 0.5 * (double)nPixels);
        int y0 = (int)(y * this.scaleY + this.translateY - 0.5 * (double)nPixels);
        if (this.verbose >= 2) {
            System.out.println("in drawPoint(" + x + ',' + y + ',' + nPixels + ") -> " + x0 + ',' + y0);
        }
        if (x0 < -nPixels || x0 > this.gsize.width + nPixels || y0 < -nPixels || y0 > this.gsize.width + nPixels) {
            return;
        }
        throw new Error("Assertion failed at PSMyGraphics.prejava(141): false");
    }

    public void drawString(String s, double x, double y) {
        throw new Error("Assertion failed at PSMyGraphics.prejava(149): false");
    }

    public void drawString(String s, double x, double y, double xJustify, double yJustify) {
        throw new Error("Assertion failed at PSMyGraphics.prejava(174): false");
    }

    public double getFontHeight() {
        throw new Error("Assertion failed at PSMyGraphics.prejava(183): false");
    }

    public void smartDrawArcNonClipped(double focusX, double focusY, double focusAngleRadians, double c, double start, double end, boolean antiAlias) {
        if (c > 1.0E-5) {
            double r = 1.0 / c;
            double centerX = focusX - r * Math.cos(focusAngleRadians);
            double centerY = focusY - r * Math.sin(focusAngleRadians);
            double endRadians = focusAngleRadians + end * c;
            double startRadians = focusAngleRadians + start * c;
            if (endRadians < startRadians) {
                double temp = startRadians;
                startRadians = endRadians;
                endRadians = temp;
            }
            this.endPathIfInPath();
            this.writer.println("n " + (float)centerX + ' ' + (float)centerY + ' ' + (float)r + ' ' + (float)(startRadians * 57.29577951308232) + ' ' + (float)(endRadians * 57.29577951308232) + " a s");
            return;
        }
        double cosFocusAngle = Math.cos(focusAngleRadians);
        double sinFocusAngle = Math.sin(focusAngleRadians);
        double[][] normalAndTangent = new double[][]{{cosFocusAngle, sinFocusAngle}, {-sinFocusAngle, cosFocusAngle}};
        double[] point = new double[2];
        double[] scratch = new double[2];
        PSMyGraphics.findPointOnArc(start, focusX, focusY, c, normalAndTangent, scratch, point);
        double startX = point[0];
        double startY = point[1];
        PSMyGraphics.findPointOnArc(end, focusX, focusY, c, normalAndTangent, scratch, point);
        double endX = point[0];
        double endY = point[1];
        this.endPathIfInPath();
        this.writer.println("n " + (float)startX + ' ' + (float)startY + " m " + (float)endX + ' ' + (float)endY + " l s");
    }

    public void drawThickArc(double x, double y, double width, double height, double startRadians, double arcRadians, double lineThicknessInPixels, boolean antiAlias) {
        double centerX = x + width * 0.5;
        double centerY = y + height * 0.5;
        double radius = 0.25 * (width + height);
        double curvature = 1.0 / radius;
        double focusAngleRadians = startRadians;
        double start = 0.0;
        double end = arcRadians * radius;
        double focusX = centerX + radius * Math.cos(focusAngleRadians);
        double focusY = centerY + radius * Math.sin(focusAngleRadians);
        this.smartDrawThickArc(lineThicknessInPixels, focusX, focusY, focusAngleRadians, curvature, start, end, antiAlias);
    }

    public Color getColor() {
        return this.currentColor;
    }

    public void setColor(Color color) {
        this.currentColor = color;
        int colorRGB = color.getRGB();
        int rbyte = colorRGB >> 16 & 0xFF;
        int gbyte = colorRGB >> 8 & 0xFF;
        int bbyte = colorRGB & 0xFF;
        double r = (double)rbyte / 255.0;
        double g = (double)gbyte / 255.0;
        double b = (double)bbyte / 255.0;
        double[] hsl = new double[3];
        PSMyGraphics.RGBtoHSL(r, g, b, hsl);
        double[] rgb = new double[3];
        PSMyGraphics.HSLtoRGB(hsl[0], hsl[1], 1.0 - hsl[2], rgb);
        r = rgb[0];
        g = rgb[1];
        b = rgb[2];
        this.endPathIfInPath();
        this.writer.println("" + (float)r + ' ' + (float)g + ' ' + (float)b + " setrgbcolor");
    }

    private static final void findPointOnArc(double t, double focusX, double focusY, double c, double[][] normalAndTangent, double[] scratch, double[] result) {
        scratch[0] = -MyMath.cosf1_over_x(t * c) * t;
        scratch[1] = MyMath.sin_over_x(t * c) * t;
        VecMath.vxm(result, scratch, normalAndTangent);
        result[0] = result[0] + focusX;
        result[1] = result[1] + focusY;
    }

    public void flush() {
        this.endPathIfInPath();
        this.writer.println("showpage");
        this.writer.flush();
    }

    private final void newPathIfNotInPath() {
        if (!this.inPath) {
            this.writer.println("n");
            this.inPath = true;
        }
    }

    private final void endPathIfInPath() {
        if (this.inPath) {
            this.writer.println("s");
            this.inPath = false;
        }
    }

    public static void HSVtoRGB(double h, double s, double v, double[] rgb) {
        while (h < 0.0) {
            h += 1.0;
        }
        while (h >= 1.0) {
            h -= 1.0;
        }
        int segment = (int)(h * 6.0);
        double frac = 6.0 * h - (double)segment;
        if (segment % 2 == 1) {
            frac = 1.0 - frac;
        }
        double major = v;
        double minor = (1.0 - s) * v;
        double middle = frac * major + (1.0 - frac) * minor;
        rgb[(segment + 1) / 2 % 3] = major;
        rgb[(segment + 4) / 2 % 3] = minor;
        rgb[(7 - segment) % 3] = middle;
    }

    public static void RGBtoHSV(double r, double g, double b, double[] hsv) {
        double h;
        double s;
        int n;
        int majorI;
        int n2;
        double[] rgb = new double[]{r, g, b};
        if (r >= g) {
            n2 = r >= b ? 0 : 2;
        } else {
            int n3 = 0;
            if (g >= b) {
                n3 = 1;
            }
            n2 = majorI = 2 - n3;
        }
        if (r <= g) {
            n = r <= b ? 0 : 2;
        } else {
            int n4 = 0;
            if (g <= b) {
                n4 = 1;
            }
            n = 2 - n4;
        }
        int minorI = n;
        int middleI = 3 - majorI - minorI;
        int n5 = 0;
        if ((majorI - middleI + 3) % 3 == 1) {
            n5 = 1;
        }
        int segment = (minorI + 1) % 3 * 2 + n5;
        double v = rgb[majorI];
        double d = s = v == 0.0 ? 0.0 : 1.0 - rgb[minorI] / v;
        if (rgb[majorI] != rgb[minorI]) {
            double frac = (rgb[middleI] - rgb[minorI]) / (rgb[majorI] - rgb[minorI]);
            h = ((double)segment + (segment % 2 == 0 ? frac : 1.0 - frac)) * 0.16666666666666666;
        } else {
            h = 0.0;
        }
        hsv[0] = h;
        hsv[1] = s;
        hsv[2] = v;
    }

    public static void RGBtoHSL(double r, double g, double b, double[] hsl) {
        double s_of_hsl;
        double l;
        double[] hsv = hsl;
        PSMyGraphics.RGBtoHSV(r, g, b, hsv);
        double h = hsv[0];
        double s_of_hsv = hsv[1];
        double v = hsv[2];
        hsl[0] = h;
        hsl[2] = l = 0.3 * r + 0.59 * g + 0.11 * b;
        double major = v;
        double minor = v + s_of_hsv * (0.0 - v);
        hsl[1] = s_of_hsl = l == 0.0 || l == 1.0 ? 0.0 : ((major - l) / (1.0 - l) >= (minor - l) / (0.0 - l) ? (major - l) / (1.0 - l) : (minor - l) / (0.0 - l));
    }

    public static void HSLtoRGB(double h, double s, double l, double[] rgb) {
        double hlmajor;
        PSMyGraphics.HSVtoRGB(h, 1.0, 1.0, rgb);
        double hr = rgb[0];
        double hg = rgb[1];
        double hb = rgb[2];
        double hl = 0.3 * hr + 0.59 * hg + 0.11 * hb;
        double delta = (l - hl) / (double)3;
        double hlr = hr + (l - hl);
        double hlg = hg + (l - hl);
        double hlb = hb + (l - hl);
        double d = hlr >= hlg ? (hlr >= hlb ? hlr : hlb) : (hlmajor = hlg >= hlb ? hlg : hlb);
        double hlminor = hlr <= hlg ? (hlr <= hlb ? hlr : hlb) : (hlg <= hlb ? hlg : hlb);
        double t1 = (1.0 - l) / (hlmajor - l) <= (0.0 - l) / (hlminor - l) ? (1.0 - l) / (hlmajor - l) : (0.0 - l) / (hlminor - l);
        double t = s * t1;
        rgb[0] = l + t * (hlr - l);
        rgb[1] = l + t * (hlg - l);
        rgb[2] = l + t * (hlb - l);
    }

    public static void main(String[] args) {
        double r = Math.random();
        double g = Math.random();
        double b = Math.random();
        r = 0.8;
        g = 0.7;
        b = 0.6;
        double[] hsl = new double[3];
        PSMyGraphics.RGBtoHSL(r, g, b, hsl);
        double[] rgb = new double[3];
        PSMyGraphics.HSLtoRGB(hsl[0], hsl[1], hsl[2], rgb);
    }

    private final /* synthetic */ void this() {
        this.inPath = false;
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        this.translateX = 0.0;
        this.translateY = 0.0;
        this.verbose = 0;
    }

    public PSMyGraphics(PrintWriter writer, Dimension gsize, double x0, double x1, double y0, double y1) {
        super(null, gsize, x0, x1, y0, y1);
        this.this();
        this.writer = writer;
        this.writePrologue();
    }

    public PSMyGraphics(PrintWriter writer, Dimension gsize) {
        super(null, gsize);
        this.this();
        this.writer = writer;
        this.writePrologue();
    }
}

