/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MyGraphics {
    private Graphics g;
    private Dimension gsize;
    private double scaleX;
    private double scaleY;
    private double translateX;
    private double translateY;
    public int verbose;
    private Color[] cache;
    private Color cacheColor;
    private int cacheRGB;

    public void fit(double x0, double x1, double y0, double y1, double left, double right, double bottom, double top) {
        this.scaleX = (right - left) / (x1 - x0);
        this.scaleY = (top - bottom) / (y1 - y0);
        this.translateX = left - this.scaleX * x0;
        this.translateY = bottom - this.scaleY * y0;
    }

    public void fitToWindow(double x0, double x1, double y0, double y1) {
        this.fit(x0, x1, y0, y1, 0.5, (double)this.gsize.width - 0.5, (double)this.gsize.height - 0.5, 0.5);
    }

    public void fitToPixel(double centerX, double centerY, double pixelSizeX, double pixelSizeY) {
        this.fit(centerX, centerX + pixelSizeX, centerY, centerY + pixelSizeY, (double)this.gsize.width * 0.5, (double)this.gsize.width * 0.5 + 1.0, (double)this.gsize.height * 0.5, (double)this.gsize.height * 0.5 + 1.0);
    }

    public void translate(double x, double y) {
        this.translateX += x * this.scaleX;
        this.translateY += y * this.scaleY;
    }

    public void pick(double x, double y, double[] result) {
        result[0] = (x - this.translateX) / this.scaleX;
        result[1] = (y - this.translateY) / this.scaleY;
    }

    public void unpick(double x, double y, double[] result) {
        result[0] = x * this.scaleX + this.translateX;
        result[1] = y * this.scaleY + this.translateY;
    }

    public void fillWindow() {
        this.g.fillRect(0, 0, this.gsize.width, this.gsize.height);
    }

    public void drawLineNonClipped(double x0, double y0, double x1, double y1, boolean antiAlias) {
        if (antiAlias) {
            if (x0 == x1 && y0 == y1) {
                this.drawPoint(x0, y0, 1);
                return;
            }
            x0 = x0 * this.scaleX + this.translateX - 0.5;
            y0 = y0 * this.scaleY + this.translateY - 0.5;
            x1 = x1 * this.scaleX + this.translateX - 0.5;
            y1 = y1 * this.scaleY + this.translateY - 0.5;
            Color savedColor = this.getColor();
            Color[] transparentColorCache = this.getTransparentColorCache(savedColor);
            if (Math.abs(y1 - y0) >= Math.abs(x1 - x0)) {
                int Y1;
                int Y0 = (int)Math.round(y0);
                int dirY = Y0 <= (Y1 = (int)Math.round(y1)) ? 1 : -1;
                double slope = (x1 - x0) / (y1 - y0);
                int Y = Y0;
                while (Y != Y1) {
                    double x = x0 + ((double)Y - y0) * slope;
                    int X = (int)Math.floor(x);
                    double frac = x - (double)X;
                    int alpha = (int)(frac * 256.0);
                    this.setColor(transparentColorCache[255 - alpha]);
                    this.g.fillRect(X, Y, 1, 1);
                    this.setColor(transparentColorCache[alpha]);
                    this.g.fillRect(X + 1, Y, 1, 1);
                    Y += dirY;
                }
            } else {
                int X1;
                int X0 = (int)Math.round(x0);
                int dirX = X0 <= (X1 = (int)Math.round(x1)) ? 1 : -1;
                double slope = (y1 - y0) / (x1 - x0);
                int X = X0;
                while (X != X1) {
                    double y = y0 + ((double)X - x0) * slope;
                    int Y = (int)Math.floor(y);
                    double frac = y - (double)Y;
                    int alpha = (int)(frac * 256.0);
                    this.setColor(transparentColorCache[255 - alpha]);
                    this.g.fillRect(X, Y, 1, 1);
                    this.setColor(transparentColorCache[alpha]);
                    this.g.fillRect(X, Y + 1, 1, 1);
                    X += dirX;
                }
            }
            this.setColor(savedColor);
        } else {
            this.g.drawLine((int)(x0 * this.scaleX + this.translateX), (int)(y0 * this.scaleY + this.translateY), (int)(x1 * this.scaleX + this.translateX), (int)(y1 * this.scaleY + this.translateY));
        }
    }

    public void drawLine(double x0, double y0, double x1, double y1, boolean antiAlias) {
        this.drawLineNonClipped(x0, y0, x1, y1, antiAlias);
    }

    public void drawPoint(double x, double y, int nPixels) {
        int x0 = (int)(x * this.scaleX + this.translateX - 0.5 * (double)nPixels);
        int y0 = (int)(y * this.scaleY + this.translateY - 0.5 * (double)nPixels);
        if (this.verbose >= 2) {
            System.out.println("in drawPoint(" + x + ',' + y + ',' + nPixels + ") -> " + x0 + ',' + y0);
        }
        if (x0 < -nPixels || x0 > this.gsize.width + nPixels || y0 < -nPixels || y0 > this.gsize.width + nPixels) {
            return;
        }
        this.g.fillRect(x0, y0, nPixels, nPixels);
    }

    public void drawString(String s, double x, double y) {
        this.g.drawString(s, (int)(x * this.scaleX + this.translateX), (int)(y * this.scaleY + this.translateY));
    }

    public void drawString(String s, double x, double y, double xJustify, double yJustify) {
        FontMetrics fm = this.g.getFontMetrics();
        this.g.drawString(s, (int)(x * this.scaleX + this.translateX - (double)fm.stringWidth(s) * (xJustify + 1.0) * 0.5), (int)(y * this.scaleY + this.translateY + (double)fm.getAscent() * (1.0 - yJustify) * 0.5));
    }

    public void drawStringCentered(String s, double x, double y) {
        this.drawString(s, x, y, 0.0, 0.0);
    }

    public void drawStringRightJustified(String s, double x, double y) {
        this.drawString(s, x, y, 1.0, 0.0);
    }

    public double getFontHeight() {
        FontMetrics fm = this.g.getFontMetrics();
        return Math.abs((double)fm.getHeight() / this.scaleY);
    }

    public void smartDrawArcNonClipped(double focusX, double focusY, double focusAngleRadians, double c, double start, double end, boolean antiAlias) {
        boolean useSegments = antiAlias;
        if (useSegments) {
            int nSegs = 10 >= (int)(((end - start) * c < 0.0 ? -((end - start) * c) : (end - start) * c) / (Math.PI / 180)) ? 10 : (int)(((end - start) * c < 0.0 ? -((end - start) * c) : (end - start) * c) / (Math.PI / 180));
            double cosFocusAngle = Math.cos(focusAngleRadians);
            double sinFocusAngle = Math.sin(focusAngleRadians);
            double[][] normalAndTangent = new double[][]{{cosFocusAngle, sinFocusAngle}, {-sinFocusAngle, cosFocusAngle}};
            double[] prevPoint = new double[2];
            double[] point = new double[2];
            double[] scratch = new double[2];
            int i = 0;
            while (i < nSegs + 1) {
                double t = start + (double)i / (double)nSegs * (end - start);
                MyGraphics.findPointOnArc(t, focusX, focusY, c, normalAndTangent, scratch, point);
                if (i > 0) {
                    this.drawLineNonClipped(prevPoint[0], prevPoint[1], point[0], point[1], antiAlias);
                }
                System.arraycopy(point, 0, prevPoint, 0, 2);
                ++i;
            }
            return;
        }
        if (c * Math.abs(start - end) > 2.356194490192345) {
            this.smartDrawArcNonClipped(focusX, focusY, focusAngleRadians, c, start, (start + end) * 0.5, antiAlias);
            this.smartDrawArcNonClipped(focusX, focusY, focusAngleRadians, c, (start + end) * 0.5, end, antiAlias);
            return;
        }
        focusX = focusX * this.scaleX + this.translateX;
        focusY = focusY * this.scaleY + this.translateY;
        if (this.scaleY < 0.0) {
            focusAngleRadians *= -1.0;
            start *= -1.0;
            end *= -1.0;
        }
        double scale = 0.5 * (Math.abs(this.scaleX) + Math.abs(this.scaleY));
        c /= scale;
        start *= scale;
        end *= scale;
        if (c < 0.0) {
            c *= -1.0;
            focusAngleRadians += Math.PI;
            start *= -1.0;
            end *= -1.0;
        }
        if (start > end) {
            double temp = start;
            start = end;
            end = temp;
        }
        double normalX = Math.cos(focusAngleRadians);
        double normalY = Math.sin(focusAngleRadians);
        double[][] normalAndTangent = new double[][]{{normalX, normalY}, {-normalY, normalX}};
        double[] point = new double[2];
        double[] scratch = new double[2];
        MyGraphics.findPointOnArc(start, focusX, focusY, c, normalAndTangent, scratch, point);
        double startX = point[0];
        double startY = point[1];
        MyGraphics.findPointOnArc(end, focusX, focusY, c, normalAndTangent, scratch, point);
        double endX = point[0];
        double endY = point[1];
        int maxPointsToDraw = (int)Math.ceil(Math.abs(end - start)) + 1;
        int nPointsDrawn = 0;
        int x = (int)Math.round(startX);
        int y = (int)Math.round(startY);
        double X = (double)x - focusX;
        double Y = (double)y - focusY;
        this.g.fillRect(x, y, 1, 1);
        ++nPointsDrawn;
        if (c < 1.0) {
            do {
                int n;
                int quantizedDirX;
                int n2;
                int[][] nArrayArray = new int[8][];
                int[] nArray = new int[2];
                nArray[0] = 1;
                nArrayArray[0] = nArray;
                nArrayArray[1] = new int[]{1, 1};
                int[] nArray2 = new int[2];
                nArray2[1] = 1;
                nArrayArray[2] = nArray2;
                nArrayArray[3] = new int[]{-1, 1};
                int[] nArray3 = new int[2];
                nArray3[0] = -1;
                nArrayArray[4] = nArray3;
                nArrayArray[5] = new int[]{-1, -1};
                int[] nArray4 = new int[2];
                nArray4[1] = -1;
                nArrayArray[6] = nArray4;
                nArrayArray[7] = new int[]{1, -1};
                int[][] quantizedDirVectors = nArrayArray;
                double thisNormalX = c * X + normalX;
                double thisNormalY = c * Y + normalY;
                double thisTangentX = -thisNormalY;
                double thisTangentY = thisNormalX;
                if (thisTangentX < 0.0) {
                    n2 = -1;
                } else {
                    n2 = 0;
                    if (thisTangentX > 0.0) {
                        n2 = quantizedDirX = 1;
                    }
                }
                if (thisTangentY < 0.0) {
                    n = -1;
                } else {
                    n = 0;
                    if (thisTangentY > 0.0) {
                        n = 1;
                    }
                }
                int quantizedDirY = n;
                double absThisTangentX = Math.abs(thisTangentX);
                double absThisTangentY = Math.abs(thisTangentY);
                if (absThisTangentX > (double)2 * absThisTangentY) {
                    quantizedDirY = 0;
                } else if (absThisTangentY > (double)2 * absThisTangentX) {
                    quantizedDirX = 0;
                }
                int dir = 0;
                while (dir < 8) {
                    if (quantizedDirVectors[dir][0] == quantizedDirX && quantizedDirVectors[dir][1] == quantizedDirY) break;
                    ++dir;
                }
                if (dir == 8) {
                    System.out.println("huh?????");
                    break;
                }
                X = (double)(x += quantizedDirVectors[dir][0]) - focusX;
                Y = (double)(y += quantizedDirVectors[dir][1]) - focusY;
                double signedDistanceOutsideCircle = (c * (X * X + Y * Y) + (double)2 * (X * normalX + Y * normalY)) / (MyMath.hypot(c * X + normalX, c * Y + normalY) + 1.0);
                double thisNormalX2 = c * X + normalX;
                double thisNormalY2 = c * Y + normalY;
                double inflation = MyMath.hypot(thisNormalX2, thisNormalY2) / Math.max(Math.abs(thisNormalX2), Math.abs(thisNormalY2));
                if ((signedDistanceOutsideCircle *= inflation) > 0.5001) {
                    x -= quantizedDirVectors[dir][0];
                    y -= quantizedDirVectors[dir][1];
                    dir = (dir + 1) % 8;
                    X = (double)(x += quantizedDirVectors[dir][0]) - focusX;
                    Y = (double)(y += quantizedDirVectors[dir][1]) - focusY;
                } else if (signedDistanceOutsideCircle < -0.5001) {
                    x -= quantizedDirVectors[dir][0];
                    y -= quantizedDirVectors[dir][1];
                    dir = (dir - 1 + 8) % 8;
                    X = (double)(x += quantizedDirVectors[dir][0]) - focusX;
                    Y = (double)(y += quantizedDirVectors[dir][1]) - focusY;
                }
                thisNormalX2 = c * X + normalX;
                thisNormalY2 = c * Y + normalY;
                signedDistanceOutsideCircle = (c * (X * X + Y * Y) + (double)2 * (X * normalX + Y * normalY)) / (MyMath.hypot(c * X + normalX, c * Y + normalY) + 1.0);
                double arcPointX = focusX + X - signedDistanceOutsideCircle * thisNormalX2;
                double arcPointY = focusY + Y - signedDistanceOutsideCircle * thisNormalY2;
                double startToArcPoint = MyMath.hypot(arcPointX - startX, arcPointY - startY);
                double arcDistance = startToArcPoint * MyMath.asin_over_x(c * startToArcPoint * 0.5);
                if (arcDistance >= end - start) break;
                this.g.fillRect(x, y, 1, 1);
            } while (++nPointsDrawn < maxPointsToDraw - 1);
            this.g.fillRect((int)Math.round(endX), (int)Math.round(endY), 1, 1);
            ++nPointsDrawn;
        }
    }

    public void smartDrawArcClipped(double focusX, double focusY, double focusAngleRadians, double c, double start, double end, boolean antiAlias, double clipX0, double clipX1, double clipY0, double clipY1, double slack) {
        double dist;
        double[] scratch;
        double[] point;
        double[][] normalAndTangent;
        double clipMaxY;
        double clipMinY;
        double clipMaxX;
        double clipMinX;
        block5: {
            double dist2;
            int dir;
            block4: {
                clipMinX = Math.min(clipX0, clipX1);
                clipMaxX = Math.max(clipX0, clipX1);
                clipMinY = Math.min(clipY0, clipY1);
                clipMaxY = Math.max(clipY0, clipY1);
                if (c * Math.abs(end - start) > Math.PI * 2) {
                    start = 0.0;
                    end = Math.PI * 2 / c;
                }
                dir = start <= end ? 1 : -1;
                double normalX = Math.cos(focusAngleRadians);
                double normalY = Math.sin(focusAngleRadians);
                normalAndTangent = new double[][]{{normalX, normalY}, {-normalY, normalX}};
                point = new double[2];
                scratch = new double[2];
                do {
                    MyGraphics.findPointOnArc(start, focusX, focusY, c, normalAndTangent, scratch, point);
                    double startX = point[0];
                    double startY = point[1];
                    double d = startX - clipMaxX >= clipMinX - startX ? (startX - clipMaxX >= startY - clipMaxY ? (startX - clipMaxX >= clipMinY - startY ? startX - clipMaxX : clipMinY - startY) : (startY - clipMaxY >= clipMinY - startY ? startY - clipMaxY : clipMinY - startY)) : (clipMinX - startX >= startY - clipMaxY ? (clipMinX - startX >= clipMinY - startY ? clipMinX - startX : clipMinY - startY) : (dist2 = startY - clipMaxY >= clipMinY - startY ? startY - clipMaxY : clipMinY - startY));
                    if (dist2 <= slack) break block4;
                } while (!((double)dir * (end - (start += (double)dir * dist2)) < 0.0));
                return;
            }
            do {
                MyGraphics.findPointOnArc(end, focusX, focusY, c, normalAndTangent, scratch, point);
                double endX = point[0];
                double endY = point[1];
                double d = endX - clipMaxX >= clipMinX - endX ? (endX - clipMaxX >= endY - clipMaxY ? (endX - clipMaxX >= clipMinY - endY ? endX - clipMaxX : clipMinY - endY) : (endY - clipMaxY >= clipMinY - endY ? endY - clipMaxY : clipMinY - endY)) : (clipMinX - endX >= endY - clipMaxY ? (clipMinX - endX >= clipMinY - endY ? clipMinX - endX : clipMinY - endY) : (dist2 = endY - clipMaxY >= clipMinY - endY ? endY - clipMaxY : clipMinY - endY));
                if (dist2 <= slack) break block5;
            } while (!((double)dir * ((end -= (double)dir * dist2) - start) < 0.0));
            return;
        }
        double mid = (start + end) * 0.5;
        MyGraphics.findPointOnArc(mid, focusX, focusY, c, normalAndTangent, scratch, point);
        double midX = point[0];
        double midY = point[1];
        double d = midX - clipMaxX >= clipMinX - midX ? (midX - clipMaxX >= midY - clipMaxY ? (midX - clipMaxX >= clipMinY - midY ? midX - clipMaxX : clipMinY - midY) : (midY - clipMaxY >= clipMinY - midY ? midY - clipMaxY : clipMinY - midY)) : (clipMinX - midX >= midY - clipMaxY ? (clipMinX - midX >= clipMinY - midY ? clipMinX - midX : clipMinY - midY) : (dist = midY - clipMaxY >= clipMinY - midY ? midY - clipMaxY : clipMinY - midY));
        if (dist > slack) {
            this.smartDrawArcClipped(focusX, focusY, focusAngleRadians, c, start, mid, antiAlias, clipX0, clipX1, clipY0, clipY1, slack);
            this.smartDrawArcClipped(focusX, focusY, focusAngleRadians, c, mid, end, antiAlias, clipX0, clipX1, clipY0, clipY1, slack);
            return;
        }
        this.smartDrawArcNonClipped(focusX, focusY, focusAngleRadians, c, start, end, antiAlias);
    }

    public void smartDrawArc_(double focusX, double focusY, double focusAngleRadians, double c, double start, double end, boolean antiAlias) {
        this.smartDrawArcClipped(focusX, focusY, focusAngleRadians, c, start, end, antiAlias, (0.0 - this.translateX) / this.scaleX, ((double)this.gsize.width - this.translateX) / this.scaleX, (0.0 - this.translateY) / this.scaleY, ((double)this.gsize.height - this.translateY) / this.scaleY, (double)2 / ((Math.abs(this.scaleX) + Math.abs(this.scaleY)) * 0.5));
    }

    public void smartDrawThickArc(double thicknessInPixels, double focusX, double focusY, double focusAngleRadians, double c, double start, double end, boolean antiAlias) {
        double n = (int)Math.ceil((double)2 * thicknessInPixels - 1.0);
        if (n <= 1.0) {
            this.smartDrawArc_(focusX, focusY, focusAngleRadians, c, start, end, antiAlias);
            return;
        }
        double scale = 0.5 * (Math.abs(this.scaleX) + Math.abs(this.scaleY));
        double onePixel = 1.0 / scale;
        double dx = Math.cos(focusAngleRadians);
        double dy = Math.sin(focusAngleRadians);
        int i = 0;
        while ((double)i < n) {
            double s = (-(thicknessInPixels - 1.0) / (double)2 + (double)i / (n - 1.0) * ((thicknessInPixels - 1.0) / (double)2 - -(thicknessInPixels - 1.0) / (double)2)) * onePixel;
            double foo = 1.0 + c * s;
            if (!(foo <= 0.0)) {
                this.smartDrawArc_(focusX + s * dx, focusY + s * dy, focusAngleRadians, c / foo, start * foo, end * foo, antiAlias);
            }
            ++i;
        }
    }

    public void drawThickArc(double x, double y, double width, double height, double startRadians, double arcRadians, double thicknessInPixels, boolean antiAlias) {
        double centerX = x + width * 0.5;
        double centerY = y + height * 0.5;
        double radius = 0.25 * (width + height);
        double curvature = 1.0 / radius;
        double focusAngleRadians = startRadians;
        double start = 0.0;
        double end = arcRadians * radius;
        double focusX = centerX + radius * Math.cos(focusAngleRadians);
        double focusY = centerY + radius * Math.sin(focusAngleRadians);
        this.smartDrawThickArc(thicknessInPixels, focusX, focusY, focusAngleRadians, curvature, start, end, antiAlias);
    }

    public Color getColor() {
        return this.g.getColor();
    }

    public void setColor(Color color) {
        this.g.setColor(color);
    }

    private final Color[] getTransparentColorCache(Color color) {
        if (color != this.cacheColor) {
            this.cacheColor = color;
            int colorRGB = color.getRGB();
            if (this.cache == null || colorRGB != this.cacheRGB) {
                this.cacheRGB = colorRGB;
                if (this.cache == null) {
                    this.cache = new Color[256];
                }
                int r = colorRGB >> 16 & 0xFF;
                int g = colorRGB >> 8 & 0xFF;
                int b = colorRGB & 0xFF;
                int i = 0;
                while (i < 256) {
                    this.cache[i] = new Color(r, g, b, i);
                    ++i;
                }
            }
        }
        return this.cache;
    }

    private static final void findPointOnArc(double t, double focusX, double focusY, double c, double[][] normalAndTangent, double[] scratch, double[] result) {
        scratch[0] = -MyMath.cosf1_over_x(t * c) * t;
        scratch[1] = MyMath.sin_over_x(t * c) * t;
        VecMath.vxm(result, scratch, normalAndTangent);
        result[0] = result[0] + focusX;
        result[1] = result[1] + focusY;
    }

    public void flush() {
    }

    private final /* synthetic */ void this() {
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        this.translateX = 0.0;
        this.translateY = 0.0;
        this.verbose = 0;
        this.cache = null;
        this.cacheColor = null;
    }

    public MyGraphics(Graphics g, Dimension gsize, double x0, double x1, double y0, double y1) {
        this.this();
        this.g = g;
        this.gsize = gsize;
        this.fitToWindow(x0, x1, y0, y1);
    }

    public MyGraphics(Graphics g, Dimension gsize) {
        this.this();
        this.g = g;
        this.gsize = gsize;
        this.fitToWindow(-1.0, 1.0, -1.0, 1.0);
    }
}

