/*
 * Decompiled with CFR 0.152.
 */
public class HyperbolicUtils {
    public static final int POINCARE_DISK = 0;
    public static final int KLEIN_DISK = 1;
    public static final int UPPER_HALF_PLANE = 2;
    public static final int ANTIKLEIN_DISK = 3;

    public static double h2eNorm(double hNorm) {
        if (Double.isInfinite(hNorm)) {
            return 1.0;
        }
        return MyMath.tanh(0.5 * hNorm);
    }

    public static double e2hNorm(double eNorm) {
        return (double)2 * MyMath.atanh(eNorm);
    }

    public static boolean unHBary2(int nVerts, double[] result, double[] p, double[][] verts, int verbose) {
        int dim = 2;
        if (nVerts < 3) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(42): nVerts >= 3");
        }
        Isometry2 translatePToOrigin = Isometry2.pureTranslation(-p[0], -p[1]);
        double[][] v = new double[nVerts][2];
        int i = 0;
        while (i < nVerts) {
            Complex temp = translatePToOrigin.apply(new Complex(verts[i]));
            v[i][0] = temp.x;
            v[i][1] = temp.y;
            ++i;
        }
        i = 0;
        while (i < 3) {
            result[i] = HyperbolicUtils.calcSmallestPointOnLine2(null, v[(i + 1) % 3], v[(i + 2) % 3]);
            if (VecMath.vxv2(v[(i + 1) % 3], v[(i + 2) % 3]) < 0.0) {
                int n = i;
                result[n] = result[n] * -1.0;
            }
            ++i;
        }
        while (i < nVerts) {
            result[i] = 0.0;
            ++i;
        }
        return true;
    }

    public static boolean unHBary2(int nVerts, double[] result, Complex p, Complex[] verts, int verbose) {
        double[] _p = new double[]{p.x, p.y};
        double[][] _verts = new double[nVerts][2];
        int i = 0;
        while (i < nVerts) {
            _verts[i][0] = verts[i].x;
            _verts[i][1] = verts[i].y;
            ++i;
        }
        return HyperbolicUtils.unHBary2(nVerts, result, _p, _verts, verbose);
    }

    public static boolean hBary2(int nPoints, double[] result, double[] b, Complex[] p, int verbose) {
        double[][] _p = new double[nPoints][2];
        int i = 0;
        while (i < nPoints) {
            _p[i][0] = p[i].x;
            _p[i][1] = p[i].y;
            ++i;
        }
        return HyperbolicUtils.hBary2(nPoints, result, b, _p, verbose);
    }

    public static boolean hBary2FromDistances(int nPoints, double[] result, double[] dists, double[][] p) {
        if (nPoints < 3) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(119): nPoints >= 3");
        }
        double[] p0 = p[0];
        double[] p1 = p[1];
        double A = dists[1];
        double B = dists[0];
        double C = HyperbolicUtils.hdist2_poincare(p0, p1);
        double alpha = HyperbolicUtils.solveTriangleAlphaFromABC(A, B, C);
        double beta = HyperbolicUtils.solveTriangleAlphaFromABC(B, C, A);
        if (HyperbolicUtils.pointIsToRightSideOfLinePoincare(p[2], p[0], p[1], 0.0)) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(134): false");
        }
        Isometry2 take_p0_to_origin = Isometry2.pureTranslation(-p0[0], -p0[1]);
        Isometry2 take_origin_to_p0 = Isometry2.pureTranslation(p0[0], p0[1]);
        double[] q1 = take_p0_to_origin.apply(p1);
        double dir = Math.atan2(q1[1], q1[0]) + alpha;
        double[] foo0 = new double[]{0.5 * Math.cos(dir), 0.5 * Math.sin(dir)};
        take_origin_to_p0.apply(foo0, foo0);
        Isometry2 take_p1_to_origin = Isometry2.pureTranslation(-p1[0], -p1[1]);
        Isometry2 take_origin_to_p1 = Isometry2.pureTranslation(p1[0], p1[1]);
        double[] q0 = take_p1_to_origin.apply(p0);
        double dir2 = Math.atan2(q0[1], q0[0]) - beta;
        double[] foo1 = new double[]{0.5 * Math.cos(dir2), 0.5 * Math.sin(dir2)};
        take_origin_to_p1.apply(foo1, foo1);
        return HyperbolicUtils.calcLineLineIntersection2(result, p0, foo0, p1, foo1);
    }

    public static boolean hBary2(int nPoints, double[] result, double[] b, double[][] p, int verbose) {
        boolean doSimpleWrongWay;
        if (nPoints < 3) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(174): nPoints >= 3");
        }
        if (nPoints > 3) {
            return HyperbolicUtils.hBary2(3, result, b, p, verbose);
        }
        int dim = 2;
        if (verbose >= 2) {
            System.out.println("in hBary");
            System.out.print("    b =");
            int i = 0;
            while (i < nPoints) {
                System.out.print(" " + b[i]);
                ++i;
            }
            System.out.println();
            System.out.print("    p = ");
            i = 0;
            while (i < nPoints) {
                int j = 0;
                while (j < 2) {
                    System.out.print(p[i][j] + (j == 1 ? " " : ","));
                    ++j;
                }
                ++i;
            }
            System.out.println();
        }
        if (doSimpleWrongWay = false) {
            VecMath.zerovec(result);
            double sum = 0.0;
            int i = 0;
            while (i < nPoints) {
                if ((sum += b[i]) != 0.0) {
                    Isometry2 temp = Isometry2.pureTranslation(result[0], result[1]);
                    Isometry2 inverseTemp = Isometry2.pureTranslation(-result[0], -result[1]);
                    double[] p_i_ = inverseTemp.apply(p[i]);
                    VecMath.vxs(result, p_i_, b[i] / sum);
                    temp.apply(result, result);
                } else if (b[i] != 0.0) {
                    throw new Error("Assertion failed at HyperbolicUtils.prejava(233): b[i] == 0.");
                }
                ++i;
            }
            return true;
        }
        double[][] q = new double[nPoints][2];
        int i = 0;
        while (i < nPoints) {
            double[][] otherPoints = new double[nPoints - 1][];
            double[] otherBs = new double[nPoints - 1];
            int j = 0;
            while (j < nPoints - 1) {
                otherPoints[j] = p[(i + 1 + j) % nPoints];
                otherBs[j] = b[(i + 1 + j) % nPoints];
                ++j;
            }
            HyperbolicUtils._calcPointOnWeightedSector2(nPoints - 1, q[i], p[i], otherPoints, otherBs, verbose);
            ++i;
        }
        double bestSum = -1.0;
        int bestI = -1;
        int bestJ = -1;
        i = 0;
        while (i < nPoints) {
            int j = 0;
            while (j < i) {
                double sum;
                double d = sum = b[i] + b[j] - 1.0 < 0.0 ? -(b[i] + b[j] - 1.0) : b[i] + b[j] - 1.0;
                if (sum > bestSum) {
                    bestI = i;
                    bestJ = j;
                    bestSum = sum;
                }
                ++j;
            }
            ++i;
        }
        if (bestI == -1 || bestJ == -1 || bestI == bestJ) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(278): bestI != -1 && bestJ != -1 && bestI != bestJ");
        }
        boolean returnval = HyperbolicUtils.calcLineLineIntersection2(result, p[bestI], q[bestI], p[bestJ], q[bestJ]);
        boolean hBaryDebug = false;
        if (hBaryDebug) {
            i = 0;
            while (i < nPoints) {
                int j = 0;
                while (j < nPoints) {
                    if (i != j) {
                        double[] intersection = new double[2];
                        System.out.print((i == bestI && j == bestJ ? "(best)" : "      ") + " Intersection " + i + ' ' + j);
                        if (HyperbolicUtils.calcLineLineIntersection2(intersection, p[i], q[i], p[j], q[j])) {
                            System.out.print(" =");
                            int k = 0;
                            while (k < intersection.length) {
                                System.out.print(" " + intersection[k]);
                                ++k;
                            }
                            System.out.println();
                        } else {
                            System.out.println(" bad");
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return returnval;
    }

    public static boolean calcLineLineIntersection2(double[] result, double[] p0, double[] p1, double[] q0, double[] q1) {
        int N = 2;
        double[] q = new double[2];
        HyperbolicUtils.calcSmallestPointOnLine2(q, q0, q1);
        Isometry2 F = Isometry2.pureTranslation(q[0], q[1]);
        Isometry2 inverseF = F.inverse();
        double[] p0_ = inverseF.apply(p0);
        double[] p1_ = inverseF.apply(p1);
        double[] q0_ = inverseF.apply(q0);
        double[] q1_ = inverseF.apply(q1);
        p0_ = HyperbolicUtils._calcEndOfGeodesic2(p1_, p0_);
        p1_ = HyperbolicUtils._calcEndOfGeodesic2(p0_, p1_);
        q0_ = HyperbolicUtils._calcEndOfGeodesic2(q1_, q0_);
        double x0 = VecMath.dot(q0_, p0_);
        double x1 = VecMath.dot(q0_, p1_);
        double temp = (double)2 * x0 * x1 - VecMath.dot(p0_, p1_) + 1.0;
        if (temp * temp - (x0 + x1) * (x0 + x1) < 0.0) {
            return false;
        }
        double x = (x0 + x1) / (temp + Math.sqrt(temp * temp - (x0 + x1) * (x0 + x1)));
        VecMath.vxs(result, q0_, x);
        F.apply(result, result);
        return true;
    }

    public static double calcSmallestPointOnLine2(double[] result, double[] p0, double[] p1) {
        int N = 2;
        double[] q0 = HyperbolicUtils._calcEndOfGeodesic2(p1, p0);
        double[] q1 = HyperbolicUtils._calcEndOfGeodesic2(p0, p1);
        double[] q = new double[2];
        VecMath.sxvpsxv(q, 0.5, q0, 0.5, q1);
        double scale = 1.0 / (1.0 + 0.5 * Math.sqrt(VecMath.distsqrd(q0, q1)));
        if (result != null) {
            VecMath.vxs(result, q, scale);
        }
        return HyperbolicUtils.e2hNorm(scale * Math.sqrt(VecMath.dot(q, q)));
    }

    public static double calcClosestPointOnLine2(double[] result, double[] p, double[] l0, double[] l1) {
        Isometry2 F = Isometry2.pureTranslation(p[0], p[1]);
        Isometry2 inverseF = F.inverse();
        double[] _l0 = inverseF.apply(l0);
        double[] _l1 = inverseF.apply(l1);
        double dist = HyperbolicUtils.calcSmallestPointOnLine2(result, _l0, _l1);
        F.apply(result, result);
        return dist;
    }

    public static double calcClosestPointOnLine2(Complex result, Complex p, Complex l0, Complex l1) {
        double[] _result = new double[2];
        double dist = HyperbolicUtils.calcClosestPointOnLine2(_result, new double[]{p.x, p.y}, new double[]{l0.x, l0.y}, new double[]{l1.x, l1.y});
        result.set(_result[0], _result[1]);
        return dist;
    }

    private static final double[] _calcEndOfGeodesic2(double[] p0, double[] p1) {
        int N = 2;
        Isometry2 F = Isometry2.pureTranslation(p1[0], p1[1]);
        Isometry2 inverseF = F.inverse();
        double[] p0_ = inverseF.apply(p0);
        double len = Math.sqrt(VecMath.dot(p0_, p0_));
        if (len == 0.0) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(430): len != 0.");
        }
        double[] result = new double[2];
        VecMath.vxs(result, p0_, -1.0 / len);
        F.apply(result, result);
        return result;
    }

    private static final void _calcPointOnWeightedSector2(int nPoints, double[] result, double[] p0, double[][] p, double[] b, int verbose) {
        int dim = 2;
        double d00 = VecMath.dot(p0, p0);
        if (d00 >= 0.9999980000009999) {
            if (verbose >= 1) {
                System.out.println("DOING THE INFINITESIMAL THING! (no way this will work)");
            }
            throw new Error("Assertion failed at HyperbolicUtils.prejava(464): false");
        }
        Isometry2 F = Isometry2.pureTranslation(p0[0], p0[1]);
        Isometry2 inverseF = Isometry2.pureTranslation(-p0[0], -p0[1]);
        double[][] p_ = new double[nPoints][2];
        int i = 0;
        while (i < nPoints) {
            inverseF.apply(p[i], p_[i]);
            ++i;
        }
        double[] c = new double[nPoints];
        i = 0;
        while (i < nPoints) {
            double[][] otherPoints = new double[nPoints - 1][];
            int j = 0;
            while (j < nPoints - 1) {
                otherPoints[j] = p_[(i + j + 1) % nPoints];
                ++j;
            }
            double oppositeSideContent = HyperbolicUtils.calcContentWithOrigin(2, nPoints - 1, otherPoints);
            c[i] = b[i] * oppositeSideContent;
            ++i;
        }
        VecMath.vxm(result, c, p_);
        double d = VecMath.dot(result, result);
        if (d == 0.0) {
            d = 1.0E-20;
        }
        if (d == 0.0) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(586): d != 0.");
        }
        VecMath.vxs(result, result, 1.0 / Math.sqrt(d));
        F.apply(result, result);
    }

    public static double calcContentWithOrigin(int n, int k, double[][] _v) {
        double[][] v = new double[k][n];
        VecMath.copymat(v, _v);
        double prod = 1.0;
        int i = 0;
        while (i < k) {
            double dotii = VecMath.dot(v[i], v[i]);
            if (dotii == 0.0) {
                return 0.0;
            }
            int j = i + 1;
            while (j < k) {
                VecMath.vpsxv(v[j], v[j], -VecMath.dot(v[j], v[i]) * (1.0 / dotii), v[i]);
                ++j;
            }
            prod *= dotii;
            ++i;
        }
        return Math.sqrt(prod);
    }

    public static double calcSimplexContent(int n, int k, double[][] p) {
        double[][] v = new double[k - 1][n];
        int i = 0;
        while (i < k - 1) {
            VecMath.vmv(v[i], p[i + 1], p[0]);
            ++i;
        }
        return HyperbolicUtils.calcContentWithOrigin(n, k - 1, v);
    }

    public static boolean pointIsToRightSideOfLinePoincare(Complex p, Complex l0, Complex l1, double eps) {
        Isometry2 I = Isometry2.pureTranslation(-l0.x, -l0.y);
        p = I.apply(p);
        l1 = I.apply(l1);
        double twiceTriangleArea = p.x * l1.y - p.y * l1.x;
        boolean bl = false;
        if (twiceTriangleArea > eps * eps) {
            bl = true;
        }
        return bl;
    }

    public static boolean pointIsToRightSideOfLinePoincare(double[] p, double[] l0, double[] l1, double eps) {
        return HyperbolicUtils.pointIsToRightSideOfLinePoincare(new Complex(p), new Complex(l0), new Complex(l1), eps);
    }

    public static void calcFaceCenter(double p, int q, double[] result) {
        double s = Math.sin(Math.PI / (double)q);
        double c = Math.cos(Math.PI / (double)q);
        double r = p == 0.0 ? 1.0 : HyperbolicUtils.h2eNorm(MyMath.acosh(c / s / Math.tan(Math.PI / p)));
        result[0] = r * c;
        result[1] = r * s;
    }

    public static void calcFaceCenterFromHalfEdgeLength(double p, double halfEdgeLength, double[] result) {
        double polygonHalfAngle = HyperbolicUtils.polygonHalfAngle(p, halfEdgeLength);
        double circumRadius = HyperbolicUtils.polygonCircumRadius(p, halfEdgeLength);
        double r = HyperbolicUtils.h2eNorm(circumRadius);
        result[0] = r * Math.cos(polygonHalfAngle);
        result[1] = r * Math.sin(polygonHalfAngle);
    }

    public static double polygonHalfAngle(double p, double halfEdgeLength) {
        return Math.asin((p == 0.0 ? 1.0 : Math.cos(Math.PI / p)) / MyMath.cosh(halfEdgeLength));
    }

    public static double polygonCircumRadius(double p, double halfEdgeLength) {
        if (p == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return MyMath.asinh(MyMath.sinh(halfEdgeLength) / Math.sin(Math.PI / p));
    }

    public static double polygonInRadius(double p, double halfEdgeLength) {
        if (p == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return MyMath.asinh(MyMath.tanh(halfEdgeLength) / Math.tan(Math.PI / p));
    }

    public static double calcUniformTilingHalfEdgeLength(double[] p, double q, double density) {
        double mid;
        int nps = p.length;
        if (nps == 0 || q == 0.0) {
            return 0.0;
        }
        double max_cos_pi_over_p = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < nps) {
            if (p[i] == 0.0) {
                max_cos_pi_over_p = 1.0;
                break;
            }
            double cos_pi_over_p = Math.cos(Math.PI / p[i]);
            if (cos_pi_over_p > max_cos_pi_over_p) {
                max_cos_pi_over_p = cos_pi_over_p;
            }
            ++i;
        }
        double lo = 1.0;
        double hi = max_cos_pi_over_p / Math.sin(density * Math.PI / ((double)nps * q));
        if (Double.isInfinite(hi)) {
            hi = 1.0E9;
        }
        while ((mid = lo + (hi - lo) * 0.5) != lo && mid != hi) {
            double sum = 0.0;
            int i2 = 0;
            while (i2 < nps) {
                sum = 1.0 / (p[i2] == 0.0 ? p[i2] : Math.sin(Math.PI / p[i2])) < 0.0 ? (sum -= q * (double)2 * Math.asin((p[i2] == 0.0 ? 1.0 : Math.cos(Math.PI / p[i2])) / mid)) : (sum += q * (double)2 * Math.asin((p[i2] == 0.0 ? 1.0 : Math.cos(Math.PI / p[i2])) / mid));
                ++i2;
            }
            if (sum > density * (double)2 * Math.PI) {
                lo = mid;
                continue;
            }
            hi = mid;
        }
        double result = MyMath.acosh(mid);
        if (Double.isNaN(result)) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(831): !Double.isNaN(result)");
        }
        if (Double.isInfinite(result)) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(832): !Double.isInfinite(result)");
        }
        return result;
    }

    public static double calcUniformTilingHalfEdgeLength(int[] p, double q, double density) {
        double[] pdouble = new double[p.length];
        int i = 0;
        while (i < p.length) {
            pdouble[i] = p[i];
            ++i;
        }
        return HyperbolicUtils.calcUniformTilingHalfEdgeLength(pdouble, q, density);
    }

    public static double calcRegularTilingHalfEdgeLength(double p, int q) {
        double sin_pi_q;
        double cos_pi_p = p == 0.0 ? 1.0 : Math.cos(Math.PI / p);
        double result = MyMath.acosh(cos_pi_p / (sin_pi_q = q == 0 ? 0.0 : Math.sin(Math.PI / (double)q)));
        if (Double.isNaN(result)) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(857): !Double.isNaN(result)");
        }
        if (Double.isInfinite(result)) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(858): !Double.isInfinite(result)");
        }
        if (!(result > 1.0E-6)) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(859): result > 1e-6");
        }
        return result;
    }

    public static double solveTriangleAFromAlphaCBeta(double alpha, double C, double beta) {
        double sinAlpha = Math.sin(alpha);
        double temp = MyMath.cosh(C) * sinAlpha * Math.sin(beta) - Math.cos(alpha) * Math.cos(beta);
        double A = MyMath.asinh(MyMath.sinh(C) * sinAlpha / Math.sqrt(1.0 - temp * temp));
        return A;
    }

    public static double solveTriangleCFromAGammaB(double A, double gamma, double B) {
        return MyMath.acosh(MyMath.cosh(A) * MyMath.cosh(B) - Math.cos(gamma) * MyMath.sinh(A) * MyMath.sinh(B));
    }

    public static double solveTriangleAlphaFromABC(double A, double B, double C) {
        return Math.acos((MyMath.cosh(B) * MyMath.cosh(C) - MyMath.cosh(A)) / (MyMath.sinh(B) * MyMath.sinh(C)));
    }

    public static double hangle(double[] p0, double[] p1, double[] p2) {
        Isometry2 take_p1_to_origin = Isometry2.pureTranslation(-p1[0], -p1[1]);
        double[] q0 = take_p1_to_origin.apply(p0);
        double[] q2 = take_p1_to_origin.apply(p2);
        VecMath.normalize(q0, q0);
        VecMath.normalize(q2, q2);
        return VecMath.angleBetweenUnitVectors(q0, q2);
    }

    public static boolean findBaryCoordsThatMakeSnubUniform(double[] result, double[][] verts, int verbose) {
        double[] schwarzNumbers = new double[verts.length];
        int i = 0;
        while (i < verts.length) {
            schwarzNumbers[i] = Math.PI / HyperbolicUtils.hangle(verts[(i - 1 + verts.length) % verts.length], verts[i], verts[(i + 1) % verts.length]);
            ++i;
        }
        double[] snubFaceList = new double[2 * verts.length];
        int i2 = 0;
        while (i2 < verts.length) {
            snubFaceList[2 * i2] = verts.length;
            snubFaceList[2 * i2 + 1] = schwarzNumbers[i2];
            ++i2;
        }
        double snubHalfEdgeLength = HyperbolicUtils.calcUniformTilingHalfEdgeLength(snubFaceList, 1.0, 1.0);
        double[] distsToVerts = new double[verts.length];
        int i3 = 0;
        while (i3 < verts.length) {
            distsToVerts[i3] = HyperbolicUtils.polygonCircumRadius(schwarzNumbers[i3], snubHalfEdgeLength);
            ++i3;
        }
        double[] resultPoint = new double[2];
        if (!HyperbolicUtils.hBary2FromDistances(verts.length, resultPoint, distsToVerts, verts)) {
            return false;
        }
        return HyperbolicUtils.unHBary2(verts.length, result, resultPoint, verts, verbose);
    }

    public static boolean findBaryCoordsThatMakeSnubUniform(double[] result, Complex[] complexVerts, int verbose) {
        double[][] verts = new double[complexVerts.length][];
        int i = 0;
        while (i < verts.length) {
            verts[i] = new double[]{complexVerts[i].x, complexVerts[i].y};
            ++i;
        }
        return HyperbolicUtils.findBaryCoordsThatMakeSnubUniform(result, verts, verbose);
    }

    public static int UnCachedEnumerateIsometry2GroupForUniformTiling(Isometry2 F0, int nGens, Isometry2[] gens, int[] pp, int rotationalMultiplicity, int[] backEdgeInds, int maxIsometries, Isometry2[] return_isometries, int[] return_isometry_composition_lengths, Isometry2 return_smallestIsometry, int maxLevels, double tooFar, double tooSmall, int verbose) {
        long startTime = System.currentTimeMillis();
        if (rotationalMultiplicity < 1) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(1000): rotationalMultiplicity >= 1");
        }
        double smallestTranslateSqrd = F0.P.x * F0.P.x + F0.P.y * F0.P.y;
        return_smallestIsometry.set(F0);
        if (maxLevels == 0) {
            return 0;
        }
        if (maxIsometries == 0) {
            return 0;
        }
        int[] backEdgeSigns = new int[backEdgeInds.length];
        backEdgeInds = (int[])Arrays.copy(backEdgeInds, 1);
        int i = 0;
        while (i < backEdgeSigns.length) {
            int n = backEdgeSigns[i] = backEdgeInds[i] < 0 ? -1 : 1;
            if (backEdgeSigns[i] == -1) {
                int n2 = i;
                backEdgeInds[n2] = ~backEdgeInds[n2];
            }
            int n3 = i++;
            backEdgeSigns[n3] = backEdgeSigns[n3] * -1;
        }
        int[] expandedPP = new int[pp.length * rotationalMultiplicity];
        int[] expandedBackEdgeInds = new int[pp.length * rotationalMultiplicity];
        int[] expandedBackEdgeSigns = new int[pp.length * rotationalMultiplicity];
        int i2 = 0;
        while (i2 < expandedPP.length) {
            expandedPP[i2] = pp[i2 % pp.length];
            expandedBackEdgeSigns[i2] = backEdgeSigns[i2 % pp.length];
            expandedBackEdgeInds[i2] = backEdgeInds[i2 % pp.length] + i2 / pp.length * pp.length;
            ++i2;
        }
        pp = expandedPP;
        backEdgeInds = expandedBackEdgeInds;
        backEdgeSigns = expandedBackEdgeSigns;
        rotationalMultiplicity = 1;
        if (pp.length != nGens) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(1049): pp.length == nGens");
        }
        Node[] nodes = new Node[maxIsometries];
        int n = 0;
        if (n >= maxIsometries) {
            return n;
        }
        return_isometries[n] = F0;
        nodes[n] = new Node(nGens, 1, 0);
        if (return_isometry_composition_lengths != null) {
            return_isometry_composition_lengths[0] = 0;
        }
        if (++n >= maxIsometries) {
            return n;
        }
        int levelStart = 0;
        int iNode = 0;
        int iLevel = 0;
        iLevel = 0;
        while (iLevel < maxLevels) {
            int levelEnd = n;
            while (iNode < levelEnd) {
                int _iGen = 0;
                while (_iGen < nGens) {
                    int iGen = (nodes[iNode].start + nodes[iNode].sign * _iGen + nGens) % nGens;
                    if (verbose >= 3) {
                        System.out.println("    Trying " + iNode + ':' + iGen);
                    }
                    if (nodes[iNode].neighbors[iGen] != -1) {
                        if (verbose >= 3) {
                            System.out.println("        (ha, " + iNode + ':' + iGen + " -> " + nodes[iNode].neighbors[iGen] + ':' + nodes[iNode].backEdgeInds[iGen] + ')');
                        }
                    } else {
                        int dir = 1;
                        while (dir >= -1) {
                            int jNode = iNode;
                            int jGen = (iGen + dir * nodes[jNode].sign + nGens) % nGens;
                            int faceSize = pp[dir * nodes[iNode].sign == -1 ? (iGen - 1 + nGens) % nGens : iGen];
                            if (verbose >= 3) {
                                System.out.print("            ");
                            }
                            int iAlongFace = 0;
                            while (iAlongFace < faceSize - 1) {
                                Node node = nodes[jNode];
                                jNode = node.neighbors[jGen];
                                jGen = node.backEdgeInds[jGen];
                                if (verbose >= 3) {
                                    System.out.print("" + jNode + ':' + jGen + ' ');
                                }
                                if (jNode == -1) break;
                                jGen = (jGen + dir * nodes[jNode].sign + nGens) % nGens;
                                if (verbose >= 3) {
                                    System.out.print("" + jNode + ':' + jGen + ' ');
                                }
                                ++iAlongFace;
                            }
                            if (verbose >= 3) {
                                System.out.println();
                            }
                            if (jNode != -1) {
                                if (verbose >= 3) {
                                    System.out.println("        (HA! found it!!! " + iNode + ':' + iGen + " -> " + jNode + ':' + jGen + " (dir=" + dir + "))");
                                }
                                nodes[iNode].neighbors[iGen] = jNode;
                                nodes[iNode].backEdgeInds[iGen] = jGen;
                                nodes[jNode].neighbors[jGen] = iNode;
                                nodes[jNode].backEdgeInds[jGen] = iGen;
                                break;
                            }
                            dir -= 2;
                        }
                        if (nodes[iNode].neighbors[iGen] == -1) {
                            Isometry2 I = return_isometries[iNode];
                            Isometry2 F = Isometry2.mul(I, gens[iGen], return_isometries[n]);
                            if ((gens[iGen].P.x != 0.0 || gens[iGen].P.y != 0.0) && (F.P.x - I.P.x) * (F.P.x - I.P.x) + (F.P.y - I.P.y) * (F.P.y - I.P.y) < tooSmall * tooSmall) {
                                if (verbose >= 2) {
                                    System.out.print("S");
                                }
                            } else {
                                double thisTranslateSqrd = F.P.x * F.P.x + F.P.y * F.P.y;
                                if (thisTranslateSqrd >= tooFar * tooFar) {
                                    if (verbose >= 2) {
                                        System.out.print("F");
                                    }
                                } else {
                                    int jNode = n;
                                    int jGen = backEdgeInds[iGen];
                                    nodes[jNode] = new Node(nGens, nodes[iNode].sign * backEdgeSigns[iGen], jGen);
                                    nodes[iNode].neighbors[iGen] = jNode;
                                    nodes[iNode].backEdgeInds[iGen] = jGen;
                                    nodes[jNode].neighbors[jGen] = iNode;
                                    nodes[jNode].backEdgeInds[jGen] = iGen;
                                    if (return_isometry_composition_lengths != null) {
                                        return_isometry_composition_lengths[jNode] = return_isometry_composition_lengths[iNode] + 1;
                                    }
                                    if ((return_isometry_composition_lengths != null ? return_isometry_composition_lengths[jNode] % 2 == 0 : return_isometries[jNode].R == 1) && thisTranslateSqrd < smallestTranslateSqrd) {
                                        smallestTranslateSqrd = thisTranslateSqrd;
                                        return_smallestIsometry.set(F);
                                    }
                                    if (verbose >= 3) {
                                        System.out.println("        adding " + iNode + " -> " + nodes[iNode].neighbors[iGen]);
                                    }
                                    if (++n >= maxIsometries) break;
                                }
                            }
                        }
                    }
                    ++_iGen;
                }
                if (n >= maxIsometries) break;
                ++iNode;
            }
            if (n >= maxIsometries) break;
            levelStart = levelEnd;
            ++iLevel;
        }
        long endTime = System.currentTimeMillis();
        if (verbose >= 1) {
            if (iNode == n) {
                System.out.println("Got all " + n + " return_isometries\n");
            }
            if (iLevel >= maxLevels) {
                System.out.println("Terminating enumeration at " + iLevel + " levels\n");
            }
            if (n == maxIsometries) {
                System.out.println("Terminating enumeration at " + n + " return_isometries\n");
            }
            System.out.print("    ");
            System.out.println("endTime-startTime = " + (endTime - startTime));
        }
        return n;
    }

    public static int UnCachedEnumerateIsometry2Group(Isometry2 F0, int nGens, Isometry2[] gens, int rotationalMultiplicity, int maxIsometries, Isometry2[] return_isometries, Isometry2 return_smallestIsometry, int maxLevels, double tooFar, double tooSmall, int verbose) {
        long startTime = System.currentTimeMillis();
        if (rotationalMultiplicity < 1) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(1242): rotationalMultiplicity >= 1");
        }
        Isometry2HashTable hashTable = new Isometry2HashTable();
        double smallestTranslateSqrd = F0.P.x * F0.P.x + F0.P.y * F0.P.y;
        return_smallestIsometry.set(F0);
        if (maxLevels == 0) {
            return 0;
        }
        if (maxIsometries == 0) {
            return 0;
        }
        int n = 0;
        if (n >= maxIsometries) {
            return n;
        }
        boolean inserted = hashTable.Insert(F0);
        if (!inserted) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(1255): inserted");
        }
        return_isometries[n++] = F0;
        if (n >= maxIsometries) {
            return n;
        }
        int nIsometriesOnPreviousLevels = 1;
        int generatingLevel = 1;
        if (generatingLevel >= maxLevels) {
            return n;
        }
        Isometry2 rotation = Isometry2.pureRotation(Math.PI / (double)rotationalMultiplicity);
        Isometry2 temp = new Isometry2();
        if (verbose >= 1) {
            System.out.print("    ");
            System.out.println("rotationalMultiplicity = " + rotationalMultiplicity);
        }
        rotationalMultiplicity = 1;
        if (verbose >= 1) {
            System.out.print("    ");
            System.out.println("rotationalMultiplicity = " + rotationalMultiplicity);
        }
        int i = 0;
        while (i < n) {
            if (i == nIsometriesOnPreviousLevels) {
                if (++generatingLevel >= maxLevels) break;
                nIsometriesOnPreviousLevels = n;
            }
            Isometry2 I = new Isometry2(return_isometries[i]);
            int iRot = 0;
            while (iRot < rotationalMultiplicity) {
                int iGen = 0;
                while (iGen < nGens) {
                    Isometry2 F = Isometry2.mul(I, gens[iGen], return_isometries[n]);
                    if ((gens[iGen].P.x != 0.0 || gens[iGen].P.y != 0.0) && (F.P.x - I.P.x) * (F.P.x - I.P.x) + (F.P.y - I.P.y) * (F.P.y - I.P.y) < tooSmall * tooSmall) {
                        if (verbose >= 2) {
                            System.out.print("S");
                        }
                    } else {
                        double thisTranslateSqrd = F.P.x * F.P.x + F.P.y * F.P.y;
                        if (thisTranslateSqrd >= tooFar * tooFar) {
                            if (verbose >= 2) {
                                System.out.print("F");
                            }
                        } else {
                            inserted = hashTable.Insert(F);
                            if (inserted) {
                                if (thisTranslateSqrd < smallestTranslateSqrd) {
                                    smallestTranslateSqrd = thisTranslateSqrd;
                                    return_smallestIsometry.set(F);
                                }
                                if (++n >= maxIsometries) break;
                            }
                        }
                    }
                    ++iGen;
                }
                if (n >= maxIsometries || iRot == rotationalMultiplicity - 1) break;
                Isometry2.mul(I, rotation, temp);
                I.set(temp);
                ++iRot;
            }
            if (n >= maxIsometries) break;
            ++i;
        }
        if (verbose >= 1) {
            if (i == n) {
                System.out.println("Got all " + n + " return_isometries\n");
            }
            if (generatingLevel >= maxLevels) {
                System.out.println("Terminating enumeration at " + generatingLevel + " levels\n");
            }
            if (n == maxIsometries) {
                System.out.println("Terminating enumeration at " + n + " return_isometries\n");
            }
        }
        long endTime = System.currentTimeMillis();
        if (verbose >= 1) {
            System.out.print("    ");
            System.out.println("endTime-startTime = " + (endTime - startTime));
            System.out.print("    ");
            System.out.println("hashTable.nInsertSuccesses = " + hashTable.nInsertSuccesses);
            System.out.print("    ");
            System.out.println("hashTable.nInsertFailures = " + hashTable.nInsertFailures);
        }
        return n;
    }

    public static int subdivideArc(double[] p0, double[] p1, double tolerance, int maxIntermediatePoints, int startI, double[][] result_intermediatePoints) {
        Complex _p0 = new Complex(p0);
        Complex _p1 = new Complex(p1);
        Complex _p1_minus_p0 = Isometry2.pureTranslation(-_p0.x, -_p0.y).apply(_p1);
        double fullDist = HyperbolicUtils.e2hNorm(Math.sqrt(_p1_minus_p0.x * _p1_minus_p0.x + _p1_minus_p0.y * _p1_minus_p0.y));
        int N = p0.length;
        if (N != 2) {
            throw new Error("Assertion failed at HyperbolicUtils.prejava(1390): N == 2");
        }
        int nIntermediatePoints = maxIntermediatePoints;
        double sinh_fullDist = MyMath.sinh(fullDist);
        int i = 0;
        while (i < nIntermediatePoints) {
            double t = (double)(i + 1) / (double)(nIntermediatePoints + 1);
            HyperbolicUtils.hlerp2_poincare(p0, p1, t, result_intermediatePoints[startI + i]);
            ++i;
        }
        return nIntermediatePoints;
    }

    static double hlerp2_poincare(double[] p0, double[] p1, double t, double[] result) {
        Isometry2 take_p0_to_origin = Isometry2.pureTranslation(-p0[0], -p0[1]);
        Isometry2 take_origin_to_p0 = Isometry2.pureTranslation(p0[0], p0[1]);
        double[] p1_ = take_p0_to_origin.apply(p1);
        double normSqrd = p1_[0] * p1_[0] + p1_[1] * p1_[1];
        if (normSqrd < 1.0E-12) {
            if (result != null) {
                result[0] = p0[0] + t * (p1[0] - p0[0]);
                result[1] = p0[1] + t * (p1[1] - p0[1]);
            }
            return (double)2 * Math.sqrt(normSqrd);
        }
        if (normSqrd > 1.0) {
            if (result != null) {
                result[0] = 0.0;
                result[1] = 0.0;
            }
            return -1.0;
        }
        double norm = Math.sqrt(normSqrd);
        double atanNorm = MyMath.atanh(norm);
        if (result != null) {
            double desiredNorm = MyMath.tanh(t * atanNorm);
            double[] p_ = p1_;
            VecMath.vxs(p_, p1_, desiredNorm / norm);
            take_origin_to_p0.apply(p_, result);
        }
        return (double)2 * atanNorm;
    }

    static double hlerp2_poincare(Complex p0, Complex p1, double t, Complex result) {
        double[] temp = new double[2];
        double dist = HyperbolicUtils.hlerp2_poincare(new double[]{p0.x, p0.y}, new double[]{p1.x, p1.y}, t, temp);
        result.set(temp[0], temp[1]);
        return dist;
    }

    static double hdist2_poincare(double[] p0, double[] p1) {
        return HyperbolicUtils.hlerp2_poincare(p0, p1, 0.0, null);
    }

    static double hlerp2_poincare(double[] p0, double[] p1, double t, double aspect, double[] result) {
        if (aspect == 1.0) {
            return HyperbolicUtils.hlerp2_poincare(p0, p1, t, result);
        }
        double[] _p0 = new double[2];
        double[] _p1 = new double[2];
        VecMath.vxs(_p0, p0, Math.pow(Math.sqrt(VecMath.dot(p0, p0)), 1.0 / aspect - 1.0));
        VecMath.vxs(_p1, p1, Math.pow(Math.sqrt(VecMath.dot(p1, p1)), 1.0 / aspect - 1.0));
        double dist = HyperbolicUtils.hlerp2_poincare(_p0, _p1, t, result);
        if (result != null) {
            VecMath.vxs(result, result, Math.pow(Math.sqrt(VecMath.dot(result, result)), aspect - 1.0));
        }
        return dist;
    }

    static double hlerp2_uhp(double[] p0, double[] p1, double t, double aspect, double[] result) {
        double[] p0_ = new double[2];
        double[] p1_ = new double[2];
        double[] p_ = result == null ? null : new double[2];
        HyperbolicUtils.uhp2d(p0[0], p0[1] / aspect, p0_);
        HyperbolicUtils.uhp2d(p1[0], p1[1] / aspect, p1_);
        double ret = HyperbolicUtils.hlerp2_poincare(p0_, p1_, t, p_);
        if (result != null) {
            HyperbolicUtils.d2uhp(p_[0], p_[1], result);
            result[1] = result[1] * aspect;
        }
        return ret;
    }

    static double hlerp2_simple_inversion(double[] p0, double[] p1, double t, double aspect, boolean conformal, double[] result) {
        double[] p0_ = new double[2];
        double[] p1_ = new double[2];
        double[] u0 = new double[2];
        double invLength0 = 1.0 / Math.sqrt(VecMath.dot(p0, p0));
        double invLength1 = 1.0 / Math.sqrt(VecMath.dot(p1, p1));
        double[] u1 = new double[2];
        VecMath.vxs(u0, p0, invLength0);
        VecMath.vxs(u1, p1, invLength1);
        double[] u = new double[2];
        VecMath.vpv(u, u0, u1);
        VecMath.vxs(u, u, 1.0 / Math.sqrt(VecMath.dot(u, u)));
        VecMath.vxs(p1_, u, Math.sqrt(invLength1));
        VecMath.vxs(p0_, u0, Math.sqrt(invLength0));
        double ret = HyperbolicUtils.hlerp2_poincare(p0_, p1_, t, result);
        if (result != null && ret != -1.0) {
            double finalLength = 1.0 / VecMath.dot(result, result);
            double[] u2 = new double[2];
            VecMath.vxs(u2, result, Math.sqrt(finalLength));
            double[] halfway = new double[2];
            VecMath.vxs(halfway, u2, VecMath.dot(u0, u2));
            double[] fullway = new double[2];
            VecMath.sxvpsxv(fullway, 2, halfway, -1.0, u0);
            VecMath.vxs(result, fullway, finalLength);
        }
        return ret;
    }

    static double distToCircleCenteredAtMinus1(double x, double y) {
        return (x * x + y * (y + (double)2)) / (Math.sqrt(x * x + (y + 1.0) * (y + 1.0)) + 1.0);
    }

    static double hlerp2_polar(double[] p0, double[] p1, double t, double aspect, boolean conformal, double[] result) {
        double x0 = p0[0];
        double y0 = p0[1] - 1.0;
        double x1 = p1[0];
        double y1 = p1[1] - 1.0;
        double actualAlt0 = HyperbolicUtils.distToCircleCenteredAtMinus1(x0, y0);
        double actualAlt1 = HyperbolicUtils.distToCircleCenteredAtMinus1(x1, y1);
        double angle0 = Math.atan2(-x0, y0 + 1.0);
        double angle1 = Math.atan2(-x1, y1 + 1.0);
        if (angle1 > angle0 + Math.PI) {
            angle1 -= Math.PI * 2;
        } else if (angle1 < angle0 - Math.PI) {
            angle1 += Math.PI * 2;
        }
        double alt0 = MyMath.log1p(actualAlt0);
        double alt1 = MyMath.log1p(actualAlt1);
        if (!conformal) {
            alt0 = actualAlt0;
            alt1 = actualAlt1;
        }
        double[] p0_ = new double[]{angle0, alt0};
        double[] p1_ = new double[]{angle1, alt1};
        double ret = HyperbolicUtils.hlerp2_uhp(p0_, p1_, t, aspect, result);
        if (result != null) {
            double angle = result[0];
            double alt = result[1];
            double actualAlt = conformal ? MyMath.expm1(alt) : alt;
            double r = actualAlt + 1.0;
            double x = -r * Math.sin(angle);
            double y = actualAlt - r * MyMath.cosf1(angle);
            result[0] = x;
            result[1] = y + 1.0;
        }
        return ret;
    }

    static boolean hspline(double t0, double[] p0, double t1, double[] p1, double t2, double[] p2, double t3, double[] p3, double t, double aspect, boolean conformal, LerpFunction lerp, double[] result) {
        boolean verbose = false;
        double transT = -t1;
        double scaleT = 1.0 / (t2 - t1);
        t0 = (t0 + transT) * scaleT;
        t1 = 0.0;
        t2 = 1.0;
        t3 = (t3 + transT) * scaleT;
        t = (t + transT) * scaleT;
        double[][] W = new double[4][4];
        double[][] dArrayArray = new double[4][];
        double[] dArray = new double[4];
        dArray[0] = 1.0;
        dArray[2] = -3.0;
        dArray[3] = 2;
        dArrayArray[0] = dArray;
        double[] dArray2 = new double[4];
        dArray2[2] = 3;
        dArray2[3] = -2.0;
        dArrayArray[1] = dArray2;
        double[] dArray3 = new double[4];
        dArray3[1] = 1.0;
        dArray3[2] = -2.0;
        dArray3[3] = 1.0;
        dArrayArray[2] = dArray3;
        double[] dArray4 = new double[4];
        dArray4[2] = -1.0;
        dArray4[3] = 1.0;
        dArrayArray[3] = dArray4;
        double[][] invT = dArrayArray;
        double[][] dArrayArray2 = new double[4][];
        double[] dArray5 = new double[4];
        dArray5[2] = -1.0 / ((1.0 - t0) * -t0);
        dArrayArray2[0] = dArray5;
        double[] dArray6 = new double[4];
        dArray6[0] = 1.0;
        dArray6[2] = 1.0 / ((1.0 - t0) * -t0) - -t0 / (1.0 - t0);
        dArray6[3] = -(t3 - 1.0) / t3;
        dArrayArray2[1] = dArray6;
        double[] dArray7 = new double[4];
        dArray7[1] = 1.0;
        dArray7[2] = -t0 / (1.0 - t0);
        dArray7[3] = (t3 - 1.0) / t3 - 1.0 / (t3 * (t3 - 1.0));
        dArrayArray2[2] = dArray7;
        double[] dArray8 = new double[4];
        dArray8[3] = 1.0 / (t3 * (t3 - 1.0));
        dArrayArray2[3] = dArray8;
        double[][] thatHairyMatrixOnTheRight = dArrayArray2;
        VecMath.mxm(W, thatHairyMatrixOnTheRight, invT);
        double[] tVec = new double[]{1.0, t, t * t, t * t * t};
        double[] wVec = new double[4];
        VecMath.mxv(wVec, W, tVec);
        double w0 = wVec[0];
        double w1 = wVec[1];
        double w2 = wVec[2];
        double w3 = wVec[3];
        double w1_01 = w0 + w1 == 0.0 ? 0.5 : w1 / (w0 + w1);
        double w3_23 = w2 + w3 == 0.0 ? 0.5 : w3 / (w2 + w3);
        double w23 = w2 + w3;
        double[] A = new double[2];
        double[] B = new double[2];
        if (lerp.apply(p0, p1, w1_01, aspect, conformal, A) == -1.0) {
            return false;
        }
        if (lerp.apply(p2, p3, w3_23, aspect, conformal, B) == -1.0) {
            return false;
        }
        return lerp.apply(A, B, w23, aspect, conformal, result) != -1.0;
    }

    private static final void canonicalCircularInvert(double x, double y, double[] result) {
        double scale = (double)2 / (x * x + (y + 1.0) * (y + 1.0));
        result[0] = x * scale;
        result[1] = (y + 1.0) * scale - 1.0;
    }

    static boolean hlerp3_polar(double[] p0, double[] p1, double t, double aspect, double result) {
        return false;
    }

    static void d2uhp(double x, double y, double[] result) {
        HyperbolicUtils.canonicalCircularInvert(x, -y, result);
    }

    static void uhp2d(double x, double y, double[] result) {
        HyperbolicUtils.canonicalCircularInvert(x, y, result);
        result[1] = result[1] * -1.0;
    }

    private static class Node {
        int[] neighbors;
        int[] backEdgeInds;
        int sign;
        int start;

        public Node(int valence, int sign, int start) {
            this.neighbors = Arrays.fill(valence, -1);
            this.backEdgeInds = Arrays.fill(valence, -1);
            this.sign = sign;
            this.start = start;
        }
    }

    public static abstract class LerpFunction {
        public abstract double apply(double[] var1, double[] var2, double var3, double var5, boolean var7, double[] var8);

        public double dist(double[] p0, double[] p1, double aspect, boolean conformal) {
            return this.apply(p0, p1, 0.5, aspect, conformal, null);
        }
    }

    public static class Hlerp2_poincare
    extends LerpFunction {
        public double apply(double[] p0, double[] p1, double t, double aspect, boolean conformal, double[] result) {
            return HyperbolicUtils.hlerp2_poincare(p0, p1, t, aspect, result);
        }
    }

    public static class Hlerp2_uhp
    extends LerpFunction {
        public double apply(double[] p0, double[] p1, double t, double aspect, boolean conformal, double[] result) {
            return HyperbolicUtils.hlerp2_uhp(p0, p1, t, aspect, result);
        }
    }

    public static class Hlerp2_polar
    extends LerpFunction {
        public double apply(double[] p0, double[] p1, double t, double aspect, boolean conformal, double[] result) {
            return HyperbolicUtils.hlerp2_polar(p0, p1, t, aspect, conformal, result);
        }
    }

    public static class Hlerp2_simple_inversion
    extends LerpFunction {
        public double apply(double[] p0, double[] p1, double t, double aspect, boolean conformal, double[] result) {
            return HyperbolicUtils.hlerp2_simple_inversion(p0, p1, t, aspect, conformal, result);
        }
    }

    public static class Hlerp2_euclidean
    extends LerpFunction {
        public double apply(double[] p0, double[] p1, double t, double aspect, boolean conformal, double[] result) {
            if (result != null) {
                VecMath.sxvpsxv(result, 1.0 - t, p0, t, p1);
            }
            return Math.sqrt(VecMath.distsqrd(p0, p1));
        }
    }
}

