/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class HyperbolicDrawUtils {
    public static void DrawOmnitruncatedTiling(MyGraphics mg, int hyperbolicModel, Isometry2 F0, int p, int q, int maxLevels, int maxIsometries, double[] wythoffCoeffs, boolean drawPrimal, float primalR, float primalG, float primalB, boolean drawDual, float dualR, float dualG, float dualB, boolean drawSnub, float snubR, float snubG, float snubB, int snubParity, boolean doCurveLines, boolean doAntiAlias, boolean doRemoveDups, boolean doRandomJitter, double lineThicknessInPixels, int showIsometryLabels, int verbose, Isometry2 return_smallestIsometry, PickableSchwarzPolygon return_pickableSchwarz) {
        int nSegments;
        Object segments;
        boolean drawGreenGridForDebugging;
        int nIsometries;
        double tolerance = 0.001;
        double halfEdgeLength = HyperbolicUtils.calcRegularTilingHalfEdgeLength(p, q);
        if (verbose >= 1) {
            System.out.print("    ");
            System.out.println("p = " + p);
            System.out.print("    ");
            System.out.println("q = " + q);
            System.out.print("    ");
            System.out.println("halfEdgeLength = " + halfEdgeLength);
        }
        double R = HyperbolicUtils.h2eNorm((double)2 * halfEdgeLength);
        double r = HyperbolicUtils.h2eNorm(halfEdgeLength);
        Isometry2 A = new Isometry2(new Complex(Math.cos(Math.PI - Math.PI * 2 / (double)q), Math.sin(Math.PI - Math.PI * 2 / (double)q)), new Complex(R, 0.0), 1);
        Isometry2 B = new Isometry2(new Complex(Math.cos(Math.PI * 2 / (double)q), Math.sin(Math.PI * 2 / (double)q)), Complex.zero, 1);
        Isometry2[] gens = new Isometry2[]{A, B};
        double tooSmall = 0.001;
        double tooFar = 1.0 - tooSmall;
        double x0 = 0.0;
        double y0 = 0.0;
        double x1 = R;
        double y1 = 0.0;
        Isometry2[] list = new Isometry2[maxIsometries];
        int i = 0;
        while (i < maxIsometries) {
            list[i] = new Isometry2();
            ++i;
        }
        boolean useNewShellMethod = true;
        if (useNewShellMethod) {
            Isometry2 C = Isometry2.mul(Isometry2.pureTranslation(R, 0.0), Isometry2.pureRotation(Math.PI));
            gens = new Isometry2[q];
            int iGen = 0;
            while (iGen < q) {
                Isometry2 rotate = Isometry2.pow(B, iGen);
                Isometry2 temp = Isometry2.mul(C, rotate.inverse());
                gens[iGen] = Isometry2.mul(rotate, temp);
                ++iGen;
            }
            nIsometries = HyperbolicUtils.UnCachedEnumerateIsometry2GroupForUniformTiling(F0, gens.length, gens, new int[]{p}, q, new int[]{-1}, maxIsometries, list, null, return_smallestIsometry, maxLevels, tooFar, tooSmall, verbose);
            int newNIsometries = nIsometries * q;
            Isometry2[] newIsometries = new Isometry2[newNIsometries];
            Isometry2[] rotates = new Isometry2[q];
            int iArm = 0;
            while (iArm < q) {
                rotates[iArm] = Isometry2.pow(B, iArm);
                ++iArm;
            }
            int iIsometry = 0;
            while (iIsometry < nIsometries) {
                int iArm2 = 0;
                while (iArm2 < q) {
                    newIsometries[iIsometry * q + iArm2] = Isometry2.mul(list[iIsometry], rotates[iArm2]);
                    ++iArm2;
                }
                ++iIsometry;
            }
            nIsometries = newNIsometries;
            list = newIsometries;
        } else {
            nIsometries = HyperbolicUtils.UnCachedEnumerateIsometry2Group(F0, gens.length, gens, q, maxIsometries, list, return_smallestIsometry, maxLevels, tooFar, tooSmall, verbose);
        }
        if (verbose >= 1) {
            System.out.println(nIsometries + " isometries");
        }
        if (drawGreenGridForDebugging = false) {
            mg.setColor(new Color(0.0f, 0.5f, 0.0f));
            int subDiv = 20;
            int i2 = 0;
            while (i2 < subDiv + 1) {
                mg.drawLine(-1.0f + (float)i2 / (float)subDiv * 2.0f, -1.0, -1.0f + (float)i2 / (float)subDiv * 2.0f, 1.0, doAntiAlias);
                mg.drawLine(-1.0, -1.0f + (float)i2 / (float)subDiv * 2.0f, 1.0, -1.0f + (float)i2 / (float)subDiv * 2.0f, doAntiAlias);
                ++i2;
            }
        }
        double[][] elementCenters = new double[3][2];
        elementCenters[0][0] = 0.0;
        elementCenters[0][1] = 0.0;
        elementCenters[1][0] = r;
        elementCenters[1][1] = 0.0;
        HyperbolicUtils.calcFaceCenter(p, q, elementCenters[2]);
        return_pickableSchwarz.setVertices(elementCenters, F0);
        boolean drawSchwarzPolygon = false;
        if (drawSchwarzPolygon) {
            Complex[] sp = return_pickableSchwarz.SchwarzPolygon;
            int i3 = 0;
            while (i3 < sp.length) {
                HyperbolicDrawUtils.DrawLine2fPoincare(mg, sp[i3].x, sp[i3].y, sp[(i3 + 1) % sp.length].x, sp[(i3 + 1) % sp.length].y, tolerance, hyperbolicModel, doCurveLines, doAntiAlias, doRandomJitter, lineThicknessInPixels);
                ++i3;
            }
        }
        if (drawDual) {
            mg.setColor(new Color(dualR, dualG, dualB));
            Complex[] P = new Complex[3];
            P[0] = new Complex(0.0, 0.0);
            P[1] = new Complex(r, 0.0);
            double[] P2 = new double[2];
            HyperbolicUtils.calcFaceCenter(p, q, P2);
            P[2] = new Complex(P2);
            segments = new int[4][2];
            nSegments = 0;
            if (wythoffCoeffs[0] != 0.0) {
                segments[nSegments][0] = 1;
                segments[nSegments][1] = 2;
                ++nSegments;
            }
            if (wythoffCoeffs[1] != 0.0) {
                segments[nSegments][0] = 0;
                segments[nSegments][1] = 2;
                ++nSegments;
            }
            if (wythoffCoeffs[2] != 0.0) {
                segments[nSegments][0] = 0;
                segments[nSegments][1] = 1;
                ++nSegments;
            }
            if (nSegments > ((int[][])segments).length) {
                throw new Error("Assertion failed at HyperbolicDrawUtils.prejava(217): nSegments <= segments.length");
            }
            HyperbolicDrawUtils.DrawTiling(mg, hyperbolicModel, nIsometries, list, P.length, P, nSegments, segments, null, doCurveLines, doAntiAlias, doRemoveDups, doRandomJitter, lineThicknessInPixels, 0, tolerance, verbose);
        }
        if (drawSnub) {
            mg.setColor(new Color(snubR, snubG, snubB));
            Complex[] P = new Complex[6];
            double[] P0 = new double[2];
            if (!HyperbolicUtils.hBary2(3, P0, wythoffCoeffs, elementCenters, verbose)) {
                return;
            }
            P[0] = new Complex(P0);
            P[1] = B.apply(P[0]);
            P[2] = B.inverse().apply(P[0]);
            P[3] = A.apply(P[1]);
            P[4] = A.apply(P[0]);
            P[5] = A.inverse().apply(P[0]);
            if (snubParity == 1) {
                int i4 = 0;
                while (i4 < P.length) {
                    P[i4].y *= -1.0;
                    ++i4;
                }
            }
            int[][] nArrayArray = new int[4][];
            int[] nArray = new int[2];
            nArray[1] = 1;
            nArrayArray[0] = nArray;
            int[] nArray2 = new int[2];
            nArray2[1] = 2;
            nArrayArray[1] = nArray2;
            int[] nArray3 = new int[2];
            nArray3[1] = 3;
            nArrayArray[2] = nArray3;
            int[] nArray4 = new int[2];
            nArray4[1] = 4;
            nArrayArray[3] = nArray4;
            segments = nArrayArray;
            nSegments = ((int[][])segments).length;
            HyperbolicDrawUtils.DrawTiling(mg, hyperbolicModel, nIsometries, list, P.length, P, nSegments, segments, null, doCurveLines, doAntiAlias, doRemoveDups, doRandomJitter, lineThicknessInPixels, showIsometryLabels, tolerance, verbose);
        }
        if (drawPrimal) {
            mg.setColor(new Color(primalR, primalG, primalB));
            Complex[] P = new Complex[7];
            double[] P0 = new double[2];
            if (!HyperbolicUtils.hBary2(3, P0, wythoffCoeffs, elementCenters, verbose)) {
                return;
            }
            P[0] = new Complex(P0);
            int i5 = 0;
            while (i5 < 3) {
                double[] temp = new double[2];
                HyperbolicUtils.calcClosestPointOnLine2(temp, P0, elementCenters[i5], elementCenters[(i5 + 1) % 3]);
                P[i5 + 1] = new Complex(temp);
                HyperbolicUtils.hlerp2_poincare(P0, temp, (double)2, temp);
                P[i5 + 1 + 3] = new Complex(temp);
                ++i5;
            }
            int[][] segments2 = new int[6][2];
            int nSegments2 = 0;
            int i6 = 0;
            while (i6 < 3) {
                if (wythoffCoeffs[(i6 + 2) % 3] != 0.0) {
                    segments2[nSegments2][0] = 0;
                    segments2[nSegments2][1] = i6 + 1;
                    ++nSegments2;
                    if (i6 == 2 || wythoffCoeffs[2 * i6] != 0.0) {
                        segments2[nSegments2][0] = i6 + 1;
                        segments2[nSegments2][1] = i6 + 1 + 3;
                        ++nSegments2;
                    }
                }
                ++i6;
            }
            if (nSegments2 > segments2.length) {
                throw new Error("Assertion failed at HyperbolicDrawUtils.prejava(294): nSegments <= segments.length");
            }
            HyperbolicDrawUtils.DrawTiling(mg, hyperbolicModel, nIsometries, list, P.length, P, nSegments2, segments2, null, doCurveLines, doAntiAlias, doRemoveDups, doRandomJitter, lineThicknessInPixels, showIsometryLabels, tolerance, verbose);
        }
        if (hyperbolicModel == 0 || hyperbolicModel == 1 || hyperbolicModel == 3) {
            mg.setColor(new Color(primalR, primalG, primalB));
            mg.drawThickArc(-1.0, -1.0, 2, 2, 0.0, Math.PI * 2, lineThicknessInPixels, doAntiAlias);
        }
    }

    public static void DrawUniformTiling(MyGraphics mg, int hyperbolicModel, Isometry2 F0, int[] pp, int q, int[] backEdgeInds, int maxLevels, int maxIsometries, double[] wythoffCoeffs, boolean drawPrimal, float primalR, float primalG, float primalB, boolean drawDual, float dualR, float dualG, float dualB, boolean drawSnub, float snubR, float snubG, float snubB, int snubParity, boolean doCurveLines, boolean doAntiAlias, boolean doRemoveDups, boolean doRandomJitter, double lineThicknessInPixels, int showIsometryLabels, int verbose, Isometry2 return_smallestIsometry, PickableSchwarzPolygon return_pickableSchwarz) {
        int i;
        boolean drawGreenGridForDebugging;
        double tolerance = 0.001;
        double halfEdgeLength = HyperbolicUtils.calcUniformTilingHalfEdgeLength(pp, (double)q, 1.0);
        int p = pp[0];
        if (verbose >= 1) {
            System.out.print("    ");
            System.out.println("p = " + p);
            System.out.print("    ");
            System.out.println("q = " + q);
            System.out.print("    ");
            System.out.println("halfEdgeLength = " + halfEdgeLength);
        }
        double R = HyperbolicUtils.h2eNorm((double)2 * halfEdgeLength);
        double r = HyperbolicUtils.h2eNorm(halfEdgeLength);
        double[] angles = new double[pp.length * q];
        double angle = 0.0;
        int i2 = 0;
        while (i2 < pp.length * q) {
            angles[i2] = angle;
            angle += (double)2 * HyperbolicUtils.polygonHalfAngle(pp[i2 % pp.length], halfEdgeLength);
            ++i2;
        }
        Complex[] neighbors = new Complex[pp.length * q];
        Complex[] edgeCenters = new Complex[pp.length * q];
        i2 = 0;
        while (i2 < pp.length * q) {
            double angle2 = angles[i2];
            neighbors[i2] = new Complex(R * Math.cos(angle2), R * Math.sin(angle2));
            edgeCenters[i2] = new Complex(r * Math.cos(angle2), r * Math.sin(angle2));
            ++i2;
        }
        Complex[] faceCenters = new Complex[pp.length * q];
        int i3 = 0;
        while (i3 < pp.length * q) {
            double[] P2 = new double[2];
            HyperbolicUtils.calcFaceCenterFromHalfEdgeLength(pp[i3 % pp.length], halfEdgeLength, P2);
            faceCenters[i3] = new Complex(P2);
            Isometry2.pureRotation(angles[i3]).apply(faceCenters[i3], faceCenters[i3]);
            ++i3;
        }
        Isometry2[] gens = new Isometry2[pp.length * q];
        int i4 = 0;
        while (i4 < pp.length * q) {
            boolean isRotation = false;
            int j = backEdgeInds[i4 % pp.length];
            if (j < 0) {
                j ^= 0xFFFFFFFF;
                isRotation = true;
            }
            Isometry2 G = Isometry2.pureRotation(-angles[j += i4 / pp.length * pp.length]);
            G = isRotation ? Isometry2.mul(new Isometry2(new Complex(-1.0, 0.0), new Complex(0.0, 0.0), 1), G) : Isometry2.mul(new Isometry2(new Complex(-1.0, 0.0), new Complex(0.0, 0.0), -1), G);
            G = Isometry2.mul(Isometry2.pureRotation(angles[i4]), G);
            gens[i4] = G = Isometry2.mul(Isometry2.pureTranslation(neighbors[i4].x, neighbors[i4].y), G);
            ++i4;
        }
        double tooSmall = 5.0E-4;
        double tooFar = 1.0 - tooSmall;
        double x0 = 0.0;
        double y0 = 0.0;
        double x1 = R;
        double y1 = 0.0;
        Isometry2[] list = new Isometry2[maxIsometries];
        int i5 = 0;
        while (i5 < maxIsometries) {
            list[i5] = new Isometry2();
            ++i5;
        }
        boolean useNewShellMethod = true;
        int[] compositionLengths = null;
        if (drawSnub && useNewShellMethod) {
            compositionLengths = new int[maxIsometries];
        }
        int nIsometries = useNewShellMethod ? HyperbolicUtils.UnCachedEnumerateIsometry2GroupForUniformTiling(F0, gens.length, gens, pp, q, backEdgeInds, maxIsometries, list, compositionLengths, return_smallestIsometry, maxLevels, tooFar, tooSmall, verbose) : HyperbolicUtils.UnCachedEnumerateIsometry2Group(F0, gens.length, gens, q, maxIsometries, list, return_smallestIsometry, maxLevels, tooFar, tooSmall, verbose);
        if (verbose >= 1) {
            System.out.println(nIsometries + " isometries");
        }
        if (drawGreenGridForDebugging = false) {
            mg.setColor(new Color(0.0f, 0.5f, 0.0f));
            int subDiv = 20;
            int i6 = 0;
            while (i6 < subDiv + 1) {
                mg.drawLine(-1.0f + (float)i6 / (float)subDiv * 2.0f, -1.0, -1.0f + (float)i6 / (float)subDiv * 2.0f, 1.0, doAntiAlias);
                mg.drawLine(-1.0, -1.0f + (float)i6 / (float)subDiv * 2.0f, 1.0, -1.0f + (float)i6 / (float)subDiv * 2.0f, doAntiAlias);
                ++i6;
            }
        }
        if (drawDual) {
            mg.setColor(new Color(dualR, dualG, dualB));
            Complex[] P = new Complex[2 * edgeCenters.length];
            int[][] segments = new int[2 * edgeCenters.length][2];
            i = 0;
            while (i < edgeCenters.length) {
                P[2 * i] = edgeCenters[i];
                P[2 * i + 1] = faceCenters[i];
                ++i;
            }
            i = 0;
            while (i < 2 * edgeCenters.length) {
                segments[i][0] = i;
                segments[i][1] = (i + 1) % segments.length;
                ++i;
            }
            HyperbolicDrawUtils.DrawTiling(mg, hyperbolicModel, nIsometries, list, P.length, P, segments.length, segments, null, doCurveLines, doAntiAlias, doRemoveDups, doRandomJitter, lineThicknessInPixels, 0, tolerance, verbose);
        }
        return_pickableSchwarz.setVerticesFromDoubles(faceCenters, F0);
        boolean drawSchwarzPolygon = false;
        if (drawSchwarzPolygon) {
            mg.setColor(Color.red);
            Complex[] sp = return_pickableSchwarz.SchwarzPolygon;
            i = 0;
            while (i < sp.length) {
                HyperbolicDrawUtils.DrawLine2fPoincare(mg, sp[i].x, sp[i].y, sp[(i + 1) % sp.length].x, sp[(i + 1) % sp.length].y, tolerance, hyperbolicModel, doCurveLines, doAntiAlias, doRandomJitter, lineThicknessInPixels);
                ++i;
            }
        }
        if (drawSnub) {
            mg.setColor(new Color(snubR, snubG, snubB));
            Complex[] P = new Complex[neighbors.length];
            int[][] segments = new int[neighbors.length][];
            if (wythoffCoeffs == null) {
                P[0] = Complex.zero;
                int i7 = 0;
                while (i7 < neighbors.length) {
                    P[i7] = neighbors[i7];
                    ++i7;
                }
            } else {
                double[] P2 = new double[2];
                if (!HyperbolicUtils.hBary2(faceCenters.length, P2, wythoffCoeffs, faceCenters, verbose)) {
                    return;
                }
                Complex complexP2 = new Complex(P2);
                int i8 = 0;
                while (i8 < neighbors.length) {
                    P[i8] = new Complex();
                    HyperbolicUtils.calcClosestPointOnLine2(P[i8], complexP2, faceCenters[(i8 - 1 + neighbors.length) % neighbors.length], faceCenters[i8]);
                    HyperbolicUtils.hlerp2_poincare(complexP2, P[i8], (double)2, P[i8]);
                    ++i8;
                }
            }
            int i9 = 0;
            while (i9 < neighbors.length) {
                segments[i9] = new int[]{i9, (i9 + 1) % neighbors.length};
                ++i9;
            }
            Isometry2[] snubbedList = new Isometry2[nIsometries];
            int nSnubbedIsometries = 0;
            int desiredParity = 1 - snubParity;
            int i10 = 0;
            while (i10 < nIsometries) {
                if (compositionLengths != null && compositionLengths[i10] % 2 == desiredParity) {
                    snubbedList[nSnubbedIsometries++] = list[i10];
                }
                ++i10;
            }
            HyperbolicDrawUtils.DrawTiling(mg, hyperbolicModel, nSnubbedIsometries, snubbedList, P.length, P, segments.length, segments, null, doCurveLines, doAntiAlias, doRemoveDups, doRandomJitter, lineThicknessInPixels, showIsometryLabels, tolerance, verbose);
        }
        if (drawPrimal) {
            mg.setColor(new Color(primalR, primalG, primalB));
            Complex[] P = new Complex[neighbors.length + 1];
            int[][] segments = new int[neighbors.length][];
            if (wythoffCoeffs == null) {
                P[0] = Complex.zero;
                int i11 = 0;
                while (i11 < neighbors.length) {
                    P[i11 + 1] = edgeCenters[i11];
                    ++i11;
                }
            } else {
                double[] P2 = new double[2];
                if (!HyperbolicUtils.hBary2(faceCenters.length, P2, wythoffCoeffs, faceCenters, verbose)) {
                    return;
                }
                P[0] = new Complex(P2);
                int i12 = 0;
                while (i12 < neighbors.length) {
                    P[i12 + 1] = new Complex();
                    HyperbolicUtils.calcClosestPointOnLine2(P[i12 + 1], P[0], faceCenters[(i12 - 1 + neighbors.length) % neighbors.length], faceCenters[i12]);
                    ++i12;
                }
            }
            int i13 = 0;
            while (i13 < neighbors.length) {
                int[] nArray = new int[2];
                nArray[1] = i13 + 1;
                segments[i13] = nArray;
                ++i13;
            }
            HyperbolicDrawUtils.DrawTiling(mg, hyperbolicModel, nIsometries, list, P.length, P, segments.length, segments, null, doCurveLines, doAntiAlias, doRemoveDups, doRandomJitter, lineThicknessInPixels, showIsometryLabels, tolerance, verbose);
        }
        if (hyperbolicModel == 0 || hyperbolicModel == 1 || hyperbolicModel == 3) {
            mg.setColor(new Color(primalR, primalG, primalB));
            mg.drawThickArc(-1.0, -1.0, 2, 2, 0.0, Math.PI * 2, lineThicknessInPixels, doAntiAlias);
        }
    }

    private static final void DrawTiling(MyGraphics mg, int hyperbolicModel, int nIsometries, Isometry2[] isometries, int nLocalVerts, Complex[] localVerts, int nSegments, int[][] segments, int[][] segmentColors, boolean doCurveLines, boolean doAntiAlias, boolean doRemoveDups, boolean doRandomJitter, double lineThicknessInPixels, int showIsometryLabels, double tolerance, int verbose) {
        double[] label0Position = null;
        double[] labelPosition = null;
        if (showIsometryLabels >= 1) {
            if (nIsometries >= 2) {
                double[] v0 = new double[]{isometries[0].P.x, isometries[0].P.y};
                double[] v1 = new double[]{isometries[1].P.x, isometries[1].P.y};
                double hDist = 0.25 * HyperbolicUtils.hlerp2_poincare(v0, v1, 0.0, null);
                double eDist = HyperbolicUtils.h2eNorm(hDist);
                label0Position = eDist > 0.001 ? new double[]{eDist, 0.3 * eDist} : new double[]{0.08, 0.03};
            } else {
                label0Position = new double[]{0.08, 0.03};
            }
            labelPosition = new double[2];
        }
        Complex[] verts = new Complex[nLocalVerts];
        int i = 0;
        while (i < nLocalVerts) {
            verts[i] = new Complex();
            ++i;
        }
        i = 0;
        while (i < nIsometries) {
            Color savedColor;
            int j = 0;
            while (j < nLocalVerts) {
                isometries[i].apply(localVerts[j], verts[j]);
                ++j;
            }
            j = 0;
            while (j < nSegments) {
                HyperbolicDrawUtils.DrawLine2fPoincare(mg, verts[segments[j][0]].x, verts[segments[j][0]].y, verts[segments[j][1]].x, verts[segments[j][1]].y, tolerance, hyperbolicModel, doCurveLines, doAntiAlias, doRandomJitter, lineThicknessInPixels);
                if (showIsometryLabels >= 2) {
                    savedColor = mg.getColor();
                    mg.setColor(Color.red);
                    double[] v0 = new double[]{verts[segments[j][0]].x, verts[segments[j][0]].y};
                    double[] v1 = new double[]{verts[segments[j][1]].x, verts[segments[j][1]].y};
                    HyperbolicUtils.hlerp2_poincare(v0, v1, 0.5, labelPosition);
                    String label = "" + i + ':' + j;
                    if (isometries[i].R == -1) {
                        label = "[" + label + ']';
                    }
                    mg.drawStringCentered(label, labelPosition[0], labelPosition[1]);
                    mg.setColor(savedColor);
                }
                ++j;
            }
            if (showIsometryLabels == 1) {
                savedColor = mg.getColor();
                mg.setColor(Color.red);
                isometries[i].apply(label0Position, labelPosition);
                String label = "" + i;
                if (isometries[i].R == -1) {
                    label = "[" + label + ']';
                }
                mg.drawStringCentered(label, labelPosition[0], labelPosition[1]);
                mg.setColor(savedColor);
            }
            ++i;
        }
    }

    public static void DrawLine2fPoincare(MyGraphics mg, double x0, double y0, double x1, double y1, double tolerance, int hyperbolicModel, boolean doCurveLines, boolean doAntiAlias, boolean doRandomJitter, double lineThicknessInPixels) {
        if (doRandomJitter) {
            double scale;
            double jit = 0.02;
            double len0Sqrd = (x0 += ((double)2 * Math.random() - 1.0) * jit) * x0 + (y0 += ((double)2 * Math.random() - 1.0) * jit) * y0;
            double len1Sqrd = (x1 += ((double)2 * Math.random() - 1.0) * jit) * x1 + (y1 += ((double)2 * Math.random() - 1.0) * jit) * y1;
            if (len0Sqrd > 0.99) {
                scale = 0.99 / Math.sqrt(len0Sqrd);
                x0 *= scale;
                y0 *= scale;
            }
            if (len1Sqrd > 0.99) {
                scale = 0.99 / Math.sqrt(len1Sqrd);
                x1 *= scale;
                y1 *= scale;
            }
        }
        if (hyperbolicModel == 1) {
            double[] p0 = new double[]{x0, y0};
            double[] p1 = new double[]{x1, y1};
            VecMath.vxs(p0, p0, (double)2 / (1.0 + VecMath.normsqrd(p0)));
            VecMath.vxs(p1, p1, (double)2 / (1.0 + VecMath.normsqrd(p1)));
            mg.drawLine(p0[0], p0[1], p1[0], p1[1], doAntiAlias);
        } else if (hyperbolicModel == 0) {
            if (!doCurveLines) {
                mg.drawLine(x0, y0, x1, y1, doAntiAlias);
            } else if ((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0) > 1.0E-9) {
                double[] p0 = new double[]{x0, y0};
                double[] p1 = new double[]{x1, y1};
                double[] mid = new double[2];
                HyperbolicUtils.hlerp2_poincare(p0, p1, 0.5, mid);
                double[] seg0 = VecMath.vmv(mid, p0);
                double[] seg1 = VecMath.vmv(p1, mid);
                int sign = VecMath.vxv2(seg0, seg1) < 0.0 ? -1 : 1;
                double a = VecMath.dist(p0, mid);
                double b = VecMath.dist(mid, p1);
                double c = VecMath.dist(p0, p1);
                double s = (a + b + c) / (double)2;
                double temp = s * (a + b - s) * (a + c - s) * (b + c - s);
                if (temp < 0.0) {
                    temp = 0.0;
                }
                double curvature = (double)4 * Math.sqrt(temp) / (a * b * c);
                double start = (double)sign * -a * MyMath.asin_over_x(a * 0.5 * curvature);
                double end = (double)sign * b * MyMath.asin_over_x(b * 0.5 * curvature);
                if (!((end - start < 0.0 ? -(end - start) : end - start) < 2.01)) {
                    System.out.println("    p0 = " + VecMath.toString(p0));
                    System.out.println("    p1 = " + VecMath.toString(p1));
                    System.out.println("    mid = " + VecMath.toString(mid));
                    System.out.print("    ");
                    System.out.println("a = " + a);
                    System.out.print("    ");
                    System.out.println("b = " + b);
                    System.out.print("    ");
                    System.out.println("c = " + c);
                    System.out.print("    ");
                    System.out.println("a+b = " + (a + b));
                    System.out.print("    ");
                    System.out.println("s = " + s);
                    System.out.print("    ");
                    System.out.println("a+b-s = " + (a + b - s));
                    System.out.print("    ");
                    System.out.println("a+c-s = " + (a + c - s));
                    System.out.print("    ");
                    System.out.println("b+c-s = " + (b + c - s));
                    System.out.print("    ");
                    System.out.println("s*(a+b-s)*(a+c-s)*(b+c-s) = " + s * (a + b - s) * (a + c - s) * (b + c - s));
                    System.out.print("    ");
                    System.out.println("curvature = " + curvature);
                    System.out.print("    ");
                    System.out.println("start = " + start);
                    System.out.print("    ");
                    System.out.println("end = " + end);
                }
                if (!((end - start < 0.0 ? -(end - start) : end - start) < 2.01)) {
                    throw new Error("Assertion failed at HyperbolicDrawUtils.prejava(881): ABS(end-start) < 2.01");
                }
                double dirAtMid = Math.atan2(mid[1] - y0, mid[0] - x0);
                double focusAngleRadians = (dirAtMid += (double)sign * Math.asin(a * 0.5 * curvature)) - (double)sign * 1.5707963267948966;
                mg.smartDrawThickArc(lineThicknessInPixels, mid[0], mid[1], focusAngleRadians, curvature, start, end, doAntiAlias);
            }
        } else {
            throw new Error("Assertion failed at HyperbolicDrawUtils.prejava(900): false");
        }
    }
}

