/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.text.ParseException;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HyperbolicApplet
extends Applet
implements MouseListener,
MouseMotionListener,
KeyListener {
    public static final int PRIMAL = 0;
    public static final int DUAL = 8;
    public static final int RUNCINATED = 10;
    public static final int OMNITRUNCATED = 12;
    public static final int TRACKBALL = 0;
    public static final int DRAG_GEODESIC = 1;
    public static final int DRAG_NONPRECESSING = 2;
    public static final int DRAG_PURETRANSLATE = 3;
    public static final int DRAG_PURETRANSLATE_CLAMPED = 4;
    private final double[][] wythoffChoices;
    GraphicsAntiAliasingSetter graphicsAntiAliasingSetter;
    int dim;
    int[] schlafli_pp;
    int schlafli_q;
    int schlafli_r;
    int currentOperation;
    double[] currentWythoff;
    int[] backEdgeInds;
    int eventVerbose;
    int nonEventVerbose;
    int maxLevels;
    int maxIsometries;
    int doQuality;
    boolean drawPrimal;
    boolean drawDual;
    boolean drawSnub;
    int snubParity;
    boolean doAntiAliasing;
    boolean doRemoveDups;
    boolean doRandomJitter;
    double lineThicknessInPixels;
    int showIsometryLabels;
    boolean implementAntiAliasingInHardware;
    boolean doDoubleBuffer;
    Image backBufferImage;
    int hyperbolicModel;
    int motionModel;
    boolean doCompleteGraph;
    int prevX;
    int prevY;
    Isometry2 currentIsometry;
    PickableSchwarzPolygon currentPickableSchwarzPolygon;
    boolean button1IsDown;
    boolean button2IsDown;
    boolean button3IsDown;
    boolean psDumpRequested;
    boolean windowDumpRequested;

    private final String getParameterString(String paramName, String defaultValue) {
        String paramValueString = this.getParameter(paramName);
        if (paramValueString != null) {
            return paramValueString;
        }
        return defaultValue;
    }

    private final int getParameterInt(String paramName, int defaultValue) {
        String paramValueString = this.getParameter(paramName);
        if (paramValueString != null) {
            try {
                return Integer.decode(paramValueString);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return defaultValue;
    }

    private final double getParameterDouble(String paramName, double defaultValue) {
        String paramValueString = this.getParameter(paramName);
        if (paramValueString != null) {
            try {
                return Double.parseDouble(paramValueString);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return defaultValue;
    }

    private final boolean getParameterBoolean(String paramName, boolean defaultValue) {
        String paramValueString = this.getParameter(paramName);
        if (paramValueString != null) {
            try {
                int n = Integer.decode(paramValueString);
                boolean bl = false;
                if (n != 0) {
                    bl = true;
                }
                return bl;
            }
            catch (NumberFormatException e) {
                return paramValueString.equalsIgnoreCase("true") || paramValueString.equalsIgnoreCase("yes") || paramValueString.equalsIgnoreCase("t") || paramValueString.equalsIgnoreCase("y");
            }
        }
        return defaultValue;
    }

    /*
     * Unable to fully structure code
     */
    public void init() {
        block41: {
            this.eventVerbose = this.getParameterInt("EventVerbose", this.eventVerbose);
            if (this.eventVerbose >= 1) {
                System.out.println("in init");
            }
            this.nonEventVerbose = this.getParameterInt("nonEventVerbose", this.nonEventVerbose);
            this.maxLevels = this.getParameterInt("maxLevels", this.maxLevels);
            this.maxIsometries = this.getParameterInt("maxIsometries", this.maxIsometries);
            this.doRandomJitter = this.getParameterBoolean("doRandomJitter", this.doRandomJitter);
            this.showIsometryLabels = this.getParameterInt("showIsometryLabels", this.showIsometryLabels);
            this.lineThicknessInPixels = this.getParameterDouble("lineThicknessInPixels", this.lineThicknessInPixels);
            this.drawPrimal = this.getParameterBoolean("drawPrimal", this.drawPrimal);
            this.drawDual = this.getParameterBoolean("drawDual", this.drawDual);
            this.drawSnub = this.getParameterBoolean("drawSnub", this.drawSnub);
            schlafliString = this.getParameterString("symbol", "7 3");
            schlafliString = schlafliString.trim();
            orbifoldSymbol = null;
            i = 0;
            len = schlafliString.length();
            if (i >= len || schlafliString.charAt(i) != '(') ** GOTO lbl23
            while (i < len && schlafliString.charAt(i++) != ')') {
            }
            break block41;
lbl-1000:
            // 1 sources

            {
                ++i;
lbl23:
                // 2 sources

                ** while (i < len && " ;:_^+".indexOf((int)schlafliString.charAt((int)i)) != -1)
            }
        }
        while (i < len) {
            c = schlafliString.charAt(i);
            if ("[(<.*".indexOf(c) != -1) {
                orbifoldSymbol = schlafliString.substring(i);
                schlafliString = schlafliString.substring(0, i);
                break;
            }
            ++i;
        }
        st = new StringTokenizer(schlafliString, " ;:_^+");
        schlafliTokens = new String[st.countTokens()];
        i = 0;
        while (st.hasMoreTokens()) {
            schlafliTokens[i] = st.nextToken();
            ++i;
        }
        this.dim = schlafliTokens.length;
        if (this.dim >= 1) {
            if (schlafliTokens[0].startsWith("(") && schlafliTokens[0].endsWith(")")) {
                schlafliTokens[0] = schlafliTokens[0].substring(1, schlafliTokens[0].length() - 1);
            }
            st = new StringTokenizer(schlafliTokens[0], ",");
            nps = st.countTokens();
            this.schlafli_pp = new int[nps];
            this.backEdgeInds = new int[nps];
            i = 0;
            while (st.hasMoreTokens()) {
                pToken = st.nextToken();
                if (pToken.startsWith("<") && pToken.endsWith(">")) {
                    pToken = pToken.substring(1, pToken.length() - 1);
                }
                this.schlafli_pp[i] = Integer.decode(pToken);
                this.backEdgeInds[i] = i;
                ++i;
            }
        }
        if (this.dim >= 2) {
            this.schlafli_q = Integer.decode(schlafliTokens[1]);
        }
        if (this.dim >= 3) {
            this.schlafli_r = Integer.decode(schlafliTokens[2]);
        }
        if (this.dim == 1 && this.schlafli_pp.length >= 3) {
            this.dim = 2;
            this.schlafli_q = 1;
        }
        if (this.dim != 2) {
            throw new Error("Schlafli symbol \"" + schlafliString + "\" has " + schlafliTokens.length + " space-or-semicolon separated tokens implying dim=" + this.dim + ", but only supported dim is 2");
        }
        if (orbifoldSymbol != null) {
            len = orbifoldSymbol.length();
            i = 0;
            while (i < len) {
                c = orbifoldSymbol.charAt(i);
                v0 = c == '[' ? ']' : (c == '(' ? ')' : (endChar = c == '<' ? '>' : '\u0000'));
                if (endChar != '\u0000') {
                    j = i + 1;
                    while (j <= len) {
                        v1 = '\u0000';
                        if (j != len) {
                            v1 = orbifoldSymbol.charAt(j);
                        }
                        if ((c = v1) == endChar || "[]()<>.*".indexOf(c) != -1 || j == len) {
                            bracketContents = orbifoldSymbol.substring(i + 1, j);
                            st = new StringTokenizer(bracketContents, " ;_,");
                            n = st.countTokens();
                            if (n == 1) {
                                ind = Integer.decode(st.nextToken());
                                if (ind < 0 || ind >= this.schlafli_pp.length) {
                                    throw new Error("Orbifold symbol refers to index " + ind + " which is out of bounds [0.." + (this.schlafli_pp.length - 1) + "]!");
                                }
                                this.backEdgeInds[ind] = endChar == ')' ? ~ind : ind;
                            } else if (n == 2) {
                                ind0 = Integer.decode(st.nextToken());
                                ind1 = Integer.decode(st.nextToken());
                                if (ind0 < 0 || ind0 >= this.schlafli_pp.length) {
                                    throw new Error("Orbifold symbol refers to index " + ind0 + " which is out of bounds [0.." + (this.schlafli_pp.length - 1) + "]!");
                                }
                                if (ind1 < 0 || ind1 >= this.schlafli_pp.length) {
                                    throw new Error("Orbifold symbol refers to index " + ind1 + " which is out of bounds [0.." + (this.schlafli_pp.length - 1) + "]!");
                                }
                                this.backEdgeInds[ind0] = endChar == ')' ? ~ind1 : ind1;
                                this.backEdgeInds[ind1] = endChar == ')' ? ~ind0 : ind0;
                            } else {
                                throw new Error("Orbifold symbol \"" + orbifoldSymbol + "\" is malformed! (should be 1 or 2 items per cycle)");
                            }
                            i = c == endChar ? j : j - 1;
                            break;
                        }
                        ++j;
                    }
                } else if ("[]()<>.*".indexOf(c) != -1) {
                    System.out.print("    ");
                    System.out.println("i = " + i);
                    System.out.print("    ");
                    System.out.println("c = " + c);
                    throw new Error("Orbifold symbol \"" + orbifoldSymbol + "\" is malformed!");
                }
                ++i;
            }
        }
        if (this.nonEventVerbose >= 1) {
            System.out.println("    dim = " + this.dim);
            System.out.print("    p = ");
            i = 0;
            while (i < this.schlafli_pp.length) {
                System.out.print(this.schlafli_pp[i]);
                if (i + 1 < this.schlafli_pp.length) {
                    System.out.print(",");
                }
                ++i;
            }
            System.out.println();
            System.out.println("    q = " + this.schlafli_q);
        }
        if (this.schlafli_pp.length == 1) {
            this.currentOperation = this.getParameterInt("currentOperation", 0);
            this.currentOperation = (this.currentOperation + this.wythoffChoices.length) % this.wythoffChoices.length;
            this.currentWythoff = this.wythoffChoices[this.currentOperation];
        } else {
            this.currentOperation = 12;
            this.currentWythoff = null;
        }
        currentIsometryParam = this.getParameter("currentIsometry");
        if (currentIsometryParam != null) {
            try {
                foo = (double[])Arrays.fromString(currentIsometryParam);
                System.out.println("    foo = " + Arrays.toStringCompact(foo));
                v2 = new Complex(foo[0], foo[1]);
                v3 = new Complex(foo[2], foo[3]);
                v4 = 1;
                if (foo.length > 4) {
                    v4 = (int)foo[4];
                }
                this.currentIsometry = new Isometry2(v2, v3, v4);
            }
            catch (ParseException e) {
                System.out.println("couldn't parse currentIsometry \"" + currentIsometryParam + '\"');
            }
        }
        if (this.drawSnub && this.schlafli_pp.length != 1 && !HyperbolicApplet.is_all_even(this.schlafli_pp)) {
            System.out.println("Sorry, can't draw snub unless tiling is regular or all faces are even");
            this.drawSnub = false;
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.graphicsAntiAliasingSetter = new GraphicsAntiAliasingSetter();
        if (this.eventVerbose >= 1) {
            System.out.println("out init");
        }
    }

    public void start() {
        if (this.eventVerbose >= 1) {
            System.out.println("in start");
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out start");
        }
    }

    public void stop() {
        if (this.eventVerbose >= 1) {
            System.out.println("in stop");
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out stop");
        }
    }

    public void destroy() {
        if (this.eventVerbose >= 1) {
            System.out.println("in destroy");
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out destroy");
        }
    }

    private static final int getButton(MouseEvent e) {
        int mods = e.getModifiers();
        if ((mods & 8) != 0) {
            return 2;
        }
        if ((mods & 4) != 0) {
            return 3;
        }
        return 1;
    }

    public void mousePressed(MouseEvent e) {
        if (this.eventVerbose >= 1) {
            System.out.println("in mousePressed: " + e);
        }
        if (this.eventVerbose >= 1) {
            if (HyperbolicApplet.getButton(e) == 1) {
                System.out.println("    (left mouse)");
            }
            if (HyperbolicApplet.getButton(e) == 2) {
                System.out.println("    (middle mouse)");
            }
            if (HyperbolicApplet.getButton(e) == 3) {
                System.out.println("    (right mouse)");
            }
        }
        this.prevX = e.getX();
        this.prevY = e.getY();
        int whichButton = HyperbolicApplet.getButton(e);
        if (whichButton == 1) {
            this.button1IsDown = true;
        } else if (whichButton == 2) {
            this.button2IsDown = true;
        } else if (whichButton == 3) {
            this.button3IsDown = true;
            Dimension size = this.getSize();
            Complex p = new Complex(-1.0 + (double)this.prevX / (double)(size.width - 1) * (double)2, -1.0 + (1.0 - (double)this.prevY / (double)(size.height - 1)) * (double)2);
            if (this.hyperbolicModel == 1) {
                Complex.k2p(p);
            }
            this.changeCurrentWythoffSoCanonicalVertIsAt(p);
            this.repaint();
        }
        if (this.doQuality == 1) {
            this.repaint();
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out mousePressed: " + e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        int whichButton;
        if (this.eventVerbose >= 1) {
            System.out.println("in mouseReleased: " + e);
        }
        if ((whichButton = HyperbolicApplet.getButton(e)) == 1) {
            this.button1IsDown = false;
        } else if (whichButton == 2) {
            this.button2IsDown = false;
        } else if (whichButton == 3) {
            this.button3IsDown = false;
        }
        if (this.doQuality == 1) {
            this.repaint();
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out mouseReleased: " + e);
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (this.eventVerbose >= 1) {
            System.out.println("in mouseEntered: " + e);
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out mouseEntered: " + e);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.eventVerbose >= 1) {
            System.out.println("in mouseExited: " + e);
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out mouseExited: " + e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.eventVerbose >= 1) {
            System.out.println("in mouseClicked: " + e);
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out mouseClicked: " + e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        Dimension size;
        int thisY;
        int thisX;
        if (this.eventVerbose >= 2) {
            System.out.println("  in mouseDragged: " + e);
        }
        if (this.button3IsDown) {
            thisX = e.getX();
            thisY = e.getY();
            size = this.getSize();
            Complex p = new Complex(-1.0 + (double)thisX / (double)(size.width - 1) * (double)2, -1.0 + (1.0 - (double)thisY / (double)(size.height - 1)) * (double)2);
            if (this.hyperbolicModel == 1) {
                Complex.k2p(p);
            }
            this.changeCurrentWythoffSoCanonicalVertIsAt(p);
            this.repaint();
        }
        if (this.button1IsDown) {
            Isometry2 increment;
            thisX = e.getX();
            thisY = e.getY();
            size = this.getSize();
            Complex pp = new Complex(-1.0 + (double)this.prevX / (double)(size.width - 1) * (double)2, -1.0 + (1.0 - (double)this.prevY / (double)(size.height - 1)) * (double)2);
            Complex p = new Complex(-1.0 + (double)thisX / (double)(size.width - 1) * (double)2, -1.0 + (1.0 - (double)thisY / (double)(size.height - 1)) * (double)2);
            if (this.hyperbolicModel == 1) {
                Complex.k2p(p);
                Complex.k2p(pp);
            }
            if (this.eventVerbose >= 1) {
                System.out.print("    ");
                System.out.println("pp = " + pp);
                System.out.print("    ");
                System.out.println("p = " + p);
            }
            switch (this.motionModel) {
                case 0: {
                    increment = new Isometry2(Complex.one, Complex.sub(p, pp), 1);
                    break;
                }
                case 1: {
                    increment = Isometry2.mul(Isometry2.mul(new Isometry2(Complex.one, pp, 1), new Isometry2(Complex.one, new Isometry2(Complex.one, Complex.neg(pp), 1).apply(p), 1)), new Isometry2(Complex.one, Complex.neg(pp), 1));
                    break;
                }
                case 2: {
                    increment = Isometry2.mul(new Isometry2(Complex.one, p, 1), new Isometry2(Complex.one, Complex.neg(pp), 1));
                    break;
                }
                case 4: {
                    double scale;
                    double max = 0.99;
                    if (pp.x * pp.x + pp.y * pp.y > max * max) {
                        scale = max / MyMath.hypot(pp.x, pp.y);
                        pp.x *= scale;
                        pp.y *= scale;
                    }
                    if (p.x * p.x + p.y * p.y > max * max) {
                        scale = max / MyMath.hypot(p.x, p.y);
                        p.x *= scale;
                        p.y *= scale;
                    }
                }
                case 3: {
                    increment = Isometry2.pureTranslation(pp, p);
                    break;
                }
                default: {
                    throw new Error("Assertion failed at HyperbolicApplet.prejava(618): false");
                }
            }
            this.currentIsometry = Isometry2.mul(increment, this.currentIsometry);
            this.prevX = thisX;
            this.prevY = thisY;
            this.repaint();
        }
        if (this.eventVerbose >= 2) {
            System.out.println("  out mouseDragged: " + e);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.eventVerbose >= 3) {
            System.out.println("    in mouseMoved: " + e);
        }
        if (this.eventVerbose >= 3) {
            System.out.println("    out mouseMoved: " + e);
        }
    }

    public void keyPressed(KeyEvent e) {
        if (this.eventVerbose >= 1) {
            System.out.println("in keyPressed: " + e);
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out keyPressed: " + e);
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.eventVerbose >= 1) {
            System.out.println("in keyReleased: " + e);
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out keyReleased: " + e);
        }
    }

    public void keyTyped(KeyEvent e) {
        if (this.eventVerbose >= 1) {
            System.out.println("in keyTyped: " + e);
        }
        switch (e.getKeyChar()) {
            case 'V': {
                System.out.print("eventVerbose " + this.eventVerbose);
                this.eventVerbose = (this.eventVerbose + 1) % 4;
                System.out.println(" -> " + this.eventVerbose);
                break;
            }
            case ' ': {
                this.repaint();
                break;
            }
            case 'A': {
                this.doAntiAliasing ^= true;
                System.out.println("doAntiAliasing -> " + this.doAntiAliasing + " (if this platform supports it)");
                this.repaint();
                break;
            }
            case 'u': {
                System.out.print("doQuality " + this.doQuality);
                this.doQuality = (this.doQuality + 1) % 3;
                System.out.println(" -> " + this.doQuality);
                this.repaint();
                break;
            }
            case 't': {
                System.out.print("lineThicknessInPixels " + this.lineThicknessInPixels);
                this.lineThicknessInPixels += 1.0;
                System.out.println(" -> " + this.lineThicknessInPixels);
                this.repaint();
                break;
            }
            case 'T': {
                System.out.print("lineThicknessInPixels " + this.lineThicknessInPixels);
                this.lineThicknessInPixels -= 1.0;
                System.out.println(" -> " + this.lineThicknessInPixels);
                this.repaint();
                break;
            }
            case 'J': {
                this.doRandomJitter ^= true;
                System.out.println("doRandomJitter -> " + this.doRandomJitter);
                this.repaint();
                break;
            }
            case 'L': {
                System.out.print("showIsometryLabels " + this.showIsometryLabels);
                this.showIsometryLabels = (this.showIsometryLabels + 1) % 3;
                System.out.println(" -> " + this.showIsometryLabels);
                this.repaint();
                break;
            }
            case 'B': {
                this.doDoubleBuffer ^= true;
                System.out.println("doDoubleBuffer -> " + this.doDoubleBuffer);
                this.repaint();
                break;
            }
            case 'r': {
                this.currentIsometry = Isometry2.identity;
                this.repaint();
                break;
            }
            case 'p': {
                int i = 0;
                while (i < this.schlafli_pp.length) {
                    int n = i++;
                    this.schlafli_pp[n] = this.schlafli_pp[n] + 1;
                }
                this.repaint();
                break;
            }
            case 'P': {
                int i = 0;
                while (i < this.schlafli_pp.length) {
                    int n = i++;
                    this.schlafli_pp[n] = this.schlafli_pp[n] - 1;
                }
                if (HyperbolicUtils.calcUniformTilingHalfEdgeLength(this.schlafli_pp, (double)this.schlafli_q, 1.0) == 0.0) {
                    i = 0;
                    while (i < this.schlafli_pp.length) {
                        int n = i++;
                        this.schlafli_pp[n] = this.schlafli_pp[n] + 1;
                    }
                    break;
                }
                this.repaint();
                break;
            }
            case 'q': {
                ++this.schlafli_q;
                this.repaint();
                break;
            }
            case 'Q': {
                --this.schlafli_q;
                if (HyperbolicUtils.calcUniformTilingHalfEdgeLength(this.schlafli_pp, (double)this.schlafli_q, 1.0) == 0.0) {
                    ++this.schlafli_q;
                    break;
                }
                this.repaint();
                break;
            }
            case '\u0003': {
                this.doCompleteGraph ^= true;
                System.out.println("doCompleteGraph -> " + this.doCompleteGraph);
                this.repaint();
                break;
            }
            case '\u0018': {
                if (e.isShiftDown()) {
                    this.windowDumpRequested = true;
                } else {
                    this.psDumpRequested = true;
                }
                this.repaint();
                break;
            }
            case '\u0010': {
                this.drawPrimal ^= true;
                System.out.println("drawPrimal -> " + this.drawPrimal);
                this.repaint();
                break;
            }
            case '\u0004': {
                this.drawDual ^= true;
                System.out.println("drawDual -> " + this.drawDual);
                this.repaint();
                break;
            }
            case '\u0013': {
                if (e.isShiftDown()) {
                    this.snubParity ^= 1;
                    System.out.println("snubParity -> " + this.snubParity);
                    this.repaint();
                    break;
                }
                if (this.schlafli_pp.length == 1 || HyperbolicApplet.is_all_even(this.schlafli_pp)) {
                    this.drawSnub ^= true;
                    System.out.println("drawSnub -> " + this.drawSnub);
                    this.repaint();
                    break;
                }
                System.out.println("Sorry, can't draw snub unless it's regular or all faces are even");
                break;
            }
            case '\u000f': {
                if (this.schlafli_pp.length == 1 || HyperbolicApplet.is_all_even(this.schlafli_pp) && VecMath.isIdentityPerm(this.backEdgeInds)) {
                    double[] newWythoff = new double[this.currentPickableSchwarzPolygon.SchwarzPolygon.length];
                    if (HyperbolicUtils.findBaryCoordsThatMakeSnubUniform(newWythoff, this.currentPickableSchwarzPolygon.SchwarzPolygon, this.nonEventVerbose)) {
                        System.out.println("    newWythoff = " + Arrays.toStringCompact(newWythoff));
                        this.currentWythoff = newWythoff;
                        this.currentOperation = 12;
                        this.repaint();
                        break;
                    }
                    System.out.println("Sorry, failed to make snub uniform for some reason");
                    break;
                }
                System.out.println("Sorry, can't make snub uniform unless it's regular, or all faces are even and all generating isometries are mirror-edge reflections");
                break;
            }
            case 'm': {
                this.hyperbolicModel = this.hyperbolicModel == 0 ? 1 : 0;
                this.repaint();
                break;
            }
            case 'o': {
                if (this.schlafli_pp.length == 1) {
                    if (this.currentWythoff == this.wythoffChoices[this.currentOperation]) {
                        this.currentOperation = (this.currentOperation + 1) % this.wythoffChoices.length;
                    }
                    this.currentWythoff = this.wythoffChoices[this.currentOperation];
                } else {
                    this.currentWythoff = null;
                }
                this.repaint();
                break;
            }
            case 'O': {
                if (this.schlafli_pp.length == 1) {
                    if (this.currentWythoff == this.wythoffChoices[this.currentOperation]) {
                        this.currentOperation = (this.currentOperation - 1 + this.wythoffChoices.length) % this.wythoffChoices.length;
                    }
                    this.currentWythoff = this.wythoffChoices[this.currentOperation];
                } else {
                    this.currentWythoff = null;
                }
                this.repaint();
                break;
            }
            case '\t': 
            case 'i': {
                System.out.print("maxIsometries " + this.maxIsometries);
                this.maxIsometries += (e.isShiftDown() ? -1 : 1) * (e.isControlDown() ? 1 : 10);
                if (this.maxIsometries < 0) {
                    this.maxIsometries = 0;
                }
                System.out.println(" -> " + this.maxIsometries);
                this.repaint();
                break;
            }
            case 'I': {
                System.out.print("maxIsometries " + this.maxIsometries);
                this.maxIsometries -= e.isControlDown() ? 1 : 10;
                if (this.maxIsometries < 0) {
                    this.maxIsometries = 0;
                }
                System.out.println(" -> " + this.maxIsometries);
                this.repaint();
                break;
            }
            default: {
                System.out.println("Unknown key '" + e.getKeyChar() + "'(" + e.getKeyChar() + ") typed");
                break;
            }
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out keyTyped: " + e);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics frontBufferGraphics) {
        boolean doCurvedLines;
        if (this.eventVerbose >= 1) {
            System.out.println("in paint");
        }
        this.makeSureBackBufferIsRight();
        Graphics g = this.doDoubleBuffer ? this.backBufferImage.getGraphics() : frontBufferGraphics;
        Dimension size = this.getSize();
        double minSize = size.width <= size.height ? size.width : size.height;
        MyGraphics mg = new MyGraphics(g, size, (double)(-size.width) / minSize, (double)size.width / minSize, (double)(-size.height) / minSize, (double)size.height / minSize);
        if (this.psDumpRequested) {
            this.psDumpRequested = false;
            String fileName = "PSDUMP.eps";
            try {
                PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                System.out.println("Dumping postscript to " + fileName + "...");
                mg = new PSMyGraphics(writer, size, (double)(-size.width) / minSize, (double)size.width / minSize, (double)(-size.height) / minSize, (double)size.height / minSize);
            }
            catch (IOException e) {
                System.out.println("Couldn't write to file " + fileName + ": " + e);
            }
        }
        if (this.implementAntiAliasingInHardware) {
            this.graphicsAntiAliasingSetter.setAntiAliasing(g, this.doAntiAliasing, this.eventVerbose);
        }
        mg.setColor(Color.black);
        mg.fillWindow();
        Isometry2 smallestIsometry = new Isometry2(this.currentIsometry);
        boolean bl = false;
        if (this.doQuality >= 2 || this.doQuality >= 1 && !this.button1IsDown && !this.button3IsDown) {
            bl = doCurvedLines = true;
        }
        if (this.doCompleteGraph) {
            int n = this.schlafli_pp[0];
            double[][] verts = new double[n][2];
            int i = 0;
            while (i < n) {
                double ang = Math.PI * 2 * (double)i / (double)n;
                verts[i][0] = Math.cos(ang);
                verts[i][1] = Math.sin(ang);
                ++i;
            }
            VecMath.mxs(verts, verts, 0.9999);
            mg.setColor(Color.white);
            i = 0;
            while (i < n) {
                int j = 0;
                while (j < i) {
                    double[] a = verts[i];
                    double[] b = verts[j];
                    double d = a[0];
                    double d2 = a[1];
                    double d3 = b[0];
                    double d4 = b[1];
                    boolean bl2 = false;
                    if (this.doAntiAliasing && !this.implementAntiAliasingInHardware) {
                        bl2 = true;
                    }
                    HyperbolicDrawUtils.DrawLine2fPoincare(mg, d, d2, d3, d4, 0.0, this.hyperbolicModel, doCurvedLines, bl2, this.doRandomJitter, this.lineThicknessInPixels);
                    ++j;
                }
                ++i;
            }
        } else if (this.schlafli_pp.length == 1) {
            int n = this.schlafli_pp[0];
            boolean bl3 = false;
            if (this.doAntiAliasing && !this.implementAntiAliasingInHardware) {
                bl3 = true;
            }
            HyperbolicDrawUtils.DrawOmnitruncatedTiling(mg, this.hyperbolicModel, this.currentIsometry, n, this.schlafli_q, this.maxLevels, this.maxIsometries, this.currentWythoff, this.drawPrimal, 1.0f, 1.0f, 1.0f, this.drawDual, 0.0f, 0.0f, 1.0f, this.drawSnub, 1.0f, 0.0f, 0.0f, this.snubParity, doCurvedLines, bl3, this.doRemoveDups, this.doRandomJitter, this.lineThicknessInPixels, this.showIsometryLabels, this.nonEventVerbose, smallestIsometry, this.currentPickableSchwarzPolygon);
        } else {
            boolean bl4 = false;
            if (this.doAntiAliasing && !this.implementAntiAliasingInHardware) {
                bl4 = true;
            }
            HyperbolicDrawUtils.DrawUniformTiling(mg, this.hyperbolicModel, this.currentIsometry, this.schlafli_pp, this.schlafli_q, this.backEdgeInds, this.maxLevels, this.maxIsometries, this.currentWythoff, this.drawPrimal, 1.0f, 1.0f, 1.0f, this.drawDual, 0.0f, 0.0f, 1.0f, this.drawSnub, 1.0f, 0.0f, 0.0f, this.snubParity, doCurvedLines, bl4, this.doRemoveDups, this.doRandomJitter, this.lineThicknessInPixels, this.showIsometryLabels, this.nonEventVerbose, smallestIsometry, this.currentPickableSchwarzPolygon);
        }
        this.currentIsometry = smallestIsometry;
        mg.flush();
        if (mg instanceof PSMyGraphics) {
            System.out.println("done.");
        }
        if (g != frontBufferGraphics) {
            frontBufferGraphics.drawImage(this.backBufferImage, 0, 0, this);
            if (this.windowDumpRequested) {
                this.windowDumpRequested = false;
                String lineThicknessInPixelsString = (double)((int)this.lineThicknessInPixels) == this.lineThicknessInPixels ? "" + (int)this.lineThicknessInPixels : "" + this.lineThicknessInPixels;
                String fileName = "WINDOWDUMP." + size.width + 'x' + size.height + '.' + lineThicknessInPixelsString + ".ppm";
                try {
                    BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(fileName));
                    System.out.println("    " + size.width + 'x' + size.height);
                    System.out.println("    currentIsometry=" + this.currentIsometry);
                    System.out.println("Dumping window to " + fileName + "...");
                    int w = size.width;
                    int h = size.height;
                    int[] pixels = new int[w * h];
                    int off = 0;
                    int stride = w;
                    PixelGrabber grabber = new PixelGrabber(this.backBufferImage, 0, 0, w, h, pixels, off, stride);
                    try {
                        System.out.print("    grabbing...");
                        System.out.flush();
                        grabber.grabPixels();
                        System.out.println("done.");
                        System.out.print("    fixing");
                        System.out.flush();
                        int white = -1;
                        int black = -16777216;
                        int blue = -16776961;
                        int outerblack = 0;
                        int[][] stack = new int[w * h][2];
                        HyperbolicApplet.seedfill(pixels, w, h, 0, 0, outerblack, stack);
                        System.out.print(".");
                        System.out.flush();
                        HyperbolicApplet.seedfill(pixels, w, h, w - 1, 0, outerblack, stack);
                        System.out.print(".");
                        System.out.flush();
                        HyperbolicApplet.seedfill(pixels, w, h, 0, h - 1, outerblack, stack);
                        System.out.print(".");
                        System.out.flush();
                        HyperbolicApplet.seedfill(pixels, w, h, w - 1, h - 1, outerblack, stack);
                        System.out.print(".");
                        System.out.flush();
                        int q = (int)Math.ceil(this.lineThicknessInPixels) + 1;
                        int y = 0;
                        while (y < h) {
                            int x = 0;
                            while (x < w) {
                                if (pixels[y * w + x] == black && (y < q || y >= h - q || x < q || x >= w - q || pixels[(y - q) * w + x] == outerblack || pixels[(y + q) * w + x] == outerblack || pixels[y * w + (x - q)] == outerblack || pixels[y * w + (x + q)] == outerblack || pixels[(y - q / 2) * w + (x - q / 2)] == outerblack || pixels[(y - q / 2) * w + (x + q / 2)] == outerblack || pixels[(y + q / 2) * w + (x - q / 2)] == outerblack || pixels[(y + q / 2) * w + (x + q / 2)] == outerblack)) {
                                    HyperbolicApplet.seedfill(pixels, w, h, x, y, blue, stack);
                                }
                                ++x;
                            }
                            ++y;
                        }
                        System.out.println(" done.");
                        System.out.print("    writing...");
                        System.out.flush();
                        String header = "P6\n" + w + ' ' + h + "\n255\n";
                        ostream.write(header.getBytes());
                        int y2 = 0;
                        while (y2 < h) {
                            int x = 0;
                            while (x < w) {
                                int pix = pixels[y2 * w + x];
                                int alpha = pix >> 24 & 0xFF;
                                int red = pix >> 16 & 0xFF;
                                int green = pix >> 8 & 0xFF;
                                int blue2 = pix & 0xFF;
                                ostream.write(red);
                                ostream.write(green);
                                ostream.write(blue2);
                                ++x;
                            }
                            ++y2;
                        }
                        ostream.flush();
                        System.out.println("done.");
                        System.out.println("done.");
                    }
                    catch (InterruptedException e) {
                        System.err.println("interrupted waiting for pixels!");
                    }
                }
                catch (IOException e) {
                    System.out.println("Couldn't write to file " + fileName + ": " + e);
                }
            }
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out paint");
        }
    }

    static void seedfill(int[] pixels, int w, int h, int x0, int y0, int newColor, int[][] stack) {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[0] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = -1;
        nArrayArray[3] = nArray4;
        int[][] deltas = nArrayArray;
        int oldColor = pixels[y0 * w + x0];
        if (oldColor != newColor) {
            int nStack = 0;
            pixels[y0 * w + x0] = newColor;
            stack[nStack][0] = x0;
            stack[nStack][1] = y0;
            ++nStack;
            while (nStack > 0) {
                int x = stack[--nStack][0];
                int y = stack[nStack][1];
                int i = 0;
                while (i < 4) {
                    int dx = deltas[i][0];
                    int dy = deltas[i][1];
                    int x1 = x + dx;
                    int y1 = y + dy;
                    if (x1 >= 0 && x1 < w && y1 >= 0 && y1 < h && pixels[y1 * w + x1] == oldColor) {
                        pixels[y1 * w + x1] = newColor;
                        stack[nStack][0] = x1;
                        stack[nStack][1] = y1;
                        ++nStack;
                    }
                    ++i;
                }
            }
        }
    }

    private final void makeSureBackBufferIsRight() {
        if (this.doDoubleBuffer) {
            Dimension size = this.getSize();
            if (this.backBufferImage == null || this.backBufferImage.getWidth(this) != size.width || this.backBufferImage.getHeight(this) != size.height) {
                if (this.eventVerbose >= 1) {
                    System.out.println("Creating back buffer " + size.width + 'x' + size.height);
                }
                this.backBufferImage = this.createImage(size.width, size.height);
            }
        } else {
            this.backBufferImage = null;
        }
    }

    private static final boolean is_all_even(int[] array) {
        int i = 0;
        while (i < array.length) {
            if ((array[i] & 1) != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private final void changeCurrentWythoffSoCanonicalVertIsAt(Complex p) {
        if (this.schlafli_pp.length != 1) {
            if (!VecMath.isIdentityPerm(this.backEdgeInds)) {
                return;
            }
            if (!HyperbolicApplet.is_all_even(this.schlafli_pp)) {
                return;
            }
        }
        this.currentOperation = 12;
        Isometry2 isometryTakingPToSchwarzPolygon = new Isometry2();
        int[] nFlips = new int[1];
        if (this.currentPickableSchwarzPolygon.pick(p, isometryTakingPToSchwarzPolygon, this.nonEventVerbose, nFlips)) {
            Complex q = isometryTakingPToSchwarzPolygon.apply(p);
            this.currentWythoff = new double[3];
            if (HyperbolicUtils.unHBary2(this.currentWythoff.length, this.currentWythoff, q, this.currentPickableSchwarzPolygon.SchwarzPolygon, this.nonEventVerbose)) {
                if (this.nonEventVerbose >= 1) {
                    System.out.println("    currentWythoff = " + Arrays.toStringCompact(this.currentWythoff));
                }
            } else {
                this.currentWythoff = this.wythoffChoices[this.currentOperation];
                if (this.currentOperation == 12 && this.schlafli_pp.length * this.schlafli_q != 3) {
                    this.currentWythoff = null;
                }
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("in main");
        Frame frame = new Frame("Hyperbolic Applet"){

            public final boolean handleEvent(Event event) {
                switch (event.id) {
                    case 201: {
                        System.out.println("bye!");
                        this.dispose();
                        System.exit(0);
                        return true;
                    }
                }
                return super.handleEvent(event);
            }
        };
        frame.addWindowListener(new WindowAdapter(frame){
            final /* synthetic */ Frame val$frame;

            public final void windowClosing(WindowEvent we) {
                System.out.println("ciao!");
                this.val$frame.dispose();
                System.exit(0);
            }
            {
                this.val$frame = frame;
            }
        });
        HyperbolicApplet applet = new HyperbolicApplet();
        applet.setStub(new AppletStub(args){
            final /* synthetic */ String[] val$args;

            public final void appletResize(int width, int height) {
            }

            public final AppletContext getAppletContext() {
                return null;
            }

            public final URL getCodeBase() {
                return null;
            }

            public final URL getDocumentBase() {
                return null;
            }

            public final String getParameter(String name) {
                String prefix = name.toLowerCase() + '=';
                int i = 0;
                while (i < this.val$args.length) {
                    if (this.val$args[i].toLowerCase().startsWith(prefix)) {
                        return this.val$args[i].substring(prefix.length());
                    }
                    ++i;
                }
                return null;
            }

            public final boolean isActive() {
                return true;
            }
            {
                this.val$args = stringArray;
            }
        });
        frame.add(applet);
        applet.init();
        applet.start();
        int size = applet.getParameterInt("size", 512);
        int width = applet.getParameterInt("width", size);
        int height = applet.getParameterInt("height", size);
        frame.move(400, 20);
        frame.resize(width, height);
        frame.show();
        System.out.println("out main");
    }

    private final /* synthetic */ void this() {
        double[][] dArrayArray = new double[13][];
        double[] dArray = new double[3];
        dArray[0] = 1.0;
        dArrayArray[0] = dArray;
        double[] dArray2 = new double[3];
        dArray2[0] = 0.75;
        dArray2[1] = 0.25;
        dArrayArray[1] = dArray2;
        double[] dArray3 = new double[3];
        dArray3[0] = 0.5;
        dArray3[1] = 0.5;
        dArrayArray[2] = dArray3;
        double[] dArray4 = new double[3];
        dArray4[0] = 0.25;
        dArray4[1] = 0.75;
        dArrayArray[3] = dArray4;
        double[] dArray5 = new double[3];
        dArray5[1] = 1.0;
        dArrayArray[4] = dArray5;
        double[] dArray6 = new double[3];
        dArray6[1] = 0.75;
        dArray6[2] = 0.25;
        dArrayArray[5] = dArray6;
        double[] dArray7 = new double[3];
        dArray7[1] = 0.5;
        dArray7[2] = 0.5;
        dArrayArray[6] = dArray7;
        double[] dArray8 = new double[3];
        dArray8[1] = 0.25;
        dArray8[2] = 0.75;
        dArrayArray[7] = dArray8;
        double[] dArray9 = new double[3];
        dArray9[2] = 1.0;
        dArrayArray[8] = dArray9;
        double[] dArray10 = new double[3];
        dArray10[0] = 0.25;
        dArray10[2] = 0.75;
        dArrayArray[9] = dArray10;
        double[] dArray11 = new double[3];
        dArray11[0] = 0.5;
        dArray11[2] = 0.5;
        dArrayArray[10] = dArray11;
        double[] dArray12 = new double[3];
        dArray12[0] = 0.75;
        dArray12[2] = 0.25;
        dArrayArray[11] = dArray12;
        dArrayArray[12] = new double[]{1.0, 1.0, 1.0};
        this.wythoffChoices = dArrayArray;
        this.eventVerbose = 0;
        this.nonEventVerbose = 0;
        this.maxLevels = 100;
        this.maxIsometries = 500;
        this.doQuality = 1;
        this.drawPrimal = true;
        this.drawDual = true;
        this.drawSnub = false;
        this.snubParity = 0;
        this.doAntiAliasing = false;
        this.doRemoveDups = true;
        this.doRandomJitter = false;
        this.lineThicknessInPixels = 1.0;
        this.showIsometryLabels = 0;
        this.implementAntiAliasingInHardware = true;
        this.doDoubleBuffer = true;
        this.backBufferImage = null;
        this.hyperbolicModel = 0;
        this.motionModel = 4;
        this.doCompleteGraph = false;
        this.prevX = 0;
        this.prevY = 0;
        this.currentIsometry = Isometry2.identity;
        this.currentPickableSchwarzPolygon = new PickableSchwarzPolygon();
        this.button1IsDown = false;
        this.button2IsDown = false;
        this.button3IsDown = false;
        this.psDumpRequested = false;
        this.windowDumpRequested = false;
    }

    public HyperbolicApplet() {
        this.this();
    }
}

