/*
 * Decompiled with CFR 0.152.
 */
public class Complex {
    static final Complex zero = new Complex(0.0, 0.0);
    static final Complex one = new Complex(1.0, 0.0);
    public double x;
    public double y;

    public Complex set(Complex z) {
        this.x = z.x;
        this.y = z.y;
        return this;
    }

    public Complex set(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public static Complex conj(Complex z, Complex result) {
        result.x = z.x;
        result.y = -z.y;
        return result;
    }

    public static Complex neg(Complex z, Complex result) {
        result.x = -z.x;
        result.y = -z.y;
        return result;
    }

    public static Complex sub(Complex a, Complex b, Complex result) {
        result.x = a.x - b.x;
        result.y = a.y - b.y;
        return result;
    }

    public static Complex add(Complex a, Complex b, Complex result) {
        result.x = a.x + b.x;
        result.y = a.y + b.y;
        return result;
    }

    public static Complex mul(Complex a, Complex b, Complex result) {
        result.x = a.x * b.x - a.y * b.y;
        result.y = a.x * b.y + a.y * b.x;
        return result;
    }

    public static Complex div(Complex a, Complex b, Complex result) {
        double invLenSqrd = 1.0 / (b.x * b.x + b.y * b.y);
        result.x = (a.x * b.x + a.y * b.y) * invLenSqrd;
        result.y = (-a.x * b.y + a.y * b.x) * invLenSqrd;
        return result;
    }

    public static Complex conj(Complex z) {
        return Complex.conj(z, new Complex());
    }

    public static Complex neg(Complex z) {
        return Complex.neg(z, new Complex());
    }

    public static Complex sub(Complex a, Complex b) {
        return Complex.sub(a, b, new Complex());
    }

    public static Complex add(Complex a, Complex b) {
        return Complex.add(a, b, new Complex());
    }

    public static Complex mul(Complex a, Complex b) {
        return Complex.mul(a, b, new Complex());
    }

    public static Complex div(Complex a, Complex b) {
        return Complex.div(a, b, new Complex());
    }

    public static void k2p(Complex p) {
        double scale = 1.0 / (1.0 + Math.sqrt(1.0 - (p.x * p.x + p.y * p.y)));
        if (!Double.isNaN(scale)) {
            p.x *= scale;
            p.y *= scale;
        }
    }

    public static void p2k(Complex p) {
        double scale = (double)2 / (1.0 + (p.x * p.x + p.y * p.y));
        p.x *= scale;
        p.y *= scale;
    }

    public String toString() {
        return "" + this.x + ',' + this.y;
    }

    public Complex() {
    }

    public Complex(Complex z) {
        this.x = z.x;
        this.y = z.y;
    }

    public Complex(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Complex(double[] xy) {
        this.x = xy[0];
        this.y = xy[1];
    }
}

