<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<!-- can't use 3.2 since we can't do without the "archive" element for applets -->
<html>
    <head>
        <title>
            Modern Portfolio Theory Applet
        </title>
    </head>
    <body bgcolor="#CC9999">

        Modern Portfolio Theory Applet
        <br>

        <applet
            code="EfficientFrontierApplet.class"
            archive="EfficientFrontierApplet.jar"
            codebase="."
            width="768" height="512"
            alt="Your browser understands Java but can't seem to run this applet, sorry."
        >
            <param name="eventVerbose" value="<?php echo $HTTP_GET_VARS["eventVerbose"]; ?>">
            <param name="showControlPanel" value="<?php echo $HTTP_GET_VARS["showControlPanel"]; ?>">
        </applet>

        <br>

        The following keys and mouse actions do interesting things:
        <br>
        (NOTE: you may have to click on the applet once before it will accept
        keyboard input)
        <pre>
    Left-click - move an asset (white dot)
    Middle-click (or ctrl-click or alt-click) - add an asset
    Right-click (or meta-click) - delete nearest asset
    
    'c' - toggle control panel
    'g' - toggle geom mean grid lines (may be very subtle depending on your monitor)
    'a' - toggle arithmetic mean grid lines
    'm' - toggle minor grid lines (when showing major grid lines)
    'G' - switch to using geometric mean returns (default)
    'A' - switch to using arithmetic mean returns
    'M' - toggle showing correlation matrix in control panel

Debugging (stuff you don't care about):
    ' ' - repaint
    'V' - cycle event debug level (output to java console window).
    'T' - toggle draw time debugging (output to java console window).
    'b' - toggle double buffering
        </pre>

        So, I was reading this book called
        <em>
        The Intelligent Asset Allocator
        </em>
        by
        William Bernstein,
        and it has some fascinating pictures showing how,
        if you diversify your portfolio among statistically uncorrelated assets
        with various risk/return characteristics,
        you can get a portfolio with a lower risk and higher return
        than the lowest-risk component asset, and sometimes
        a higher return than even the highest-return component asset.  Cool!
        In particular, if two assets have exactly the
        same risk/return characteristics,
        if they are statistically uncorrelated,
        you get much lower risk
        <em>and</em>
        slightly higher return (!) by mixing them
        50/50 than by investing in either one by itself.
        <p>
        What hooked me is that it's easy to quantify and calculate the resulting
        return and risk, if you define risk as standard deviation.
        The simplest model of an asset with any given mean return
        and standard deviation is a coin toss.
        For example, consider an investment that, in any given year,
        has 50% chance of giving you +30% return,
        and 50% chance of giving you -10% return
        (this is Bernstein's "Uncle Fred's coin toss").
        The (geometric) mean return is 8.17% (square root of (1.30 * .90)),
        and the standard deviation is 20%.
        If you have two identical but uncorrelated investments A and B
        with the above behavior, and you split your money 50/50 between them,
        then there are four equally likely
        outcomes in any given year:
        <pre>
                  A    B
                -10% -10%
                -10%  30%
                 30% -10%
                 30%  30%
        </pre>
        So the expected return of this portfolio
        is the geometric mean of these four outcomes, i.e.
        <pre>
            (.90 * 1.10 * 1.10 * 1.30)<sup>1/4</sup> = 1.0908,
        </pre>
        i.e. 9.08% (slightly better than the 8.17%
        you'd get by putting all your money one one or the other coin toss).
        And the standard deviation is clearly lower than
        that of a single coin toss; it's approximately:
        <pre>
                sqrt(((-10-10)<sup>2</sup> + (10-10)<sup>2</sup> + (10-10)<sup>2</sup> + (30-10)<sup>2</sup>) / 4) = 14.14%,
        </pre>
        better than the 20% of either individual coin toss.
        You can do a similar easy calculation to get the mean and standard
        deviation of a 25/75 split of A and B, or any other combination.
        <p>
        This applet illustrates this phenomenon.
        The vertical axis is (mean) annualized return,
        and the horizontal axis is risk, measured as standard deviation
        (calculated in log space, so, for example, a standard deviation
        of 25% means the deviation is typically +25% or -20%).
        (The mean annualized return is calculated in log space too,
        so it's a geometric mean.)  (Notice that the axis labels
        are not evenly spaced, since it's a logarithmic scale on both axes.)
        <p>
        Create new assets (white points) with the middle mouse button
        (or alt-left), and move them around with the left mouse button.
        The red curves show mixtures of two assets, in increments of 5%.
        The blue grids show mixtures of three assets.
        The green dots show mixtures of four assets.
        The yellow dots show mixtures of five assets (very slow).
        <br>
        You probably don't want to display that many,
        since it gets too cluttered and slow; anyway, according to Bernstein,
        <p>
            <center>
            "In the real world of investing, however, it is difficult to find
            two assets that are uncorrelated,
            and it is practically impossible to find three.
            It is absolutely impossible to find
            more than three mutually uncorrelated assets."
            </center>
        <p>
        The upper-left edge of the data (where return is maximized
        for a given risk, and risk is minimized for a given return)
        is called the
        <em>efficient frontier,</em>
        and is shown delimited by two cyan dots (the minimimum-risk portfolio
        and the maximum-return portfolio).
        Finding the efficient frontier is called Mean-Variance Optimization.
        A guy named Harry Markowitz
        came up with this stuff and earned a Nobel prize for it.
        <p>
        William Bernstein's web site is
        <a href="http://www.efficientfrontier.com/">
        http://www.efficientfrontier.com/
        </a>
        .
        It includes an on-line version of the aforementioned book through
        Chapter 2 (unfortunately the interesting stuff
        begins in chapter 3).
        <p>
        Download
        <a href="EfficientFrontierApplet.jar">
        source code
        </a>
        for this applet
        (compressed jar file contains class files and source)

        <hr>
        <table width="100%">  <!-- use full width of page -->
            <tr>
                <td align="left">
                    <?php include("../hitcounter.php"); ?>
                    <br>
                    Last Modified:
Sat Jul  5 23:08:17 PDT 2003
                    <address>
                    Don Hatch
                    <br>
                    <a href="mailto:hatch@plunk.org">hatch@plunk.org</a>
                    </address>
                <td align="right">
                        <!--
                        The original:
                            src="http://www.w3.org/Icons/valid-html40"
                        But netscape doesn't do png transparency right, so:
                            src="http://www.w3.org/Icons/valid-html40.gif"
                        -->
                    <a href="http://validator.w3.org/check/referer"><img
                        border="0"
                        src="../images/valid-html40.gif"
                        alt="Valid HTML 4.0!" height="31" width="88"></a>
        </table>

        <center>
            <font size=-1>
                <a href="http://www.plunk.org/~hatch/">
                    Back to Don Hatch's home page.
                </a>
            </font>
        </center>

    </body>
</html>
