/*
 * Decompiled with CFR 0.152.
 */
public class SortStuff {
    public static void sort(Object[] list, Comparator comparator) {
        SortStuff.sortRange(list, 0, list.length - 1, comparator);
    }

    public static void sort(double[] list) {
        SortStuff.sort(list, new DoubleComparator());
    }

    public static void sort(int[] list) {
        SortStuff.sort(list, new IntComparator());
    }

    public static void sort(double[] list, DoubleComparator comparator) {
        double[][] ptrlist = new double[list.length][1];
        int i = 0;
        while (i < list.length) {
            ptrlist[i][0] = list[i];
            ++i;
        }
        SortStuff.sort((Object[])ptrlist, new Comparator(comparator){
            final /* synthetic */ DoubleComparator val$comparator;

            public final int compare(Object a, Object b) {
                return this.val$comparator.compare(((double[])a)[0], ((double[])b)[0]);
            }
            {
                this.val$comparator = doubleComparator;
            }
        });
        i = 0;
        while (i < list.length) {
            list[i] = ptrlist[i][0];
            ++i;
        }
    }

    public static void sort(int[] list, IntComparator comparator) {
        int[][] ptrlist = new int[list.length][1];
        int i = 0;
        while (i < list.length) {
            ptrlist[i][0] = list[i];
            ++i;
        }
        SortStuff.sort((Object[])ptrlist, new Comparator(comparator){
            final /* synthetic */ IntComparator val$comparator;

            public final int compare(Object a, Object b) {
                return this.val$comparator.compare(((int[])a)[0], ((int[])b)[0]);
            }
            {
                this.val$comparator = intComparator;
            }
        });
        i = 0;
        while (i < list.length) {
            list[i] = ptrlist[i][0];
            ++i;
        }
    }

    private static final void sortRange(Object[] list, int i, int j, Comparator comparator) {
        if (j <= i) {
            return;
        }
        int k = (i + j) / 2;
        SortStuff.swap(list, k, j);
        int l = SortStuff.partitionRange(list, i - 1, j, list[j], comparator);
        SortStuff.swap(list, l, j);
        if (l - i > 1) {
            SortStuff.sortRange(list, i, l - 1, comparator);
        }
        if (j - l > 1) {
            SortStuff.sortRange(list, l + 1, j, comparator);
        }
    }

    private static final void swap(Object[] list, int i, int j) {
        Object temp = list[j];
        list[j] = list[i];
        list[i] = temp;
    }

    private static final int partitionRange(Object[] list, int i, int j, Object object, Comparator comparator) {
        while (true) {
            if (comparator.compare(list[++i], object) < 0) {
                continue;
            }
            while (j > 0 && comparator.compare(list[--j], object) > 0) {
            }
            SortStuff.swap(list, i, j);
            if (i >= j) break;
        }
        SortStuff.swap(list, i, j);
        return i;
    }

    public static int bsearch(Object[] list, Object item, Comparator comparator) {
        int lo = 0;
        int hi = list.length - 1;
        while (lo <= hi) {
            int mid = (lo + hi) / 2;
            int disposition = comparator.compare(list[mid], item);
            if (disposition < 0) {
                lo = mid + 1;
                continue;
            }
            if (disposition > 0) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static int nodup(Object[] list, int oldN, Comparator comparator) {
        int newN = 0;
        int oldI = 0;
        while (oldI < oldN) {
            if (newN == 0 || comparator.compare(list[oldI], list[newN - 1]) != 0) {
                list[newN++] = list[oldI];
            }
            ++oldI;
        }
        return newN;
    }

    public static int nodup(Object[] list, Comparator comparator) {
        return SortStuff.nodup(list, list.length, comparator);
    }

    public static class IntComparator {
        public int compare(int i, int j) {
            int n;
            if (i < j) {
                n = -1;
            } else {
                n = 0;
                if (i > j) {
                    n = 1;
                }
            }
            return n;
        }
    }

    public static class DoubleComparator {
        public int compare(double x, double y) {
            int n;
            if (x < y) {
                n = -1;
            } else {
                n = 0;
                if (x > y) {
                    n = 1;
                }
            }
            return n;
        }
    }

    public static interface Comparator {
        public int compare(Object var1, Object var2);
    }
}

