/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

abstract class RhoPanel
extends Panel {
    private double everyRho;
    private double[][] rhos;
    private String[] names;
    private Label[] labels;
    private TextField[] textFields;
    private Scrollbar[] scrollbars;
    private Button[] zeroButtons;

    private final void updateOneRho(int I, int i, int j, double newRho, AdjustmentEvent ae) {
        double d = newRho = newRho <= -1.0 ? -1.0 : (newRho >= 1.0 ? 1.0 : newRho);
        if (newRho != (I == 0 ? this.everyRho : this.rhos[i][j])) {
            double newEveryRho = this.everyRho;
            double[][] newRhos = VecMath.copymat(this.rhos);
            if (I == 0) {
                newEveryRho = newRho;
                int n = newRhos.length;
                int otheri = 0;
                while (otheri < n) {
                    int otherj = 0;
                    while (otherj < otheri) {
                        double d2 = newEveryRho;
                        newRhos[otherj][otheri] = d2;
                        newRhos[otheri][otherj] = d2;
                        ++otherj;
                    }
                    ++otheri;
                }
            } else {
                newRhos[i][j] = newRho;
                newRhos[j][i] = newRho;
            }
            this.update(newEveryRho, newRhos, I, ae);
        }
    }

    public void update() {
        this.update(this.everyRho, this.rhos, -1, null);
    }

    public void update(double newEveryRho, double[][] newRhos) {
        this.update(newEveryRho, newRhos, -1, null);
    }

    private final void update(double newEveryRho, double[][] newRhos, int sourceI, AdjustmentEvent ae) {
        newEveryRho = this.verifyNewRhos(newEveryRho, newRhos);
        int n = this.rhos.length;
        int N = RhoPanel.rowFromIJ(0, n);
        int I = 0;
        while (I < N) {
            double newRho;
            int i = RhoPanel.iFromRow(I);
            int j = RhoPanel.jFromRow(I);
            double d = newRho = I == 0 ? newEveryRho : newRhos[i][j];
            if (I == sourceI || newRho != (I == 0 ? this.everyRho : this.rhos[i][j])) {
                this.textFields[I].setText("" + newRho);
                int newScrollbarValue = (int)Math.round(newRho * 100.0);
                if (ae == null || ae.getAdjustable() != this.scrollbars[I] || ae.getValue() != newScrollbarValue) {
                    this.scrollbars[I].setValue(newScrollbarValue);
                }
            }
            ++I;
        }
        this.everyRho = newEveryRho;
        this.rhos = newRhos;
    }

    public abstract double verifyNewRhos(double var1, double[][] var3);

    private static final int rowFromIJ(int i, int j) {
        return j * (j - 1) / 2 + i + 1;
    }

    private static final int jFromRow(int row) {
        int j = 0;
        while (RhoPanel.rowFromIJ(0, j + 1) <= row) {
            ++j;
        }
        return j;
    }

    private static final int iFromRow(int row) {
        return row - RhoPanel.rowFromIJ(0, RhoPanel.jFromRow(row));
    }

    public static void beep() {
        try {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (NoSuchMethodError e) {
            System.out.println("\u0007BEEP!");
        }
    }

    static /* synthetic */ void access$0(RhoPanel rhoPanel, int n, int n2, int n3, double d, AdjustmentEvent adjustmentEvent) {
        rhoPanel.updateOneRho(n, n2, n3, d, adjustmentEvent);
    }

    static /* synthetic */ double access$1(RhoPanel rhoPanel) {
        return rhoPanel.everyRho;
    }

    static /* synthetic */ double[][] access$2(RhoPanel rhoPanel) {
        return rhoPanel.rhos;
    }

    public RhoPanel(double _everyRho, double[][] _rhos, String[] _names) {
        int n = _rhos.length;
        int N = RhoPanel.rowFromIJ(0, n);
        this.everyRho = _everyRho;
        this.rhos = VecMath.copymat(_rhos);
        this.names = _names;
        this.labels = new Label[N];
        this.textFields = new TextField[N];
        this.scrollbars = new Scrollbar[N];
        this.zeroButtons = new Button[N];
        int I = 0;
        while (I < N) {
            int II = I;
            int i = RhoPanel.iFromRow(I);
            int j = RhoPanel.jFromRow(I);
            this.labels[I] = new Label(I == 0 ? "All:" : this.names[i] + this.names[j]);
            this.textFields[I] = new TextField(this, "" + (I == 0 ? this.everyRho : this.rhos[i][j]), 5, II, i, j){
                final /* synthetic */ RhoPanel this$0;
                final /* synthetic */ int val$II;
                final /* synthetic */ int val$i;
                final /* synthetic */ int val$j;

                public final boolean action(Event e, Object what) {
                    try {
                        String s = (String)what;
                        double newRho = s.equals("") ? 0.0 : Double.parseDouble(s);
                        RhoPanel.access$0(this.this$0, this.val$II, this.val$i, this.val$j, newRho, null);
                    }
                    catch (NumberFormatException nfe) {
                        RhoPanel.beep();
                    }
                    return true;
                }

                public final boolean lostFocus(Event e, Object what) {
                    this.setText("" + (this.val$II == 0 ? RhoPanel.access$1(this.this$0) : RhoPanel.access$2(this.this$0)[this.val$i][this.val$j]));
                    return true;
                }
                {
                    this.this$0 = rhoPanel;
                    this.val$II = n;
                    this.val$i = n2;
                    this.val$j = n3;
                }
            };
            this.scrollbars[I] = new Scrollbar(this, 0, (int)Math.round((I == 0 ? this.everyRho : this.rhos[i][j]) * 100.0), 20, -100, 120){
                final /* synthetic */ RhoPanel this$0;

                public final Dimension getPreferredSize() {
                    int height = super.getPreferredSize().height;
                    return new Dimension(200 + this.getVisible() + 2 * height, height);
                }
                {
                    this.this$0 = rhoPanel;
                }
            };
            this.scrollbars[I].addAdjustmentListener(new AdjustmentListener(this, II, i, j){
                final /* synthetic */ RhoPanel this$0;
                final /* synthetic */ int val$II;
                final /* synthetic */ int val$i;
                final /* synthetic */ int val$j;

                public final void adjustmentValueChanged(AdjustmentEvent ae) {
                    double newRho;
                    RhoPanel.access$0(this.this$0, this.val$II, this.val$i, this.val$j, newRho, -1.0 <= (newRho = (double)ae.getValue() / 100.0) && newRho <= 1.0 ? ae : null);
                }
                {
                    this.this$0 = rhoPanel;
                    this.val$II = n;
                    this.val$i = n2;
                    this.val$j = n3;
                }
            });
            this.scrollbars[I].addKeyListener(new KeyListener(this, II, i, j){
                final /* synthetic */ RhoPanel this$0;
                final /* synthetic */ int val$II;
                final /* synthetic */ int val$i;
                final /* synthetic */ int val$j;

                public final void keyTyped(KeyEvent e) {
                }

                public final void keyPressed(KeyEvent e) {
                    double newRho;
                    switch (e.getKeyChar()) {
                        case '+': 
                        case '1': {
                            newRho = 1.0;
                            break;
                        }
                        case '0': {
                            newRho = 0.0;
                            break;
                        }
                        case '-': 
                        case '2': {
                            newRho = -1.0;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    RhoPanel.access$0(this.this$0, this.val$II, this.val$i, this.val$j, newRho, null);
                }

                public final void keyReleased(KeyEvent e) {
                }
                {
                    this.this$0 = rhoPanel;
                    this.val$II = n;
                    this.val$i = n2;
                    this.val$j = n3;
                }
            });
            this.zeroButtons[I] = new Button(this, "Zero", II, i, j){
                final /* synthetic */ RhoPanel this$0;
                final /* synthetic */ int val$II;
                final /* synthetic */ int val$i;
                final /* synthetic */ int val$j;

                public final boolean action(Event e, Object what) {
                    RhoPanel.access$0(this.this$0, this.val$II, this.val$i, this.val$j, 0.0, null);
                    return true;
                }
                {
                    this.this$0 = rhoPanel;
                    this.val$II = n;
                    this.val$i = n2;
                    this.val$j = n3;
                }
            };
            ++I;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagConstraints horizontalStretchConstraints = new GridBagConstraints();
        horizontalStretchConstraints.fill = 2;
        horizontalStretchConstraints.weightx = 1.0;
        horizontalStretchConstraints.weighty = 1.0;
        int I2 = 0;
        while (I2 < N) {
            constraints.gridy = I2;
            horizontalStretchConstraints.gridy = I2;
            constraints.gridx = 0;
            this.add((Component)this.labels[I2], constraints);
            constraints.gridx = 1;
            this.add((Component)this.textFields[I2], constraints);
            horizontalStretchConstraints.gridx = 2;
            this.add((Component)this.scrollbars[I2], horizontalStretchConstraints);
            constraints.gridx = 3;
            this.add((Component)this.zeroButtons[I2], constraints);
            ++I2;
        }
    }
}

