/*
 * Decompiled with CFR 0.152.
 */
public class MyMath {
    public static double expm1(double x) {
        double u = Math.exp(x);
        if (u == 1.0) {
            return x;
        }
        if (u - 1.0 == -1.0) {
            return -1.0;
        }
        return (u - 1.0) * x / Math.log(u);
    }

    public static double log1p(double x) {
        double u = 1.0 + x;
        return Math.log(u) - (u - 1.0 - x) / u;
    }

    public static double sinh(double x) {
        double u = MyMath.expm1(x);
        return 0.5 * u / (u + 1.0) * (u + (double)2);
    }

    public static double cosh(double x) {
        double e_x = Math.exp(x);
        return (e_x + 1.0 / e_x) * 0.5;
    }

    public static double coshm1(double x) {
        double u = MyMath.expm1(x);
        return 0.5 * u / (u + 1.0) * u;
    }

    public static double tanh(double x) {
        double u = MyMath.expm1(x);
        return u / (u * (u + (double)2) + (double)2) * (u + (double)2);
    }

    public static double asinh(double x) {
        return MyMath.log1p(x * (1.0 + x / (Math.sqrt(x * x + 1.0) + 1.0)));
    }

    public static double acosh(double x) {
        return (double)2 * Math.log(Math.sqrt((x + 1.0) * 0.5) + Math.sqrt((x - 1.0) * 0.5));
    }

    public static double atanh(double x) {
        return 0.5 * MyMath.log1p((double)2 * x / (1.0 - x));
    }

    public static double cosf1(double x) {
        double sinHalfX = Math.sin(0.5 * x);
        return (double)2 * sinHalfX * sinHalfX;
    }

    public static double acos1m(double x) {
        return (double)2 * Math.asin(Math.sqrt(0.5 * x));
    }

    public static double sin_over_x(double x) {
        if (1.0 - x * x * 0.16666666666666666 == 1.0) {
            return 1.0;
        }
        return Math.sin(x) / x;
    }

    public static double asin_over_x(double x) {
        if (1.0 + x * x * x * 0.3333333333333333 == 1.0) {
            return 1.0;
        }
        return Math.asin(x) / x;
    }

    public static double cosf1_over_x(double x) {
        if (1.0 - x * x * 0.16666666666666666 == 1.0) {
            return 0.5 * x;
        }
        return MyMath.cosf1(x) / x;
    }

    public static double hypot(double x, double y) {
        double max;
        double min;
        if ((x = Math.abs(x)) < (y = Math.abs(y))) {
            min = x;
            max = y;
        } else {
            min = y;
            max = x;
        }
        if (min == 0.0) {
            return max;
        }
        double min_max = min / max;
        return max * Math.sqrt(1.0 + min_max * min_max);
    }
}

