/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MyGraphics {
    private Graphics g;
    private Dimension gsize;
    private double scaleX;
    private double scaleY;
    private double translateX;
    private double translateY;
    public int verbose;

    public void fit(double x0, double x1, double y0, double y1, double left, double right, double bottom, double top) {
        this.scaleX = (right - left) / (x1 - x0);
        this.scaleY = (top - bottom) / (y1 - y0);
        this.translateX = left - this.scaleX * x0;
        this.translateY = bottom - this.scaleY * y0;
    }

    public void fitToWindow(double x0, double x1, double y0, double y1) {
        this.fit(x0, x1, y0, y1, 0.5, (double)this.gsize.width - 0.5, (double)this.gsize.height - 0.5, 0.5);
    }

    public void translate(double x, double y) {
        this.translateX += x * this.scaleX;
        this.translateY += y * this.scaleY;
    }

    public void pick(double x, double y, double[] result) {
        result[0] = (x - this.translateX) / this.scaleX;
        result[1] = (y - this.translateY) / this.scaleY;
    }

    public void unpick(double x, double y, double[] result) {
        result[0] = x * this.scaleX + this.translateX;
        result[1] = y * this.scaleY + this.translateY;
    }

    public void fillWindow() {
        this.g.fillRect(0, 0, this.gsize.width, this.gsize.height);
    }

    public void drawLine(double x0, double y0, double x1, double y1) {
        this.g.drawLine((int)(x0 * this.scaleX + this.translateX - 0.5), (int)(y0 * this.scaleY + this.translateY - 0.5), (int)(x1 * this.scaleX + this.translateX - 0.5), (int)(y1 * this.scaleY + this.translateY - 0.5));
    }

    public void drawPoint(double x, double y, int nPixels) {
        int x0 = (int)(x * this.scaleX + this.translateX - 0.5 * (double)nPixels);
        int y0 = (int)(y * this.scaleY + this.translateY - 0.5 * (double)nPixels);
        if (this.verbose >= 2) {
            System.out.println("in drawPoint(" + x + ',' + y + ',' + nPixels + ") -> " + x0 + ',' + y0);
        }
        if (x0 < -nPixels || x0 > this.gsize.width + nPixels || y0 < -nPixels || y0 > this.gsize.width + nPixels) {
            return;
        }
        this.g.fillRect(x0, y0, nPixels, nPixels);
    }

    public void drawString(String s, double x, double y) {
        this.g.drawString(s, (int)(x * this.scaleX + this.translateX), (int)(y * this.scaleY + this.translateY));
    }

    public void drawString(String s, double x, double y, double xJustify, double yJustify) {
        FontMetrics fm = this.g.getFontMetrics();
        this.g.drawString(s, (int)(x * this.scaleX + this.translateX - (double)fm.stringWidth(s) * (xJustify + 1.0) * 0.5), (int)(y * this.scaleY + this.translateY + (double)fm.getAscent() * (1.0 - yJustify) * 0.5));
    }

    public void drawStringCentered(String s, double x, double y) {
        this.drawString(s, x, y, 0.0, 0.0);
    }

    public void drawStringRightJustified(String s, double x, double y) {
        this.drawString(s, x, y, 1.0, 0.0);
    }

    public double getFontHeight() {
        FontMetrics fm = this.g.getFontMetrics();
        return Math.abs((double)fm.getHeight() / this.scaleY);
    }

    public void smartDrawArcNonClipped(double focusX, double focusY, double focusAngleRadians, double c, double start, double end) {
        int nSegs = 10 >= (int)(((end - start) * c < 0.0 ? -((end - start) * c) : (end - start) * c) / (Math.PI / 180)) ? 10 : (int)(((end - start) * c < 0.0 ? -((end - start) * c) : (end - start) * c) / (Math.PI / 180));
        System.out.println("nSegs = " + nSegs);
        double cosFocusAngle = Math.cos(focusAngleRadians);
        double sinFocusAngle = Math.sin(focusAngleRadians);
        double[][] normalAndTangent = new double[][]{{cosFocusAngle, sinFocusAngle}, {-sinFocusAngle, cosFocusAngle}};
        double[] prevPoint = new double[2];
        double[] point = new double[2];
        double[] coeff = new double[2];
        int i = 0;
        while (i < nSegs + 1) {
            double t = start + (double)i / (double)nSegs * (end - start);
            coeff[0] = -MyMath.cosf1_over_x(t * c) * t;
            coeff[1] = MyMath.sin_over_x(t * c) * t;
            VecMath.vxm(point, coeff, normalAndTangent);
            if (i > 0) {
                this.drawLine(focusX + prevPoint[0], focusY + prevPoint[1], focusX + point[0], focusY + point[1]);
            }
            VecMath.copyvec(prevPoint, point);
            ++i;
        }
    }

    public void drawArc(double x, double y, double width, double height, double startRadians, double arcRadians) {
        double centerX = x + width * 0.5;
        double centerY = y + height * 0.5;
        double radius = 0.25 * (width + height);
        double curvature = 1.0 / radius;
        double focusAngleRadians = startRadians;
        double start = 0.0;
        double end = arcRadians * radius;
        double focusX = centerX + radius * Math.cos(focusAngleRadians);
        double focusY = centerY + radius * Math.sin(focusAngleRadians);
        this.smartDrawArcNonClipped(focusX, focusY, focusAngleRadians, curvature, start, end);
    }

    public Color getColor() {
        return this.g.getColor();
    }

    public void setColor(Color color) {
        this.g.setColor(color);
    }

    private final /* synthetic */ void this() {
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        this.translateX = 0.0;
        this.translateY = 0.0;
        this.verbose = 0;
    }

    public MyGraphics(Graphics g, Dimension gsize, double x0, double x1, double y0, double y1) {
        this.this();
        this.g = g;
        this.gsize = gsize;
        this.fitToWindow(x0, x1, y0, y1);
    }
}

