/*
 * Decompiled with CFR 0.152.
 */
public class Minimizer {
    static final double TINY = 1.0E-10;

    public static double[] minimize(VectorFunction fun, double[] initialGuess, double initialDelta, int maxCalls) {
        int n = initialGuess.length;
        if (n == 0) {
            return new double[n];
        }
        double[][] simplex = new double[n + 1][n];
        double[] vals = new double[n + 1];
        int nTries = 1;
        int I = 0;
        while (I < nTries) {
            int i = 0;
            while (i < n + 1) {
                VecMath.copyvec(simplex[i], initialGuess);
                if (i < n) {
                    double[] dArray = simplex[i];
                    int n2 = i;
                    dArray[n2] = dArray[n2] + initialDelta;
                }
                vals[i] = fun.apply(simplex[i]);
                ++i;
            }
            double ftol = 1.0E-12;
            int nCalls = Minimizer.amoeba(simplex, vals, ftol, fun, maxCalls);
            if (nCalls >= maxCalls) {
                return null;
            }
            initialGuess = simplex[0];
            ++I;
        }
        return simplex[0];
    }

    private static final int amoeba(double[][] simplex, double[] vals, double ftol, VectorFunction fun, int maxCalls) {
        int n = simplex.length - 1;
        int nCalls = 0;
        double[] psum = VecMath.sum(simplex);
        while (true) {
            int ihi;
            int ilo;
            int inhi;
            if (vals[0] <= vals[1]) {
                inhi = 0;
                ilo = 0;
                ihi = 1;
            } else {
                inhi = 1;
                ilo = 1;
                ihi = 0;
            }
            int i = 2;
            while (i < n + 1) {
                if (vals[i] < vals[ilo]) {
                    ilo = i;
                }
                if (vals[i] > vals[ihi]) {
                    inhi = ihi;
                    ihi = i;
                } else if (vals[i] > vals[inhi]) {
                    inhi = i;
                }
                ++i;
            }
            double rtol = (double)2 * Math.abs(vals[ihi] - vals[ilo]) / (Math.abs(vals[ihi]) + Math.abs(vals[ilo]) + 1.0E-10);
            if (rtol < ftol) {
                double dtemp = vals[0];
                vals[0] = vals[ilo];
                vals[ilo] = dtemp;
                double[] ptemp = simplex[0];
                simplex[0] = simplex[ilo];
                simplex[ilo] = ptemp;
                break;
            }
            if (nCalls >= maxCalls) {
                System.out.println("Minimizer: maxCalls " + maxCalls + " exceeded");
                break;
            }
            double ytry = Minimizer.amotry(simplex, vals, psum, fun, ihi, -1.0);
            ++nCalls;
            if (ytry <= vals[ilo]) {
                ytry = Minimizer.amotry(simplex, vals, psum, fun, ihi, 2);
                ++nCalls;
                continue;
            }
            if (!(ytry >= vals[inhi])) continue;
            double ysave = vals[ihi];
            ytry = Minimizer.amotry(simplex, vals, psum, fun, ihi, 0.5);
            ++nCalls;
            if (!(ytry >= ysave)) continue;
            int i2 = 0;
            while (i2 < n + 1) {
                if (i2 != ilo) {
                    VecMath.lerp(simplex[i2], simplex[ilo], simplex[i2], 0.5);
                    vals[i2] = fun.apply(simplex[i2]);
                }
                ++i2;
            }
            nCalls += n;
            VecMath.sum(psum, simplex);
        }
        return nCalls;
    }

    private static final double amotry(double[][] simplex, double[] vals, double[] psum, VectorFunction fun, int ihi, double fac) {
        int n = simplex.length - 1;
        double[] ptry = new double[n];
        double fac0 = (1.0 - fac) / (double)n;
        double fac1 = fac0 - fac;
        VecMath.sxvpsxv(ptry, fac0, psum, -fac1, simplex[ihi]);
        double ytry = fun.apply(ptry);
        if (ytry < vals[ihi]) {
            vals[ihi] = ytry;
            VecMath.vmv(psum, psum, simplex[ihi]);
            simplex[ihi] = ptry;
            VecMath.vpv(psum, psum, simplex[ihi]);
        }
        return ytry;
    }

    public static interface VectorFunction {
        public double apply(double[] var1);
    }
}

