/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.URL;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EfficientFrontierApplet
extends Applet {
    static double[][] cachedV = null;
    static boolean[] cachedWhichColumnsOfVAreImaginary = null;
    static double[][] rhosOfCachedV = null;
    static int impossibleCorrelationsStrategyOfCachedV = -1;
    static final int COMBINE_FAST = 0;
    static final int COMBINE_GOOD = 1;
    static final int COMBINE_FAST_EXCELLENT = 2;
    static final int IMPOSSIBLE_ALLOW = 0;
    static final int IMPOSSIBLE_FIX = 1;
    static final int IMPOSSIBLE_DISALLOW = 2;
    static final int MEAN_ARITHMETIC = 0;
    static final int MEAN_GEOMETRIC = 1;
    static int integrationIterationsPerArea = 1600;
    double[][] assets;
    String[] assetNames;
    double[][] allRhos;
    double everyRho;
    double[][] drawnAssets;
    private double minMean;
    private double maxMean;
    private double minStdDev;
    private double maxStdDev;
    private double logMaxMean;
    private double logMaxStdDev;
    private double invLogMaxMean;
    private double invLogMaxStdDev;
    private int nMeanIntervals;
    private int nStdDevIntervals;
    boolean useArithmeticMeans;
    boolean showGeomMeanLines;
    double gGridContrast;
    boolean showArithMeanLines;
    double aGridContrast;
    boolean showMinorGridLines;
    double minorGridContrast;
    int maxAssetsToDraw;
    int combineMethod;
    int impossibleCorrelationsStrategy;
    int possibleStatus;
    double[] prevP;
    int selectedPointIndex;
    Image verticalAxisLabelImage;
    int eventVerbose;
    int timeVerbose;
    boolean doDoubleBuffer;
    int pickRadius;
    Image backBufferImage;
    MyGraphics mostRecentGraphics;
    GridBagConstraints horizontalStretchConstraints;
    Frame controlPanelFrame;
    MyPanel rhoPanelHolder;
    RhoPanel rhoPanel;
    boolean showMatrixPanel;
    MatrixPanel matrixPanel;
    MatrixPanel VmatrixPanel;
    Canvas canvas;
    Canvas rhosStatusCanvas;
    Label rhosStatusLabel;
    Checkbox useGeomMeanCheckbox;
    Checkbox useArithMeanCheckbox;
    Checkbox showMinorGridLinesCheckbox;
    Checkbox showGeomMeanLinesCheckbox;
    Checkbox showArithMeanLinesCheckbox;
    Scrollbar gGridScrollbar;
    Scrollbar aGridScrollbar;
    Scrollbar minorGridScrollbar;
    Button showControlPanelButton;
    boolean button1IsDown;
    boolean button2IsDown;
    boolean button3IsDown;

    private final String getParameterString(String paramName, String defaultValue) {
        String paramValueString = this.getParameter(paramName);
        if (paramValueString != null) {
            return paramValueString;
        }
        return defaultValue;
    }

    private final int getParameterInt(String paramName, int defaultValue) {
        String paramValueString = this.getParameter(paramName);
        if (paramValueString != null) {
            try {
                return Integer.decode(paramValueString);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return defaultValue;
    }

    private final boolean getParameterBoolean(String paramName, boolean defaultValue) {
        String paramValueString = this.getParameter(paramName);
        if (paramValueString != null) {
            try {
                int n = Integer.decode(paramValueString);
                boolean bl = false;
                if (n != 0) {
                    bl = true;
                }
                return bl;
            }
            catch (NumberFormatException e) {
                return paramValueString.equalsIgnoreCase("true") || paramValueString.equalsIgnoreCase("yes") || paramValueString.equalsIgnoreCase("t") || paramValueString.equalsIgnoreCase("y");
            }
        }
        return defaultValue;
    }

    public void init() {
        this.eventVerbose = this.getParameterInt("eventVerbose", 0);
        if (this.eventVerbose >= 1) {
            System.out.println("in init");
        }
        if (this.getParameterBoolean("showControlPanel", false)) {
            this.controlPanelFrame.show();
            this.showControlPanelButton.setLabel("Hide Control Panel");
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out init");
        }
    }

    public void start() {
        if (this.eventVerbose >= 1) {
            System.out.println("in start");
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out start");
        }
    }

    public void stop() {
        if (this.eventVerbose >= 1) {
            System.out.println("in stop");
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out stop");
        }
    }

    public void destroy() {
        if (this.eventVerbose >= 1) {
            System.out.println("in destroy");
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out destroy");
        }
    }

    private static final int getButton(MouseEvent e) {
        int mods = e.getModifiers();
        if ((mods & 8) != 0) {
            return 2;
        }
        if ((mods & 4) != 0) {
            return 3;
        }
        return 1;
    }

    private static final Image makeVerticalStringImage(String labelString, Color bgColor, Color fgColor, Graphics g, Component component) {
        FontMetrics fm = g.getFontMetrics();
        int width = fm.stringWidth(labelString);
        int height = fm.getHeight() - fm.getLeading();
        Image image0 = component.createImage(width, height);
        Graphics ig = image0.getGraphics();
        ig.setColor(bgColor);
        ig.fillRect(0, 0, width, height);
        ig.setFont(g.getFont());
        ig.setColor(fgColor);
        ig.drawString(labelString, 0, fm.getMaxAscent());
        int[] buf0 = new int[width * height];
        int[] buf = new int[height * width];
        PixelGrabber pixelGrabber = new PixelGrabber(image0, 0, 0, width, height, buf0, 0, width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return null;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return null;
        }
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                buf[i * height + j] = buf0[j * width + (width - 1 - i)];
                ++j;
            }
            ++i;
        }
        return component.createImage(new MemoryImageSource(height, width, buf, 0, height));
    }

    private static final int findClosestVertIndex(double[] p, double[][] points, int n, double pickRadius) {
        int bestI = -1;
        double bestDistSqrd = Double.POSITIVE_INFINITY;
        int i = n - 1;
        while (i >= 0) {
            double[] v = points[i];
            double thisDistSqrd = VecMath.distsqrd(p, v);
            if (thisDistSqrd < bestDistSqrd) {
                bestDistSqrd = thisDistSqrd;
                bestI = i;
            }
            --i;
        }
        return bestDistSqrd <= pickRadius * pickRadius ? bestI : -1;
    }

    private static final void combine_mean_stddev(double[] result, double w0, double M0, double S0, double w1, double M1, double S1, double rho) {
        if (Double.isNaN(w0)) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1699): !Double.isNaN(w0)");
        }
        if (Double.isNaN(M0)) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1700): !Double.isNaN(M0)");
        }
        if (Double.isNaN(S0)) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1701): !Double.isNaN(S0)");
        }
        if (Double.isNaN(w1)) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1702): !Double.isNaN(w1)");
        }
        if (Double.isNaN(M1)) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1703): !Double.isNaN(M1)");
        }
        if (Double.isNaN(S1)) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1704): !Double.isNaN(S1)");
        }
        if (Double.isNaN(rho)) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1705): !Double.isNaN(rho)");
        }
        double sameWeight = (1.0 + rho) * 0.25;
        double oppositeWeight = (1.0 - rho) * 0.25;
        double logA = Math.log(w0 * (M0 / S0) + w1 * (M1 / S1));
        double logB = Math.log(w0 * (M0 / S0) + w1 * (M1 * S1));
        double logC = Math.log(w0 * (M0 * S0) + w1 * (M1 / S1));
        double logD = Math.log(w0 * (M0 * S0) + w1 * (M1 * S1));
        double logMean = sameWeight * (logA + logD) + oppositeWeight * (logB + logC);
        double logVariance = sameWeight * ((logA - logMean) * (logA - logMean) + (logD - logMean) * (logD - logMean)) + oppositeWeight * ((logB - logMean) * (logB - logMean) + (logC - logMean) * (logC - logMean));
        double logStdDev = Math.sqrt(logVariance);
        if (Double.isNaN(logMean) || Double.isNaN(logStdDev)) {
            System.out.println("w0 = " + w0);
            System.out.println("M0 = " + M0);
            System.out.println("S0 = " + S0);
            System.out.println("w1 = " + w1);
            System.out.println("M1 = " + M1);
            System.out.println("S1 = " + S1);
            System.out.println("rho = " + rho);
            System.out.println("sameWeight = " + sameWeight);
            System.out.println("oppositeWeight = " + oppositeWeight);
            System.out.println("logVariance = " + logVariance);
            System.out.println("logStdDev = " + logStdDev);
        }
        if (Double.isNaN(logMean)) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1750): !Double.isNaN(logMean)");
        }
        if (Double.isNaN(logStdDev)) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1751): !Double.isNaN(logStdDev)");
        }
        result[0] = Math.exp(logMean);
        result[1] = Math.exp(logStdDev);
    }

    private static final void fast_combine_mean_stddev(double[] result, double[] weights, double[] means, double[] stdDevs, double[][] rhos) {
        int n = weights.length;
        if (n != means.length) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1775): n == means.length");
        }
        if (n != stdDevs.length) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1776): n == stdDevs.length");
        }
        if (n < 1) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1777): n >= 1");
        }
        double sum = weights[0];
        result[0] = means[0];
        result[1] = stdDevs[0];
        int i = 1;
        while (i < weights.length) {
            double rhoAvg = 0.0;
            if (sum != 0.0) {
                int j = 0;
                while (j < i) {
                    rhoAvg += rhos[i][j] * weights[j];
                    ++j;
                }
                rhoAvg /= sum;
            }
            if ((sum += weights[i]) != 0.0) {
                double t = weights[i] / sum;
                EfficientFrontierApplet.combine_mean_stddev(result, 1.0 - t, result[0], result[1], t, means[i], stdDevs[i], rhoAvg);
            }
            ++i;
        }
    }

    private static final void good_combine_mean_stddev(double[] result, double[] weights, double[] means, double[] stdDevs, double[][] rhos) {
        int n = weights.length;
        if (n != means.length) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1817): n == means.length");
        }
        if (n != stdDevs.length) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1818): n == stdDevs.length");
        }
        if (n < 1) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1819): n >= 1");
        }
        double[][] winOrLose = new double[2][n];
        int i = 0;
        while (i < n) {
            double temp = weights[i] * means[i];
            winOrLose[0][i] = temp / stdDevs[i];
            winOrLose[1][i] = temp * stdDevs[i];
            ++i;
        }
        int N = 1 << n;
        double[] logOutcomes = new double[N];
        double[] probs = new double[N];
        double invN = 1.0 / (double)N;
        int I = 0;
        while (I < N) {
            double probSum = 0.0;
            double outcomeSum = 0.0;
            int i2 = 0;
            while (i2 < n) {
                int BIT_I_i = I >> i2 & 1;
                outcomeSum += winOrLose[BIT_I_i][i2];
                int j = 0;
                while (j < i2) {
                    probSum += (double)((BIT_I_i * 2 - 1) * ((I >> j & 1) * 2 - 1)) * rhos[i2][j];
                    ++j;
                }
                ++i2;
            }
            logOutcomes[I] = Math.log(outcomeSum);
            probs[I] = (1.0 + probSum) * invN;
            if (2 * I >= N && probs[I] != probs[N - 1 - I]) {
                throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1860): probs[I] == probs[N-1-I]");
            }
            ++I;
        }
        double logspaceMean = 0.0;
        int N_over_2 = N / 2;
        I = 0;
        while (I < N_over_2) {
            logspaceMean += probs[I] * (logOutcomes[I] + logOutcomes[N - 1 - I]);
            ++I;
        }
        double logspaceVariance = 0.0;
        I = 0;
        while (I < N_over_2) {
            logspaceVariance += probs[I] * ((logOutcomes[I] - logspaceMean) * (logOutcomes[I] - logspaceMean) + (logOutcomes[N - 1 - I] - logspaceMean) * (logOutcomes[N - 1 - I] - logspaceMean));
            ++I;
        }
        double logspaceStdDev = logspaceVariance < 0.0 ? 0.0 : Math.sqrt(logspaceVariance);
        result[0] = Math.exp(logspaceMean);
        result[1] = Math.exp(logspaceStdDev);
    }

    private static final void fast_excellent_combine_mean_stddev(double[] result, double[] weights, double[] means, double[] stdDevs, double[][] V, boolean[] whichColumnsOfVAreImaginary) {
        boolean XXXverbose = false;
        int n = weights.length;
        if (n != means.length) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1942): n == means.length");
        }
        if (n != stdDevs.length) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1943): n == stdDevs.length");
        }
        if (n != V.length) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1944): n == V.length");
        }
        if (n != 0 && n != V[0].length) {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(1945): n == 0 || n == V[0].length");
        }
        double[][] W = new double[n][2 * n];
        double sqrt_n = Math.sqrt(n);
        int i = 0;
        while (i < n) {
            double mean = means[i];
            double logspaceStdDev = Math.log(stdDevs[i]);
            double logspaceStdDev_times_sqrt_n = logspaceStdDev * sqrt_n;
            int j = 0;
            while (j < n) {
                double dev = whichColumnsOfVAreImaginary != null && whichColumnsOfVAreImaginary[j] ? Math.cos(V[i][j] * logspaceStdDev_times_sqrt_n) : Math.exp(V[i][j] * logspaceStdDev_times_sqrt_n);
                W[i][j] = mean / dev;
                W[i][n + j] = mean * dev;
                ++j;
            }
            ++i;
        }
        double[] logOutcomes = new double[2 * n];
        double sumLogOutcomes = 0.0;
        int j = 0;
        while (j < 2 * n) {
            double logOutcomeThisPeriod;
            double outcomeThisPeriod = 0.0;
            int i2 = 0;
            while (i2 < n) {
                outcomeThisPeriod += weights[i2] * W[i2][j];
                if (XXXverbose) {
                    System.out.println("sample j=" + j + " asset i=" + i2 + ": " + weights[i2] + '*' + W[i2][j] + " = " + weights[i2] * W[i2][j]);
                }
                ++i2;
            }
            if (XXXverbose) {
                System.out.println("outcomeThisPeriod = " + outcomeThisPeriod);
            }
            logOutcomes[j] = logOutcomeThisPeriod = Math.log(outcomeThisPeriod);
            sumLogOutcomes += logOutcomeThisPeriod;
            ++j;
        }
        double logspaceMean = sumLogOutcomes / (double)(2 * n);
        double logspaceVariance = 0.0;
        int i3 = 0;
        while (i3 < 2 * n) {
            logspaceVariance += (logOutcomes[i3] - logspaceMean) * (logOutcomes[i3] - logspaceMean);
            ++i3;
        }
        double logspaceStdDev = Math.sqrt(logspaceVariance /= (double)(2 * n));
        result[0] = Math.exp(logspaceMean);
        result[1] = Math.exp(logspaceStdDev);
        if (XXXverbose) {
            System.out.println("weights.length = " + weights.length);
            System.out.println("result[0] = " + result[0]);
            System.out.println("result[1] = " + result[1]);
            System.out.println("))))))))))))))))))))))))))))))");
        }
    }

    private static final void combine_mean_stddev(double[] result, double[] weights, double[] means, double[] stdDevs, double[][] rhos, int combineMethod, int impossibleCorrelationsStrategy, EfficientFrontierApplet applet) {
        if (combineMethod == 0) {
            EfficientFrontierApplet.fast_combine_mean_stddev(result, weights, means, stdDevs, rhos);
        } else if (combineMethod == 1) {
            EfficientFrontierApplet.good_combine_mean_stddev(result, weights, means, stdDevs, rhos);
        } else if (combineMethod == 2) {
            if (impossibleCorrelationsStrategy != impossibleCorrelationsStrategyOfCachedV || !VecMath.equals(rhos, rhosOfCachedV, 0.0)) {
                rhosOfCachedV = VecMath.copymat(rhos);
                impossibleCorrelationsStrategyOfCachedV = impossibleCorrelationsStrategy;
                cachedV = new double[rhos.length][rhos.length];
                cachedWhichColumnsOfVAreImaginary = impossibleCorrelationsStrategyOfCachedV == 0 ? new boolean[rhos.length] : null;
                VecMath.leftSqrtOfSymmetricMatrix(cachedV, cachedWhichColumnsOfVAreImaginary, rhos);
                if (cachedWhichColumnsOfVAreImaginary != null) {
                    VecMath.normalizeRows(cachedV, cachedV);
                }
                if (rhos.length == applet.allRhos.length && applet.VmatrixPanel.isVisible() && applet.VmatrixPanel.setMatrix(cachedV, cachedWhichColumnsOfVAreImaginary)) {
                    applet.controlPanelFrame.pack();
                }
            }
            EfficientFrontierApplet.fast_excellent_combine_mean_stddev(result, weights, means, stdDevs, cachedV, cachedWhichColumnsOfVAreImaginary);
        } else {
            throw new Error("Assertion failed at EfficientFrontierApplet.prejava(2084): false");
        }
    }

    private static final double findGMeanFromAMeanAndStdDev(double aMean, double stdDev) {
        double hi = (double)2 * aMean * (stdDev * stdDev) / (1.0 + stdDev * stdDev);
        double lo = (double)2 * aMean - hi;
        double gMean = Math.sqrt(hi * lo);
        return gMean;
    }

    private static final double findAMeanFromGMeanAndStdDev(double gMean, double stdDev) {
        double hi = gMean * stdDev;
        double lo = gMean / stdDev;
        double aMean = (hi + lo) * 0.5;
        return aMean;
    }

    private static final String findUnusedAssetName(String[] assetNames) {
        int length = 1;
        while (true) {
            int i = 0;
            while (i < 26) {
                String name = "";
                int j = 0;
                while (j < length) {
                    name = name + (char)(65 + i);
                    ++j;
                }
                j = 0;
                while (j < assetNames.length) {
                    if (name.equals(assetNames[j])) break;
                    ++j;
                }
                if (j == assetNames.length) {
                    return name;
                }
                ++i;
            }
            ++length;
        }
    }

    public static void main(String[] args) {
        System.out.println("in main");
        if (args.length == 1 && args[0].equalsIgnoreCase("test")) {
            EfficientFrontierApplet.test();
            return;
        }
        Frame frame = new Frame("Portfolio Theory Applet"){

            public final boolean handleEvent(Event event) {
                switch (event.id) {
                    case 201: {
                        System.out.println("bye!");
                        this.dispose();
                        System.exit(0);
                        return true;
                    }
                }
                return super.handleEvent(event);
            }
        };
        EfficientFrontierApplet applet = new EfficientFrontierApplet();
        applet.setStub(new AppletStub(args){
            final /* synthetic */ String[] val$args;

            public final void appletResize(int width, int height) {
            }

            public final AppletContext getAppletContext() {
                return null;
            }

            public final URL getCodeBase() {
                return null;
            }

            public final URL getDocumentBase() {
                return null;
            }

            public final String getParameter(String name) {
                String prefix = name.toLowerCase() + '=';
                int i = 0;
                while (i < this.val$args.length) {
                    if (this.val$args[i].toLowerCase().startsWith(prefix)) {
                        return this.val$args[i].substring(prefix.length());
                    }
                    ++i;
                }
                return null;
            }

            public final boolean isActive() {
                return true;
            }
            {
                this.val$args = stringArray;
            }
        });
        frame.add(applet);
        applet.init();
        applet.start();
        frame.move(20, 20);
        frame.resize(768, 512);
        frame.show();
        System.out.println("out main");
    }

    private static final void test() {
        double[] weights = new double[]{0.5, 0.5};
        double[] means = new double[]{1.0, 1.0};
        double[] stdDevs = new double[]{1.25, 1.25};
        double[][] rhos = new double[][]{{1.0, -1.0}, {-1.0, 1.0}};
        double[] result = new double[2];
        EfficientFrontierApplet.fast_combine_mean_stddev(result, weights, means, stdDevs, rhos);
        double mean = result[0];
        double stddev = result[1];
        System.out.println("mean = " + mean);
        System.out.println("stddev = " + stddev);
        double[][] V = new double[rhos.length][rhos.length];
        boolean[] whichColumnsOfVAreImaginary = new boolean[rhos.length];
        VecMath.leftSqrtOfSymmetricMatrix(V, whichColumnsOfVAreImaginary, rhos);
        if (whichColumnsOfVAreImaginary != null) {
            VecMath.normalizeRows(V, V);
        }
        System.out.println("V =\n" + VecMath.toString(V));
        System.out.println("whichColumnsOfVAreImaginary = " + VecMath.toString(whichColumnsOfVAreImaginary));
        EfficientFrontierApplet.fast_excellent_combine_mean_stddev(result, weights, means, stdDevs, V, whichColumnsOfVAreImaginary);
        mean = result[0];
        stddev = result[1];
        System.out.println("mean = " + mean);
        System.out.println("stddev = " + stddev);
    }

    private final /* synthetic */ void this() {
        this.assets = new double[][]{{1.05, 1.2}, {1.1, 1.4}};
        this.assetNames = new String[]{"A", "B"};
        this.allRhos = VecMath.identitymat(this.assets.length);
        this.everyRho = 0.0;
        this.drawnAssets = null;
        this.minMean = 0.8;
        this.maxMean = 1.25;
        this.minStdDev = 1.0;
        this.maxStdDev = 1.5;
        this.logMaxMean = Math.log(this.maxMean);
        this.logMaxStdDev = Math.log(this.maxStdDev);
        this.invLogMaxMean = 1.0 / this.logMaxMean;
        this.invLogMaxStdDev = 1.0 / this.logMaxStdDev;
        this.nMeanIntervals = 9;
        this.nStdDevIntervals = 10;
        this.useArithmeticMeans = false;
        this.showGeomMeanLines = true;
        this.gGridContrast = 0.2;
        this.showArithMeanLines = false;
        this.aGridContrast = 0.2;
        this.showMinorGridLines = true;
        this.minorGridContrast = 0.15;
        this.maxAssetsToDraw = 5;
        this.combineMethod = 1;
        this.impossibleCorrelationsStrategy = 1;
        this.possibleStatus = -2;
        this.prevP = null;
        this.selectedPointIndex = -1;
        this.verticalAxisLabelImage = null;
        this.eventVerbose = 0;
        this.timeVerbose = 0;
        this.doDoubleBuffer = true;
        this.pickRadius = 15;
        this.backBufferImage = null;
        this.mostRecentGraphics = null;
        this.showMatrixPanel = false;
        this.button1IsDown = false;
        this.button2IsDown = false;
        this.button3IsDown = false;
    }

    public EfficientFrontierApplet() {
        this.this();
        this.setLayout(new GridBagLayout());
        this.canvas = new EfficientFrontierAppletCanvas();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 14;
        c.fill = 0;
        this.showControlPanelButton = new Button(this, "Show Control Panel"){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean action(Event e, Object what) {
                if (this.getLabel().equals("Show Control Panel")) {
                    System.out.println("showing control panel");
                    this.this$0.controlPanelFrame.show();
                    this.setLabel("Hide Control Panel");
                } else {
                    System.out.println("hiding control panel");
                    this.this$0.controlPanelFrame.hide();
                    this.setLabel("Show Control Panel");
                }
                return true;
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        this.add((Component)this.showControlPanelButton, c);
        c.fill = 1;
        this.add((Component)this.canvas, c);
        this.controlPanelFrame = new Frame(this, "Portfolio Theory Applet Control Panel"){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean handleEvent(Event event) {
                switch (event.id) {
                    case 201: {
                        System.out.println("hiding control panel");
                        this.hide();
                        this.this$0.showControlPanelButton.setLabel("Show Control Panel");
                        return true;
                    }
                }
                return super.handleEvent(event);
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        this.controlPanelFrame.setLayout(new GridBagLayout());
        this.horizontalStretchConstraints = new GridBagConstraints(this){
            final /* synthetic */ EfficientFrontierApplet this$0;

            private final /* synthetic */ void this() {
                this.fill = 2;
                this.weightx = 1.0;
                this.weighty = 1.0;
            }
            {
                this.this$0 = efficientFrontierApplet;
                this.this();
            }
        };
        GridBagConstraints eastConstraints = new GridBagConstraints(this){
            final /* synthetic */ EfficientFrontierApplet this$0;

            private final /* synthetic */ void this() {
                this.anchor = 13;
            }
            {
                this.this$0 = efficientFrontierApplet;
                this.this();
            }
        };
        this.rhosStatusCanvas = new Canvas(this){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final Dimension getPreferredSize() {
                return new Dimension(40, 20);
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        this.rhosStatusLabel = new Label("Possible (barely)");
        this.matrixPanel = new MatrixPanel();
        this.matrixPanel.setVisible(this.showMatrixPanel);
        this.VmatrixPanel = new MatrixPanel();
        boolean bl = false;
        if (this.showMatrixPanel && this.combineMethod == 2) {
            bl = true;
        }
        this.VmatrixPanel.setVisible(bl);
        this.rhoPanel = new MyRhoPanel();
        this.rhoPanel.verifyNewRhos(this.everyRho, this.allRhos);
        this.rhoPanelHolder = new Row(new Object[][]{{this.rhoPanel, this.horizontalStretchConstraints}});
        CheckboxGroup whichMeanCBG = new CheckboxGroup();
        CheckboxGroup maxPortfolioCBG = new CheckboxGroup();
        CheckboxGroup combineMethodCBG = new CheckboxGroup();
        CheckboxGroup impossibleCorrelationsCBG = new CheckboxGroup();
        this.gGridScrollbar = new Scrollbar(0, (int)Math.round(this.gGridContrast * 100.0), 20, 0, 120);
        this.aGridScrollbar = new Scrollbar(0, (int)Math.round(this.aGridContrast * 100.0), 20, 0, 120);
        this.minorGridScrollbar = new Scrollbar(0, (int)Math.round(this.minorGridContrast * 100.0), 20, 0, 120);
        this.gGridScrollbar.addAdjustmentListener(new AdjustmentListener(this){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final void adjustmentValueChanged(AdjustmentEvent ae) {
                this.this$0.gGridContrast = (double)ae.getValue() / 100.0;
                System.out.println("gGridContrast -> " + this.this$0.gGridContrast);
                this.this$0.canvas.repaint();
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        });
        this.aGridScrollbar.addAdjustmentListener(new AdjustmentListener(this){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final void adjustmentValueChanged(AdjustmentEvent ae) {
                this.this$0.aGridContrast = (double)ae.getValue() / 100.0;
                System.out.println("aGridContrast -> " + this.this$0.aGridContrast);
                this.this$0.canvas.repaint();
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        });
        this.minorGridScrollbar.addAdjustmentListener(new AdjustmentListener(this){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final void adjustmentValueChanged(AdjustmentEvent ae) {
                this.this$0.minorGridContrast = (double)ae.getValue() / 100.0;
                System.out.println("minorGridContrast -> " + this.this$0.minorGridContrast);
                this.this$0.canvas.repaint();
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        });
        Object[][] objectArray = new Object[6][];
        Object[] objectArray2 = new Object[1];
        Object[][][] objectArray3 = new Object[2][][];
        Object[][] objectArrayArray = new Object[1][];
        Object[] objectArray4 = new Object[1];
        this.useGeomMeanCheckbox = new Checkbox(this, "Geometric mean return", whichMeanCBG, this.useArithmeticMeans ^ true){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean action(Event e, Object what) {
                this.this$0.useArithmeticMeans = false;
                this.this$0.canvas.repaint();
                return true;
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        objectArray4[0] = this.useGeomMeanCheckbox;
        objectArrayArray[0] = objectArray4;
        objectArray3[0] = objectArrayArray;
        Object[][] objectArrayArray2 = new Object[1][];
        Object[] objectArray5 = new Object[1];
        this.useArithMeanCheckbox = new Checkbox(this, "Arithmetic mean return", whichMeanCBG, this.useArithmeticMeans){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean action(Event e, Object what) {
                this.this$0.useArithmeticMeans = true;
                this.this$0.canvas.repaint();
                return true;
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        objectArray5[0] = this.useArithMeanCheckbox;
        objectArrayArray2[0] = objectArray5;
        objectArray3[1] = objectArrayArray2;
        objectArray2[0] = new MyPanel("Vertical Axis is:", "   ", objectArray3);
        objectArray[0] = objectArray2;
        Object[] objectArray6 = new Object[2];
        Object[][][] objectArray7 = new Object[3][][];
        Object[][] objectArrayArray3 = new Object[2][];
        Object[] objectArray8 = new Object[1];
        this.showGeomMeanLinesCheckbox = new Checkbox(this, "Show geometric mean lines", this.showGeomMeanLines){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean action(Event e, Object what) {
                this.this$0.showGeomMeanLines = this.getState();
                if (!this.this$0.useArithmeticMeans) {
                    this.this$0.showMinorGridLinesCheckbox.setEnabled(this.this$0.showGeomMeanLines);
                    this.this$0.minorGridScrollbar.setEnabled(this.this$0.showGeomMeanLines);
                }
                this.this$0.showMinorGridLinesCheckbox.setEnabled(this.this$0.useArithmeticMeans ? this.this$0.showArithMeanLines : this.this$0.showGeomMeanLines);
                this.this$0.canvas.repaint();
                return true;
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        objectArray8[0] = this.showGeomMeanLinesCheckbox;
        objectArrayArray3[0] = objectArray8;
        objectArrayArray3[1] = new Object[]{this.gGridScrollbar, this.horizontalStretchConstraints};
        objectArray7[0] = objectArrayArray3;
        Object[][] objectArrayArray4 = new Object[2][];
        Object[] objectArray9 = new Object[1];
        this.showArithMeanLinesCheckbox = new Checkbox(this, "Show arithmetic mean lines", this.showArithMeanLines){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean action(Event e, Object what) {
                this.this$0.showArithMeanLines = this.getState();
                if (this.this$0.useArithmeticMeans) {
                    this.this$0.showMinorGridLinesCheckbox.setEnabled(this.this$0.showArithMeanLines);
                    this.this$0.minorGridScrollbar.setEnabled(this.this$0.showArithMeanLines);
                }
                this.this$0.canvas.repaint();
                return true;
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        objectArray9[0] = this.showArithMeanLinesCheckbox;
        objectArrayArray4[0] = objectArray9;
        objectArrayArray4[1] = new Object[]{this.aGridScrollbar, this.horizontalStretchConstraints};
        objectArray7[1] = objectArrayArray4;
        Object[][] objectArrayArray5 = new Object[2][];
        Object[] objectArray10 = new Object[1];
        this.showMinorGridLinesCheckbox = new Checkbox(this, "Show minor grid lines", this.showMinorGridLines){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean action(Event e, Object what) {
                this.this$0.showMinorGridLines = this.getState();
                this.this$0.canvas.repaint();
                return true;
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        objectArray10[0] = this.showMinorGridLinesCheckbox;
        objectArrayArray5[0] = objectArray10;
        objectArrayArray5[1] = new Object[]{this.minorGridScrollbar, this.horizontalStretchConstraints};
        objectArray7[2] = objectArrayArray5;
        objectArray6[0] = new MyPanel("Grids:", "   ", objectArray7, this.horizontalStretchConstraints);
        objectArray6[1] = this.horizontalStretchConstraints;
        objectArray[1] = objectArray6;
        Object[] objectArray11 = new Object[1];
        Object[][][] objectArray12 = new Object[1][][];
        Object[][] objectArrayArray6 = new Object[4][];
        Object[] objectArray13 = new Object[1];
        boolean bl2 = false;
        if (this.maxAssetsToDraw == 2) {
            bl2 = true;
        }
        objectArray13[0] = new Checkbox(this, "2 assets", maxPortfolioCBG, bl2){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean action(Event e, Object what) {
                this.this$0.maxAssetsToDraw = 2;
                this.this$0.canvas.repaint();
                return true;
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        objectArrayArray6[0] = objectArray13;
        Object[] objectArray14 = new Object[1];
        boolean bl3 = false;
        if (this.maxAssetsToDraw == 3) {
            bl3 = true;
        }
        objectArray14[0] = new Checkbox(this, "3 assets", maxPortfolioCBG, bl3){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean action(Event e, Object what) {
                this.this$0.maxAssetsToDraw = 3;
                this.this$0.canvas.repaint();
                return true;
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        objectArrayArray6[1] = objectArray14;
        Object[] objectArray15 = new Object[1];
        boolean bl4 = false;
        if (this.maxAssetsToDraw == 4) {
            bl4 = true;
        }
        objectArray15[0] = new Checkbox(this, "4 assets", maxPortfolioCBG, bl4){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean action(Event e, Object what) {
                this.this$0.maxAssetsToDraw = 4;
                this.this$0.canvas.repaint();
                return true;
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        objectArrayArray6[2] = objectArray15;
        Object[] objectArray16 = new Object[1];
        boolean bl5 = false;
        if (this.maxAssetsToDraw == 5) {
            bl5 = true;
        }
        objectArray16[0] = new Checkbox(this, "5 assets", maxPortfolioCBG, bl5){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean action(Event e, Object what) {
                this.this$0.maxAssetsToDraw = 5;
                this.this$0.canvas.repaint();
                return true;
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        objectArrayArray6[3] = objectArray16;
        objectArray12[0] = objectArrayArray6;
        objectArray11[0] = new MyPanel("Show portfolios of up to:", "   ", objectArray12);
        objectArray[2] = objectArray11;
        Object[] objectArray17 = new Object[1];
        Object[][][] objectArray18 = new Object[3][][];
        Object[][] objectArrayArray7 = new Object[1][];
        Object[] objectArray19 = new Object[1];
        boolean bl6 = false;
        if (this.combineMethod == 0) {
            bl6 = true;
        }
        objectArray19[0] = new Checkbox(this, "High Speed", combineMethodCBG, bl6){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean action(Event e, Object what) {
                this.this$0.combineMethod = 0;
                this.this$0.canvas.repaint();
                boolean bl = this.this$0.VmatrixPanel.isVisible();
                boolean bl2 = false;
                if (this.this$0.showMatrixPanel && this.this$0.combineMethod == 2) {
                    bl2 = true;
                }
                if (bl != bl2) {
                    this.this$0.VmatrixPanel.setMatrix(cachedV, cachedWhichColumnsOfVAreImaginary);
                    MatrixPanel matrixPanel = this.this$0.VmatrixPanel;
                    boolean bl3 = false;
                    if (this.this$0.showMatrixPanel && this.this$0.combineMethod == 2) {
                        bl3 = true;
                    }
                    matrixPanel.setVisible(bl3);
                    this.this$0.controlPanelFrame.pack();
                }
                return true;
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        objectArrayArray7[0] = objectArray19;
        objectArray18[0] = objectArrayArray7;
        Object[][] objectArrayArray8 = new Object[1][];
        Object[] objectArray20 = new Object[1];
        boolean bl7 = false;
        if (this.combineMethod == 1) {
            bl7 = true;
        }
        objectArray20[0] = new Checkbox(this, "High Quality", combineMethodCBG, bl7){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean action(Event e, Object what) {
                this.this$0.combineMethod = 1;
                this.this$0.canvas.repaint();
                boolean bl = this.this$0.VmatrixPanel.isVisible();
                boolean bl2 = false;
                if (this.this$0.showMatrixPanel && this.this$0.combineMethod == 2) {
                    bl2 = true;
                }
                if (bl != bl2) {
                    this.this$0.VmatrixPanel.setMatrix(cachedV, cachedWhichColumnsOfVAreImaginary);
                    MatrixPanel matrixPanel = this.this$0.VmatrixPanel;
                    boolean bl3 = false;
                    if (this.this$0.showMatrixPanel && this.this$0.combineMethod == 2) {
                        bl3 = true;
                    }
                    matrixPanel.setVisible(bl3);
                    this.this$0.controlPanelFrame.pack();
                }
                return true;
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        objectArrayArray8[0] = objectArray20;
        objectArray18[1] = objectArrayArray8;
        Object[][] objectArrayArray9 = new Object[1][];
        Object[] objectArray21 = new Object[1];
        boolean bl8 = false;
        if (this.combineMethod == 2) {
            bl8 = true;
        }
        objectArray21[0] = new Checkbox(this, "Really Excellent Quality And Fast Too (but not quite right :-( )", combineMethodCBG, bl8){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean action(Event e, Object what) {
                this.this$0.combineMethod = 2;
                this.this$0.canvas.repaint();
                boolean bl = this.this$0.VmatrixPanel.isVisible();
                boolean bl2 = false;
                if (this.this$0.showMatrixPanel && this.this$0.combineMethod == 2) {
                    bl2 = true;
                }
                if (bl != bl2) {
                    this.this$0.VmatrixPanel.setMatrix(cachedV, cachedWhichColumnsOfVAreImaginary);
                    MatrixPanel matrixPanel = this.this$0.VmatrixPanel;
                    boolean bl3 = false;
                    if (this.this$0.showMatrixPanel && this.this$0.combineMethod == 2) {
                        bl3 = true;
                    }
                    matrixPanel.setVisible(bl3);
                    this.this$0.controlPanelFrame.pack();
                }
                return true;
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        objectArrayArray9[0] = objectArray21;
        objectArray18[2] = objectArrayArray9;
        objectArray17[0] = new MyPanel("Calculation method for 3 or more assets:", "   ", objectArray18);
        objectArray[3] = objectArray17;
        objectArray[4] = new Object[]{new MyPanel("Correlations: ", new Object[][][]{{{this.rhosStatusCanvas}, {this.rhosStatusLabel}}})};
        Object[] objectArray22 = new Object[2];
        Object[][] objectArray23 = new Object[6][];
        Object[] objectArray24 = new Object[1];
        boolean bl9 = false;
        if (this.impossibleCorrelationsStrategy == 0) {
            bl9 = true;
        }
        objectArray24[0] = new Checkbox(this, "Allow impossible correlations", impossibleCorrelationsCBG, bl9){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean action(Event e, Object what) {
                this.this$0.impossibleCorrelationsStrategy = 0;
                System.out.println("impossibleCorrelationsStrategy -> IMPOSSIBLE_ALLOW");
                if (this.this$0.possibleStatus == -1) {
                    this.this$0.rhoPanel.update();
                }
                this.this$0.canvas.repaint();
                return true;
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        objectArray23[0] = objectArray24;
        Object[] objectArray25 = new Object[1];
        boolean bl10 = false;
        if (this.impossibleCorrelationsStrategy == 1) {
            bl10 = true;
        }
        objectArray25[0] = new Checkbox(this, "Approximate impossible correlations", impossibleCorrelationsCBG, bl10){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean action(Event e, Object what) {
                this.this$0.impossibleCorrelationsStrategy = 1;
                System.out.println("impossibleCorrelationsStrategy -> IMPOSSIBLE_FIX");
                if (this.this$0.possibleStatus == -1) {
                    this.this$0.rhoPanel.update();
                }
                this.this$0.canvas.repaint();
                return true;
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        objectArray23[1] = objectArray25;
        Object[] objectArray26 = new Object[1];
        boolean bl11 = false;
        if (this.impossibleCorrelationsStrategy == 2) {
            bl11 = true;
        }
        objectArray26[0] = new Checkbox(this, "Disallow impossible correlations", impossibleCorrelationsCBG, bl11){
            final /* synthetic */ EfficientFrontierApplet this$0;

            public final boolean action(Event e, Object what) {
                if (this.this$0.possibleStatus == -1) {
                    RhoPanel.beep();
                    System.err.println("Can't change impossibleCorrelationsStrategy to IMPOSSIBLE_DISALLOW while impossible, sorry");
                    this.getCheckboxGroup().setCurrent((Checkbox)this.getParent().getComponent(this.getParent().getComponentCount() - 1 - 2 - 3 + this.this$0.impossibleCorrelationsStrategy));
                } else {
                    this.this$0.impossibleCorrelationsStrategy = 2;
                    System.out.println("impossibleCorrelationsStrategy -> IMPOSSIBLE_DISALLOW");
                }
                this.this$0.canvas.repaint();
                return true;
            }
            {
                this.this$0 = efficientFrontierApplet;
            }
        };
        objectArray23[2] = objectArray26;
        objectArray23[3] = new Object[]{this.matrixPanel};
        objectArray23[4] = new Object[]{this.VmatrixPanel};
        objectArray23[5] = new Object[]{this.rhoPanelHolder, this.horizontalStretchConstraints};
        objectArray22[0] = new MyPanel("   ", new Col(objectArray23), this.horizontalStretchConstraints);
        objectArray22[1] = this.horizontalStretchConstraints;
        objectArray[5] = objectArray22;
        this.controlPanelFrame.add((Component)new Col(objectArray), this.horizontalStretchConstraints);
        this.controlPanelFrame.pack();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class MatrixPanel
    extends Panel {
        double[][] matrix;
        boolean[] whichColumnsAreImaginary;
        TextField[][][] textfields;

        public boolean setMatrix(double[][] newMatrix, boolean[] newWhichColumnsAreImaginary) {
            boolean sizeChanged;
            boolean matrixChanged;
            block18: {
                block17: {
                    matrixChanged = false;
                    sizeChanged = false;
                    boolean bl = false;
                    if (newMatrix == null) {
                        bl = true;
                    }
                    boolean bl2 = false;
                    if (this.matrix == null) {
                        bl2 = true;
                    }
                    if (bl == bl2 && (newMatrix == null || newMatrix.length == this.matrix.length) && (newMatrix == null || newMatrix.length <= 0 || newMatrix[0].length == this.matrix[0].length)) break block17;
                    if (newMatrix == null) {
                        this.textfields = new TextField[0][][];
                    } else {
                        int n = newMatrix.length;
                        int n2 = 0;
                        if (newMatrix.length != 0) {
                            n2 = newMatrix[0].length;
                        }
                        this.textfields = new TextField[n][n2][1];
                        int i = 0;
                        while (i < newMatrix.length) {
                            int j = 0;
                            while (j < newMatrix[i].length) {
                                this.textfields[i][j][0] = new TextField(newMatrix[i][j] + (newWhichColumnsAreImaginary != null && newWhichColumnsAreImaginary[j] ? "i" : ""), 5);
                                this.textfields[i][j][0].setEditable(false);
                                ++j;
                            }
                            ++i;
                        }
                    }
                    this.remove(0);
                    this.add(new MyPanel(this.textfields));
                    matrixChanged = true;
                    sizeChanged = true;
                    break block18;
                }
                if (newMatrix == null) break block18;
                int i = 0;
                while (i < newMatrix.length) {
                    int j = 0;
                    while (j < newMatrix[i].length) {
                        block20: {
                            block19: {
                                if (newMatrix[i][j] != this.matrix[i][j]) break block19;
                                boolean bl = false;
                                if (newWhichColumnsAreImaginary == null) {
                                    bl = true;
                                }
                                boolean bl3 = false;
                                if (this.whichColumnsAreImaginary == null) {
                                    bl3 = true;
                                }
                                if (bl == bl3 && (newWhichColumnsAreImaginary == null || newWhichColumnsAreImaginary[j] == this.whichColumnsAreImaginary[j])) break block20;
                            }
                            String text = "" + newMatrix[i][j];
                            if (this.whichColumnsAreImaginary != null && this.whichColumnsAreImaginary[j]) {
                                this.textfields[i][j][0].setForeground(Color.red);
                                text = text + 'i';
                            } else {
                                this.textfields[i][j][0].setForeground(Color.black);
                            }
                            this.textfields[i][j][0].setText(text);
                            matrixChanged = true;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (matrixChanged) {
                this.matrix = VecMath.copymat(newMatrix);
                this.whichColumnsAreImaginary = newWhichColumnsAreImaginary == null ? null : VecMath.copyvec(newWhichColumnsAreImaginary);
            }
            return sizeChanged;
        }

        private final /* synthetic */ void this() {
            this.matrix = null;
            this.whichColumnsAreImaginary = null;
            this.textfields = null;
        }

        public MatrixPanel() {
            this.this();
            this.setLayout(new GridBagLayout());
            this.add(new MyPanel(new Object[0][][]));
        }
    }

    private class EfficientFrontierAppletCanvas
    extends Canvas
    implements MouseListener,
    MouseMotionListener,
    KeyListener {
        public void mousePressed(MouseEvent e) {
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("in mousePressed: " + e);
            }
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                if (EfficientFrontierApplet.getButton(e) == 1) {
                    System.out.println("    (left mouse)");
                }
                if (EfficientFrontierApplet.getButton(e) == 2) {
                    System.out.println("    (middle mouse)");
                }
                if (EfficientFrontierApplet.getButton(e) == 3) {
                    System.out.println("    (right mouse)");
                }
            }
            double[] thisP = new double[2];
            EfficientFrontierApplet.this.mostRecentGraphics.pick(e.getX(), e.getY(), thisP);
            int whichButton = EfficientFrontierApplet.getButton(e);
            if (whichButton == 1) {
                EfficientFrontierApplet.this.button1IsDown = true;
                EfficientFrontierApplet.this.selectedPointIndex = EfficientFrontierApplet.findClosestVertIndex(thisP, EfficientFrontierApplet.this.drawnAssets, EfficientFrontierApplet.this.drawnAssets.length, EfficientFrontierApplet.this.pickRadius);
            } else if (whichButton == 2) {
                EfficientFrontierApplet.this.button2IsDown = true;
                int newInd = EfficientFrontierApplet.this.assets.length;
                double[][] newAssets = new double[EfficientFrontierApplet.this.assets.length + 1][];
                String[] newAssetNames = new String[EfficientFrontierApplet.this.assets.length + 1];
                double[][] newDrawnAssets = new double[EfficientFrontierApplet.this.assets.length + 1][];
                int i = 0;
                while (i < newInd) {
                    newAssets[i] = EfficientFrontierApplet.this.assets[i];
                    newAssetNames[i] = EfficientFrontierApplet.this.assetNames[i];
                    newDrawnAssets[i] = EfficientFrontierApplet.this.drawnAssets[i];
                    ++i;
                }
                newAssets[newInd] = new double[]{Math.exp(thisP[1] * EfficientFrontierApplet.this.logMaxMean), Math.exp(thisP[0] * EfficientFrontierApplet.this.logMaxStdDev)};
                if (EfficientFrontierApplet.this.useArithmeticMeans) {
                    newAssets[newInd][0] = EfficientFrontierApplet.findGMeanFromAMeanAndStdDev(newAssets[newInd][0], newAssets[newInd][1]);
                }
                newAssetNames[newInd] = EfficientFrontierApplet.findUnusedAssetName(EfficientFrontierApplet.this.assetNames);
                newDrawnAssets[newInd] = thisP;
                i = newInd;
                while (i < EfficientFrontierApplet.this.assets.length) {
                    newAssets[i + 1] = EfficientFrontierApplet.this.assets[i];
                    newAssetNames[i + 1] = EfficientFrontierApplet.this.assetNames[i];
                    newDrawnAssets[i + 1] = EfficientFrontierApplet.this.drawnAssets[i];
                    ++i;
                }
                EfficientFrontierApplet.this.assets = newAssets;
                EfficientFrontierApplet.this.assetNames = newAssetNames;
                EfficientFrontierApplet.this.drawnAssets = newDrawnAssets;
                EfficientFrontierApplet.this.allRhos = VecMath.insertIdentityRowAndColumn(EfficientFrontierApplet.this.allRhos, newInd, 0.0, 1.0);
                EfficientFrontierApplet.this.selectedPointIndex = newInd;
                int[] indices = new int[EfficientFrontierApplet.this.assetNames.length];
                int i2 = 0;
                while (i2 < EfficientFrontierApplet.this.assetNames.length) {
                    indices[i2] = i2;
                    ++i2;
                }
                SortStuff.sort(indices, new SortStuff.IntComparator(this){
                    final /* synthetic */ EfficientFrontierAppletCanvas this$0;

                    public final int compare(int i, int j) {
                        return this.this$0.EfficientFrontierApplet.this.assetNames[i].compareTo(this.this$0.EfficientFrontierApplet.this.assetNames[j]);
                    }
                    {
                        this.this$0 = efficientFrontierAppletCanvas;
                    }
                });
                int n = EfficientFrontierApplet.this.assets.length;
                newAssetNames = new String[n];
                double[][] newAssets2 = new double[n][];
                double[][] newDrawnAssets2 = new double[n][];
                double[][] newAllRhos = new double[n][n];
                int newSelectedPointIndex = -1;
                int i3 = 0;
                while (i3 < n) {
                    int oldPosition = indices[i3];
                    newAssetNames[i3] = EfficientFrontierApplet.this.assetNames[oldPosition];
                    newAssets2[i3] = EfficientFrontierApplet.this.assets[oldPosition];
                    newDrawnAssets2[i3] = EfficientFrontierApplet.this.drawnAssets[oldPosition];
                    int j = 0;
                    while (j < n) {
                        newAllRhos[i3][j] = EfficientFrontierApplet.this.allRhos[oldPosition][indices[j]];
                        ++j;
                    }
                    if (EfficientFrontierApplet.this.selectedPointIndex == oldPosition) {
                        newSelectedPointIndex = i3;
                    }
                    ++i3;
                }
                EfficientFrontierApplet.this.assetNames = newAssetNames;
                EfficientFrontierApplet.this.assets = newAssets2;
                EfficientFrontierApplet.this.drawnAssets = newDrawnAssets2;
                EfficientFrontierApplet.this.allRhos = newAllRhos;
                EfficientFrontierApplet.this.selectedPointIndex = newSelectedPointIndex;
                EfficientFrontierApplet.this.rhoPanel = new MyRhoPanel();
                EfficientFrontierApplet.this.rhoPanelHolder.add(EfficientFrontierApplet.this.rhoPanel, EfficientFrontierApplet.this.horizontalStretchConstraints, 1);
                EfficientFrontierApplet.this.rhoPanelHolder.remove(0);
                if (EfficientFrontierApplet.this.matrixPanel.isVisible()) {
                    EfficientFrontierApplet.this.matrixPanel.setMatrix(EfficientFrontierApplet.this.allRhos, null);
                }
                EfficientFrontierApplet.this.controlPanelFrame.pack();
                EfficientFrontierApplet.this.rhoPanel.verifyNewRhos(EfficientFrontierApplet.this.everyRho, EfficientFrontierApplet.this.allRhos);
            } else if (whichButton == 3) {
                EfficientFrontierApplet.this.button3IsDown = true;
                int bestI = EfficientFrontierApplet.findClosestVertIndex(thisP, EfficientFrontierApplet.this.drawnAssets, EfficientFrontierApplet.this.drawnAssets.length, Double.POSITIVE_INFINITY);
                if (bestI != -1) {
                    double[][] newAssets = new double[EfficientFrontierApplet.this.assets.length - 1][];
                    String[] newAssetNames = new String[EfficientFrontierApplet.this.assets.length - 1];
                    double[][] newDrawnAssets = new double[EfficientFrontierApplet.this.assets.length - 1][];
                    int n = newAssets.length;
                    int i = 0;
                    while (i < n) {
                        newAssets[i] = EfficientFrontierApplet.this.assets[i >= bestI ? i + 1 : i];
                        newAssetNames[i] = EfficientFrontierApplet.this.assetNames[i >= bestI ? i + 1 : i];
                        newDrawnAssets[i] = EfficientFrontierApplet.this.drawnAssets[i >= bestI ? i + 1 : i];
                        ++i;
                    }
                    EfficientFrontierApplet.this.assets = newAssets;
                    EfficientFrontierApplet.this.assetNames = newAssetNames;
                    EfficientFrontierApplet.this.drawnAssets = newDrawnAssets;
                    EfficientFrontierApplet.this.allRhos = VecMath.deleteRowAndColumn(EfficientFrontierApplet.this.allRhos, bestI);
                    EfficientFrontierApplet.this.rhoPanel = new MyRhoPanel();
                    EfficientFrontierApplet.this.rhoPanelHolder.add(EfficientFrontierApplet.this.rhoPanel, EfficientFrontierApplet.this.horizontalStretchConstraints, 0);
                    EfficientFrontierApplet.this.rhoPanelHolder.remove(1);
                    if (EfficientFrontierApplet.this.matrixPanel.isVisible()) {
                        EfficientFrontierApplet.this.matrixPanel.setMatrix(EfficientFrontierApplet.this.allRhos, null);
                    }
                    EfficientFrontierApplet.this.controlPanelFrame.pack();
                    EfficientFrontierApplet.this.rhoPanel.verifyNewRhos(EfficientFrontierApplet.this.everyRho, EfficientFrontierApplet.this.allRhos);
                }
                EfficientFrontierApplet.this.selectedPointIndex = -1;
            }
            EfficientFrontierApplet.this.prevP = thisP;
            this.repaint();
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("out mousePressed: " + e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("in mouseReleased: " + e);
            }
            double[] thisP = new double[2];
            EfficientFrontierApplet.this.mostRecentGraphics.pick(e.getX(), e.getY(), thisP);
            int whichButton = EfficientFrontierApplet.getButton(e);
            if (whichButton == 1) {
                EfficientFrontierApplet.this.button1IsDown = false;
                this.repaint();
            } else if (whichButton == 2) {
                EfficientFrontierApplet.this.button2IsDown = false;
                this.repaint();
            } else if (whichButton == 3) {
                EfficientFrontierApplet.this.button3IsDown = false;
                this.repaint();
            }
            EfficientFrontierApplet.this.button3IsDown = false;
            EfficientFrontierApplet.this.button2IsDown = false;
            EfficientFrontierApplet.this.button1IsDown = false;
            EfficientFrontierApplet.this.prevP = thisP;
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("out mouseReleased: " + e);
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("in mouseEntered: " + e);
            }
            this.requestFocus();
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("out mouseEntered: " + e);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("in mouseExited: " + e);
            }
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("out mouseExited: " + e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("in mouseClicked: " + e);
            }
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("out mouseClicked: " + e);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (EfficientFrontierApplet.this.eventVerbose >= 2) {
                System.out.println("  in mouseDragged: " + e);
            }
            double[] thisP = new double[2];
            EfficientFrontierApplet.this.mostRecentGraphics.pick(e.getX(), e.getY(), thisP);
            if (EfficientFrontierApplet.this.button1IsDown || EfficientFrontierApplet.this.button2IsDown) {
                double[] delta = VecMath.vmv(thisP, EfficientFrontierApplet.this.prevP);
                if (EfficientFrontierApplet.this.selectedPointIndex != -1) {
                    VecMath.vpv(EfficientFrontierApplet.this.drawnAssets[EfficientFrontierApplet.this.selectedPointIndex], EfficientFrontierApplet.this.drawnAssets[EfficientFrontierApplet.this.selectedPointIndex], delta);
                    EfficientFrontierApplet.this.assets[EfficientFrontierApplet.this.selectedPointIndex][0] = Math.exp(EfficientFrontierApplet.this.drawnAssets[EfficientFrontierApplet.this.selectedPointIndex][1] * EfficientFrontierApplet.this.logMaxMean);
                    EfficientFrontierApplet.this.assets[EfficientFrontierApplet.this.selectedPointIndex][1] = Math.exp(EfficientFrontierApplet.this.drawnAssets[EfficientFrontierApplet.this.selectedPointIndex][0] * EfficientFrontierApplet.this.logMaxStdDev);
                    if (EfficientFrontierApplet.this.useArithmeticMeans) {
                        EfficientFrontierApplet.this.assets[EfficientFrontierApplet.this.selectedPointIndex][0] = EfficientFrontierApplet.findGMeanFromAMeanAndStdDev(EfficientFrontierApplet.this.assets[EfficientFrontierApplet.this.selectedPointIndex][0], EfficientFrontierApplet.this.assets[EfficientFrontierApplet.this.selectedPointIndex][1]);
                    }
                }
            }
            boolean cfr_ignored_0 = EfficientFrontierApplet.this.button3IsDown;
            EfficientFrontierApplet.this.prevP = thisP;
            this.repaint();
            if (EfficientFrontierApplet.this.eventVerbose >= 2) {
                System.out.println("  out mouseDragged: " + e);
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (EfficientFrontierApplet.this.eventVerbose >= 3) {
                System.out.println("    in mouseMoved: " + e);
            }
            if (EfficientFrontierApplet.this.eventVerbose >= 3) {
                System.out.println("    out mouseMoved: " + e);
            }
        }

        public void keyPressed(KeyEvent e) {
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("in keyPressed: " + e);
            }
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("out keyPressed: " + e);
            }
        }

        public void keyReleased(KeyEvent e) {
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("in keyReleased: " + e);
            }
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("out keyReleased: " + e);
            }
        }

        public void keyTyped(KeyEvent e) {
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("in keyTyped: " + e);
            }
            switch (e.getKeyChar()) {
                case 'V': {
                    System.out.print("eventVerbose " + EfficientFrontierApplet.this.eventVerbose);
                    EfficientFrontierApplet.this.eventVerbose = (EfficientFrontierApplet.this.eventVerbose + 1) % 4;
                    System.out.println(" -> " + EfficientFrontierApplet.this.eventVerbose);
                    break;
                }
                case 'T': {
                    System.out.print("timeVerbose " + EfficientFrontierApplet.this.timeVerbose);
                    EfficientFrontierApplet.this.timeVerbose = (EfficientFrontierApplet.this.timeVerbose + 1) % 2;
                    System.out.println(" -> " + EfficientFrontierApplet.this.timeVerbose);
                    break;
                }
                case 'M': {
                    EfficientFrontierApplet.this.showMatrixPanel ^= true;
                    System.out.println("showMatrixPanel -> " + EfficientFrontierApplet.this.showMatrixPanel);
                    EfficientFrontierApplet.this.matrixPanel.setMatrix(EfficientFrontierApplet.this.allRhos, null);
                    EfficientFrontierApplet.this.matrixPanel.setVisible(EfficientFrontierApplet.this.showMatrixPanel);
                    EfficientFrontierApplet.this.VmatrixPanel.setMatrix(cachedV, cachedWhichColumnsOfVAreImaginary);
                    MatrixPanel matrixPanel = EfficientFrontierApplet.this.VmatrixPanel;
                    boolean bl = false;
                    if (EfficientFrontierApplet.this.showMatrixPanel && EfficientFrontierApplet.this.combineMethod == 2) {
                        bl = true;
                    }
                    matrixPanel.setVisible(bl);
                    EfficientFrontierApplet.this.controlPanelFrame.pack();
                    break;
                }
                case ' ': {
                    this.repaint();
                    break;
                }
                case 'b': {
                    EfficientFrontierApplet.this.doDoubleBuffer ^= true;
                    System.out.println("doDoubleBuffer -> " + EfficientFrontierApplet.this.doDoubleBuffer);
                    this.repaint();
                    break;
                }
                case 'c': {
                    if (EfficientFrontierApplet.this.controlPanelFrame.isVisible()) {
                        EfficientFrontierApplet.this.controlPanelFrame.hide();
                        break;
                    }
                    EfficientFrontierApplet.this.controlPanelFrame.show();
                    break;
                }
                case 'g': {
                    EfficientFrontierApplet.this.showGeomMeanLines ^= true;
                    System.out.println("showGeomMeanLines -> " + EfficientFrontierApplet.this.showGeomMeanLines);
                    EfficientFrontierApplet.this.showGeomMeanLinesCheckbox.setState(EfficientFrontierApplet.this.showGeomMeanLines);
                    if (!EfficientFrontierApplet.this.useArithmeticMeans) {
                        EfficientFrontierApplet.this.showMinorGridLinesCheckbox.setEnabled(EfficientFrontierApplet.this.showGeomMeanLines);
                        EfficientFrontierApplet.this.minorGridScrollbar.setEnabled(EfficientFrontierApplet.this.showGeomMeanLines);
                    }
                    this.repaint();
                    break;
                }
                case 'a': {
                    EfficientFrontierApplet.this.showArithMeanLines ^= true;
                    System.out.println("showArithMeanLines -> " + EfficientFrontierApplet.this.showArithMeanLines);
                    EfficientFrontierApplet.this.showArithMeanLinesCheckbox.setState(EfficientFrontierApplet.this.showArithMeanLines);
                    if (EfficientFrontierApplet.this.useArithmeticMeans) {
                        EfficientFrontierApplet.this.showMinorGridLinesCheckbox.setEnabled(EfficientFrontierApplet.this.showArithMeanLines);
                        EfficientFrontierApplet.this.minorGridScrollbar.setEnabled(EfficientFrontierApplet.this.showArithMeanLines);
                    }
                    this.repaint();
                    break;
                }
                case 'm': {
                    EfficientFrontierApplet.this.showMinorGridLines ^= true;
                    System.out.println("showMinorGridLines -> " + EfficientFrontierApplet.this.showMinorGridLines);
                    EfficientFrontierApplet.this.showMinorGridLinesCheckbox.setState(EfficientFrontierApplet.this.showMinorGridLines);
                    this.repaint();
                    break;
                }
                case 'A': {
                    EfficientFrontierApplet.this.useArithmeticMeans = true;
                    EfficientFrontierApplet.this.useArithMeanCheckbox.setState(true);
                    System.out.println("useArithmeticMeans -> " + EfficientFrontierApplet.this.useArithmeticMeans);
                    EfficientFrontierApplet.this.controlPanelFrame.pack();
                    EfficientFrontierApplet.this.verticalAxisLabelImage = null;
                    this.repaint();
                    break;
                }
                case 'G': {
                    EfficientFrontierApplet.this.useArithmeticMeans = false;
                    EfficientFrontierApplet.this.useGeomMeanCheckbox.setState(true);
                    System.out.println("useArithmeticMeans -> " + EfficientFrontierApplet.this.useArithmeticMeans);
                    EfficientFrontierApplet.this.controlPanelFrame.pack();
                    EfficientFrontierApplet.this.verticalAxisLabelImage = null;
                    this.repaint();
                    break;
                }
                default: {
                    System.out.println("Unknown key '" + e.getKeyChar() + "' typed");
                    break;
                }
            }
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("out keyTyped: " + e);
            }
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics frontBufferGraphics) {
            int i;
            int n;
            MyGraphics mg;
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("in paint");
            }
            long startTimeMillis = System.currentTimeMillis();
            this.makeSureBackBufferIsRight();
            Graphics g = EfficientFrontierApplet.this.doDoubleBuffer ? EfficientFrontierApplet.this.backBufferImage.getGraphics() : frontBufferGraphics;
            EfficientFrontierApplet.this.mostRecentGraphics = mg = new MyGraphics(g, this.getSize(), -0.25, 1.1, -1.1, 1.1);
            mg.setColor(Color.black);
            mg.fillWindow();
            double[] yellow = new double[]{0.75, 0.75, 0.5};
            double[] green = new double[]{0.5, 1.0, 0.5};
            if (EfficientFrontierApplet.this.useArithmeticMeans ? EfficientFrontierApplet.this.showArithMeanLines : EfficientFrontierApplet.this.showGeomMeanLines) {
                double lightGrayLevel = EfficientFrontierApplet.this.useArithmeticMeans ? EfficientFrontierApplet.this.aGridContrast : EfficientFrontierApplet.this.gGridContrast;
                double darkGrayLevel = EfficientFrontierApplet.this.minorGridContrast;
                lightGrayLevel = darkGrayLevel >= lightGrayLevel ? darkGrayLevel : lightGrayLevel;
                double[] color = EfficientFrontierApplet.this.useArithmeticMeans ? yellow : green;
                Color darkGray = new Color((int)(darkGrayLevel * color[0] * 255.5), (int)(darkGrayLevel * color[1] * 255.5), (int)(darkGrayLevel * color[2] * 255.5));
                Color lightGray = new Color((int)(lightGrayLevel * color[0] * 255.5), (int)(lightGrayLevel * color[1] * 255.5), (int)(lightGrayLevel * color[2] * 255.5));
                mg.setColor(darkGray);
                int minorOrMajor = 0;
                while (minorOrMajor < 2) {
                    if (minorOrMajor != 0 || EfficientFrontierApplet.this.showMinorGridLines) {
                        double frac;
                        double val;
                        int p;
                        n = EfficientFrontierApplet.this.nMeanIntervals * 5;
                        i = 0;
                        while (i < n + 1) {
                            boolean bl = false;
                            if (i % 5 == 0) {
                                bl = true;
                            }
                            boolean bl2 = false;
                            if (minorOrMajor == 1) {
                                bl2 = true;
                            }
                            if (bl == bl2 && 2 * i != n) {
                                p = (int)Math.round((EfficientFrontierApplet.this.minMean - 1.0) * 100.0 + (double)i / (double)n * ((EfficientFrontierApplet.this.maxMean - 1.0) * 100.0 - (EfficientFrontierApplet.this.minMean - 1.0) * 100.0));
                                val = 1.0 + (double)p * 0.01;
                                frac = Math.log(val / EfficientFrontierApplet.this.minMean) / Math.log(EfficientFrontierApplet.this.maxMean / EfficientFrontierApplet.this.minMean);
                                double y = -1.0 + frac * (double)2;
                                if (i % 5 == 0) {
                                    mg.setColor(lightGray);
                                }
                                mg.drawLine(0.0, y, 1.0, y);
                                if (i % 5 == 0) {
                                    mg.setColor(darkGray);
                                }
                            }
                            ++i;
                        }
                        n = EfficientFrontierApplet.this.nStdDevIntervals * 5;
                        i = 1;
                        while (i < n + 1) {
                            boolean bl = false;
                            if (i % 5 == 0) {
                                bl = true;
                            }
                            boolean bl3 = false;
                            if (minorOrMajor == 1) {
                                bl3 = true;
                            }
                            if (bl == bl3 && i != 0) {
                                p = (int)Math.round((EfficientFrontierApplet.this.minStdDev - 1.0) * 100.0 + (double)i / (double)n * ((EfficientFrontierApplet.this.maxStdDev - 1.0) * 100.0 - (EfficientFrontierApplet.this.minStdDev - 1.0) * 100.0));
                                val = 1.0 + (double)p * 0.01;
                                frac = Math.log(val / EfficientFrontierApplet.this.minStdDev) / Math.log(EfficientFrontierApplet.this.maxStdDev / EfficientFrontierApplet.this.minStdDev);
                                double x = 0.0 + frac;
                                if (i % 5 == 0) {
                                    mg.setColor(lightGray);
                                }
                                mg.drawLine(x, -1.0, x, 1.0);
                                if (i % 5 == 0) {
                                    mg.setColor(darkGray);
                                }
                            }
                            ++i;
                        }
                    }
                    ++minorOrMajor;
                }
            }
            if (EfficientFrontierApplet.this.useArithmeticMeans ? EfficientFrontierApplet.this.showGeomMeanLines : EfficientFrontierApplet.this.showArithMeanLines) {
                double grayLevel = EfficientFrontierApplet.this.aGridContrast;
                double[] color = EfficientFrontierApplet.this.useArithmeticMeans ? green : yellow;
                Color gray = new Color((int)(grayLevel * color[0] * 255.5), (int)(grayLevel * color[1] * 255.5), (int)(grayLevel * color[2] * 255.5));
                mg.setColor(gray);
                int nn = EfficientFrontierApplet.this.nMeanIntervals;
                int ii = 0;
                while (ii < nn + 1) {
                    double otherMean = 1.0 + 0.01 * (double)((int)Math.round((EfficientFrontierApplet.this.minMean - 1.0) * 100.0 + (double)(ii + 1) / (double)nn * ((EfficientFrontierApplet.this.maxMean - 1.0) * 100.0 - (EfficientFrontierApplet.this.minMean - 1.0) * 100.0)));
                    n = EfficientFrontierApplet.this.nStdDevIntervals * 5;
                    i = 0;
                    while (i < n) {
                        double y1val;
                        double y0val;
                        double x0val = 1.0 + 0.01 * (double)((int)Math.round((EfficientFrontierApplet.this.minStdDev - 1.0) * 100.0 + (double)i / (double)n * ((EfficientFrontierApplet.this.maxStdDev - 1.0) * 100.0 - (EfficientFrontierApplet.this.minStdDev - 1.0) * 100.0)));
                        double x1val = 1.0 + 0.01 * (double)((int)Math.round((EfficientFrontierApplet.this.minStdDev - 1.0) * 100.0 + (double)(i + 1) / (double)n * ((EfficientFrontierApplet.this.maxStdDev - 1.0) * 100.0 - (EfficientFrontierApplet.this.minStdDev - 1.0) * 100.0)));
                        if (EfficientFrontierApplet.this.useArithmeticMeans) {
                            y0val = EfficientFrontierApplet.findAMeanFromGMeanAndStdDev(otherMean, x0val);
                            y1val = EfficientFrontierApplet.findAMeanFromGMeanAndStdDev(otherMean, x1val);
                        } else {
                            y0val = EfficientFrontierApplet.findGMeanFromAMeanAndStdDev(otherMean, x0val);
                            y1val = EfficientFrontierApplet.findGMeanFromAMeanAndStdDev(otherMean, x1val);
                        }
                        if (y0val >= EfficientFrontierApplet.this.minMean && y1val <= EfficientFrontierApplet.this.maxMean) {
                            double x0 = Math.log(x0val) * EfficientFrontierApplet.this.invLogMaxStdDev;
                            double x1 = Math.log(x1val) * EfficientFrontierApplet.this.invLogMaxStdDev;
                            double y0 = Math.log(y0val) * EfficientFrontierApplet.this.invLogMaxMean;
                            double y1 = Math.log(y1val) * EfficientFrontierApplet.this.invLogMaxMean;
                            mg.drawLine(x0, y0, x1, y1);
                        }
                        ++i;
                    }
                    ++ii;
                }
            }
            mg.setColor(Color.white);
            mg.drawLine(0.0, -1.0, 0.0, 1.0);
            mg.drawLine(0.0, 0.0, 1.0, 0.0);
            int n2 = EfficientFrontierApplet.this.nMeanIntervals;
            int i2 = 0;
            while (i2 < n2 + 1) {
                int p = (int)Math.round((EfficientFrontierApplet.this.minMean - 1.0) * 100.0 + (double)i2 / (double)n2 * ((EfficientFrontierApplet.this.maxMean - 1.0) * 100.0 - (EfficientFrontierApplet.this.minMean - 1.0) * 100.0));
                double val = 1.0 + (double)p * 0.01;
                double frac = Math.log(val / EfficientFrontierApplet.this.minMean) / Math.log(EfficientFrontierApplet.this.maxMean / EfficientFrontierApplet.this.minMean);
                double x = -0.02;
                double y = -1.0 + frac * (double)2;
                mg.drawStringRightJustified("" + p + '%', x, y);
                mg.drawLine(0.0, y, 0.005, y);
                ++i2;
            }
            n2 = EfficientFrontierApplet.this.nStdDevIntervals;
            i2 = 1;
            while (i2 < n2 + 1) {
                int p = (int)Math.round((EfficientFrontierApplet.this.minStdDev - 1.0) * 100.0 + (double)i2 / (double)n2 * ((EfficientFrontierApplet.this.maxStdDev - 1.0) * 100.0 - (EfficientFrontierApplet.this.minStdDev - 1.0) * 100.0));
                double val = 1.0 + (double)p * 0.01;
                double frac = Math.log(val / EfficientFrontierApplet.this.minStdDev) / Math.log(EfficientFrontierApplet.this.maxStdDev / EfficientFrontierApplet.this.minStdDev);
                double x = 0.0 + frac;
                double y = -0.1;
                mg.drawStringCentered("" + p + '%', x, y);
                mg.drawLine(x, -0.02, x, 0.02);
                ++i2;
            }
            mg.drawString("Risk (Standard Deviation)", 0.5, -0.1 - mg.getFontHeight(), 0.0, -1.0);
            if (EfficientFrontierApplet.this.verticalAxisLabelImage == null) {
                EfficientFrontierApplet.this.verticalAxisLabelImage = EfficientFrontierApplet.makeVerticalStringImage((EfficientFrontierApplet.this.useArithmeticMeans ? "(Arithmetic)" : "(Geometric)") + " Mean Annualized Return", Color.black, Color.white, g, this);
            }
            if (EfficientFrontierApplet.this.verticalAxisLabelImage != null) {
                double[] xy = new double[2];
                mg.unpick(-0.02, 0.3, xy);
                double x = xy[0] - (double)g.getFontMetrics().stringWidth("-100%") - (double)EfficientFrontierApplet.this.verticalAxisLabelImage.getWidth(null);
                double y = xy[1] - 0.5 * (double)EfficientFrontierApplet.this.verticalAxisLabelImage.getHeight(null);
                g.drawImage(EfficientFrontierApplet.this.verticalAxisLabelImage, (int)Math.round(x), (int)Math.round(y), this);
            }
            EfficientFrontierApplet applet = EfficientFrontierApplet.this;
            if (EfficientFrontierApplet.this.maxAssetsToDraw >= 5) {
                mg.setColor(Color.yellow);
                double[] result = new double[2];
                int pi = 0;
                while (pi < EfficientFrontierApplet.this.assets.length) {
                    int pj = pi + 1;
                    while (pj < EfficientFrontierApplet.this.assets.length) {
                        int pk = pj + 1;
                        while (pk < EfficientFrontierApplet.this.assets.length) {
                            int pl = pk + 1;
                            while (pl < EfficientFrontierApplet.this.assets.length) {
                                int pm = pl + 1;
                                while (pm < EfficientFrontierApplet.this.assets.length) {
                                    double[] means = new double[]{EfficientFrontierApplet.this.assets[pi][0], EfficientFrontierApplet.this.assets[pj][0], EfficientFrontierApplet.this.assets[pk][0], EfficientFrontierApplet.this.assets[pl][0], EfficientFrontierApplet.this.assets[pm][0]};
                                    double[] stdDevs = new double[]{EfficientFrontierApplet.this.assets[pi][1], EfficientFrontierApplet.this.assets[pj][1], EfficientFrontierApplet.this.assets[pk][1], EfficientFrontierApplet.this.assets[pl][1], EfficientFrontierApplet.this.assets[pm][1]};
                                    double[][] rhos = VecMath.submat(EfficientFrontierApplet.this.allRhos, new int[]{pi, pj, pk, pl, pm});
                                    int n3 = 20;
                                    int i3 = 0;
                                    while (i3 < n3) {
                                        int j = 0;
                                        while (j < n3 - i3) {
                                            int k = 0;
                                            while (k < n3 - i3 - j) {
                                                int l = 0;
                                                while (l < n3 - i3 - j - k) {
                                                    int m = n3 - i3 - j - k - l;
                                                    if (i3 != 0 && j != 0 && k != 0 && l != 0 && m != 0) {
                                                        double[] weights = new double[]{(double)i3 / (double)n3, (double)j / (double)n3, (double)k / (double)n3, (double)l / (double)n3, (double)m / (double)n3};
                                                        EfficientFrontierApplet.combine_mean_stddev(result, weights, means, stdDevs, rhos, EfficientFrontierApplet.this.combineMethod, EfficientFrontierApplet.this.impossibleCorrelationsStrategy, EfficientFrontierApplet.this);
                                                        double mean = result[0];
                                                        double stdDev = result[1];
                                                        if (EfficientFrontierApplet.this.useArithmeticMeans) {
                                                            mean = EfficientFrontierApplet.findAMeanFromGMeanAndStdDev(mean, stdDev);
                                                        }
                                                        mg.drawPoint(Math.log(stdDev) * EfficientFrontierApplet.this.invLogMaxStdDev, Math.log(mean) * EfficientFrontierApplet.this.invLogMaxMean, 1);
                                                    }
                                                    ++l;
                                                }
                                                ++k;
                                            }
                                            ++j;
                                        }
                                        ++i3;
                                    }
                                    ++pm;
                                }
                                ++pl;
                            }
                            ++pk;
                        }
                        ++pj;
                    }
                    ++pi;
                }
            }
            if (EfficientFrontierApplet.this.maxAssetsToDraw >= 4) {
                mg.setColor(Color.green);
                double[] result = new double[2];
                int pi = 0;
                while (pi < EfficientFrontierApplet.this.assets.length) {
                    int pj = pi + 1;
                    while (pj < EfficientFrontierApplet.this.assets.length) {
                        int pk = pj + 1;
                        while (pk < EfficientFrontierApplet.this.assets.length) {
                            int pl = pk + 1;
                            while (pl < EfficientFrontierApplet.this.assets.length) {
                                double[] means = new double[]{EfficientFrontierApplet.this.assets[pi][0], EfficientFrontierApplet.this.assets[pj][0], EfficientFrontierApplet.this.assets[pk][0], EfficientFrontierApplet.this.assets[pl][0]};
                                double[] stdDevs = new double[]{EfficientFrontierApplet.this.assets[pi][1], EfficientFrontierApplet.this.assets[pj][1], EfficientFrontierApplet.this.assets[pk][1], EfficientFrontierApplet.this.assets[pl][1]};
                                double[][] rhos = VecMath.submat(EfficientFrontierApplet.this.allRhos, new int[]{pi, pj, pk, pl});
                                int n4 = 20;
                                int i4 = 0;
                                while (i4 < n4) {
                                    int j = 0;
                                    while (j < n4 - i4) {
                                        int k = 0;
                                        while (k < n4 - i4 - j) {
                                            int l = n4 - i4 - j - k;
                                            if (i4 != 0 && j != 0 && k != 0 && l != 0) {
                                                double[] weights = new double[]{(double)i4 / (double)n4, (double)j / (double)n4, (double)k / (double)n4, (double)l / (double)n4};
                                                EfficientFrontierApplet.combine_mean_stddev(result, weights, means, stdDevs, rhos, EfficientFrontierApplet.this.combineMethod, EfficientFrontierApplet.this.impossibleCorrelationsStrategy, EfficientFrontierApplet.this);
                                                double mean = result[0];
                                                double stdDev = result[1];
                                                if (EfficientFrontierApplet.this.useArithmeticMeans) {
                                                    mean = EfficientFrontierApplet.findAMeanFromGMeanAndStdDev(mean, stdDev);
                                                }
                                                mg.drawPoint(Math.log(stdDev) * EfficientFrontierApplet.this.invLogMaxStdDev, Math.log(mean) * EfficientFrontierApplet.this.invLogMaxMean, 1);
                                            }
                                            ++k;
                                        }
                                        ++j;
                                    }
                                    ++i4;
                                }
                                ++pl;
                            }
                            ++pk;
                        }
                        ++pj;
                    }
                    ++pi;
                }
            }
            if (EfficientFrontierApplet.this.maxAssetsToDraw >= 3) {
                mg.setColor(Color.blue);
                double[] result = new double[2];
                int pi = 0;
                while (pi < EfficientFrontierApplet.this.assets.length) {
                    int pj = pi + 1;
                    while (pj < EfficientFrontierApplet.this.assets.length) {
                        int pk = pj + 1;
                        while (pk < EfficientFrontierApplet.this.assets.length) {
                            int j;
                            int n5 = 20;
                            double[][][] values = new double[n5 + 1][n5 + 1][2];
                            double[] means = new double[]{EfficientFrontierApplet.this.assets[pi][0], EfficientFrontierApplet.this.assets[pj][0], EfficientFrontierApplet.this.assets[pk][0]};
                            double[] stdDevs = new double[]{EfficientFrontierApplet.this.assets[pi][1], EfficientFrontierApplet.this.assets[pj][1], EfficientFrontierApplet.this.assets[pk][1]};
                            double[][] rhos = VecMath.submat(EfficientFrontierApplet.this.allRhos, new int[]{pi, pj, pk});
                            int i5 = 0;
                            while (i5 < n5 + 1) {
                                j = 0;
                                while (j < n5 + 1 - i5) {
                                    int k = n5 - i5 - j;
                                    double[] weights = new double[]{(double)i5 / (double)n5, (double)j / (double)n5, (double)k / (double)n5};
                                    EfficientFrontierApplet.combine_mean_stddev(values[i5][j], weights, means, stdDevs, rhos, EfficientFrontierApplet.this.combineMethod, EfficientFrontierApplet.this.impossibleCorrelationsStrategy, EfficientFrontierApplet.this);
                                    if (EfficientFrontierApplet.this.useArithmeticMeans) {
                                        values[i5][j][0] = EfficientFrontierApplet.findAMeanFromGMeanAndStdDev(values[i5][j][0], values[i5][j][1]);
                                    }
                                    values[i5][j][0] = Math.log(values[i5][j][0]) * EfficientFrontierApplet.this.invLogMaxMean;
                                    values[i5][j][1] = Math.log(values[i5][j][1]) * EfficientFrontierApplet.this.invLogMaxStdDev;
                                    ++j;
                                }
                                ++i5;
                            }
                            i5 = 0;
                            while (i5 < n5 - 1) {
                                j = 0;
                                while (j < n5 - 1 - i5) {
                                    mg.drawLine(values[i5][j + 1][1], values[i5][j + 1][0], values[i5 + 1][j][1], values[i5 + 1][j][0]);
                                    mg.drawLine(values[i5][j + 1][1], values[i5][j + 1][0], values[i5 + 1][j + 1][1], values[i5 + 1][j + 1][0]);
                                    mg.drawLine(values[i5 + 1][j][1], values[i5 + 1][j][0], values[i5 + 1][j + 1][1], values[i5 + 1][j + 1][0]);
                                    ++j;
                                }
                                ++i5;
                            }
                            ++pk;
                        }
                        ++pj;
                    }
                    ++pi;
                }
            }
            if (EfficientFrontierApplet.this.maxAssetsToDraw >= 2) {
                mg.setColor(Color.red);
                double[] result = new double[2];
                double prevLogMean = 0.0;
                double prevLogStdDev = 0.0;
                int pi = 0;
                while (pi < EfficientFrontierApplet.this.assets.length) {
                    int pj = pi + 1;
                    while (pj < EfficientFrontierApplet.this.assets.length) {
                        double[] means = new double[]{EfficientFrontierApplet.this.assets[pi][0], EfficientFrontierApplet.this.assets[pj][0]};
                        double[] stdDevs = new double[]{EfficientFrontierApplet.this.assets[pi][1], EfficientFrontierApplet.this.assets[pj][1]};
                        double[][] rhos = VecMath.submat(EfficientFrontierApplet.this.allRhos, new int[]{pi, pj});
                        int N = 20;
                        int n6 = 4;
                        int i6 = 0;
                        while (i6 < N * n6 + 1) {
                            int j = N * n6 - i6;
                            double[] weights = new double[]{(double)i6 / (double)(N * n6), (double)j / (double)(N * n6)};
                            EfficientFrontierApplet.combine_mean_stddev(result, weights, means, stdDevs, rhos, EfficientFrontierApplet.this.combineMethod, EfficientFrontierApplet.this.impossibleCorrelationsStrategy, EfficientFrontierApplet.this);
                            if (EfficientFrontierApplet.this.useArithmeticMeans) {
                                result[0] = EfficientFrontierApplet.findAMeanFromGMeanAndStdDev(result[0], result[1]);
                            }
                            double logMean = Math.log(result[0]);
                            double logStdDev = Math.log(result[1]);
                            if (i6 % n6 == 0) {
                                mg.drawPoint(logStdDev * EfficientFrontierApplet.this.invLogMaxStdDev, logMean * EfficientFrontierApplet.this.invLogMaxMean, 3);
                            }
                            if (i6 > 0) {
                                mg.drawLine(prevLogStdDev * EfficientFrontierApplet.this.invLogMaxStdDev, prevLogMean * EfficientFrontierApplet.this.invLogMaxMean, logStdDev * EfficientFrontierApplet.this.invLogMaxStdDev, logMean * EfficientFrontierApplet.this.invLogMaxMean);
                            }
                            prevLogMean = logMean;
                            prevLogStdDev = logStdDev;
                            ++i6;
                        }
                        ++pj;
                    }
                    ++pi;
                }
            }
            mg.setColor(Color.white);
            EfficientFrontierApplet.this.drawnAssets = new double[EfficientFrontierApplet.this.assets.length][];
            int i7 = 0;
            while (i7 < EfficientFrontierApplet.this.assets.length) {
                double mean = EfficientFrontierApplet.this.assets[i7][0];
                double stdDev = EfficientFrontierApplet.this.assets[i7][1];
                if (EfficientFrontierApplet.this.useArithmeticMeans) {
                    mean = EfficientFrontierApplet.findAMeanFromGMeanAndStdDev(mean, stdDev);
                }
                EfficientFrontierApplet.this.drawnAssets[i7] = new double[]{Math.log(stdDev) * EfficientFrontierApplet.this.invLogMaxStdDev, Math.log(mean) * EfficientFrontierApplet.this.invLogMaxMean};
                mg.drawPoint(EfficientFrontierApplet.this.drawnAssets[i7][0], EfficientFrontierApplet.this.drawnAssets[i7][1], 5);
                mg.drawString(" " + EfficientFrontierApplet.this.assetNames[i7], EfficientFrontierApplet.this.drawnAssets[i7][0], EfficientFrontierApplet.this.drawnAssets[i7][1], -1.0, 0.0);
                ++i7;
            }
            if (EfficientFrontierApplet.this.assets.length >= 1) {
                MinusMeanFun fun;
                double[] maxReturnWeights_except_last;
                double[] maxReturnWeights;
                double[] minRiskWeights;
                double[] equalWeights_except_last = new double[EfficientFrontierApplet.this.assets.length - 1];
                double[] means = new double[EfficientFrontierApplet.this.assets.length];
                double[] stdDevs = new double[EfficientFrontierApplet.this.assets.length];
                int i8 = 0;
                while (i8 < EfficientFrontierApplet.this.assets.length - 1) {
                    equalWeights_except_last[i8] = 1.0 / (double)EfficientFrontierApplet.this.assets.length;
                    ++i8;
                }
                i8 = 0;
                while (i8 < EfficientFrontierApplet.this.assets.length) {
                    means[i8] = EfficientFrontierApplet.this.assets[i8][0];
                    stdDevs[i8] = EfficientFrontierApplet.this.assets[i8][1];
                    ++i8;
                }
                /*
                 * Illegal identifiers - consider using --renameillegalidents true
                 */
                class StdDevFun
                implements Minimizer.VectorFunction {
                    double[] weights;
                    double[] scratch;
                    double[] means;
                    double[] stdDevs;
                    double[][] rhos;
                    final /* synthetic */ EfficientFrontierAppletCanvas this$0;

                    public double apply(double[] weights_except_last) {
                        double sum = 0.0;
                        int i = 0;
                        while (i < this.weights.length - 1) {
                            this.weights[i] = weights_except_last[i];
                            sum += this.weights[i];
                            ++i;
                        }
                        this.weights[i] = 1.0 - sum;
                        i = 0;
                        while (i < this.weights.length) {
                            if (this.weights[i] < 0.0) {
                                return Double.POSITIVE_INFINITY;
                            }
                            ++i;
                        }
                        EfficientFrontierApplet.access$16(this.scratch, this.weights, this.means, this.stdDevs, this.rhos, this.this$0.EfficientFrontierApplet.this.combineMethod, this.this$0.EfficientFrontierApplet.this.impossibleCorrelationsStrategy, this.this$0.EfficientFrontierApplet.this);
                        return this.scratch[1];
                    }

                    private final /* synthetic */ void this() {
                        this.scratch = new double[2];
                    }

                    public StdDevFun(EfficientFrontierAppletCanvas efficientFrontierAppletCanvas, double[] means, double[] stdDevs, double[][] rhos) {
                        this.this$0 = efficientFrontierAppletCanvas;
                        this.this();
                        this.means = means;
                        this.stdDevs = stdDevs;
                        this.rhos = rhos;
                        this.weights = new double[means.length];
                    }
                }
                StdDevFun fun2 = new StdDevFun(this, means, stdDevs, EfficientFrontierApplet.this.allRhos);
                double[] minRiskWeights_except_last = Minimizer.minimize(fun2, equalWeights_except_last, 0.001, 1000);
                double[] dArray = minRiskWeights = minRiskWeights_except_last == null ? null : Arrays.append(minRiskWeights_except_last, 1.0 - VecMath.sum(minRiskWeights_except_last));
                if (minRiskWeights != null) {
                    double[] result = new double[2];
                    EfficientFrontierApplet.combine_mean_stddev(result, minRiskWeights, means, stdDevs, EfficientFrontierApplet.this.allRhos, EfficientFrontierApplet.this.combineMethod, EfficientFrontierApplet.this.impossibleCorrelationsStrategy, EfficientFrontierApplet.this);
                    if (EfficientFrontierApplet.this.useArithmeticMeans) {
                        result[0] = EfficientFrontierApplet.findAMeanFromGMeanAndStdDev(result[0], result[1]);
                    }
                    mg.setColor(Color.cyan);
                    mg.drawPoint(Math.log(result[1]) * EfficientFrontierApplet.this.invLogMaxStdDev, Math.log(result[0]) * EfficientFrontierApplet.this.invLogMaxMean, 3);
                }
                /*
                 * Illegal identifiers - consider using --renameillegalidents true
                 */
                class MinusMeanFun
                implements Minimizer.VectorFunction {
                    double[] weights;
                    double[] scratch;
                    double[] means;
                    double[] stdDevs;
                    double[][] rhos;
                    final /* synthetic */ EfficientFrontierAppletCanvas this$0;

                    public double apply(double[] weights_except_last) {
                        double sum = 0.0;
                        int i = 0;
                        while (i < this.weights.length - 1) {
                            this.weights[i] = weights_except_last[i];
                            sum += this.weights[i];
                            ++i;
                        }
                        this.weights[i] = 1.0 - sum;
                        i = 0;
                        while (i < this.weights.length) {
                            if (this.weights[i] < 0.0) {
                                return Double.POSITIVE_INFINITY;
                            }
                            ++i;
                        }
                        EfficientFrontierApplet.access$16(this.scratch, this.weights, this.means, this.stdDevs, this.rhos, this.this$0.EfficientFrontierApplet.this.combineMethod, this.this$0.EfficientFrontierApplet.this.impossibleCorrelationsStrategy, this.this$0.EfficientFrontierApplet.this);
                        return -this.scratch[0];
                    }

                    private final /* synthetic */ void this() {
                        this.scratch = new double[2];
                    }

                    public MinusMeanFun(EfficientFrontierAppletCanvas efficientFrontierAppletCanvas, double[] means, double[] stdDevs, double[][] rhos) {
                        this.this$0 = efficientFrontierAppletCanvas;
                        this.this();
                        this.means = means;
                        this.stdDevs = stdDevs;
                        this.rhos = rhos;
                        this.weights = new double[means.length];
                    }
                }
                double[] dArray2 = maxReturnWeights = (maxReturnWeights_except_last = Minimizer.minimize(fun = new MinusMeanFun(this, means, stdDevs, EfficientFrontierApplet.this.allRhos), equalWeights_except_last, 0.001, 1000)) == null ? null : Arrays.append(maxReturnWeights_except_last, 1.0 - VecMath.sum(maxReturnWeights_except_last));
                if (maxReturnWeights != null) {
                    double[] result = new double[2];
                    EfficientFrontierApplet.combine_mean_stddev(result, maxReturnWeights, means, stdDevs, EfficientFrontierApplet.this.allRhos, EfficientFrontierApplet.this.combineMethod, EfficientFrontierApplet.this.impossibleCorrelationsStrategy, EfficientFrontierApplet.this);
                    if (EfficientFrontierApplet.this.useArithmeticMeans) {
                        result[0] = EfficientFrontierApplet.findAMeanFromGMeanAndStdDev(result[0], result[1]);
                    }
                    mg.setColor(Color.cyan);
                    mg.drawPoint(Math.log(result[1]) * EfficientFrontierApplet.this.invLogMaxStdDev, Math.log(result[0]) * EfficientFrontierApplet.this.invLogMaxMean, 3);
                }
            }
            if (g != frontBufferGraphics) {
                frontBufferGraphics.drawImage(EfficientFrontierApplet.this.backBufferImage, 0, 0, this);
            }
            long endTimeMillis = System.currentTimeMillis();
            double paintTime = (double)(endTimeMillis - startTimeMillis) / 1000.0;
            if (EfficientFrontierApplet.this.timeVerbose >= 1) {
                System.out.println(paintTime);
            }
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("out paint (" + paintTime + "secs)");
            }
        }

        private final void makeSureBackBufferIsRight() {
            if (EfficientFrontierApplet.this.doDoubleBuffer) {
                Dimension size = this.size();
                if (EfficientFrontierApplet.this.backBufferImage == null || EfficientFrontierApplet.this.backBufferImage.getWidth(this) != size.width || EfficientFrontierApplet.this.backBufferImage.getHeight(this) != size.height) {
                    if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                        System.out.println("Creating back buffer " + size.width + 'x' + size.height);
                    }
                    EfficientFrontierApplet.this.backBufferImage = this.createImage(size.width, size.height);
                }
            } else {
                EfficientFrontierApplet.this.backBufferImage = null;
            }
        }

        EfficientFrontierAppletCanvas() {
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("in EfficientFrontierAppletCanvas()");
            }
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addKeyListener(this);
            if (EfficientFrontierApplet.this.eventVerbose >= 1) {
                System.out.println("out EfficientFrontierAppletCanvas()");
            }
        }
    }

    private class MyRhoPanel
    extends RhoPanel {
        public double verifyNewRhos(double newEveryRho, double[][] newRhos) {
            int n = newRhos.length;
            double[][] adjustedNewRhos = new double[n][n];
            int newStatus = VecMath.positiveSemiDefinitizeWithUnitDiagonal(adjustedNewRhos, null, newRhos);
            if (EfficientFrontierApplet.this.possibleStatus != newStatus) {
                if (newStatus == 1) {
                    EfficientFrontierApplet.this.rhosStatusCanvas.setBackground(Color.getHSBColor(0.33333334f, 1.0f, 0.85f));
                    EfficientFrontierApplet.this.rhosStatusLabel.setText("Possible");
                } else if (newStatus == 0) {
                    EfficientFrontierApplet.this.rhosStatusCanvas.setBackground(Color.getHSBColor(0.16666667f, 1.0f, 0.85f));
                    EfficientFrontierApplet.this.rhosStatusLabel.setText("Possible (barely)");
                } else if (newStatus == -1) {
                    if (EfficientFrontierApplet.this.impossibleCorrelationsStrategy != 2) {
                        EfficientFrontierApplet.this.rhosStatusCanvas.setBackground(Color.getHSBColor(0.0f, 1.0f, 0.9f));
                        EfficientFrontierApplet.this.rhosStatusLabel.setText("Impossible");
                    }
                } else {
                    throw new Error("Assertion failed at EfficientFrontierApplet.prejava(2168): false");
                }
                EfficientFrontierApplet.this.rhosStatusCanvas.repaint();
                EfficientFrontierApplet.this.rhosStatusLabel.repaint();
                EfficientFrontierApplet.this.controlPanelFrame.validate();
            }
            if (newStatus == -1 && EfficientFrontierApplet.this.impossibleCorrelationsStrategy != 0) {
                if (EfficientFrontierApplet.this.impossibleCorrelationsStrategy == 2) {
                    VecMath.copymat(newRhos, EfficientFrontierApplet.this.allRhos);
                    return EfficientFrontierApplet.this.everyRho;
                }
                if (EfficientFrontierApplet.this.impossibleCorrelationsStrategy == 1) {
                    EfficientFrontierApplet.this.possibleStatus = newStatus;
                    VecMath.copymat(EfficientFrontierApplet.this.allRhos, adjustedNewRhos);
                    EfficientFrontierApplet.this.everyRho = newEveryRho;
                    if (EfficientFrontierApplet.this.matrixPanel.isVisible()) {
                        EfficientFrontierApplet.this.matrixPanel.setMatrix(EfficientFrontierApplet.this.allRhos, null);
                    }
                    EfficientFrontierApplet.this.canvas.repaint();
                    return newEveryRho;
                }
                throw new Error("Assertion failed at EfficientFrontierApplet.prejava(2203): false");
            }
            EfficientFrontierApplet.this.possibleStatus = newStatus;
            VecMath.copymat(EfficientFrontierApplet.this.allRhos, newRhos);
            EfficientFrontierApplet.this.everyRho = newEveryRho;
            if (EfficientFrontierApplet.this.matrixPanel.isVisible()) {
                EfficientFrontierApplet.this.matrixPanel.setMatrix(EfficientFrontierApplet.this.allRhos, null);
            }
            EfficientFrontierApplet.this.canvas.repaint();
            return newEveryRho;
        }

        MyRhoPanel() {
            super(EfficientFrontierApplet.this.everyRho, EfficientFrontierApplet.this.allRhos, EfficientFrontierApplet.this.assetNames);
        }
    }
}

