/*
 * Decompiled with CFR 0.152.
 */
abstract class VectorFunctionOfPositionAndNormal {
    public static VectorFunctionOfPositionAndNormal[] funs = new VectorFunctionOfPositionAndNormal[]{new CommonFun("p"), new CommonFun("p/||p||"), new CommonFun("p/||p||^2"), new CommonFun("p*||p||"), new CommonFun("p/sqrt(||p||)"), new CommonFun("p/||p||^1.5"), new CommonFun("p*sqrt(||p||)"), new CommonFun("p/||n||"), new CommonFun("p/||n||^2"), new CommonFun("p*||n||"), new CommonFun("p/||p||*||n||"), new CommonFun("n"), new CommonFun("n/||n||"), new CommonFun("n/||n||^2"), new CommonFun("n*||n||"), new CommonFun("n/||p||"), new CommonFun("n/||p||^2"), new CommonFun("n*||p||"), new CommonFun("n*||p||/||n||"), new CommonFun("p/||p||*log(||p||)"), new CommonFun("p/||p||*log(||n||)"), new CommonFun("n/||n||*log(||n||)"), new CommonFun("n/||n||*log(||p||)")};
    public static String[] commonVectorStrings = new String[]{"p", "n", "(p+n)"};
    public static String[] commonScalarStrings = new String[]{"1", "2", "0.5", "||p||", "1/||p||", "1/||p||^2", "2/||p||^2", "1/||p||^3", "||n||", "1/||n||", "1/||n||^2", "1/||n||^3", "1/||p||/||n||", "1/sqrt(||p||)/sqrt(||n||)", "1/(p dot n)", "1/sqrt(p dot n)", "1/(p cross n)", "1/sqrt(p cross n)", "1/||p||*log(||p||)", "1/||p||^2*log(||p||)", "1/||p||*log(||n||)", "1/||n||*log(||n||)", "1/||n||^2*log(||n||)", "1/||n||*log(||p||)"};
    protected String name;

    public abstract void apply(double[] var1, double[] var2, double[] var3);

    public String getName() {
        return this.name;
    }

    protected void init() {
    }

    public String toString() {
        return this.getName();
    }

    VectorFunctionOfPositionAndNormal(String name) {
        this.name = name;
        this.init();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class CommonFun
    extends VectorFunctionOfPositionAndNormal {
        boolean vectorPartHasP;
        boolean vectorPartHasN;
        double scalarConstant;
        double powerOfP;
        double powerOfN;
        double powerOfPdotN;
        double powerOfPcrossN;
        double powerOfLogP;
        double powerOfLogN;

        public void apply(double[] result, double[] p, double[] n) {
            VecMath.zerovec(result);
            if (this.vectorPartHasP) {
                VecMath.vpv(result, result, p);
            }
            if (this.vectorPartHasN) {
                VecMath.vpv(result, result, n);
            }
            double scalar = this.scalarConstant;
            if (this.powerOfP != 0.0) {
                scalar *= Math.pow(VecMath.normsqrd(p), 0.5 * this.powerOfP);
            }
            if (this.powerOfN != 0.0) {
                scalar *= Math.pow(VecMath.normsqrd(n), 0.5 * this.powerOfN);
            }
            if (this.powerOfPdotN != 0.0) {
                scalar *= Math.pow(VecMath.dot(p, n), this.powerOfPdotN);
            }
            if (this.powerOfPcrossN != 0.0) {
                if (p.length != 2) {
                    throw new Error("Assertion failed at VectorFunctionOfPositionAndNormal.prejava(68): p.length == 2");
                }
                scalar *= Math.pow(p[0] * n[1] - p[1] * n[0], this.powerOfPcrossN);
            }
            if (this.powerOfLogP != 0.0) {
                scalar *= Math.pow(0.5 * Math.log(VecMath.normsqrd(p)), this.powerOfLogP);
            }
            if (this.powerOfLogN != 0.0) {
                scalar *= Math.pow(0.5 * Math.log(VecMath.normsqrd(n)), this.powerOfLogN);
            }
            VecMath.vxs(result, result, scalar);
        }

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            String name = this.getVectorName() + this.getFactorsName();
            if (name.equals("(p+n)")) {
                name = "p+n";
            }
            return name;
        }

        private final String getVectorName() {
            return this.vectorPartHasP ? (this.vectorPartHasN ? "(p+n)" : "p") : (this.vectorPartHasN ? "n" : "0");
        }

        private final String getScalarName() {
            String scalarName = "1" + this.getFactorsName();
            if (scalarName.startsWith("1*")) {
                scalarName = scalarName.substring(2);
            }
            if (scalarName.equals("(p dot n)")) {
                scalarName = "p dot n";
            } else if (scalarName.equals("(p cross n)")) {
                scalarName = "p cross n";
            }
            return scalarName;
        }

        private final String getFactorsName() {
            return (this.scalarConstant != 1.0 ? "*" + CommonFun.doubleToString(this.scalarConstant) : "") + CommonFun.factorName(this.powerOfP, "||p||") + CommonFun.factorName(this.powerOfN, "||n||") + CommonFun.factorName(this.powerOfPdotN, "(p dot n)") + CommonFun.factorName(this.powerOfPcrossN, "(p cross n)") + CommonFun.factorName(this.powerOfLogP, "log(||p||)") + CommonFun.factorName(this.powerOfLogN, "log(||n||)");
        }

        private static final String factorName(double power, String ofWhat) {
            String string = "";
            if (power != 0.0) {
                string = string + (power < 0.0 ? "/" : "*");
                if ((power = Math.abs(power)) == 0.5) {
                    string = ofWhat.startsWith("(") ? string + "sqrt" + ofWhat : string + "sqrt(" + ofWhat + ')';
                } else {
                    string = string + ofWhat;
                    if (power != 1.0) {
                        string = string + '^' + CommonFun.doubleToString(power);
                    }
                }
            }
            return string;
        }

        private static final String doubleToString(double d) {
            if ((double)((int)d) == d) {
                return "" + (int)d;
            }
            return "" + d;
        }

        private final /* synthetic */ void this() {
            this.vectorPartHasP = false;
            this.vectorPartHasN = false;
            this.scalarConstant = 1.0;
            this.powerOfP = 0.0;
            this.powerOfN = 0.0;
            this.powerOfPdotN = 0.0;
            this.powerOfPcrossN = 0.0;
            this.powerOfLogP = 0.0;
            this.powerOfLogN = 0.0;
        }

        CommonFun(int vectorStringIndex, int scalarStringIndex) {
            this(commonVectorStrings[vectorStringIndex], commonScalarStrings[scalarStringIndex]);
        }

        CommonFun(String vectorString, String scalarString) {
            this(scalarString.startsWith("1") ? vectorString + scalarString.substring(1) : vectorString + '*' + scalarString, true);
        }

        CommonFun(String s) {
            this(s, true);
        }

        CommonFun(String s, boolean requireNameToBeCanonical) {
            super(null);
            this.this();
            String origS = s;
            s = s.trim();
            if (s.startsWith("(p+n)")) {
                s = s.substring(5).trim();
                this.vectorPartHasP = true;
                this.vectorPartHasN = true;
            } else if (s.startsWith("p+n")) {
                if (!s.equals("p+n")) {
                    throw new Error("Assertion failed at VectorFunctionOfPositionAndNormal.prejava(116): s.equals(\"p+n\")");
                }
                s = s.substring(3).trim();
                this.vectorPartHasP = true;
                this.vectorPartHasN = true;
            } else if (s.startsWith("p")) {
                s = s.substring(1).trim();
                this.vectorPartHasP = true;
            } else if (s.startsWith("n")) {
                s = s.substring(1).trim();
                this.vectorPartHasN = true;
            } else if (s.startsWith("0")) {
                s = s.substring(1).trim();
            }
            while (!s.equals("")) {
                double power = 0.0;
                if (s.startsWith("*")) {
                    power = 1.0;
                    s = s.substring(1).trim();
                } else if (s.startsWith("/")) {
                    power = -1.0;
                    s = s.substring(1).trim();
                }
                if (power == 0.0) {
                    throw new Error("Assertion failed at VectorFunctionOfPositionAndNormal.prejava(153): power != 0.");
                }
                String ofWhat = null;
                String[] ofWhats = new String[]{"1", "2", "0.5", "||p||", "||n||", "p dot n", "p cross n", "log(||p||)", "log(||n||)"};
                int i = 0;
                while (i < ofWhats.length) {
                    if (s.startsWith(ofWhats[i])) {
                        s = s.substring(ofWhats[i].length()).trim();
                        ofWhat = ofWhats[i];
                    } else if (s.startsWith("(" + ofWhats[i] + ')')) {
                        s = s.substring("()".length() + ofWhats[i].length()).trim();
                        ofWhat = ofWhats[i];
                    } else if (s.startsWith("sqrt(" + ofWhats[i] + ')')) {
                        s = s.substring("sqrt()".length() + ofWhats[i].length()).trim();
                        ofWhat = ofWhats[i];
                        power *= 0.5;
                    }
                    ++i;
                }
                if (ofWhat == null) {
                    throw new Error("Assertion failed at VectorFunctionOfPositionAndNormal.prejava(189): ofWhat != null");
                }
                if (s.startsWith("^")) {
                    s = s.substring(1).trim();
                    String doubleString = "";
                    while (!s.equals("") && "-+0123456789.eE".indexOf(s.charAt(0)) >= 0) {
                        doubleString = doubleString + s.charAt(0);
                        s = s.substring(1);
                    }
                    power *= Double.valueOf(doubleString).doubleValue();
                }
                if (ofWhat.equals("1")) continue;
                if (ofWhat.equals("2")) {
                    this.scalarConstant *= Math.pow(2, power);
                    continue;
                }
                if (ofWhat.equals("0.5")) {
                    this.scalarConstant *= Math.pow(0.5, power);
                    continue;
                }
                if (ofWhat.equals("||p||")) {
                    this.powerOfP = power;
                    continue;
                }
                if (ofWhat.equals("||n||")) {
                    this.powerOfN = power;
                    continue;
                }
                if (ofWhat.equals("p dot n")) {
                    this.powerOfPdotN = power;
                    continue;
                }
                if (ofWhat.equals("p cross n")) {
                    this.powerOfPcrossN = power;
                    continue;
                }
                if (ofWhat.equals("log(||p||)")) {
                    this.powerOfLogP = power;
                    continue;
                }
                if (ofWhat.equals("log(||n||)")) {
                    this.powerOfLogN = power;
                    continue;
                }
                throw new Error("Assertion failed at VectorFunctionOfPositionAndNormal.prejava(226): false");
            }
            if (requireNameToBeCanonical && !this.getName().equals(origS)) {
                throw new Error("Assertion failed at VectorFunctionOfPositionAndNormal.prejava(231): getName().equals(origS)");
            }
        }
    }
}

