/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Array;
import java.util.Random;

public final class VecMath {
    public static final void vpv(double[] result, double[] v0, double[] v1) {
        int i = v0.length - 1;
        while (i >= 0) {
            result[i] = v0[i] + v1[i];
            --i;
        }
    }

    public static final void vpv(int[] result, int[] v0, int[] v1) {
        int i = v0.length - 1;
        while (i >= 0) {
            result[i] = v0[i] + v1[i];
            --i;
        }
    }

    public static final void vmv(double[] result, double[] v0, double[] v1) {
        int i = v0.length - 1;
        while (i >= 0) {
            result[i] = v0[i] - v1[i];
            --i;
        }
    }

    public static final void vmv(int[] result, int[] v0, int[] v1) {
        int i = v0.length - 1;
        while (i >= 0) {
            result[i] = v0[i] - v1[i];
            --i;
        }
    }

    public static final void vxs(double[] result, double[] v, double s) {
        int i = v.length - 1;
        while (i >= 0) {
            result[i] = v[i] * s;
            --i;
        }
    }

    public static final void mxs(double[][] result, double[][] M, double s) {
        int i = M.length - 1;
        while (i >= 0) {
            if (result[i] != null) {
                VecMath.vxs(result[i], M[i], s);
            }
            --i;
        }
    }

    public static final void mxs(double[][][] result, double[][][] M, double s) {
        int i = M.length - 1;
        while (i >= 0) {
            VecMath.mxs(result[i], M[i], s);
            --i;
        }
    }

    public static final void mxs(double[][][][] result, double[][][][] M, double s) {
        int i = M.length - 1;
        while (i >= 0) {
            VecMath.mxs(result[i], M[i], s);
            --i;
        }
    }

    public static final void sxv(double[] result, double s, double[] v) {
        int i = v.length - 1;
        while (i >= 0) {
            result[i] = s * v[i];
            --i;
        }
    }

    public static final void sxv(int[] result, int s, int[] v) {
        int i = v.length - 1;
        while (i >= 0) {
            result[i] = s * v[i];
            --i;
        }
    }

    public static final void xv2(double[] result, double[] v) {
        result[0] = -v[1];
        result[1] = v[0];
    }

    public static final double vxv2(double[] v, double[] w) {
        return v[0] * w[1] - v[1] * w[0];
    }

    public static final void vxv3(double[] v0, double[] v1, double[] v2) {
        v0[0] = v1[1] * v2[2] - v1[2] * v2[1];
        v0[1] = v1[2] * v2[0] - v1[0] * v2[2];
        v0[2] = v1[0] * v2[1] - v1[1] * v2[0];
    }

    public static final double vxvxv3(double[] v0, double[] v1, double[] v2) {
        return v0[0] * (v1[1] * v2[2] - v1[2] * v2[1]) + v0[1] * (v1[2] * v2[0] - v1[0] * v2[2]) + v0[2] * (v1[0] * v2[1] - v1[1] * v2[0]);
    }

    public static final void crossprod(double[] result, double[][] vectors) {
        int dim = result.length;
        if (vectors.length != dim - 1) {
            throw new Error("Assertion failed at VecMath.prejava(105): vectors.length == dim-1");
        }
        if (vectors.length > 0 && vectors[0].length != dim) {
            throw new Error("Assertion failed at VecMath.prejava(107): vectors[0].length == dim");
        }
        switch (dim) {
            case 1: {
                result[0] = 1.0;
                return;
            }
            case 2: {
                VecMath.xv2(result, vectors[0]);
                return;
            }
            case 3: {
                VecMath.vxv3(result, vectors[0], vectors[1]);
                return;
            }
        }
        double[][] cofactorMatrix = new double[dim - 1][dim - 1];
        int sign = (dim - 1) % 2 == 0 ? 1 : -1;
        int i = 0;
        while (i < dim) {
            int j = 0;
            while (j < dim - 1) {
                int k = 0;
                while (k < dim - 1) {
                    cofactorMatrix[j][k] = vectors[j][k >= i ? k + 1 : k];
                    ++k;
                }
                ++j;
            }
            result[i] = VecMath.detDestructive(cofactorMatrix) * (double)sign;
            sign = -sign;
            ++i;
        }
    }

    public static final void vpvxs(double[] result, double[] v0, double[] v1, double s1) {
        int i = v0.length - 1;
        while (i >= 0) {
            result[i] = v0[i] + s1 * v1[i];
            --i;
        }
    }

    public static final void vpvxs(int[] result, int[] v0, int[] v1, int s1) {
        int i = v0.length - 1;
        while (i >= 0) {
            result[i] = v0[i] + s1 * v1[i];
            --i;
        }
    }

    public static final void vpsxv(double[] result, double[] v0, double s1, double[] v1) {
        int i = v0.length - 1;
        while (i >= 0) {
            result[i] = v0[i] + s1 * v1[i];
            --i;
        }
    }

    public static final void vpsxv(int[] result, int[] v0, int s1, int[] v1) {
        int i = v0.length - 1;
        while (i >= 0) {
            result[i] = v0[i] + s1 * v1[i];
            --i;
        }
    }

    public static final void vpvmv(double[] result, double[] v0, double[] v1, double[] v2) {
        int i = v0.length - 1;
        while (i >= 0) {
            result[i] = v0[i] + (v1[i] - v2[i]);
            --i;
        }
    }

    public static final void sxvpsxv(double[] result, double s0, double[] v0, double s1, double[] v1) {
        int i = v0.length - 1;
        while (i >= 0) {
            result[i] = s0 * v0[i] + s1 * v1[i];
            --i;
        }
    }

    public static final void mpm(Object result, Object M0, Object M1) {
        if (result instanceof int[]) {
            VecMath.vpv((int[])result, (int[])M0, (int[])M1);
        } else if (result instanceof double[]) {
            VecMath.vpv((double[])result, (double[])M0, (double[])M1);
        } else {
            Object[] resultArray = (Object[])result;
            Object[] M0Array = (Object[])M0;
            Object[] M1Array = (Object[])M1;
            int i = resultArray.length - 1;
            while (i >= 0) {
                VecMath.mpm(resultArray[i], M0Array[i], M1Array[i]);
                --i;
            }
        }
    }

    public static final void mmm(Object result, Object M0, Object M1) {
        if (result instanceof int[]) {
            VecMath.vmv((int[])result, (int[])M0, (int[])M1);
        } else if (result instanceof double[]) {
            VecMath.vmv((double[])result, (double[])M0, (double[])M1);
        } else {
            Object[] resultArray = (Object[])result;
            Object[] M0Array = (Object[])M0;
            Object[] M1Array = (Object[])M1;
            int i = resultArray.length - 1;
            while (i >= 0) {
                VecMath.mmm(resultArray[i], M0Array[i], M1Array[i]);
                --i;
            }
        }
    }

    public static final void mpv(double[][] result, double[][] M, double[] v) {
        int i = M.length - 1;
        while (i >= 0) {
            if (M[i] != null) {
                VecMath.vpv(result[i], M[i], v);
            }
            --i;
        }
    }

    public static final void mpv(int[][] result, int[][] M, int[] v) {
        int i = M.length - 1;
        while (i >= 0) {
            if (M[i] != null) {
                VecMath.vpv(result[i], M[i], v);
            }
            --i;
        }
    }

    public static final void mpv(Object result, Object m, double[] v) {
        Object resultFlat = Arrays.flatten(result, 0, Arrays.getDim(result) - 1);
        Object mFlat = Arrays.flatten(result, 0, Arrays.getDim(result) - 1);
        if (resultFlat instanceof double[][]) {
            VecMath.mpv((double[][])resultFlat, (double[][])mFlat, v);
        } else if (resultFlat instanceof int[][]) {
            VecMath.mpv((Object)((int[][])resultFlat), (Object)((int[][])mFlat), v);
        } else {
            throw new Error("Assertion failed at VecMath.prejava(248): false");
        }
    }

    public static final void mmv(int[][] result, int[][] M, int[] v) {
        int i = M.length - 1;
        while (i >= 0) {
            if (M[i] != null) {
                VecMath.vmv(result[i], M[i], v);
            }
            --i;
        }
    }

    public static final void mmv(double[][] result, double[][] M, double[] v) {
        int i = M.length - 1;
        while (i >= 0) {
            if (M[i] != null) {
                VecMath.vmv(result[i], M[i], v);
            }
            --i;
        }
    }

    public static final void mmv(Object result, Object m, double[] v) {
        double[][] resultFlat = (double[][])Arrays.flatten(result, 0, Arrays.getDim(result) - 1);
        double[][] mFlat = (double[][])Arrays.flatten(m, 0, Arrays.getDim(m) - 1);
        VecMath.mmv(resultFlat, mFlat, v);
    }

    public static final double sqrdTwiceTriangleArea(double[] a, double[] b, double[] c) {
        double ab_dot_ab = 0.0;
        double ab_dot_ac = 0.0;
        double ac_dot_ac = 0.0;
        int i = a.length - 1;
        while (i >= 0) {
            double ai = a[i];
            double ab = b[i] - ai;
            double ac = c[i] - ai;
            ab_dot_ab += ab * ab;
            ab_dot_ac += ab * ac;
            ac_dot_ac += ac * ac;
            --i;
        }
        return ab_dot_ab * ac_dot_ac - ab_dot_ac * ab_dot_ac;
    }

    public static final void lerp(double[] result, double[] p0, double[] p1, double t) {
        int i = p0.length - 1;
        while (i >= 0) {
            result[i] = p0[i] + t * (p1[i] - p0[i]);
            --i;
        }
    }

    public static final void bary(double[] result, double[] p0, double[] p1, double t1, double[] p2, double t2) {
        int i = p0.length - 1;
        while (i >= 0) {
            result[i] = (1.0 - t1 - t2) * p0[i] + t1 * p1[i] + t2 * p2[i];
            --i;
        }
    }

    public static final void cerp(double[] result, double[] p0, double[] p1, double[] v0, double[] v1, double t) {
        double t2 = t * t;
        double coeff_p0 = ((double)2 * t - (double)3) * t2 + 1.0;
        double coeff_p1 = (-2.0 * t + (double)3) * t2;
        double coeff_v0 = ((t - (double)2) * t + 1.0) * t;
        double coeff_v1 = (t - 1.0) * t2;
        VecMath.sxv(result, coeff_p0, p0);
        VecMath.vpsxv(result, result, coeff_p1, p1);
        VecMath.vpsxv(result, result, coeff_v0, v0);
        VecMath.vpsxv(result, result, coeff_v1, v1);
    }

    public static final void interp5(double[] result, double[] p0, double[] p1, double[] v0, double[] v1, double[] a0, double[] a1, double t) {
        double t2 = t * t;
        double t3 = t2 * t;
        double t4 = t3 * t;
        double t5 = t4 * t;
        double[] tVec = new double[]{1.0, t, t2, t3, t4, t5};
        double[][] dArrayArray = new double[6][];
        double[] dArray = new double[6];
        dArray[0] = 1.0;
        dArrayArray[0] = dArray;
        double[] dArray2 = new double[6];
        dArray2[2] = 1.0;
        dArrayArray[1] = dArray2;
        double[] dArray3 = new double[6];
        dArray3[4] = 0.5;
        dArrayArray[2] = dArray3;
        dArrayArray[3] = new double[]{-10.0, 10.0, -6.0, -4.0, -1.5, 0.5};
        dArrayArray[4] = new double[]{15.0, -15.0, 8.0, 7.0, 1.5, -1.0};
        dArrayArray[5] = new double[]{-6.0, 6.0, -3.0, -3.0, -0.5, 0.5};
        double[][] M = dArrayArray;
        double[][] pva = new double[][]{p0, p1, v0, v1, a0, a1};
        double[] coeffs = VecMath.vxm(tVec, M);
        VecMath.vxm(result, coeffs, pva);
    }

    public static final void copyvec(boolean[] result, boolean[] v) {
        int i = (result.length <= v.length ? result.length : v.length) - 1;
        while (i >= 0) {
            result[i] = v[i];
            --i;
        }
    }

    public static final void copyvec(int[] result, int[] v) {
        int i = (result.length <= v.length ? result.length : v.length) - 1;
        while (i >= 0) {
            result[i] = v[i];
            --i;
        }
    }

    public static final void copyvec(double[] result, double[] v) {
        int i = (result.length <= v.length ? result.length : v.length) - 1;
        while (i >= 0) {
            result[i] = v[i];
            --i;
        }
    }

    public static final void setcolumn(double[][] M, int iCol, double[] v) {
        int iRow = (M.length <= v.length ? M.length : v.length) - 1;
        while (iRow >= 0) {
            M[iRow][iCol] = v[iRow];
            --iRow;
        }
    }

    public static final void getcolumn(double[] v, double[][] M, int iCol) {
        int iRow = (v.length <= M.length ? v.length : M.length) - 1;
        while (iRow >= 0) {
            v[iRow] = M[iRow][iCol];
            --iRow;
        }
    }

    public static final void fillvec(double[] result, double s) {
        int i = result.length - 1;
        while (i >= 0) {
            result[i] = s;
            --i;
        }
    }

    public static final void fillvec(int[] result, int s) {
        int i = result.length - 1;
        while (i >= 0) {
            result[i] = s;
            --i;
        }
    }

    public static final void fillvec(boolean[] result, boolean s) {
        int i = result.length - 1;
        while (i >= 0) {
            result[i] = s;
            --i;
        }
    }

    public static final void fillmat(double[][] result, double s) {
        int i = result.length - 1;
        while (i >= 0) {
            VecMath.fillvec(result[i], s);
            --i;
        }
    }

    public static final void fillmat(boolean[][] result, boolean s) {
        int i = result.length - 1;
        while (i >= 0) {
            VecMath.fillvec(result[i], s);
            --i;
        }
    }

    public static final void copymat(double[][] result, double[][] m) {
        int i = (result.length <= m.length ? result.length : m.length) - 1;
        while (i >= 0) {
            int j = (result[i].length <= m[i].length ? result[i].length : m[i].length) - 1;
            while (j >= 0) {
                result[i][j] = m[i][j];
                --j;
            }
            --i;
        }
    }

    public static final void zerovec(double[] result) {
        int i = result.length - 1;
        while (i >= 0) {
            result[i] = 0.0;
            --i;
        }
    }

    public static final void zerovec(int[] result) {
        int i = result.length - 1;
        while (i >= 0) {
            result[i] = 0;
            --i;
        }
    }

    public static final void zeromat(double[][] result) {
        int i = result.length - 1;
        while (i >= 0) {
            VecMath.zerovec(result[i]);
            --i;
        }
    }

    public static final double dot(double[] v0, double[] v1) {
        double result = 0.0;
        int i = v0.length - 1;
        while (i >= 0) {
            result += v0[i] * v1[i];
            --i;
        }
        return result;
    }

    public static final void vxm(double[] result, double[] v, double[][] m) {
        if (result == v) {
            throw new Error("Assumption failed at VecMath.prejava(533): result != v");
        }
        VecMath.zerovec(result);
        int vLen = v.length;
        int i = 0;
        while (i < vLen) {
            VecMath.vpsxv(result, result, v[i], m[i]);
            ++i;
        }
        while (i < m.length) {
            VecMath.vpv(result, result, m[i]);
            ++i;
        }
    }

    public static final void vxm(int[] result, int[] v, int[][] m) {
        if (result == v) {
            throw new Error("Assumption failed at VecMath.prejava(546): result != v");
        }
        int vLen = v.length;
        VecMath.zerovec(result);
        int i = 0;
        while (i < vLen) {
            VecMath.vpsxv(result, result, v[i], m[i]);
            ++i;
        }
        while (i < m.length) {
            VecMath.vpv(result, result, m[i]);
            ++i;
        }
    }

    public static final void mxm(double[][] result, double[][] m0, double[][] m1) {
        int n = 0;
        if (m0.length != 0) {
            n = m0[0].length;
        }
        if (n == m1.length) {
            if (result == m0 || result == m1) {
                throw new Error("Assumption failed at VecMath.prejava(573): result != m0 && result != m1");
            }
            int i = result.length - 1;
            while (i >= 0) {
                VecMath.vxm(result[i], m0[i], m1);
                --i;
            }
        } else if ((m0.length == m0[0].length || m0.length == m0[0].length + 1) && m1.length == m0[0].length + 1 && m1[0].length == m0[0].length && result.length == m0[0].length + 1 && result[0].length == m0[0].length) {
            double[][] M0 = VecMath.identitymat(m1.length);
            int i = m0.length - 1;
            while (i >= 0) {
                int j = m0[i].length - 1;
                while (j >= 0) {
                    M0[i][j] = m0[i][j];
                    --j;
                }
                --i;
            }
            VecMath.mxm(result, M0, m1);
        } else {
            System.out.println("m0.length = " + m0.length);
            StringBuffer stringBuffer = new StringBuffer("ROWLENGTH(m0) = ");
            int n2 = 0;
            if (m0.length != 0) {
                n2 = m0[0].length;
            }
            System.out.println(stringBuffer.append(n2).toString());
            System.out.println("m1.length = " + m1.length);
            StringBuffer stringBuffer2 = new StringBuffer("ROWLENGTH(m1) = ");
            int n3 = 0;
            if (m1.length != 0) {
                n3 = m1[0].length;
            }
            System.out.println(stringBuffer2.append(n3).toString());
            StringBuffer stringBuffer3 = new StringBuffer("(m0.length == m0[0].length || m0.length == m0[0].length+1) = ");
            boolean bl = false;
            if (m0.length == m0[0].length || m0.length == m0[0].length + 1) {
                bl = true;
            }
            System.out.println(stringBuffer3.append(bl).toString());
            StringBuffer stringBuffer4 = new StringBuffer("m1.length == m0[0].length+1 = ");
            boolean bl2 = false;
            if (m1.length == m0[0].length + 1) {
                bl2 = true;
            }
            System.out.println(stringBuffer4.append(bl2).toString());
            StringBuffer stringBuffer5 = new StringBuffer("m1[0].length == m0[0].length = ");
            boolean bl3 = false;
            if (m1[0].length == m0[0].length) {
                bl3 = true;
            }
            System.out.println(stringBuffer5.append(bl3).toString());
            StringBuffer stringBuffer6 = new StringBuffer("result.length == m0[0].length+1 = ");
            boolean bl4 = false;
            if (result.length == m0[0].length + 1) {
                bl4 = true;
            }
            System.out.println(stringBuffer6.append(bl4).toString());
            StringBuffer stringBuffer7 = new StringBuffer("result[0].length == m0[0].length = ");
            boolean bl5 = false;
            if (result[0].length == m0[0].length) {
                bl5 = true;
            }
            System.out.println(stringBuffer7.append(bl5).toString());
            throw new Error("Assumption failed at VecMath.prejava(605): false");
        }
    }

    public static final void mxm(int[][] result, int[][] m0, int[][] m1) {
        if (result == m0 || result == m1) {
            throw new Error("Assumption failed at VecMath.prejava(625): result != m0 && result != m1");
        }
        int i = result.length - 1;
        while (i >= 0) {
            VecMath.vxm(result[i], m0[i], m1);
            --i;
        }
    }

    public static final void mxv(double[] result, double[][] m, double[] v) {
        if (result == v) {
            throw new Error("Assumption failed at VecMath.prejava(632): result != v");
        }
        int nRows = m.length;
        if (nRows == 0) {
            return;
        }
        int nCols = v.length;
        int i = 0;
        while (i < nRows) {
            double[] m_i = m[i];
            double sum = 0.0;
            int j = 0;
            while (j < nCols) {
                sum += m_i[j] * v[j];
                ++j;
            }
            result[i] = sum;
            ++i;
        }
    }

    public static final void random(double[] v) {
        do {
            int i = v.length - 1;
            while (i >= 0) {
                v[i] = (double)2 * Math.random() - 1.0;
                --i;
            }
        } while (VecMath.normsqrd(v) > 1.0);
    }

    public static final void random(double[] v, Random generator) {
        do {
            int i = v.length - 1;
            while (i >= 0) {
                v[i] = (double)2 * generator.nextDouble() - 1.0;
                --i;
            }
        } while (VecMath.normsqrd(v) > 1.0);
    }

    public static final double distsqrd(double[] v0, double[] v1) {
        double result = 0.0;
        int i = v0.length - 1;
        while (i >= 0) {
            double diff = v1[i] - v0[i];
            result += diff * diff;
            --i;
        }
        return result;
    }

    public static final double dist(double[] v0, double[] v1) {
        return Math.sqrt(VecMath.distsqrd(v0, v1));
    }

    public static final double normsqrd(double[] v) {
        return VecMath.dot(v, v);
    }

    public static final double norm(double[] v) {
        return Math.sqrt(VecMath.dot(v, v));
    }

    public static final int mini(double[] v) {
        int mini = -1;
        double min = Double.POSITIVE_INFINITY;
        int i = v.length - 1;
        while (i >= 0) {
            if (v[i] < min) {
                min = v[i];
                mini = i;
            }
            --i;
        }
        return mini;
    }

    public static final int maxi(double[] v) {
        int maxi = -1;
        double max = Double.NEGATIVE_INFINITY;
        int i = v.length - 1;
        while (i >= 0) {
            if (v[i] > max) {
                max = v[i];
                maxi = i;
            }
            --i;
        }
        return maxi;
    }

    public static final double min(double[] v) {
        double min = Double.POSITIVE_INFINITY;
        int i = v.length - 1;
        while (i >= 0) {
            min = Math.min(min, v[i]);
            --i;
        }
        return min;
    }

    public static final double max(double[] v) {
        double max = Double.NEGATIVE_INFINITY;
        int i = v.length - 1;
        while (i >= 0) {
            max = Math.max(max, v[i]);
            --i;
        }
        return max;
    }

    public static final double sum(double[] v) {
        double sum = 0.0;
        int i = v.length - 1;
        while (i >= 0) {
            sum += v[i];
            --i;
        }
        return sum;
    }

    public static final double average(double[] array) {
        return VecMath.sum(array) / (double)array.length;
    }

    public static final double productNotUsingLog(double[] array) {
        double product = 1.0;
        int i = array.length - 1;
        while (i >= 0) {
            product *= array[i];
            --i;
        }
        return product;
    }

    public static final double productUsingLog(double[] array) {
        double logProd = 0.0;
        int i = array.length - 1;
        while (i >= 0) {
            logProd += Math.log(array[i]);
            --i;
        }
        return Math.exp(logProd / (double)array.length);
    }

    public static final double geomAverage(double[] array) {
        double logProd = 0.0;
        int i = array.length - 1;
        while (i >= 0) {
            logProd += Math.log(array[i]);
            --i;
        }
        return Math.exp(logProd / (double)array.length);
    }

    public static final void sum(double[] result, double[][] array) {
        VecMath.zerovec(result);
        int i = array.length - 1;
        while (i >= 0) {
            VecMath.vpv(result, result, array[i]);
            --i;
        }
    }

    public static final void average(double[] result, double[][] array) {
        VecMath.sum(result, array);
        VecMath.vxs(result, result, 1.0 / (double)array.length);
    }

    public static final void sumIndexed(double[] result, int[] inds, double[][] array) {
        VecMath.zerovec(result);
        int i = inds.length - 1;
        while (i >= 0) {
            VecMath.vpv(result, result, array[inds[i]]);
            --i;
        }
    }

    public static final void averageIndexed(double[] result, int[] inds, double[][] array) {
        VecMath.sumIndexed(result, inds, array);
        VecMath.vxs(result, result, 1.0 / (double)inds.length);
    }

    public static final void averageIndexed(double[] result, int[][] inds, double[][] array) {
        int totalInds = 0;
        VecMath.zerovec(result);
        int i = inds.length - 1;
        while (i >= 0) {
            int[] row = inds[i];
            int j = row.length - 1;
            while (j >= 0) {
                VecMath.vpv(result, result, array[row[j]]);
                ++totalInds;
                --j;
            }
            --i;
        }
        VecMath.vxs(result, result, 1.0 / (double)totalInds);
    }

    public static final void integrate(Object result, Object from) {
        if (result instanceof int[]) {
            int[] resultArray = (int[])result;
            int[] fromArray = (int[])from;
            int sum = 0;
            int n = resultArray.length;
            int i = 0;
            while (i < n) {
                resultArray[i] = sum += fromArray[i];
                ++i;
            }
        } else if (result instanceof double[]) {
            double[] resultArray = (double[])result;
            double[] fromArray = (double[])from;
            double sum = 0.0;
            int n = resultArray.length;
            int i = 0;
            while (i < n) {
                resultArray[i] = sum += fromArray[i];
                ++i;
            }
        } else {
            Object[] resultArray = (Object[])result;
            Object[] fromArray = (Object[])from;
            int n = resultArray.length;
            int i = 0;
            while (i < n) {
                VecMath.integrate(resultArray[i], fromArray[i]);
                ++i;
            }
            i = 0;
            while (i < n - 1) {
                VecMath.mpm(resultArray[i + 1], resultArray[i], resultArray[i + 1]);
                ++i;
            }
        }
    }

    public static final void differentiate(Object result, Object from) {
        if (result instanceof int[]) {
            int[] resultArray = (int[])result;
            int[] fromArray = (int[])from;
            int i = resultArray.length - 1 - 1;
            while (i >= 0) {
                resultArray[i + 1] = fromArray[i + 1] - fromArray[i];
                --i;
            }
            if (resultArray.length > 0) {
                resultArray[0] = fromArray[0];
            }
        } else if (result instanceof double[]) {
            double[] resultArray = (double[])result;
            double[] fromArray = (double[])from;
            int i = resultArray.length - 1 - 1;
            while (i >= 0) {
                resultArray[i + 1] = fromArray[i + 1] - fromArray[i];
                --i;
            }
            if (resultArray.length > 0) {
                resultArray[0] = fromArray[0];
            }
        } else {
            Object[] resultArray = (Object[])result;
            Object[] fromArray = (Object[])from;
            int i = resultArray.length - 1;
            while (i >= 0) {
                VecMath.differentiate(resultArray[i], fromArray[i]);
                --i;
            }
            i = resultArray.length - 1 - 1;
            while (i >= 0) {
                VecMath.mmm(resultArray[i + 1], resultArray[i + 1], resultArray[i]);
                --i;
            }
        }
    }

    private static final void _bboxIndexed(double[][] result, double[][] coords, Object inds) {
        int nDims = coords[0].length;
        Class<?> indsClass = inds.getClass();
        Class<?> componentType = indsClass.getComponentType();
        if (componentType == null) {
            throw new Error("Assertion failed at VecMath.prejava(889): componentType != null");
        }
        if (componentType.isArray()) {
            int n = Array.getLength(inds);
            int i = n - 1;
            while (i >= 0) {
                VecMath._bboxIndexed(result, coords, Array.get(inds, i));
                --i;
            }
        } else {
            int[] ints = (int[])inds;
            int iInt = ints.length - 1;
            while (iInt >= 0) {
                int iDim = nDims - 1;
                while (iDim >= 0) {
                    double val = coords[ints[iInt]][iDim];
                    result[0][iDim] = Math.min(result[0][iDim], val);
                    result[1][iDim] = Math.max(result[1][iDim], val);
                    --iDim;
                }
                --iInt;
            }
        }
    }

    public static final void bboxIndexed(double[][] result, double[][] coords, Object inds) {
        VecMath.fillvec(result[0], Double.POSITIVE_INFINITY);
        VecMath.fillvec(result[1], Double.NEGATIVE_INFINITY);
        VecMath._bboxIndexed(result, coords, inds);
    }

    public static final void bbox(double[][] result, double[][] array) {
        int i = result[0].length - 1;
        while (i >= 0) {
            result[0][i] = Double.POSITIVE_INFINITY;
            result[1][i] = Double.NEGATIVE_INFINITY;
            --i;
        }
        i = array.length - 1;
        while (i >= 0) {
            int j = array[i].length - 1;
            while (j >= 0) {
                result[0][j] = Math.min(result[0][j], array[i][j]);
                result[1][j] = Math.max(result[1][j], array[i][j]);
                --j;
            }
            --i;
        }
    }

    public static final void bboxUniform(double[][] bbox, double[][] array) {
        VecMath.bbox(bbox, array);
        double[] bboxCenter = VecMath.average(bbox);
        double[] bboxDims = VecMath.vmv(bbox[1], bbox[0]);
        double bboxMaxDim = VecMath.max(bboxDims);
        VecMath.fillvec(bboxDims, bboxMaxDim);
        VecMath.vpsxv(bbox[0], bboxCenter, -0.5, bboxDims);
        VecMath.vpsxv(bbox[1], bboxCenter, 0.5, bboxDims);
    }

    public static final void bboxIntersect(double[][] result, double[][] bbox0, double[][] bbox1) {
        int n = result[0].length;
        int i = 0;
        while (i < n) {
            result[0][i] = bbox0[0][i] >= bbox1[0][i] ? bbox0[0][i] : bbox1[0][i];
            result[1][i] = bbox0[1][i] <= bbox1[1][i] ? bbox0[1][i] : bbox1[1][i];
            ++i;
        }
    }

    public static final void bboxUnion(double[][] result, double[][] bbox0, double[][] bbox1) {
        int n = result[0].length;
        int i = 0;
        while (i < n) {
            result[0][i] = bbox0[0][i] <= bbox1[0][i] ? bbox0[0][i] : bbox1[0][i];
            result[1][i] = bbox0[1][i] >= bbox1[1][i] ? bbox0[1][i] : bbox1[1][i];
            ++i;
        }
    }

    public static final boolean closedBBoxContains(double[][] bbox, double[] point, double eps) {
        int i = point.length - 1;
        while (i >= 0) {
            if (!(bbox[0][i] - eps <= point[i]) || !(point[i] <= bbox[1][i] + eps)) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static final boolean bboxInteriorContains(double[][] bbox, double[] point, double eps) {
        int i = point.length - 1;
        while (i >= 0) {
            if (!(bbox[0][i] + eps < point[i]) || !(point[i] < bbox[1][i] - eps)) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static final void transpose(double[][] result, double[][] M) {
        if (result == M) {
            throw new Error("Assumption failed at VecMath.prejava(992): result != M");
        }
        int i = M.length - 1;
        while (i >= 0) {
            int j = M[i].length - 1;
            while (j >= 0) {
                result[j][i] = M[i][j];
                --j;
            }
            --i;
        }
    }

    public static final int luDecompose(double[][] A, int n, int[] indx) throws Exception {
        double max;
        double[] vv = new double[n];
        int d = 1;
        int i = 0;
        while (i < n) {
            max = 0.0;
            int j = 0;
            while (j < n) {
                double temp;
                double d2 = temp = A[i][j] < 0.0 ? -A[i][j] : A[i][j];
                if (temp > max) {
                    max = temp;
                }
                ++j;
            }
            if (max == 0.0) {
                throw new Exception("Singular matrix in routine luDecompose");
            }
            vv[i] = 1.0 / max;
            ++i;
        }
        int j = 0;
        while (j < n) {
            int i2 = 0;
            while (i2 < j) {
                double sum = A[i2][j];
                int k = 0;
                while (k < i2) {
                    sum -= A[i2][k] * A[k][j];
                    ++k;
                }
                A[i2][j] = sum;
                ++i2;
            }
            max = 0.0;
            int imax = -1;
            int i3 = j;
            while (i3 < n) {
                double sum = A[i3][j];
                int k = 0;
                while (k < j) {
                    sum -= A[i3][k] * A[k][j];
                    ++k;
                }
                A[i3][j] = sum;
                double dum = vv[i3] * (sum < 0.0 ? -sum : sum);
                if (dum >= max) {
                    max = dum;
                    imax = i3;
                }
                ++i3;
            }
            if (imax == -1) {
                throw new Error("Assertion failed at VecMath.prejava(1058): imax != -1");
            }
            if (j != imax) {
                double[] temp = A[imax];
                A[imax] = A[j];
                A[j] = temp;
                d = -d;
                vv[imax] = vv[j];
            }
            indx[j] = imax;
            if (A[j][j] == 0.0) {
                A[j][j] = 1.0E-40;
            }
            if (j != n - 1) {
                double invAjj = 1.0 / A[j][j];
                int i4 = j + 1;
                while (i4 < n) {
                    double[] dArray = A[i4];
                    int n2 = j;
                    dArray[n2] = dArray[n2] * invAjj;
                    ++i4;
                }
            }
            ++j;
        }
        return d;
    }

    public static final void luBackSubstitute(double[][] A, int n, int[] indx, double[] b) {
        int ii = -1;
        int i = 0;
        while (i < n) {
            int ip = indx[i];
            double sum = b[ip];
            b[ip] = b[i];
            if (ii >= 0) {
                int j = ii;
                while (j < i) {
                    sum -= A[i][j] * b[j];
                    ++j;
                }
            } else if (sum != 0.0) {
                ii = i;
            }
            b[i] = sum;
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            double sum = b[i];
            int j = i + 1;
            while (j < n) {
                sum -= A[i][j] * b[j];
                ++j;
            }
            b[i] = sum / A[i][i];
            --i;
        }
    }

    public static final void gaussj(double[][] a, int n, double[][] b, int m) throws Exception {
        double doubletemp;
        int l;
        int k;
        int icol = -1;
        int irow = -1;
        int[] indxc = new int[n];
        int[] indxr = new int[n];
        int[] ipiv = new int[n];
        int j = 0;
        while (j < n) {
            ipiv[j] = 0;
            ++j;
        }
        int i = 0;
        while (i < n) {
            double big = 0.0;
            j = 0;
            while (j < n) {
                if (ipiv[j] != 1) {
                    k = 0;
                    while (k < n) {
                        if (ipiv[k] == 0) {
                            double d = a[j][k] < 0.0 ? -a[j][k] : a[j][k];
                            if (d >= big) {
                                big = a[j][k] < 0.0 ? -a[j][k] : a[j][k];
                                irow = j;
                                icol = k;
                            }
                        } else if (ipiv[k] > 1) {
                            throw new Exception("Singular matrix in routine gaussj, 1");
                        }
                        ++k;
                    }
                }
                ++j;
            }
            int n2 = icol;
            ipiv[n2] = ipiv[n2] + 1;
            if (irow != icol) {
                l = 0;
                while (l < n) {
                    doubletemp = a[irow][l];
                    a[irow][l] = a[icol][l];
                    a[icol][l] = doubletemp;
                    ++l;
                }
                l = 0;
                while (l < m) {
                    doubletemp = b[irow][l];
                    b[irow][l] = b[icol][l];
                    b[icol][l] = doubletemp;
                    ++l;
                }
            }
            indxr[i] = irow;
            indxc[i] = icol;
            if (a[icol][icol] == 0.0) {
                throw new Exception("Singular matrix in routine gaussj, 2");
            }
            double pivinv = 1.0 / a[icol][icol];
            a[icol][icol] = 1.0;
            l = 0;
            while (l < n) {
                double[] dArray = a[icol];
                int n3 = l++;
                dArray[n3] = dArray[n3] * pivinv;
            }
            l = 0;
            while (l < m) {
                double[] dArray = b[icol];
                int n4 = l++;
                dArray[n4] = dArray[n4] * pivinv;
            }
            int ll = 0;
            while (ll < n) {
                if (ll != icol) {
                    double dum = a[ll][icol];
                    a[ll][icol] = 0.0;
                    l = 0;
                    while (l < n) {
                        double[] dArray = a[ll];
                        int n5 = l;
                        dArray[n5] = dArray[n5] - a[icol][l] * dum;
                        ++l;
                    }
                    l = 0;
                    while (l < m) {
                        double[] dArray = b[ll];
                        int n6 = l;
                        dArray[n6] = dArray[n6] - b[icol][l] * dum;
                        ++l;
                    }
                }
                ++ll;
            }
            ++i;
        }
        l = n - 1;
        while (l >= 0) {
            if (indxr[l] != indxc[l]) {
                k = 0;
                while (k < n) {
                    doubletemp = a[k][indxr[l]];
                    a[k][indxr[l]] = a[k][indxc[l]];
                    a[k][indxc[l]] = doubletemp;
                    ++k;
                }
            }
            --l;
        }
    }

    public static final void invertmat(double[][] result, double[][] M) {
        int nCols;
        int nRows = M.length;
        int n = 0;
        if (M.length != 0) {
            n = nCols = M[0].length;
        }
        if (nRows != result.length) {
            throw new Error("Assertion failed at VecMath.prejava(1223): nRows == result.length");
        }
        int n2 = 0;
        if (result.length != 0) {
            n2 = result[0].length;
        }
        if (nCols != n2) {
            throw new Error("Assertion failed at VecMath.prejava(1224): nCols == ROWLENGTH(result)");
        }
        if (nRows == nCols) {
            double[][] temp = VecMath.copymat(M);
            int[] indx = new int[nRows];
            try {
                VecMath.luDecompose(temp, nRows, indx);
            }
            catch (Exception e) {
                VecMath.fillmat(result, Double.POSITIVE_INFINITY);
                return;
            }
            double[] col = new double[nRows];
            int j = 0;
            while (j < nRows) {
                VecMath.zerovec(col);
                col[j] = 1.0;
                VecMath.luBackSubstitute(temp, nRows, indx, col);
                VecMath.setcolumn(result, j, col);
                ++j;
            }
        } else {
            int n3 = nRows >= nCols ? nRows : nCols;
            double[][] temp = VecMath.identitymat(n3);
            VecMath.copymat(temp, M);
            VecMath.invertmat(temp, temp);
            VecMath.copymat(result, temp);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final double detDestructive(double[][] M) {
        int n = M.length;
        int n2 = 0;
        if (M.length != 0) {
            n2 = M[0].length;
        }
        if (n != n2) {
            throw new Error("Assertion failed at VecMath.prejava(1270): n == ROWLENGTH(M)");
        }
        switch (n) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return M[0][0];
            }
            case 2: {
                return VecMath.vxv2(M[0], M[1]);
            }
            case 3: {
                return VecMath.vxvxv3(M[0], M[1], M[2]);
            }
        }
        int[] indx = new int[n];
        try {
            void e;
            double d = VecMath.luDecompose(M, n, indx);
            int j = 0;
            while (j < n) {
                d *= M[j][j];
                ++j;
            }
            return (double)e;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static final double det(double[][] M) {
        int n = M.length;
        int n2 = 0;
        if (M.length != 0) {
            n2 = M[0].length;
        }
        if (n != n2) {
            throw new Error("Assertion failed at VecMath.prejava(1309): n == ROWLENGTH(M)");
        }
        switch (n) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return M[0][0];
            }
            case 2: {
                return VecMath.vxv2(M[0], M[1]);
            }
            case 3: {
                return VecMath.vxvxv3(M[0], M[1], M[2]);
            }
        }
        return VecMath.detDestructive(VecMath.copymat(M));
    }

    public static final void invmxv(double[] result, double[][] M, double[] b) {
        int n = result.length;
        if (n != M.length) {
            throw new Error("Assertion failed at VecMath.prejava(1340): n == M.length");
        }
        int n2 = 0;
        if (M.length != 0) {
            n2 = M[0].length;
        }
        if (n != n2) {
            throw new Error("Assertion failed at VecMath.prejava(1341): n == ROWLENGTH(M)");
        }
        double[][] temp = VecMath.copymat(M);
        int[] indx = new int[n];
        try {
            VecMath.luDecompose(temp, n, indx);
        }
        catch (Exception e) {
            VecMath.fillvec(result, Double.POSITIVE_INFINITY);
            return;
        }
        VecMath.copyvec(result, b);
        VecMath.luBackSubstitute(temp, n, indx, result);
        if (VecMath.normsqrd(result) < 1.0E20) {
            if (result == b) {
                throw new Error("Assumption failed at VecMath.prejava(1360): result != b");
            }
            double[] bb = VecMath.mxv(M, result);
            int i = 0;
            while (i < n) {
                if (1.0 + (bb[i] - b[i]) * (bb[i] - b[i]) != 1.0) {
                    System.out.println("\"WARNING!\" = WARNING!");
                    System.out.println("bb[i] = " + bb[i]);
                    System.out.println("b[i] = " + b[i]);
                    System.out.println("SQR(bb[i] - b[i]) = " + (bb[i] - b[i]) * (bb[i] - b[i]));
                    System.out.println("1. + SQR(bb[i] - b[i]) = " + (1.0 + (bb[i] - b[i]) * (bb[i] - b[i])));
                }
                if ((float)(1.0 + (bb[i] - b[i]) * (bb[i] - b[i])) != 1.0f) {
                    throw new Error("Assertion failed at VecMath.prejava(1378): (float)(1. + SQR(bb[i] - b[i])) == (float)1.");
                }
                ++i;
            }
        }
    }

    public final void invmxm(double[][] result, double[][] M, double[][] B) {
        int n = result.length;
        if (n != B.length) {
            throw new Error("Assertion failed at VecMath.prejava(1386): n == B.length");
        }
        if (n != M.length) {
            throw new Error("Assertion failed at VecMath.prejava(1387): n == M.length");
        }
        int n2 = 0;
        if (M.length != 0) {
            n2 = M[0].length;
        }
        if (n != n2) {
            throw new Error("Assertion failed at VecMath.prejava(1388): n == ROWLENGTH(M)");
        }
        int n3 = 0;
        if (result.length != 0) {
            n3 = result[0].length;
        }
        int nCols = n3;
        int n4 = 0;
        if (B.length != 0) {
            n4 = B[0].length;
        }
        if (nCols != n4) {
            throw new Error("Assertion failed at VecMath.prejava(1390): nCols == ROWLENGTH(B)");
        }
        double[][] temp = VecMath.copymat(M);
        int[] indx = new int[n];
        try {
            VecMath.luDecompose(temp, n, indx);
        }
        catch (Exception e) {
            VecMath.fillmat(result, Double.POSITIVE_INFINITY);
            return;
        }
        double[] col = new double[n];
        int i = 0;
        while (i < nCols) {
            VecMath.getcolumn(col, B, i);
            VecMath.luBackSubstitute(temp, n, indx, col);
            VecMath.setcolumn(result, i, col);
            ++i;
        }
    }

    public final void vxinvm(double[] result, double[] v, double[][] M) {
        VecMath.invmxv(result, VecMath.transpose(M), v);
    }

    public final void mxinvm(double[][] result, double[][] v, double[][] M) {
        int n = 0;
        if (result.length != 0) {
            n = result[0].length;
        }
        double[][] transposeResult = new double[n][result.length];
        this.invmxm(transposeResult, VecMath.transpose(M), VecMath.transpose(v));
        VecMath.transpose(result, transposeResult);
    }

    public static final void submat(double[][] result, double[][] M, int[] inds) {
        int i = inds.length - 1;
        while (i >= 0) {
            int j = inds.length - 1;
            while (j >= 0) {
                result[i][j] = M[inds[i]][inds[j]];
                --j;
            }
            --i;
        }
    }

    public static final void identitymat(double[][] M) {
        int i = M.length - 1;
        while (i >= 0) {
            int j = M[i].length - 1;
            while (j >= 0) {
                M[i][j] = i == j ? 1.0 : 0.0;
                --j;
            }
            --i;
        }
    }

    public static final void makeRowRotMat(double[][] M, int fromAxis, int toAxis, double radians) {
        double c;
        VecMath.identitymat(M);
        double s = Math.sin(radians);
        M[fromAxis][fromAxis] = c = Math.cos(radians);
        M[fromAxis][toAxis] = s;
        M[toAxis][fromAxis] = -s;
        M[toAxis][toAxis] = c;
    }

    public static final void makeRowTransMat(double[][] M, double[] translate) {
        VecMath.identitymat(M);
        int nRows = M.length;
        int i = translate.length - 1;
        while (i >= 0) {
            M[nRows - 1][i] = translate[i];
            --i;
        }
    }

    public static final void makeRowTransMatInv(double[][] M, double[] translate) {
        VecMath.identitymat(M);
        int nRows = M.length;
        int i = translate.length - 1;
        while (i >= 0) {
            M[nRows - 1][i] = -translate[i];
            --i;
        }
    }

    public static final void makeRowScaleMat(double[][] M, double[] scale) {
        int n = M.length;
        int n2 = 0;
        if (n != 0) {
            n2 = M[0].length;
        }
        int m = n2;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                M[i][j] = i == j ? (i >= scale.length ? 1.0 : scale[i]) : 0.0;
                ++j;
            }
            ++i;
        }
    }

    public static final double angleBetweenUnitVectors(double[] u0, double[] u1) {
        if (VecMath.dot(u0, u1) > 0.0) {
            return (double)2 * Math.asin(0.5 * VecMath.dist(u0, u1));
        }
        double[] minusU1 = VecMath.sxv(-1.0, u1);
        return Math.PI - (double)2 * Math.asin(0.5 * VecMath.dist(u0, minusU1));
    }

    public static final double[][] insertIdentityRowAndColumn(double[][] M, int ind, double zero, double one) {
        double[][] result = new double[M.length + 1][M.length + 1];
        int i = 0;
        while (i < M.length) {
            int j = 0;
            while (j < M.length) {
                result[i >= ind ? i + 1 : i][j >= ind ? j + 1 : j] = M[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < result.length) {
            double d = zero;
            result[ind][i] = d;
            result[i][ind] = d;
            ++i;
        }
        result[ind][ind] = one;
        return result;
    }

    public static final double[][] deleteRowAndColumn(double[][] M, int ind) {
        double[][] result = new double[M.length - 1][M.length - 1];
        int n = result.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                result[i][j] = M[i >= ind ? i + 1 : i][j >= ind ? j + 1 : j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static final boolean equals(int[] v0, int[] v1) {
        if (v0 == null) {
            boolean bl = false;
            if (v1 == null) {
                bl = true;
            }
            return bl;
        }
        if (v1 == null) {
            return false;
        }
        int n = v0.length;
        if (n != v1.length) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (v0[i] != v1[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean equalsExactly(double[] v0, double[] v1) {
        if (v0 == null) {
            boolean bl = false;
            if (v1 == null) {
                bl = true;
            }
            return bl;
        }
        if (v1 == null) {
            return false;
        }
        int n = v0.length;
        if (n != v1.length) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (v0[i] != v1[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean equalsUsingEqualsSymbol(Object[] v0, Object[] v1) {
        if (v0 == null) {
            boolean bl = false;
            if (v1 == null) {
                bl = true;
            }
            return bl;
        }
        if (v1 == null) {
            return false;
        }
        int n = v0.length;
        if (n != v1.length) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (v0[i] != v1[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean equals(double[][] M0, double[][] M1, double eps) {
        if (M0 == null && M1 == null) {
            return true;
        }
        if (M0 == null || M1 == null || M0.length != M1.length) {
            return false;
        }
        int n = M0.length;
        int i = 0;
        while (i < n) {
            if (M0[i].length != M1[i].length) {
                return false;
            }
            int m = M0[i].length;
            int j = 0;
            while (j < m) {
                if (M0[i][j] != M1[i][j] && Math.abs(M0[i][j] - M1[i][j]) > eps) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static final void downshift(double[][] to, double[][] from) {
        double[] from0 = from[0];
        int n = from.length;
        int i = 0;
        while (i < n - 1) {
            to[i] = from[i + 1];
            ++i;
        }
        to[i] = from0;
    }

    public static final void upshift(double[][] to, double[][] from) {
        int n = from.length;
        double[] fromLast = from[n - 1];
        int i = n - 1;
        while (i > 0) {
            to[i] = from[i - 1];
            --i;
        }
        to[i] = fromLast;
    }

    public static final int jacobi(double[][] A, double[] d, double[][] V) {
        int n = d.length;
        double[] b = new double[n];
        double[] z = new double[n];
        VecMath.identitymat(V);
        int i = 0;
        while (i < n) {
            b[i] = d[i] = A[i][i];
            z[i] = 0.0;
            ++i;
        }
        int nRot = 0;
        int iIter = 0;
        while (iIter < 50) {
            double sum = 0.0;
            int i2 = 0;
            while (i2 < n - 1) {
                int j = i2 + 1;
                while (j < n) {
                    sum += A[i2][j] < 0.0 ? -A[i2][j] : A[i2][j];
                    ++j;
                }
                ++i2;
            }
            if (sum == 0.0) {
                return nRot;
            }
            double tresh = iIter < 3 ? 0.2 * sum / (double)(n * n) : 0.0;
            int i3 = 0;
            while (i3 < n - 1) {
                int j = i3 + 1;
                while (j < n) {
                    double g = 100.0 * (A[i3][j] < 0.0 ? -A[i3][j] : A[i3][j]);
                    if (iIter > 3 && (d[i3] < 0.0 ? -d[i3] : d[i3]) + g == (d[i3] < 0.0 ? -d[i3] : d[i3]) && (d[j] < 0.0 ? -d[j] : d[j]) + g == (d[j] < 0.0 ? -d[j] : d[j])) {
                        A[i3][j] = 0.0;
                    } else {
                        double d2 = A[i3][j] < 0.0 ? -A[i3][j] : A[i3][j];
                        if (d2 > tresh) {
                            double t;
                            double h = d[j] - d[i3];
                            if ((h < 0.0 ? -h : h) + g == (h < 0.0 ? -h : h)) {
                                t = A[i3][j] / h;
                            } else {
                                double theta = 0.5 * h / A[i3][j];
                                t = 1.0 / ((theta < 0.0 ? -theta : theta) + Math.sqrt(1.0 + theta * theta));
                                if (theta < 0.0) {
                                    t = -t;
                                }
                            }
                            double c = 1.0 / Math.sqrt(1.0 + t * t);
                            double s = t * c;
                            double tau = s / (1.0 + c);
                            h = t * A[i3][j];
                            int n2 = i3;
                            z[n2] = z[n2] - h;
                            int n3 = j;
                            z[n3] = z[n3] + h;
                            int n4 = i3;
                            d[n4] = d[n4] - h;
                            int n5 = j;
                            d[n5] = d[n5] + h;
                            A[i3][j] = 0.0;
                            int k = 0;
                            while (k < i3) {
                                g = A[k][i3];
                                h = A[k][j];
                                A[k][i3] = g - s * (h + g * tau);
                                A[k][j] = h + s * (g - h * tau);
                                ++k;
                            }
                            k = i3 + 1;
                            while (k < j) {
                                g = A[i3][k];
                                h = A[k][j];
                                A[i3][k] = g - s * (h + g * tau);
                                A[k][j] = h + s * (g - h * tau);
                                ++k;
                            }
                            k = j + 1;
                            while (k < n) {
                                g = A[i3][k];
                                h = A[j][k];
                                A[i3][k] = g - s * (h + g * tau);
                                A[j][k] = h + s * (g - h * tau);
                                ++k;
                            }
                            k = 0;
                            while (k < n) {
                                g = V[k][i3];
                                h = V[k][j];
                                V[k][i3] = g - s * (h + g * tau);
                                V[k][j] = h + s * (g - h * tau);
                                ++k;
                            }
                            ++nRot;
                        }
                    }
                    ++j;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < n) {
                int n6 = i3;
                b[n6] = b[n6] + z[i3];
                d[i3] = b[i3];
                z[i3] = 0.0;
                ++i3;
            }
            ++iIter;
        }
        System.err.println("Too many iterations in routine jacobi");
        return -1;
    }

    public static final int leftSqrtOfSymmetricMatrix(double[][] result, boolean[] whichColumnsOfResultAreImaginary, double[][] C) {
        int n = C.length;
        if (n != result.length) {
            throw new Error("Assertion failed at VecMath.prejava(1711): n == result.length");
        }
        double[] eigenValues = new double[n];
        double[][] eigenVectors = new double[n][n];
        double[][] temp = VecMath.copymat(C);
        int nRot = VecMath.jacobi(temp, eigenValues, eigenVectors);
        if (nRot < 0) {
            if (result != null) {
                VecMath.identitymat(result);
            }
            return -2;
        }
        double[][] diagEigenValues = VecMath.identitymat(n);
        int i = 0;
        while (i < n) {
            diagEigenValues[i][i] = eigenValues[i];
            ++i;
        }
        double[][] A = VecMath.mxm(C, eigenVectors);
        double[][] B = VecMath.mxm(eigenVectors, diagEigenValues);
        i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                if (1.0 + (A[i][j] - B[i][j]) * (A[i][j] - B[i][j]) != 1.0) {
                    throw new Error("Assertion failed at VecMath.prejava(1743): 1. + SQR(A[i][j]-B[i][j]) == 1.");
                }
                ++j;
            }
            ++i;
        }
        int positiveDefiniteStatus = 1;
        i = 0;
        while (i < n) {
            double sqrtEigenValue;
            double eigenValue = eigenValues[i];
            if (1.0 + eigenValue * eigenValue == 1.0) {
                int n2 = 0;
                if (positiveDefiniteStatus <= 0) {
                    n2 = positiveDefiniteStatus;
                }
                positiveDefiniteStatus = n2;
            } else if (eigenValue < 0.0) {
                positiveDefiniteStatus = -1;
            }
            if (whichColumnsOfResultAreImaginary != null) {
                boolean bl = false;
                if (eigenValue < 0.0) {
                    bl = whichColumnsOfResultAreImaginary[i] = true;
                }
                sqrtEigenValue = bl ? Math.sqrt(-eigenValue) : Math.sqrt(eigenValue);
            } else {
                sqrtEigenValue = Math.sqrt(eigenValue >= 0.0 ? eigenValue : 0.0);
            }
            int j = 0;
            while (j < n) {
                double[] dArray = eigenVectors[j];
                int n3 = i;
                dArray[n3] = dArray[n3] * sqrtEigenValue;
                ++j;
            }
            ++i;
        }
        VecMath.copymat(result, eigenVectors);
        return positiveDefiniteStatus;
    }

    public static final int positiveSemiDefinitizeWithUnitDiagonal(double[][] result, boolean[] whichColumnsAreImaginary, double[][] C) {
        double[][] B = new double[result.length][result.length];
        int positiveDefiniteStatus = VecMath.leftSqrtOfSymmetricMatrix(B, whichColumnsAreImaginary, C);
        if (positiveDefiniteStatus == -2) {
            VecMath.identitymat(result);
        } else if (whichColumnsAreImaginary == null) {
            VecMath.correlate(result, B);
        }
        return positiveDefiniteStatus;
    }

    public static final int positiveDefiniteness(double[][] M) {
        return VecMath.positiveSemiDefinitizeWithUnitDiagonal(null, null, M);
    }

    public static final void correlate(double[][] result, double[][] V) {
        int n = V.length;
        int n2 = 0;
        if (V.length != 0) {
            n2 = V[0].length;
        }
        double[][] normalizedV = new double[n][n2];
        VecMath.normalizeRows(normalizedV, V);
        VecMath.mxm(result, normalizedV, VecMath.transpose(normalizedV));
    }

    public static final void normalizeRows(double[][] result, double[][] M) {
        int n = M.length;
        int i = 0;
        while (i < n) {
            VecMath.normalize(result[i], M[i]);
            ++i;
        }
    }

    public static final void normalize(double[] result, double[] v) {
        double len = VecMath.norm(v);
        VecMath.vxs(result, v, len == 0.0 ? 1.0 : 1.0 / len);
    }

    public static final String toString(boolean[] v) {
        if (v == null) {
            return "(null)";
        }
        int n = v.length;
        String result = "<";
        int i = 0;
        while (i < n) {
            result = result + v[i];
            if (i < n - 1) {
                result = result + ',';
            }
            ++i;
        }
        result = result + '>';
        return result;
    }

    public static final String toString(int[] v) {
        if (v == null) {
            return "(null)";
        }
        int n = v.length;
        String result = "<";
        int i = 0;
        while (i < n) {
            result = result + v[i];
            if (i < n - 1) {
                result = result + ',';
            }
            ++i;
        }
        result = result + '>';
        return result;
    }

    public static final String toString(double[] v) {
        if (v == null) {
            return "(null)";
        }
        int n = v.length;
        String result = "<";
        int i = 0;
        while (i < n) {
            result = result + v[i];
            if (i < n - 1) {
                result = result + ',';
            }
            ++i;
        }
        result = result + '>';
        return result;
    }

    public static final String toString(Object[] v) {
        if (v == null) {
            return "(null)";
        }
        int n = v.length;
        String result = "<";
        int i = 0;
        while (i < n) {
            result = result + v[i];
            if (i < n - 1) {
                result = result + ',';
            }
            ++i;
        }
        result = result + '>';
        return result;
    }

    public static final String toString(double[][] m) {
        return Arrays.toStringNonCompact(m, "", "    ");
    }

    public static final String toString(int[][] m) {
        return Arrays.toStringNonCompact(m, "", "    ");
    }

    public static final String toString(int[][][] m, String bigSep, String littleSep) {
        if (m == null) {
            return "(null)";
        }
        String result = "";
        int nLayers = m.length;
        int iLayer = 0;
        while (iLayer < nLayers) {
            int nRows = m[iLayer].length;
            int iRow = 0;
            while (iRow < nRows) {
                result = result + "    [";
                int nCols = m[iLayer][iRow].length;
                int iCol = 0;
                while (iCol < nCols) {
                    result = result + m[iLayer][iRow][iCol];
                    if (iCol + 1 < nCols) {
                        result = result + ' ';
                    }
                    ++iCol;
                }
                result = result + ']';
                if (iRow + 1 < nRows) {
                    result = result + littleSep;
                }
                ++iRow;
            }
            if (iLayer + 1 < nLayers) {
                result = result + bigSep;
            }
            ++iLayer;
        }
        return result;
    }

    public static final String toString(int[][][] m) {
        return VecMath.toString(m, "\n\n", "\n");
    }

    public static final double[] vpv(double[] v0, double[] v1) {
        double[] result = new double[v0.length];
        VecMath.vpv(result, v0, v1);
        return result;
    }

    public static final int[] vpv(int[] v0, int[] v1) {
        int[] result = new int[v0.length];
        VecMath.vpv(result, v0, v1);
        return result;
    }

    public static final double[] sxv(double s, double[] v) {
        double[] result = new double[v.length];
        VecMath.sxv(result, s, v);
        return result;
    }

    public static final int[] sxv(int s, int[] v) {
        int[] result = new int[v.length];
        VecMath.sxv(result, s, v);
        return result;
    }

    public static final double[] xv2(double[] v) {
        double[] result = new double[2];
        VecMath.xv2(result, v);
        return result;
    }

    public static final double[] vmv(double[] v0, double[] v1) {
        double[] result = new double[v0.length];
        VecMath.vmv(result, v0, v1);
        return result;
    }

    public static final int[][] mmv(int[][] M, int[] v) {
        int[][] result = new int[M.length][v.length];
        VecMath.mmv(result, M, v);
        return result;
    }

    public static final double[][] mmv(double[][] M, double[] v) {
        double[][] result = new double[M.length][v.length];
        VecMath.mmv(result, M, v);
        return result;
    }

    public static final double[] lerp(double[] p0, double[] p1, double t) {
        double[] result = new double[p0.length];
        VecMath.lerp(result, p0, p1, t);
        return result;
    }

    public static final double[] bary(double[] p0, double[] p1, double t1, double[] p2, double t2) {
        double[] result = new double[p0.length];
        VecMath.bary(result, p0, p1, t1, p2, t2);
        return result;
    }

    public static final double[] zerovec(int dim) {
        double[] result = new double[dim];
        VecMath.zerovec(result);
        return result;
    }

    public static final double[] fillvec(int dim, double s) {
        double[] result = new double[dim];
        VecMath.fillvec(result, s);
        return result;
    }

    public static final int[] fillvec(int dim, int s) {
        int[] result = new int[dim];
        VecMath.fillvec(result, s);
        return result;
    }

    public static final boolean[] fillvec(int dim, boolean s) {
        boolean[] result = new boolean[dim];
        VecMath.fillvec(result, s);
        return result;
    }

    public static final double[][] fillmat(int dim0, int dim1, double s) {
        double[][] result = new double[dim0][dim1];
        VecMath.fillmat(result, s);
        return result;
    }

    public static final double[] sum(double[][] array) {
        if (array.length == 0) {
            return null;
        }
        double[] result = new double[array[0].length];
        VecMath.sum(result, array);
        return result;
    }

    public static final double[] average(double[][] array) {
        if (array.length == 0) {
            return null;
        }
        double[] result = new double[array[0].length];
        VecMath.average(result, array);
        return result;
    }

    public static final double[] averageIndexed(int[][] inds, double[][] array) {
        if (array.length == 0) {
            return null;
        }
        double[] result = new double[array[0].length];
        VecMath.averageIndexed(result, inds, array);
        return result;
    }

    public static final double[][] bboxIndexed(double[][] array, Object inds) {
        if (array.length == 0) {
            return null;
        }
        double[][] result = new double[2][array[0].length];
        VecMath.bboxIndexed(result, array, inds);
        return result;
    }

    public static final double[][] bboxUniform(double[][] array) {
        if (array.length == 0) {
            return null;
        }
        double[][] result = new double[2][array[0].length];
        VecMath.bboxUniform(result, array);
        return result;
    }

    public static final double[][] bbox(double[][] array) {
        if (array.length == 0) {
            return null;
        }
        double[][] result = new double[2][array[0].length];
        VecMath.bbox(result, array);
        return result;
    }

    public static final double[][] bboxIntersect(double[][] bbox0, double[][] bbox1) {
        double[][] result = new double[2][bbox0[0].length];
        VecMath.bboxIntersect(result, bbox0, bbox1);
        return result;
    }

    public static final double[][] bboxUnion(double[][] bbox0, double[][] bbox1) {
        double[][] result = new double[2][bbox0[0].length];
        VecMath.bboxUnion(result, bbox0, bbox1);
        return result;
    }

    public static final double[][] submat(double[][] M, int[] inds) {
        double[][] result = new double[inds.length][inds.length];
        VecMath.submat(result, M, inds);
        return result;
    }

    public static final double[][] identitymat(int n) {
        double[][] result = new double[n][n];
        VecMath.identitymat(result);
        return result;
    }

    public static final double[][] identitymat(int n, int m) {
        double[][] result = new double[n][m];
        VecMath.identitymat(result);
        return result;
    }

    public static final double[][] transpose(double[][] M) {
        int n = 0;
        if (M.length != 0) {
            n = M[0].length;
        }
        double[][] result = new double[n][M.length];
        VecMath.transpose(result, M);
        return result;
    }

    public static final double[][] copymat(double[][] M) {
        int n = M.length;
        int n2 = 0;
        if (M.length != 0) {
            n2 = M[0].length;
        }
        double[][] result = new double[n][n2];
        VecMath.copymat(result, M);
        return result;
    }

    public static final boolean[] copyvec(boolean[] v) {
        boolean[] result = new boolean[v.length];
        VecMath.copyvec(result, v);
        return result;
    }

    public static final int[] copyvec(int[] v) {
        int[] result = new int[v.length];
        VecMath.copyvec(result, v);
        return result;
    }

    public static final double[] copyvec(double[] v) {
        double[] result = new double[v.length];
        VecMath.copyvec(result, v);
        return result;
    }

    public static final double[] getcolumn(double[][] M, int iCol) {
        double[] result = new double[M.length];
        VecMath.getcolumn(result, M, iCol);
        return result;
    }

    public static final double[][] mxm(double[][] m0, double[][] m1) {
        int n = m0.length;
        int dotLength = m1.length;
        int n2 = 0;
        if (dotLength != 0) {
            n2 = m1[0].length;
        }
        int m = n2;
        int n3 = 0;
        if (m0.length != 0) {
            n3 = m0[0].length;
        }
        if (dotLength != n3) {
            if (dotLength != m0[0].length + 1) {
                throw new Error("Assumption failed at VecMath.prejava(2192): dotLength == m0[0].length+1");
            }
            n = dotLength;
            m = m0[0].length;
        }
        double[][] result = new double[n][m];
        VecMath.mxm(result, m0, m1);
        return result;
    }

    public static final int[][] mxm(int[][] m0, int[][] m1) {
        int n = m0.length;
        int dotLength = m1.length;
        int n2 = 0;
        if (dotLength != 0) {
            n2 = m1[0].length;
        }
        int m = n2;
        int[][] result = new int[n][m];
        VecMath.mxm(result, m0, m1);
        return result;
    }

    public static final double[] sxvpsxv(double s0, double[] v0, double s1, double[] v1) {
        double[] result = new double[v0.length];
        VecMath.sxvpsxv(result, s0, v0, s1, v1);
        return result;
    }

    public static final double[][] mxs(double[][] M, double s) {
        int n = M.length;
        int n2 = 0;
        if (M.length != 0) {
            n2 = M[0].length;
        }
        double[][] result = new double[n][n2];
        VecMath.mxs(result, M, s);
        return result;
    }

    public static final double[] vxs(double[] v, double s) {
        double[] result = new double[v.length];
        VecMath.vxs(result, v, s);
        return result;
    }

    public static final double[] normalize(double[] v) {
        double[] result = new double[v.length];
        VecMath.normalize(result, v);
        return result;
    }

    public static final double[] vxm(double[] v, double[][] M) {
        int n = 0;
        if (M.length != 0) {
            n = M[0].length;
        }
        double[] result = new double[n];
        VecMath.vxm(result, v, M);
        return result;
    }

    public static final double[] mxv(double[][] M, double[] v) {
        double[] result = new double[M.length];
        VecMath.mxv(result, M, v);
        return result;
    }

    public static final double[] vpsxv(double[] v0, double s1, double[] v1) {
        double[] result = new double[v0.length];
        VecMath.vpsxv(result, v0, s1, v1);
        return result;
    }

    public static final int[] vpsxv(int[] v0, int s1, int[] v1) {
        int[] result = new int[v0.length];
        VecMath.vpsxv(result, v0, s1, v1);
        return result;
    }

    public static final double[][] mpv(double[][] m, double[] v) {
        int n = m.length;
        int n2 = 0;
        if (m.length != 0) {
            n2 = m[0].length;
        }
        double[][] result = new double[n][n2];
        VecMath.mpv(result, m, v);
        return result;
    }

    public static final int[][] mpv(int[][] m, int[] v) {
        int n = m.length;
        int n2 = 0;
        if (m.length != 0) {
            n2 = m[0].length;
        }
        int[][] result = new int[n][n2];
        VecMath.mpv(result, m, v);
        return result;
    }

    public static final double[][] invertmat(double[][] M) {
        int n = M.length;
        int n2 = 0;
        if (M.length != 0) {
            n2 = M[0].length;
        }
        double[][] result = new double[n][n2];
        VecMath.invertmat(result, M);
        return result;
    }

    public static final double[] invmxv(double[][] M, double[] v) {
        double[] result = new double[M.length];
        VecMath.invmxv(result, M, v);
        return result;
    }

    public static final double[] vxv3(double[] v1, double[] v2) {
        double[] result = new double[3];
        VecMath.vxv3(result, v1, v2);
        return result;
    }

    public static final double[] crossprod(double[][] vectors) {
        double[] result = new double[vectors.length + 1];
        VecMath.crossprod(result, vectors);
        return result;
    }

    public static final double[] random(int dim) {
        double[] result = new double[dim];
        VecMath.random(result);
        return result;
    }

    public static final double[] random(int dim, Random generator) {
        double[] result = new double[dim];
        VecMath.random(result, generator);
        return result;
    }

    public static final double[][] makeRowTransMat(double[] translate) {
        double[][] result = new double[translate.length + 1][translate.length];
        VecMath.makeRowTransMat(result, translate);
        return result;
    }

    public static final double[][] makeRowTransMatInv(double[] translate) {
        double[][] result = new double[translate.length + 1][translate.length];
        VecMath.makeRowTransMatInv(result, translate);
        return result;
    }

    public static final double[][] makeRowTransMat(double x, double y, double z) {
        return VecMath.makeRowTransMat(new double[]{x, y, z});
    }

    public static final double[][] makeRowTransMatInv(double x, double y, double z) {
        return VecMath.makeRowTransMatInv(new double[]{x, y, z});
    }

    public static final double[][] makeRowScaleMat(double[] scale) {
        double[][] result = new double[scale.length + 1][scale.length];
        VecMath.makeRowScaleMat(result, scale);
        return result;
    }

    public static final double[][] makeRowScaleMat(double[] scale, double[] tiePointIn, double[] tiePointOut) {
        double[][] M = VecMath.makeRowScaleMat(scale);
        if (tiePointIn != null) {
            M = VecMath.mxm(VecMath.makeRowTransMatInv(tiePointIn), M);
        }
        if (tiePointOut != null) {
            M = VecMath.mxm(M, VecMath.makeRowTransMat(tiePointOut));
        }
        return M;
    }

    public static final double[][] makeRowScaleMat(double[] scale, double[] fixedPoint) {
        return VecMath.makeRowScaleMat(scale, fixedPoint, fixedPoint);
    }

    public static final double[][] makeRowScaleMat(int n, double scale, double[] tiePointIn, double[] tiePointOut) {
        return VecMath.makeRowScaleMat(VecMath.fillvec(n, scale), tiePointIn, tiePointOut);
    }

    public static final double[][] makeRowScaleMat(int n, double scale, double[] fixedPoint) {
        return VecMath.makeRowScaleMat(n, scale, fixedPoint, fixedPoint);
    }

    public static final double[][] makeRowScaleMat(int n, double scale) {
        return VecMath.makeRowScaleMat(n, scale, null, null);
    }

    public static final double[][] makeRowScaleMat(double x, double y, double z) {
        return VecMath.makeRowScaleMat(new double[]{x, y, z}, null, null);
    }

    public static final double[][] makeRowRotMat(int n, int fromAxis, int toAxis, double radians) {
        double[][] result = new double[n][n];
        VecMath.makeRowRotMat(result, fromAxis, toAxis, radians);
        return result;
    }

    public static final double[][] makeRowRotMat(int n, int fromAxis, int toAxis, double radians, double[] tiePointIn, double[] tiePointOut) {
        double[][] M = VecMath.makeRowRotMat(n, fromAxis, toAxis, radians);
        if (tiePointIn != null) {
            M = VecMath.mxm(VecMath.makeRowTransMatInv(tiePointIn), M);
        }
        if (tiePointOut != null) {
            M = VecMath.mxm(M, VecMath.makeRowTransMat(tiePointOut));
        }
        return M;
    }

    public static final double[][] makeRowRotMat(int n, int fromAxis, int toAxis, double radians, double[] fixedPoint) {
        return VecMath.makeRowRotMat(n, fromAxis, toAxis, radians, fixedPoint, fixedPoint);
    }

    public static final double[][] makeRowRotMat(double radians, double[][] fixedAxes) {
        int n;
        int nFixedAxes = fixedAxes.length;
        int n2 = n = nFixedAxes == 0 ? 2 : fixedAxes[0].length;
        if (nFixedAxes != n - 2) {
            throw new Error("Assertion failed at VecMath.prejava(2421): nFixedAxes == n-2");
        }
        if (n != 3) {
            throw new Error("Assumption failed at VecMath.prejava(2423): n == 3");
        }
        double[] fixedAxis = fixedAxes[0];
        double[][] rotPlusZToFixedAxis = new double[3][3];
        VecMath.copyvec(rotPlusZToFixedAxis[2], fixedAxis);
        VecMath.normalize(rotPlusZToFixedAxis[2], rotPlusZToFixedAxis[2]);
        int mini = VecMath.mini(fixedAxis);
        VecMath.zerovec(rotPlusZToFixedAxis[1]);
        rotPlusZToFixedAxis[1][mini] = 1.0;
        VecMath.vxv3(rotPlusZToFixedAxis[0], rotPlusZToFixedAxis[1], rotPlusZToFixedAxis[2]);
        VecMath.normalize(rotPlusZToFixedAxis[0], rotPlusZToFixedAxis[0]);
        VecMath.vxv3(rotPlusZToFixedAxis[1], rotPlusZToFixedAxis[2], rotPlusZToFixedAxis[0]);
        return VecMath.mxmxm(VecMath.transpose(rotPlusZToFixedAxis), VecMath.makeRowRotMat(3, 0, 1, radians), rotPlusZToFixedAxis);
    }

    public static final double[][] makeRowTiePointMat(double[][] inTiePoints, double[][] outTiePoints) {
        if (inTiePoints.length <= 0) {
            throw new Error("Assumption failed at VecMath.prejava(2462): inTiePoints.length > 0");
        }
        int dim = inTiePoints[0].length;
        if (inTiePoints.length != dim + 1) {
            throw new Error("Assumption failed at VecMath.prejava(2465): inTiePoints.length == dim+1");
        }
        if (outTiePoints[0].length != dim) {
            throw new Error("Assumption failed at VecMath.prejava(2466): outTiePoints[0].length == dim");
        }
        if (outTiePoints.length != dim + 1) {
            throw new Error("Assumption failed at VecMath.prejava(2467): outTiePoints.length == dim+1");
        }
        double[][] inPadded = VecMath.fillmat(dim + 1, dim + 1, 1.0);
        VecMath.copymat(inPadded, inTiePoints);
        double[][] Mpadded = VecMath.mxm(VecMath.invertmat(inPadded), outTiePoints);
        double[][] M = new double[dim + 1][dim];
        VecMath.copymat(M, Mpadded);
        return M;
    }

    public static final double[] flatten(double[][] M) {
        return (double[])Arrays.flatten(M, 0, 2);
    }

    public static final double[][] mxmxm(double[][] A, double[][] B, double[][] C) {
        return VecMath.mxm(VecMath.mxm(A, B), C);
    }

    public static final double[][] mxmxmxm(double[][] A, double[][] B, double[][] C, double[][] D) {
        return VecMath.mxm(VecMath.mxmxm(A, B, C), D);
    }

    public static final double[] vxmxm(double[] a, double[][] B, double[][] C) {
        return VecMath.vxm(VecMath.vxm(a, B), C);
    }

    public static final int permutationSignDestructive(int[] perm) {
        int sign = 1;
        int n = perm.length;
        int i = 0;
        while (i < n) {
            int permi = perm[i];
            while (permi != i) {
                int temp = perm[permi];
                perm[permi] = permi;
                permi = temp;
                sign = -sign;
            }
            ++i;
        }
        return sign;
    }

    public static final boolean isIdentityPerm(int[] perm) {
        int i = perm.length - 1;
        while (i >= 0) {
            if (perm[i] != i) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static final void identityperm(int[] perm) {
        int i = perm.length - 1;
        while (i >= 0) {
            perm[i] = i;
            --i;
        }
    }

    public static final int[] identityperm(int n) {
        int[] result = new int[n];
        VecMath.identityperm(result);
        return result;
    }

    public static final void randomperm(int[] perm, Random generator) {
        VecMath.identityperm(perm);
        Arrays.shuffle(perm, generator);
    }

    public static final int[] randomperm(int n, Random generator) {
        int[] result = new int[n];
        VecMath.randomperm(result, generator);
        return result;
    }

    public static final void invertperm(int[] result, int[] perm) {
        if (result == perm) {
            throw new Error("Assumption failed at VecMath.prejava(2558): result != perm");
        }
        int n = result.length <= perm.length ? result.length : perm.length;
        int i = n - 1;
        while (i >= 0) {
            result[perm[i]] = i;
            --i;
        }
    }

    public static final int[] invertperm(int[] perm) {
        int[] result = new int[perm.length];
        VecMath.invertperm(result, perm);
        return result;
    }

    public static final void composeluts(int[] result, int[] lut0, int[] lut1) {
        int n = lut1.length;
        if (n != result.length) {
            throw new Error("Assertion failed at VecMath.prejava(2580): n == result.length");
        }
        int i = 0;
        while (i < n) {
            result[i] = lut0[lut1[i]];
            ++i;
        }
    }

    public static final int[] composeluts(int[] lut0, int[] lut1) {
        int[] result = new int[lut1.length];
        VecMath.composeluts(result, lut0, lut1);
        return result;
    }

    static final void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: VecMath <maxdim> [<expr>]");
            System.exit(1);
        }
        int mindim = 2;
        int maxdim = Integer.parseInt(args[0]);
        int dim = mindim;
        while (dim <= maxdim) {
            double[][] M = new double[dim][dim];
            double[] a = new double[dim];
            double[] b = new double[dim];
            double[] x = new double[dim];
            int i = 0;
            while (i < dim) {
                VecMath.random(M[i]);
                ++i;
            }
            VecMath.random(a);
            VecMath.mxv(b, M, a);
            VecMath.invmxv(x, M, b);
            System.out.println("M =\n" + VecMath.toString(M));
            System.out.println("a = " + VecMath.toString(a));
            System.out.println("b = " + VecMath.toString(b));
            System.out.println("x = " + VecMath.toString(x));
            if (dim >= 1) {
                double[][] vectors = new double[dim - 1][dim];
                VecMath.identitymat(vectors);
                System.out.println("vectors =\n" + VecMath.toString(vectors));
                System.out.println("crossprod(vectors) = " + VecMath.toString(VecMath.crossprod(vectors)));
            }
            ++dim;
        }
    }

    private VecMath() {
    }
}

