/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DualApplet
extends Applet {
    static final int RADIUS_MEDIAN = 0;
    static final int RADIUS_MEAN = 1;
    static final int RADIUS_WEIGHTED_MEAN = 2;
    static final int RADIUS_MINMAX = 3;
    static final int RADIUS_EQUALIZE_AREAS = 4;
    static final int RADIUS_EQUALIZE_PERIMETERS = 5;
    static final int RADIUS_CONSTANT = 6;
    static final int RADIUS_POLAR_MEAN = 7;
    static final String[] radiusMethodStrings = new String[]{"Geom median dist to verts and edges", "Geom mean dist to verts and edges", "Angle-weighted geom mean dist to verts and edges", "sqrt(min*max dist)", "Equalize polygon areas", "Equalize polygon perimeters", "Manual (adjust by dragging circle with left-mouse)"};
    static final int INTEGRATE_CENTRAL_ANGLE = 0;
    static final int INTEGRATE_EXTERIOR_ANGLE = 1;
    static final int INTEGRATE_VERTICES = 2;
    static final int INTEGRATE_PATH_LENGTH = 3;
    static final int INTEGRATE_AREA = 4;
    static final String[] variableOfIntegrationStrings = new String[]{"Central Angle", "Exterior (Turning) Angle", "Vertices (sum)", "Path Length", "Area"};
    static final int SELECT_NOTHING = -1;
    static final int SELECT_PRIMAL = 0;
    static final int SELECT_DUAL = 1;
    static final int SELECT_RECIPROCATION_CIRCLE = 2;
    static final int SELECT_ARCS = 3;
    static final int FOLLOW_NOTHING = 0;
    static final int FOLLOW_CUSTOM_CG = 1;
    static final int FOLLOW_CUSTOM_CG_OF_CGS = 2;
    static final int FOLLOW_MY_PAPER_RECIPROCATION_CENTER = 3;
    static final int FOLLOW_ETC_CENTER = 4;
    static final String[] followMethodStrings = new String[]{"Manual", "Follow Custom CG", "Follow Custom CG of CGs", "Follow Canonical Reciprocation Center", "Follow ETC Center"};
    static int integrationIterationsPerRadian = 500;
    static int integrationIterationsPerArea = 1600;
    double[][] verts;
    double[] center;
    double mostRecentRadius;
    int radiusMethod;
    boolean weightCGofCGs;
    boolean showRobsCG;
    boolean showMyCG;
    boolean showMySpiralCG;
    boolean showMyPaperCG;
    boolean showMyFlatCG;
    boolean showVertsCG;
    boolean showEdgesCG;
    boolean showAreaCG;
    boolean showCurvatureCG;
    boolean showCustomCG;
    int whichCustomCGvector;
    int whichCustomCGscalar;
    VectorFunctionOfPositionAndNormal customCGfun;
    int whichCustomCGvariableOfIntegration;
    boolean showRadiusMaximizingPoints;
    boolean showDualAreaMinimizingPoints;
    boolean showHalfAngleArcsCG;
    boolean showETCcenter;
    int[] ETCindex;
    boolean showGrids;
    boolean gridIsOnion;
    boolean gridIsInverseMap;
    double[][][][] cachedGrids;
    int cachedGridRadiusMethod;
    double cachedGridRadiusIfConstant;
    double[][] cachedGridVerts;
    boolean cachedGridIsInverseMap;
    boolean showDirectionsGraph;
    boolean showRectified;
    boolean showRectifiedStructure;
    boolean showAngleChangeArcs;
    boolean showHalfAngleChangeArcs;
    boolean showInverses;
    boolean showHalfInverses;
    boolean showLogHalfInverses;
    int followMethod;
    double[] prevP;
    int selectedPointIndex;
    int selectedPolygon;
    double selectedArcAngle;
    MyCGComponents myCGComponents;
    MyCGComponents prevMyCGComponents;
    int eventVerbose;
    boolean doDoubleBuffer;
    int pickRadius;
    Image backBufferImage;
    boolean button1IsDown;
    boolean button2IsDown;
    boolean button3IsDown;
    boolean controlIsDown;
    Frame controlPanelFrame;

    private final String getParameterString(String paramName, String defaultValue) {
        String paramValueString = this.getParameter(paramName);
        if (paramValueString != null) {
            return paramValueString;
        }
        return defaultValue;
    }

    private final int getParameterInt(String paramName, int defaultValue) {
        String paramValueString = this.getParameter(paramName);
        if (paramValueString != null) {
            try {
                return Integer.decode(paramValueString);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return defaultValue;
    }

    private final boolean getParameterBoolean(String paramName, boolean defaultValue) {
        String paramValueString = this.getParameter(paramName);
        if (paramValueString != null) {
            try {
                int n = Integer.decode(paramValueString);
                boolean bl = false;
                if (n != 0) {
                    bl = true;
                }
                return bl;
            }
            catch (NumberFormatException e) {
                return paramValueString.equalsIgnoreCase("true") || paramValueString.equalsIgnoreCase("yes") || paramValueString.equalsIgnoreCase("t") || paramValueString.equalsIgnoreCase("y");
            }
        }
        return defaultValue;
    }

    public void init() {
        this.eventVerbose = this.getParameterInt("EventVerbose", 0);
        if (this.eventVerbose >= 1) {
            System.out.println("in init");
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out init");
        }
    }

    public void start() {
        if (this.eventVerbose >= 1) {
            System.out.println("in start");
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out start");
        }
    }

    public void stop() {
        if (this.eventVerbose >= 1) {
            System.out.println("in stop");
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out stop");
        }
    }

    public void destroy() {
        if (this.eventVerbose >= 1) {
            System.out.println("in destroy");
        }
        if (this.eventVerbose >= 1) {
            System.out.println("out destroy");
        }
    }

    private static final int getButton(MouseEvent e) {
        int mods = e.getModifiers();
        if ((mods & 8) != 0) {
            return 2;
        }
        if ((mods & 4) != 0) {
            return 3;
        }
        return 1;
    }

    private final int findClosestVertIndex(double[] p, double[][] verts, int n, double pickRadius) {
        int bestI = -1;
        double bestDistSqrd = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < n) {
            double[] v = i < verts.length ? verts[i] : this.center;
            double thisDistSqrd = VecMath.distsqrd(p, v);
            if (thisDistSqrd < bestDistSqrd) {
                bestDistSqrd = thisDistSqrd;
                bestI = i;
            }
            ++i;
        }
        return bestDistSqrd <= pickRadius * pickRadius ? bestI : -1;
    }

    private final int findClosestEdgeIndex(double[] p, double[][] verts) {
        double[] temp = new double[2];
        int bestI = -1;
        double bestDistSqrd = Double.POSITIVE_INFINITY;
        int n = verts.length;
        int i = 0;
        while (i < n) {
            double[] a = verts[i];
            double[] b = verts[(i + 1) % n];
            DualApplet.findClosestPointOnLine(temp, p, a, b, true);
            double thisDistSqrd = VecMath.distsqrd(p, temp);
            if (thisDistSqrd < bestDistSqrd) {
                bestDistSqrd = thisDistSqrd;
                bestI = i;
            }
            ++i;
        }
        return bestI;
    }

    private final double[][] findPointAndNormalFromPickAngle(double pickAngle, double[][] verts, double[][] dualVerts, double[] center) {
        int n = verts.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < 2) {
                double halfAng1;
                double halfAng0;
                double t;
                double eps;
                double[] w;
                double[] v1;
                double[] v0;
                if (j == 0) {
                    v0 = verts[i];
                    v1 = verts[(i + 1) % n];
                    w = dualVerts[i];
                } else {
                    v0 = dualVerts[i];
                    v1 = dualVerts[(i - 1 + n) % n];
                    w = verts[i];
                }
                double angW = DualApplet.adjustAngle(Math.atan2(w[1] - center[1], w[0] - center[0]), pickAngle);
                double ang0 = DualApplet.adjustAngle(Math.atan2(v0[1] - center[1], v0[0] - center[0]), angW);
                double ang1 = DualApplet.adjustAngle(Math.atan2(v1[1] - center[1], v1[0] - center[0]), angW);
                if (ang1 != ang0 && -(eps = 1.0E-6) <= (t = (pickAngle - (halfAng0 = (ang0 + angW) * 0.5)) / ((halfAng1 = (ang1 + angW) * 0.5) - halfAng0)) && t <= 1.0 + eps) {
                    double[][] result = new double[2][];
                    result[j] = VecMath.lerp(v0, v1, t);
                    result[1 - j] = w;
                    return result;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private final void zoom(double scaleX, double scaleY) {
        boolean bl = false;
        if (this.cachedGrids != null && this.cachedGridIsInverseMap == this.gridIsInverseMap && this.radiusMethod == this.cachedGridRadiusMethod && (this.radiusMethod != 6 || this.mostRecentRadius - this.cachedGridRadiusIfConstant <= 0.01 && this.cachedGridRadiusIfConstant - this.mostRecentRadius <= 0.01) && VecMath.equals(this.verts, this.cachedGridVerts, 0.0)) {
            bl = true;
        }
        boolean cacheIsGood = bl;
        int n = this.verts.length;
        int i = 0;
        while (i < n) {
            double[] dArray = this.verts[i];
            dArray[0] = dArray[0] * scaleX;
            double[] dArray2 = this.verts[i];
            dArray2[1] = dArray2[1] * scaleY;
            ++i;
        }
        this.center[0] = this.center[0] * scaleX;
        this.center[1] = this.center[1] * scaleY;
        this.mostRecentRadius *= Math.sqrt(scaleX * scaleY);
        if (scaleX == scaleY && cacheIsGood) {
            double scale = scaleX;
            VecMath.mxs(this.cachedGrids, this.cachedGrids, scale);
            VecMath.copymat(this.cachedGridVerts, this.verts);
            this.cachedGridRadiusIfConstant = this.mostRecentRadius;
            this.cachedGridIsInverseMap = this.gridIsInverseMap;
        }
    }

    private final void pan(double[] delta) {
        boolean bl = false;
        if (this.cachedGrids != null && this.cachedGridIsInverseMap == this.gridIsInverseMap && this.radiusMethod == this.cachedGridRadiusMethod && (this.radiusMethod != 6 || this.mostRecentRadius - this.cachedGridRadiusIfConstant <= 0.01 && this.cachedGridRadiusIfConstant - this.mostRecentRadius <= 0.01) && VecMath.equals(this.verts, this.cachedGridVerts, 0.0)) {
            bl = true;
        }
        boolean cacheIsGood = bl;
        VecMath.mpv(this.verts, this.verts, delta);
        VecMath.vpv(this.center, this.center, delta);
        if (cacheIsGood) {
            VecMath.mpv(this.cachedGrids, this.cachedGrids, delta);
            VecMath.copymat(this.cachedGridVerts, this.verts);
            this.cachedGridIsInverseMap = this.gridIsInverseMap;
        }
    }

    static void findClosestPointOnLine(double[] result, double[] p, double[] a, double[] b, boolean clamp) {
        double[] ab = VecMath.vmv(b, a);
        double[] ap = VecMath.vmv(p, a);
        double frac = VecMath.dot(ap, ab) / VecMath.dot(ab, ab);
        if (clamp) {
            frac = frac <= 0.0 ? 0.0 : (frac >= 1.0 ? 1.0 : frac);
        }
        VecMath.sxvpsxv(result, 1.0 - frac, a, frac, b);
    }

    static double distsqrdFromPointToLine(double[] p, double[] a, double[] b, boolean clamp) {
        double[] closest = new double[p.length];
        DualApplet.findClosestPointOnLine(closest, p, a, b, clamp);
        return VecMath.distsqrd(p, closest);
    }

    static double distFromPointToLine(double[] p, double[] a, double[] b, boolean clamp) {
        return Math.sqrt(DualApplet.distsqrdFromPointToLine(p, a, b, clamp));
    }

    static double calcReciprocationRadius(double[][] verts, double[] center, int radiusMethod, double mostRecentRadius) {
        double[][] dualVerts;
        if (radiusMethod == 6) {
            return mostRecentRadius;
        }
        if (radiusMethod == 2) {
            verts = DualApplet.removeDups(verts, 1.0E-6);
        }
        if (verts.length == 0) {
            return 1.0;
        }
        double exteriorAngleSum = 0.0;
        double windingAngleSum = 0.0;
        double[] logDists = VecMath.zerovec(2 * verts.length);
        double[] closest = new double[2];
        int i = 0;
        while (i < verts.length) {
            logDists[2 * i] = 0.5 * Math.log(VecMath.distsqrd(center, verts[i]));
            if (radiusMethod == 2) {
                double exteriorAngle = DualApplet.calcExteriorAngle(verts, i);
                int n = 2 * i;
                logDists[n] = logDists[n] * exteriorAngle;
                exteriorAngleSum += exteriorAngle;
            }
            DualApplet.findClosestPointOnLine(closest, center, verts[i], verts[(i + 1) % verts.length], false);
            logDists[2 * i + 1] = 0.5 * Math.log(VecMath.distsqrd(center, closest));
            if (radiusMethod == 2) {
                double windingAngle = DualApplet.calcEdgeWindingAngle(verts, center, i);
                int n = 2 * i + 1;
                logDists[n] = logDists[n] * windingAngle;
                windingAngleSum += windingAngle;
            }
            ++i;
        }
        SortStuff.sort(logDists);
        if (radiusMethod == 2) {
            double logProd = 0.0;
            int i2 = 0;
            while (i2 < logDists.length) {
                logProd += logDists[i2];
                ++i2;
            }
            return Math.exp(logProd / (exteriorAngleSum + windingAngleSum));
        }
        if (radiusMethod == 1) {
            double logProd = 0.0;
            int i3 = 0;
            while (i3 < logDists.length) {
                logProd += logDists[i3];
                ++i3;
            }
            return Math.exp(logProd / (double)logDists.length);
        }
        if (radiusMethod == 3) {
            return Math.exp(0.5 * (logDists[0] + logDists[logDists.length - 1]));
        }
        if (radiusMethod == 0) {
            if (logDists.length % 2 == 1) {
                return Math.exp(logDists[(logDists.length - 1) / 2]);
            }
            return Math.exp(0.5 * (logDists[logDists.length / 2 - 1] + logDists[logDists.length / 2]));
        }
        if (radiusMethod == 4) {
            dualVerts = DualApplet.calcReciprocalVerts(verts, center, 1.0);
            double primalArea = DualApplet.calcArea(verts);
            double dualArea = DualApplet.calcArea(dualVerts);
            return Math.pow(primalArea / dualArea, 0.25);
        }
        if (radiusMethod == 5) {
            dualVerts = DualApplet.calcReciprocalVerts(verts, center, 1.0);
            double primalPerimeter = DualApplet.calcPerimeter(verts);
            double dualPerimeter = DualApplet.calcPerimeter(dualVerts);
            return Math.pow(primalPerimeter / dualPerimeter, 0.5);
        }
        if (radiusMethod == 7) {
            return DualApplet.calcPolarMeanRadiusBalanced(center, verts);
        }
        throw new Error("Assertion failed at DualApplet.prejava(3017): false");
    }

    static double[][] calcReciprocalVerts(double[][] verts, double[] center, double radius) {
        int n = verts.length;
        int n2 = 0;
        if (verts.length != 0) {
            n2 = verts[0].length;
        }
        double[][] result = new double[n][n2];
        int i = 0;
        while (i < verts.length) {
            DualApplet.findClosestPointOnLine(result[i], center, verts[i], verts[(i + 1) % verts.length], false);
            double distSqrd = VecMath.distsqrd(center, result[i]);
            VecMath.lerp(result[i], center, result[i], radius * radius / distSqrd);
            ++i;
        }
        return result;
    }

    private static final double[][] calcRectifiedVerts(double[][] verts, double[][] dualVerts, double[] center) {
        int n = verts.length;
        int n2 = 0;
        if (verts.length != 0) {
            n2 = verts[0].length;
        }
        double[][] result = new double[2 * n][n2];
        int i = 0;
        while (i < n) {
            VecMath.vpvmv(result[2 * i], verts[i], dualVerts[i], center);
            VecMath.vpvmv(result[2 * i + 1], verts[(i + 1) % n], dualVerts[i], center);
            ++i;
        }
        return result;
    }

    private static final Arc[] calcInverses(double[][] verts, double[][] dualVerts, double[] reciprocationCenter, double reciprocationRadius, boolean doHalfInverses) {
        int n = verts.length;
        Arc[] arcs = new Arc[doHalfInverses ? 4 * n : 2 * n];
        double[] w0 = new double[2];
        double[] w1 = new double[2];
        double[] arcCenter = new double[2];
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < 2) {
                double[] v;
                if (j == 0) {
                    v = dualVerts[i];
                    VecMath.copyvec(w0, verts[i]);
                    VecMath.copyvec(w1, verts[(i + 1) % n]);
                } else {
                    v = verts[i];
                    VecMath.copyvec(w0, dualVerts[(i - 1 + n) % n]);
                    VecMath.copyvec(w1, dualVerts[i]);
                }
                VecMath.lerp(w0, reciprocationCenter, w0, reciprocationRadius * reciprocationRadius / VecMath.distsqrd(reciprocationCenter, w0));
                VecMath.lerp(w1, reciprocationCenter, w1, reciprocationRadius * reciprocationRadius / VecMath.distsqrd(reciprocationCenter, w1));
                double centerX = (v[0] + reciprocationCenter[0]) * 0.5;
                double centerY = (v[1] + reciprocationCenter[1]) * 0.5;
                double radius = VecMath.dist(reciprocationCenter, v) * 0.5;
                double dirV = Math.atan2(v[1] - reciprocationCenter[1], v[0] - reciprocationCenter[0]);
                double dirW0 = DualApplet.adjustAngle(Math.atan2(w0[1] - centerY, w0[0] - centerX), dirV);
                double dirW1 = DualApplet.adjustAngle(Math.atan2(w1[1] - centerY, w1[0] - centerX), dirV);
                if (!doHalfInverses) {
                    Arc arc = new Arc();
                    arc.centerX = centerX;
                    arc.centerY = centerY;
                    arc.radius = radius;
                    arc.ang0 = dirW0;
                    arc.ang1 = dirW1;
                    arcs[2 * i + j] = arc;
                } else {
                    int k = 0;
                    while (k < 2) {
                        double dirW;
                        double[] w;
                        if (k == 0) {
                            w = w0;
                            dirW = dirW0;
                        } else {
                            w = w1;
                            dirW = dirW1;
                        }
                        double Q = 1.0 + Math.sqrt(VecMath.distsqrd(reciprocationCenter, v) / VecMath.distsqrd(reciprocationCenter, w));
                        VecMath.bary(arcCenter, w, v, 0.5, reciprocationCenter, 0.5 * Q);
                        Arc arc = new Arc();
                        arc.centerX = arcCenter[0];
                        arc.centerY = arcCenter[1];
                        arc.radius = VecMath.dist(arcCenter, v);
                        arc.ang0 = DualApplet.adjustAngle(Math.atan2(v[1] - arc.centerY, v[0] - arc.centerX), dirW);
                        arc.ang1 = DualApplet.adjustAngle(Math.atan2(w[1] - arc.centerY, w[0] - arc.centerX), dirW);
                        arcs[4 * i + 2 * k + j] = arc;
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return arcs;
    }

    private static final Arc[] calcAngleChangeArcs(double[][] verts, double[][] dualVerts, double[] reciprocationCenter, double reciprocationRadius, boolean doHalfAngles) {
        double radius;
        int n = verts.length;
        double centerX = reciprocationCenter[0];
        double centerY = reciprocationCenter[1];
        Arc[] arcs = new Arc[2 * n];
        if (n == 0) {
            return arcs;
        }
        double prevCentralAngle = Math.atan2(verts[n - 1][1] - reciprocationCenter[1], verts[n - 1][0] - reciprocationCenter[0]);
        double prevExteriorAngle = Math.atan2(dualVerts[n - 1][1] - reciprocationCenter[1], dualVerts[n - 1][0] - reciprocationCenter[0]);
        double halfAngleSum = DualApplet.adjustAngle(prevCentralAngle, prevExteriorAngle) + 0.5 * (prevExteriorAngle - DualApplet.adjustAngle(prevCentralAngle, prevExteriorAngle));
        double d = radius = doHalfAngles ? (double)2 * reciprocationRadius : reciprocationRadius;
        if (!doHalfAngles) {
            centerX += 0.5 * radius * (Math.cos(prevCentralAngle) + Math.cos(prevExteriorAngle));
            centerY += 0.5 * radius * (Math.sin(prevCentralAngle) + Math.sin(prevExteriorAngle));
        }
        int i = 0;
        while (i < n) {
            arcs[2 * i] = new Arc();
            arcs[2 * i].radius = radius;
            arcs[2 * i].ang0 = doHalfAngles ? halfAngleSum : prevCentralAngle;
            double centralAngle = Math.atan2(verts[i][1] - reciprocationCenter[1], verts[i][0] - reciprocationCenter[0]);
            centralAngle = DualApplet.adjustAngle(centralAngle, prevCentralAngle);
            halfAngleSum += 0.5 * (centralAngle - prevCentralAngle);
            if (doHalfAngles) {
                arcs[2 * i].centerX = reciprocationCenter[0];
                arcs[2 * i].centerY = reciprocationCenter[1];
            } else {
                arcs[2 * i].centerX = reciprocationCenter[0] + radius * Math.cos(prevExteriorAngle);
                arcs[2 * i].centerY = reciprocationCenter[1] + radius * Math.sin(prevExteriorAngle);
            }
            arcs[2 * i].ang1 = doHalfAngles ? halfAngleSum : centralAngle;
            prevCentralAngle = centralAngle;
            arcs[2 * i + 1] = new Arc();
            arcs[2 * i + 1].radius = radius;
            arcs[2 * i + 1].ang0 = doHalfAngles ? halfAngleSum : prevExteriorAngle;
            double exteriorAngle = Math.atan2(dualVerts[i][1] - reciprocationCenter[1], dualVerts[i][0] - reciprocationCenter[0]);
            exteriorAngle = DualApplet.adjustAngle(exteriorAngle, prevExteriorAngle);
            halfAngleSum += 0.5 * (exteriorAngle - prevExteriorAngle);
            if (doHalfAngles) {
                arcs[2 * i + 1].centerX = reciprocationCenter[0];
                arcs[2 * i + 1].centerY = reciprocationCenter[1];
            } else {
                arcs[2 * i + 1].centerX = reciprocationCenter[0] + radius * Math.cos(prevCentralAngle);
                arcs[2 * i + 1].centerY = reciprocationCenter[1] + radius * Math.sin(prevCentralAngle);
            }
            arcs[2 * i + 1].ang1 = doHalfAngles ? halfAngleSum : exteriorAngle;
            prevExteriorAngle = exteriorAngle;
            ++i;
        }
        return arcs;
    }

    private static final double adjustAngle(double ang, double refAng) {
        while (ang <= refAng - Math.PI) {
            ang += Math.PI * 2;
        }
        while (ang > refAng + Math.PI) {
            ang -= Math.PI * 2;
        }
        return ang;
    }

    static double calcAngle(double[] start0, double[] end0, double[] start1, double[] end1) {
        double[] v0 = VecMath.vmv(end0, start0);
        double[] v1 = VecMath.vmv(end1, start1);
        VecMath.vxs(v0, v0, 1.0 / VecMath.norm(v0));
        VecMath.vxs(v1, v1, 1.0 / VecMath.norm(v1));
        double sinAngle = v0[0] * v1[1] - v0[1] * v1[0];
        double cosAngle = VecMath.dot(v0, v1);
        double angle = Math.atan2(sinAngle, cosAngle);
        return angle;
    }

    static void calcSpiralMoment(double[] result, double ang0, double ang1, double r0, double r1) {
        double ang = ang1 - ang0;
        double r = r1 - r0;
        double c0 = Math.cos(ang0);
        double s0 = Math.sin(ang0);
        result[0] = (Math.cos(ang) * (r * c0 + r1 * ang * s0) + Math.sin(ang) * (r1 * ang * c0 - r * s0) - (r * c0 + r0 * ang * s0)) / ang;
        result[1] = (-Math.cos(ang) * (ang * r1 * c0 - r * s0) + Math.sin(ang) * (r * c0 + ang * r1 * s0) + (ang * r0 * c0 - r * s0)) / ang;
    }

    static double calcExteriorAngle(double[][] verts, int i) {
        int n = verts.length;
        return DualApplet.calcAngle(verts[(i - 1 + n) % n], verts[i], verts[i], verts[(i + 1) % n]);
    }

    static double calcEdgeWindingAngle(double[][] verts, double[] center, int i) {
        int n = verts.length;
        return DualApplet.calcAngle(center, verts[i], center, verts[(i + 1) % n]);
    }

    static double[][] removeDups(double[][] verts, double eps) {
        double[][] scratch = new double[((double[][])verts).length][];
        int scratchlen = 0;
        int n = ((double[][])verts).length;
        int i = 0;
        while (i < n) {
            if (i == 0 || VecMath.distsqrd(verts[i], verts[(i - 1 + n) % n]) >= eps * eps) {
                scratch[scratchlen++] = verts[i];
            }
            ++i;
        }
        if (scratchlen >= 2 && VecMath.distsqrd(scratch[scratchlen - 1], scratch[0]) < eps * eps) {
            --scratchlen;
        }
        verts = new double[scratchlen][];
        i = 0;
        while (i < scratchlen) {
            verts[i] = scratch[i];
            ++i;
        }
        return verts;
    }

    static double[] calcMyReciprocationCenter(double[][] verts) {
        double initialDelta = 0.001;
        return Minimizer.minimize(new Minimizer.VectorFunction(verts){
            final /* synthetic */ double[][] val$verts;

            public final double apply(double[] v) {
                return VecMath.distsqrd(v, DualApplet.calcMyCG(this.val$verts, v, 100.0, false, null));
            }
            {
                this.val$verts = dArray;
            }
        }, VecMath.average(verts), initialDelta, 500);
    }

    static double[] calcMySpiralReciprocationCenter(double[][] verts, double[] initialGuess) {
        double initialDelta = 0.001;
        return Minimizer.minimize(new Minimizer.VectorFunction(verts){
            final /* synthetic */ double[][] val$verts;

            public final double apply(double[] v) {
                return VecMath.distsqrd(v, DualApplet.calcMySpiralCG(this.val$verts, v, 100.0));
            }
            {
                this.val$verts = dArray;
            }
        }, initialGuess, initialDelta, 1000);
    }

    static double[] calcMyPaperReciprocationCenter(double[][] verts, double[] initialGuess) {
        double initialDelta = 0.001;
        return Minimizer.minimize(new Minimizer.VectorFunction(verts){
            final /* synthetic */ double[][] val$verts;

            public final double apply(double[] v) {
                double[][] dualVerts = DualApplet.calcReciprocalVerts(this.val$verts, v, 100.0);
                return VecMath.distsqrd(v, DualApplet.calcMyPaperCG(this.val$verts, dualVerts, v, 100.0, true));
            }
            {
                this.val$verts = dArray;
            }
        }, initialGuess, initialDelta, 1000);
    }

    static double calcReferenceNumber(double[][] verts, double[] center) {
        if (verts.length != 3) {
            return Double.NaN;
        }
        double kx = DualApplet.distFromPointToLine(center, verts[0], verts[1], false);
        System.out.println("kx = " + kx);
        System.out.println("kx/10 = " + kx / 10.0);
        return kx / 10.0;
    }

    private static final double[][] makeTriangleWithGivenSides(double a, double b, double c) {
        double cosB = (a * a + c * c - b * b) / ((double)2 * a * c);
        double sinB = Math.sqrt(1.0 - cosB * cosB);
        double[][] result = new double[3][2];
        VecMath.zerovec(result[0]);
        result[1][0] = a;
        result[1][1] = 0.0;
        result[2][0] = c * cosB;
        result[2][1] = c * sinB;
        System.out.print("a = " + a + ", ");
        System.out.print("b = " + b + ", ");
        System.out.println("c = " + c);
        System.out.print("cosB = " + cosB + ", ");
        System.out.println("sinB = " + sinB);
        System.out.println("result =\n" + VecMath.toString(result));
        System.out.println("VecMath.dist(result[0],result[1]) = " + VecMath.dist(result[0], result[1]));
        System.out.println("VecMath.dist(result[1],result[2]) = " + VecMath.dist(result[1], result[2]));
        System.out.println("VecMath.dist(result[2],result[0]) = " + VecMath.dist(result[2], result[0]));
        return result;
    }

    private static final double[][] makeRegularPolygon(int nVerts, double circumRadius) {
        double[][] verts = new double[nVerts][2];
        int i = 0;
        while (i < nVerts) {
            double angle = -1.5707963267948966 + ((double)i + 0.5) * (Math.PI * 2 / (double)nVerts);
            verts[i][0] = circumRadius * Math.cos(angle);
            verts[i][1] = circumRadius * Math.sin(angle);
            double[] dArray = verts[i];
            dArray[1] = dArray[1] * -1.0;
            ++i;
        }
        Arrays.reverse(verts, verts);
        return verts;
    }

    static double[] calcMyCG(double[][] verts, double[] center, double radius, boolean verbose, MyCGComponents components) {
        int n;
        if (verbose) {
            System.out.println("---------------------");
        }
        if ((n = (verts = DualApplet.removeDups(verts, 1.0E-6)).length) < 3) {
            return DualApplet.calcEdgesAvg(verts);
        }
        verts = VecMath.mmv(verts, center);
        VecMath.mxs(verts, verts, 1.0 / radius);
        if (components != null) {
            VecMath.copymat(components.verts, verts);
        }
        double[] zero = VecMath.zerovec(verts[0].length);
        double[][] dualVerts = DualApplet.calcReciprocalVerts(verts, zero, 1.0);
        int i = 0;
        while (i < n) {
            VecMath.vxs(dualVerts[i], dualVerts[i], 1.0 / VecMath.normsqrd(dualVerts[i]));
            ++i;
        }
        double[] result = VecMath.copyvec(zero);
        double[] unitV0 = new double[2];
        double[] unitV1 = new double[2];
        double[] unitBisector = new double[2];
        int i2 = 0;
        while (i2 < 2 * n) {
            double[] v1;
            double[] v0;
            if (i2 % 2 == 0) {
                v0 = dualVerts[(i2 / 2 - 1 + n) % n];
                v1 = verts[i2 / 2];
            } else {
                v0 = verts[i2 / 2];
                v1 = dualVerts[i2 / 2];
            }
            double lenV0 = VecMath.norm(v0);
            double lenV1 = VecMath.norm(v1);
            VecMath.vxs(unitV0, v0, 1.0 / lenV0);
            VecMath.vxs(unitV1, v1, 1.0 / lenV1);
            VecMath.vpv(unitBisector, unitV0, unitV1);
            VecMath.vxs(unitBisector, unitBisector, 1.0 / VecMath.norm(unitBisector));
            double angle = VecMath.angleBetweenUnitVectors(unitV0, unitV1);
            double centroidLength = angle == 0.0 ? 0.0 : Math.sin(angle * 0.5) / (angle * 0.5);
            double logMeanDist = 0.5 * Math.log(lenV0 * lenV1);
            if (verbose) {
                System.out.println(i2 + ": (" + Math.log(lenV0) + " + " + Math.log(lenV1) + ")/2 * " + angle + " * " + centroidLength + " * (" + unitBisector[0] + ", " + unitBisector[1] + ')');
            }
            if (components != null) {
                components.logMeanDists[i2] = logMeanDist;
                components.angles[i2] = angle;
                components.centroidLengths[i2] = centroidLength;
                VecMath.copyvec(components.centroidDirs[i2], unitBisector);
            }
            VecMath.vpsxv(result, result, logMeanDist * angle * centroidLength, unitBisector);
            ++i2;
        }
        VecMath.vxs(result, result, 1.0 / (double)(2 * n));
        if (verbose) {
            System.out.println("result = (" + result[0] + ',' + result[1] + ')');
        }
        VecMath.vxs(result, result, radius);
        VecMath.vpv(result, result, center);
        return result;
    }

    static double[] calcMyPaperCG(double[][] primalVerts, double[][] dualVerts, double[] center, double radius, boolean symmetric) {
        double[] result = VecMath.zerovec(2);
        double[] unitW = new double[2];
        double[] perpUnitW = new double[2];
        double[] centerToV0 = new double[2];
        double[] centerToV1 = new double[2];
        double angleSum = 0.0;
        int n = primalVerts.length;
        int i = 0;
        while (i < n) {
            double[] v0 = primalVerts[i];
            double[] v1 = primalVerts[(i + 1) % n];
            double[] w = dualVerts[i];
            angleSum += DualApplet.calcAngle(center, v0, center, v1);
            VecMath.vmv(unitW, w, center);
            double r = 1.0 / VecMath.norm(unitW);
            VecMath.vxs(unitW, unitW, r);
            r *= radius * radius;
            VecMath.xv2(perpUnitW, unitW);
            double distV0 = VecMath.dist(center, v0);
            double distV1 = VecMath.dist(center, v1);
            VecMath.vmv(centerToV0, v0, center);
            VecMath.vmv(centerToV1, v1, center);
            double signedDistClosestToV0 = VecMath.vxv2(unitW, centerToV0);
            double signedDistClosestToV1 = VecMath.vxv2(unitW, centerToV1);
            VecMath.vpsxv(result, result, Math.log((distV1 - signedDistClosestToV1) / (distV0 - signedDistClosestToV0)), unitW);
            ++i;
        }
        VecMath.vxs(result, result, 1.0 / angleSum);
        VecMath.vpsxv(result, center, radius, result);
        if (symmetric) {
            VecMath.upshift(dualVerts, dualVerts);
            double[] temp = DualApplet.calcMyPaperCG(dualVerts, primalVerts, center, radius, false);
            VecMath.downshift(dualVerts, dualVerts);
            VecMath.vpvmv(result, center, result, temp);
        }
        return result;
    }

    static double[] calcMyPaperF(double[][] verts, double[] center, double radius) {
        double[] F;
        System.out.println("in calcMyPaperF");
        double[] golden = DualApplet.calcMyPaperCG(verts, DualApplet.calcReciprocalVerts(verts, center, radius), center, radius, true);
        VecMath.vmv(golden, golden, center);
        VecMath.vxs(golden, golden, 1.0 / radius);
        VecMath.vxs(golden, golden, Math.PI * 2);
        int n = verts.length;
        if (n != 3) {
            return golden;
        }
        boolean dangerous = false;
        int i = 0;
        while (i < n) {
            double angle = DualApplet.calcAngle(verts[i], verts[(i + 1) % n], verts[i], verts[(i - 1 + n) % n]);
            if (!(0.0 < angle) || !(angle < Math.PI)) {
                System.out.println("DANGEROUS!");
                dangerous = true;
            }
            ++i;
        }
        double[][] basis = new double[][]{VecMath.normalize(VecMath.vmv(verts[1], verts[0])), VecMath.xv2(VecMath.normalize(VecMath.vmv(verts[1], verts[0])))};
        double[][] xformedVerts = new double[][]{VecMath.vxs(VecMath.mxv(basis, VecMath.vmv(verts[0], verts[0])), 1.0 / VecMath.dist(verts[0], verts[1])), VecMath.vxs(VecMath.mxv(basis, VecMath.vmv(verts[1], verts[0])), 1.0 / VecMath.dist(verts[0], verts[1])), VecMath.vxs(VecMath.mxv(basis, VecMath.vmv(verts[2], verts[0])), 1.0 / VecMath.dist(verts[0], verts[1]))};
        double[] xformedCenter = VecMath.vxs(VecMath.mxv(basis, VecMath.vmv(center, verts[0])), 1.0 / VecMath.dist(verts[0], verts[1]));
        System.out.println("xformedVerts =\n" + VecMath.toString(xformedVerts));
        if (xformedVerts[0][0] != 0.0) {
            throw new Error("Assertion failed at DualApplet.prejava(3776): xformedVerts[0][0] == 0.");
        }
        if (xformedVerts[0][1] != 0.0) {
            throw new Error("Assertion failed at DualApplet.prejava(3777): xformedVerts[0][1] == 0.");
        }
        if (!(xformedVerts[1][0] - 1.0 <= 1.0E-9) || !(1.0 - xformedVerts[1][0] <= 1.0E-9)) {
            throw new Error("Assertion failed at DualApplet.prejava(3778): EQ(xformedVerts[1][0], 1., 1e-9)");
        }
        if (!(xformedVerts[1][1] <= 1.0E-9) || !(0.0 - xformedVerts[1][1] <= 1.0E-9)) {
            throw new Error("Assertion failed at DualApplet.prejava(3779): EQ(xformedVerts[1][1], 0., 1e-9)");
        }
        double x2 = xformedVerts[2][0];
        double y2 = xformedVerts[2][1];
        double x = xformedCenter[0];
        double y = xformedCenter[1];
        if (x2 != 0.5 || x != 0.5) {
            double v1xv2 = y2 * (1.0 - x) - (1.0 - x2) * y;
            double v2xv0 = -x2 * y + y2 * x;
            double e12 = Math.sqrt((1.0 - x2) * (1.0 - x2) + y2 * y2);
            double e20 = Math.sqrt(x2 * x2 + y2 * y2);
            double U0 = Math.sqrt(x * x + y * y);
            double U1 = Math.sqrt((1.0 - x) * (1.0 - x) + y * y);
            double U2 = Math.sqrt((x2 - x) * (x2 - x) + (y2 - y) * (y2 - y));
            double _U0 = e12 / v1xv2;
            double _U1 = e20 / v2xv0;
            double _U2 = 1.0 / y;
            double S02 = (y2 * (y2 - y) - (1.0 - x2) * (x2 - x)) / e12;
            double S01 = (-y2 * y - (1.0 - x2) * (1.0 - x)) / e12;
            double S10 = (y2 * y + x2 * x) / e20;
            double S12 = (-y2 * (y2 - y) - x2 * (x2 - x)) / e20;
            double S20 = -x;
            double S21 = 1.0 - x;
            double _S02 = x / y / U0;
            double _S01 = (-x2 * x - y2 * y) / (v2xv0 * U0);
            double _S10 = ((1.0 - x2) * (1.0 - x) + y2 * y) / (v1xv2 * U1);
            double _S12 = (1.0 - x) / -y / U1;
            double _S20 = ((1.0 - x2) * (x2 - x) - y2 * (y2 - y)) / (v1xv2 * U2);
            double _S21 = (x2 * (x2 - x) + y2 * (y2 - y)) / (v2xv0 * U2);
            double[][] dArrayArray = new double[6][];
            dArrayArray[0] = new double[]{y2 / e12, (1.0 - x2) / e12};
            dArrayArray[1] = new double[]{-y2 / e20, x2 / e20};
            double[] dArray = new double[2];
            dArray[1] = -1.0;
            dArrayArray[2] = dArray;
            dArrayArray[3] = new double[]{-x, -y};
            dArrayArray[4] = new double[]{1.0 - x, -y};
            dArrayArray[5] = new double[]{x2 - x, y2 - y};
            double[][] vecs = dArrayArray;
            double[] coeffs = new double[]{Math.log((U2 - S02) / (U1 - S01)), Math.log((U0 - S10) / (U2 - S12)), Math.log((U1 - S21) / (U0 - S20)), -Math.log((_U2 - _S02) / (_U1 - _S01)) / U0, -Math.log((_U0 - _S10) / (_U2 - _S12)) / U1, -Math.log((_U1 - _S21) / (_U0 - _S20)) / U2};
            F = VecMath.vxm(coeffs, vecs);
        } else {
            System.out.println("Using isosceles simplification");
            double e = Math.sqrt(0.25 + y2 * y2);
            double U = Math.sqrt(0.25 + y * y);
            F = new double[]{0.5, 1.0 / e * Math.log((y2 - y) / (U * e + 0.25 + y2 * y) * (e - y2)) + (double)2 * y / U * Math.log((y2 - y) / (U * e + 0.25 + y2 * y) * (U - 0.5) / y / (double)2) + Math.log(1.0 + 1.0 / (U - 0.5)) + Math.log((e + y2) / (e - y2))};
        }
        System.out.println("F = " + VecMath.toString(F));
        F = VecMath.vxm(F, basis);
        System.out.println("F = " + VecMath.toString(F));
        double[] G = golden;
        System.out.println("G = " + VecMath.toString(G));
        if (dangerous) {
            System.out.println("DANGEROUS!");
        }
        System.out.println("out calcMyPaperF");
        return golden;
    }

    static double[] calcMySpiralCG(double[][] primalVerts, double[] center, double radius) {
        double[][] dualVerts = DualApplet.calcReciprocalVerts(primalVerts, center, radius);
        double[] result = VecMath.zerovec(2);
        double[] temp = new double[2];
        int n = primalVerts.length;
        int i = 0;
        while (i < n) {
            double[] v = primalVerts[i];
            double angV = Math.atan2(v[1] - center[1], v[0] - center[0]);
            int j = 0;
            while (j < 2) {
                double[] w = dualVerts[j == 0 ? i : (i - 1 + n) % n];
                double angW = DualApplet.adjustAngle(Math.atan2(w[1] - center[1], w[0] - center[0]), angV);
                double rV = 0.5 * Math.log(VecMath.distsqrd(center, v) / (radius * radius));
                double rW = 0.5 * Math.log(radius * radius / VecMath.distsqrd(center, w));
                DualApplet.calcSpiralMoment(temp, angV, angW, rV, rW);
                if (j == 0) {
                    VecMath.vmv(result, result, temp);
                } else {
                    VecMath.vpv(result, result, temp);
                }
                ++j;
            }
            ++i;
        }
        VecMath.vpsxv(result, center, radius, result);
        return result;
    }

    static double[] calcMyFlatCG(double[][] verts, double[] center, double radius) {
        int n = (verts = DualApplet.removeDups(verts, 1.0E-6)).length;
        if (n < 3) {
            return DualApplet.calcEdgesAvg(verts);
        }
        verts = VecMath.mmv(verts, center);
        VecMath.mxs(verts, verts, 1.0 / radius);
        double[] zero = VecMath.zerovec(verts[0].length);
        double[][] dualVerts = DualApplet.calcReciprocalVerts(verts, zero, 1.0);
        double[] result = VecMath.copyvec(zero);
        double[] edgeUnitNormal = new double[2];
        int i = 0;
        while (i < n) {
            double edgeLength = VecMath.dist(verts[i], verts[(i + 1) % n]);
            double edgeDist = 1.0 / VecMath.norm(dualVerts[i]);
            VecMath.vxs(edgeUnitNormal, dualVerts[i], edgeDist);
            VecMath.vpsxv(result, result, Math.log(edgeDist) * edgeLength, edgeUnitNormal);
            ++i;
        }
        VecMath.vxs(result, result, radius);
        VecMath.vpv(result, result, center);
        return result;
    }

    static void printStuffAboutMyCG(MyCGComponents prev, MyCGComponents these) {
        if (prev == null || these == null || prev.n != these.n) {
            return;
        }
        int n = these.n;
        double[] prevResult = VecMath.zerovec(2);
        double[] middResult = VecMath.zerovec(2);
        double[] thisResult = VecMath.zerovec(2);
        double[][] prevTerms = new double[2 * n][2];
        double[][] middTerms = new double[2 * n][2];
        double[][] thisTerms = new double[2 * n][2];
        int i = 0;
        while (i < 2 * n) {
            System.out.println("" + i);
            VecMath.sxv(prevTerms[i], prev.logMeanDists[i] * prev.angles[i] * prev.centroidLengths[i], prev.centroidDirs[i]);
            VecMath.sxv(middTerms[i], these.logMeanDists[i] * prev.angles[i] * prev.centroidLengths[i], prev.centroidDirs[i]);
            VecMath.sxv(thisTerms[i], these.logMeanDists[i] * these.angles[i] * these.centroidLengths[i], these.centroidDirs[i]);
            System.out.println("    prevTerms[" + i + "] = " + VecMath.toString(prevTerms[i]));
            System.out.println("    middTerms[" + i + "] = " + VecMath.toString(middTerms[i]));
            System.out.println("    thisTerms[" + i + "] = " + VecMath.toString(thisTerms[i]));
            VecMath.vpv(prevResult, prevResult, prevTerms[i]);
            VecMath.vpv(middResult, middResult, middTerms[i]);
            VecMath.vpv(thisResult, thisResult, thisTerms[i]);
            ++i;
        }
        VecMath.vxs(prevResult, prevResult, 1.0 / (double)(2 * n));
        VecMath.vxs(middResult, middResult, 1.0 / (double)(2 * n));
        VecMath.vxs(thisResult, thisResult, 1.0 / (double)(2 * n));
        System.out.println("prevResult = " + VecMath.toString(prevResult));
        System.out.println("middResult = " + VecMath.toString(middResult));
        System.out.println("thisResult = " + VecMath.toString(thisResult));
        System.out.println("GROUPING BY VERTEX:");
        i = 0;
        while (i < n) {
            System.out.println("" + i);
            System.out.println("VecMath.vpv(prevTerms[2*i], prevTerms[2*i+1]) = " + VecMath.toString(VecMath.vpv(prevTerms[2 * i], prevTerms[2 * i + 1])));
            System.out.println("VecMath.vpv(middTerms[2*i], middTerms[2*i+1]) = " + VecMath.toString(VecMath.vpv(middTerms[2 * i], middTerms[2 * i + 1])));
            System.out.println("VecMath.vpv(thisTerms[2*i], thisTerms[2*i+1]) = " + VecMath.toString(VecMath.vpv(thisTerms[2 * i], thisTerms[2 * i + 1])));
            ++i;
        }
        System.out.println("GROUPING BY EDGE:");
        i = 0;
        while (i < n) {
            System.out.println("" + i);
            System.out.println("VecMath.vpv(prevTerms[2*i+1], prevTerms[(2*i+2)%(2*n)]) = " + VecMath.toString(VecMath.vpv(prevTerms[2 * i + 1], prevTerms[(2 * i + 2) % (2 * n)])));
            System.out.println("VecMath.vpv(middTerms[2*i+1], middTerms[(2*i+2)%(2*n)]) = " + VecMath.toString(VecMath.vpv(middTerms[2 * i + 1], middTerms[(2 * i + 2) % (2 * n)])));
            System.out.println("VecMath.vpv(thisTerms[2*i+1], thisTerms[(2*i+2)%(2*n)]) = " + VecMath.toString(VecMath.vpv(thisTerms[2 * i + 1], thisTerms[(2 * i + 2) % (2 * n)])));
            ++i;
        }
    }

    static double[] calcCurvatureAvg(double[][] verts) {
        if ((verts = DualApplet.removeDups(verts, 1.0E-6)).length < 3) {
            return DualApplet.calcEdgesAvg(verts);
        }
        double angleSum = 0.0;
        double[] result = VecMath.zerovec(verts[0].length);
        int n = verts.length;
        int i = 0;
        while (i < n) {
            double angle = DualApplet.calcExteriorAngle(verts, i);
            VecMath.vpsxv(result, result, angle, verts[i]);
            angleSum += angle;
            ++i;
        }
        double windingNumber = angleSum / (Math.PI * 2);
        if (!(Math.abs(windingNumber) > 0.5)) {
            return null;
        }
        VecMath.vxs(result, result, 1.0 / angleSum);
        return result;
    }

    static double[] calcEdgesAvg(double[][] verts) {
        if (verts.length == 0) {
            return null;
        }
        if (verts.length == 1) {
            return verts[0];
        }
        double lengthSum = 0.0;
        double[] result = VecMath.zerovec(verts[0].length);
        double[] edgeMidPoint = new double[result.length];
        int n = verts.length;
        int i = 0;
        while (i < n) {
            double length = VecMath.dist(verts[i], verts[(i + 1) % n]);
            VecMath.lerp(edgeMidPoint, verts[i], verts[(i + 1) % n], 0.5);
            VecMath.vpsxv(result, result, length, edgeMidPoint);
            lengthSum += length;
            ++i;
        }
        if (lengthSum == 0.0) {
            return null;
        }
        VecMath.vxs(result, result, 1.0 / lengthSum);
        return result;
    }

    static double[] calcAreaAvg(double[][] verts) {
        if (verts.length < 3) {
            return DualApplet.calcEdgesAvg(verts);
        }
        double twiceAreaSum = 0.0;
        double[] result = VecMath.zerovec(verts[0].length);
        double[] v0 = new double[result.length];
        double[] v1 = new double[result.length];
        double[] triAvg = new double[result.length];
        int n = verts.length;
        int i = 1;
        while (i <= n - 2) {
            VecMath.vmv(v0, verts[i], verts[0]);
            VecMath.vmv(v1, verts[i + 1], verts[0]);
            double twiceTriArea = v0[0] * v1[1] - v0[1] * v1[0];
            twiceAreaSum += twiceTriArea;
            VecMath.vpv(triAvg, verts[0], verts[i]);
            VecMath.vpv(triAvg, triAvg, verts[i + 1]);
            VecMath.vpsxv(result, result, twiceTriArea * 0.3333333333333333, triAvg);
            ++i;
        }
        if (twiceAreaSum == 0.0) {
            return null;
        }
        VecMath.vxs(result, result, 1.0 / twiceAreaSum);
        return result;
    }

    static double calcArea(double[][] verts) {
        if (verts.length == 0) {
            return 0.0;
        }
        double twiceAreaSum = 0.0;
        double[] v0 = new double[verts[0].length];
        double[] v1 = new double[verts[0].length];
        int n = verts.length;
        int i = 1;
        while (i <= n - 2) {
            VecMath.vmv(v0, verts[i], verts[0]);
            VecMath.vmv(v1, verts[i + 1], verts[0]);
            double twiceTriArea = v0[0] * v1[1] - v0[1] * v1[0];
            twiceAreaSum += twiceTriArea;
            ++i;
        }
        return twiceAreaSum * 0.5;
    }

    static double calcPerimeter(double[][] verts) {
        if (verts.length == 0) {
            return 0.0;
        }
        double lengthSum = 0.0;
        int n = verts.length;
        int i = 0;
        while (i < n) {
            lengthSum += VecMath.dist(verts[i], verts[(i + 1) % n]);
            ++i;
        }
        return lengthSum;
    }

    static double[][][] calcOnion(double[][] verts, double scale0, double scale1, int n) {
        double[][][] layers = new double[n + 1][verts.length][2];
        double[] center = DualApplet.calcAreaAvg(verts);
        if (center == null) {
            return new double[0][0][2];
        }
        int i = 0;
        while (i < n + 1) {
            double scale = 1.0 - 1.0 / (double)(1 << i + 1);
            int j = 0;
            while (j < verts.length) {
                VecMath.lerp(layers[i][j], center, verts[j], scale);
                ++j;
            }
            ++i;
        }
        return layers;
    }

    static double[][][][] calcOnionGrids(double[][] verts, double scale0, double scale1, int nLayers, int nEdgeSubdivs, boolean gridIsInverseMap, double[] initialGuess, int radiusMethod, double radiusIfConstant) {
        dualMyCGFunction dualCGfun = new dualMyCGFunction();
        double[][][] redOnion = DualApplet.calcOnion(verts, scale0, scale1, nLayers);
        int n = redOnion.length;
        int n2 = 0;
        if (redOnion.length != 0) {
            n2 = redOnion[0].length;
        }
        double[][][] redGrid = new double[n][1 + nEdgeSubdivs * n2][2];
        int n3 = redOnion.length;
        int n4 = 0;
        if (redOnion.length != 0) {
            n4 = redOnion[0].length;
        }
        double[][][] greenGrid = new double[n3][1 + nEdgeSubdivs * n4][2];
        int i = 0;
        while (i < redOnion.length) {
            int ind = 0;
            int n5 = redOnion[i].length;
            int j = 0;
            while (j < n5) {
                int k = 0;
                while (k < nEdgeSubdivs) {
                    VecMath.lerp(redGrid[i][ind], redOnion[i][j], redOnion[i][(j + 1) % n5], (double)k / (double)nEdgeSubdivs);
                    if (gridIsInverseMap) {
                        greenGrid[i][ind] = DualApplet.inverseMapDualCGToCenter(dualCGfun, verts, redGrid[i][ind], initialGuess, radiusMethod, radiusIfConstant);
                    } else {
                        ((VectorFunctionWithVertsParam)dualCGfun).apply(greenGrid[i][ind], redGrid[i][ind], verts, radiusMethod, radiusIfConstant);
                    }
                    ++ind;
                    ++k;
                }
                ++j;
            }
            redGrid[i][ind] = VecMath.copyvec(redGrid[i][0]);
            greenGrid[i][ind] = VecMath.copyvec(greenGrid[i][0]);
            ++i;
        }
        if (gridIsInverseMap) {
            double[][][] temp = redGrid;
            redGrid = greenGrid;
            greenGrid = temp;
        }
        return new double[][][][]{greenGrid, redGrid};
    }

    static double approximateThatIntegral(double distToLine, double ang0, double ang1, int n) {
        double sum = 0.0;
        int i = 0;
        while (i < n) {
            double ang = ang0 + ((double)i + 0.5) / (double)n * (ang1 - ang0);
            double val = Math.log(distToLine / Math.cos(ang));
            System.out.println("val = " + val);
            sum += val;
            ++i;
        }
        return sum / (double)n * (ang1 - ang0);
    }

    static double calcPolarMeanRadiusUnbalanced(double[] center, double[][] verts) {
        if (verts.length == 0) {
            return 1.0;
        }
        double sum = 0.0;
        double angleSum = 0.0;
        int n = verts.length;
        double[] closest = new double[verts[0].length];
        int i = 0;
        while (i < n) {
            DualApplet.findClosestPointOnLine(closest, center, verts[i], verts[(i + 1) % n], false);
            double ang0 = DualApplet.calcAngle(center, closest, center, verts[i]);
            double ang1 = DualApplet.calcAngle(center, closest, center, verts[(i + 1) % n]);
            if (!(Math.abs(ang1 - ang0) <= Math.PI)) {
                return 0.0;
            }
            sum += DualApplet.approximateThatIntegral(VecMath.dist(center, closest), ang0, ang1, Math.max(1, (int)(Math.abs(ang1 - ang0) * (double)integrationIterationsPerRadian)));
            angleSum += ang1 - ang0;
            ++i;
        }
        double windingNumber = angleSum / (Math.PI * 2);
        if (!(Math.abs(windingNumber) > 0.5)) {
            return 0.0;
        }
        return Math.exp(sum / angleSum);
    }

    static double calcPolarMeanRadiusBalanced(double[] center, double[][] verts) {
        double[][] dualVerts = DualApplet.calcReciprocalVerts(verts, center, 1.0);
        double primalMeanRadius = DualApplet.calcPolarMeanRadiusUnbalanced(center, verts);
        double dualMeanRadius = DualApplet.calcPolarMeanRadiusUnbalanced(center, dualVerts);
        return Math.sqrt(primalMeanRadius / dualMeanRadius);
    }

    static double calcCustomCGNormalized(double[] result, double[][] verts, VectorFunctionOfPositionAndNormal fun, int variableOfIntegration) {
        if (verts == null || verts.length == 0) {
            return Double.NaN;
        }
        if (variableOfIntegration != 2) {
            verts = DualApplet.removeDups(verts, 1.0E-4);
        }
        int totalCalls = 0;
        double[] zero = VecMath.zerovec(verts[0].length);
        double[] p = VecMath.zerovec(verts[0].length);
        double[] closest = VecMath.zerovec(verts[0].length);
        double[] funResult = VecMath.zerovec(verts[0].length);
        double[] closest0 = VecMath.zerovec(verts[0].length);
        double[] closest1 = VecMath.zerovec(verts[0].length);
        double[] sum = VecMath.zerovec(verts[0].length);
        double weightsSum = 0.0;
        int n = verts.length;
        int i = 0;
        while (i < n) {
            switch (variableOfIntegration) {
                case 0: {
                    double frac;
                    double y;
                    double ang;
                    DualApplet.findClosestPointOnLine(closest, zero, verts[i], verts[(i + 1) % n], false);
                    double ang0 = DualApplet.calcAngle(zero, closest, zero, verts[i]);
                    double ang1 = DualApplet.calcAngle(zero, closest, zero, verts[(i + 1) % n]);
                    if (!(Math.abs(ang1) < 1.5707963267948966) || !(Math.abs(ang0) < 1.5707963267948966)) break;
                    double y0 = Math.tan(ang0);
                    double y1 = Math.tan(ang1);
                    int m = Math.max(1, (int)(Math.abs(ang1 - ang0) * (double)integrationIterationsPerRadian));
                    int j = 0;
                    while (j < m) {
                        ang = ang0 + ((double)j + 0.5) / (double)m * (ang1 - ang0);
                        y = Math.tan(ang);
                        frac = (y - y0) / (y1 - y0);
                        VecMath.lerp(p, verts[i], verts[(i + 1) % n], frac);
                        fun.apply(funResult, p, closest);
                        VecMath.vpsxv(sum, sum, (ang1 - ang0) / (double)m, funResult);
                        weightsSum += (ang1 - ang0) / (double)m;
                        ++totalCalls;
                        ++j;
                    }
                    break;
                }
                case 1: {
                    double frac;
                    double y;
                    double ang;
                    VecMath.copyvec(p, verts[i]);
                    DualApplet.findClosestPointOnLine(closest0, zero, verts[(i - 1 + n) % n], verts[i], false);
                    DualApplet.findClosestPointOnLine(closest1, zero, verts[i], verts[(i + 1) % n], false);
                    double ang0 = DualApplet.calcAngle(zero, verts[i], zero, closest0);
                    double ang1 = DualApplet.calcAngle(zero, verts[i], zero, closest1);
                    if (!(Math.abs(ang1) < 1.5707963267948966) || !(Math.abs(ang0) < 1.5707963267948966)) break;
                    double y0 = Math.tan(ang0);
                    double y1 = Math.tan(ang1);
                    int m = Math.max(1, (int)(Math.abs(ang1 - ang0) * (double)integrationIterationsPerRadian));
                    int j = 0;
                    while (j < m) {
                        ang = ang0 + ((double)j + 0.5) / (double)m * (ang1 - ang0);
                        y = Math.tan(ang);
                        frac = (y - y0) / (y1 - y0);
                        VecMath.lerp(closest, closest0, closest1, frac);
                        fun.apply(funResult, p, closest);
                        VecMath.vpsxv(sum, sum, (ang1 - ang0) / (double)m, funResult);
                        weightsSum += (ang1 - ang0) / (double)m;
                        ++totalCalls;
                        ++j;
                    }
                    break;
                }
                case 2: {
                    VecMath.copyvec(p, verts[i]);
                    VecMath.zerovec(closest);
                    fun.apply(funResult, p, closest);
                    VecMath.vpv(sum, sum, funResult);
                    weightsSum += 1.0;
                    break;
                }
                case 3: {
                    DualApplet.findClosestPointOnLine(closest, zero, verts[i], verts[(i + 1) % n], false);
                    double len = VecMath.dist(verts[i], verts[(i + 1) % n]);
                    int m = Math.max(1, (int)(len * (double)integrationIterationsPerRadian));
                    int j = 0;
                    while (j < m) {
                        VecMath.lerp(p, verts[i], verts[(i + 1) % n], ((double)j + 0.5) / (double)m);
                        fun.apply(funResult, p, closest);
                        VecMath.vpsxv(sum, sum, len / (double)m, funResult);
                        weightsSum += len / (double)m;
                        ++totalCalls;
                        ++j;
                    }
                    break;
                }
                case 4: {
                    int k;
                    double triArea = 0.5 * (verts[i][0] * verts[(i + 1) % n][1] - verts[i][1] * verts[(i + 1) % n][0]);
                    int m = Math.max(1, (int)Math.sqrt(triArea * (double)integrationIterationsPerArea));
                    int j = 0;
                    while (j < m) {
                        k = 0;
                        while (k < m - j) {
                            VecMath.bary(p, zero, verts[i], ((double)j + 0.3333333333333333) / (double)m, verts[(i + 1) % n], ((double)k + 0.3333333333333333) / (double)m);
                            fun.apply(funResult, p, closest);
                            VecMath.vpsxv(sum, sum, triArea / (double)(m * m), funResult);
                            weightsSum += triArea / (double)(m * m);
                            ++k;
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < m - 1) {
                        k = 0;
                        while (k < m - 1 - j) {
                            VecMath.bary(p, zero, verts[i], ((double)j + 0.6666666666666666) / (double)m, verts[(i + 1) % n], ((double)k + 0.6666666666666666) / (double)m);
                            fun.apply(funResult, p, closest);
                            VecMath.vpsxv(sum, sum, triArea / (double)(m * m), funResult);
                            weightsSum += triArea / (double)(m * m);
                            ++k;
                        }
                        ++j;
                    }
                    break;
                }
                default: {
                    throw new Error("Assertion failed at DualApplet.prejava(4473): false");
                }
            }
            ++i;
        }
        double windingNumber = weightsSum / (Math.PI * 2);
        if (!(variableOfIntegration != 0 && variableOfIntegration != 1 || Math.abs(windingNumber) > 0.5)) {
            return Double.NaN;
        }
        VecMath.vxs(sum, sum, 1.0 / weightsSum);
        VecMath.copyvec(result, sum);
        return weightsSum;
    }

    static double calcCustomCG(double[] result, double[][] verts, double[] center, double radius, VectorFunctionOfPositionAndNormal fun, int variableOfIntegration) {
        if (verts == null || verts.length == 0) {
            return Double.NaN;
        }
        double[][] normalizedVerts = new double[verts.length][verts[0].length];
        VecMath.mmv(normalizedVerts, verts, center);
        VecMath.mxs(normalizedVerts, normalizedVerts, 1.0 / radius);
        double weightsSum = DualApplet.calcCustomCGNormalized(result, normalizedVerts, fun, variableOfIntegration);
        VecMath.vpsxv(result, center, radius, result);
        if (variableOfIntegration == 2) {
            return weightsSum;
        }
        if (variableOfIntegration == 4) {
            return weightsSum * (radius * radius);
        }
        return weightsSum * radius;
    }

    static double calcCustomCGofCGs(double[] result, double[][] verts, double[][] dualVerts, double[] center, double radius, VectorFunctionOfPositionAndNormal fun, int variableOfIntegration, boolean weightCGofCGs) {
        double dualWeightsSum;
        double[] primalCG = new double[verts[0].length];
        double[] dualCG = new double[verts[0].length];
        double primalWeightsSum = DualApplet.calcCustomCG(primalCG, verts, center, radius, fun, variableOfIntegration);
        if (Double.isNaN(primalWeightsSum)) {
            primalCG = null;
        }
        if (Double.isNaN(dualWeightsSum = DualApplet.calcCustomCG(dualCG, dualVerts, center, radius, fun, variableOfIntegration))) {
            dualCG = null;
        }
        if (primalCG == null && dualCG == null) {
            return Double.NaN;
        }
        if (dualCG == null) {
            VecMath.copyvec(result, primalCG);
            return primalWeightsSum;
        }
        if (primalCG == null) {
            VecMath.copyvec(result, dualCG);
            return dualWeightsSum;
        }
        double t = weightCGofCGs ? dualWeightsSum / (primalWeightsSum + dualWeightsSum) : 0.5;
        VecMath.lerp(result, primalCG, dualCG, t);
        return primalWeightsSum + dualWeightsSum;
    }

    static boolean customIntegrationIsCompatible(VectorFunctionOfPositionAndNormal fun, int whichVar) {
        boolean isCompatible = true;
        String funName = fun.getName();
        if ((whichVar == 2 || whichVar == 4) && funName.indexOf("n") != -1) {
            isCompatible = false;
        }
        System.out.println(funName + (isCompatible ? " is " : " is NOT ") + "compatible with " + variableOfIntegrationStrings[whichVar]);
        return isCompatible;
    }

    private static final double[] inverseMapDualCGToCenter(VectorFunctionWithVertsParam dualCGfun, double[][] verts, double[] target, double[] initialGuess, int radiusMethod, double radiusIfConstant) {
        int verbose = 0;
        if (verts == null || verts.length < 3) {
            return null;
        }
        double[] center = VecMath.average(verts);
        if (initialGuess != null) {
            VecMath.copyvec(center, initialGuess);
        }
        double[] scratch = new double[center.length];
        double[] loscratch = new double[center.length];
        double[] hiscratch = new double[center.length];
        double[][] jacobian = new double[center.length][center.length];
        double[][] invJacobian = new double[center.length][center.length];
        double[] delta = new double[center.length];
        if (verbose >= 1) {
            System.out.println("verts =\n" + VecMath.toString(verts));
            System.out.println("target: " + VecMath.toString(target));
        }
        int maxIters = 1000;
        if (radiusMethod != 6 && radiusMethod != 1 && radiusMethod != 0) {
            maxIters = 40;
        }
        int iIter = 0;
        while (iIter < maxIters) {
            double eps = 0.001;
            int i = 0;
            while (i < center.length) {
                VecMath.copyvec(scratch, center);
                scratch[i] = center[i] - eps;
                dualCGfun.apply(loscratch, scratch, verts, radiusMethod, radiusIfConstant);
                scratch[i] = center[i] + eps;
                dualCGfun.apply(hiscratch, scratch, verts, radiusMethod, radiusIfConstant);
                VecMath.vmv(jacobian[i], hiscratch, loscratch);
                VecMath.vxs(jacobian[i], jacobian[i], 1.0 / ((double)2 * eps));
                ++i;
            }
            VecMath.invertmat(invJacobian, jacobian);
            double safeRadiusSqrd = dualCGfun.apply(scratch, center, verts, radiusMethod, radiusIfConstant);
            if (verbose >= 4) {
                System.out.println("jacobian =\n" + VecMath.toString(jacobian));
                System.out.println("invJacobian =\n" + VecMath.toString(invJacobian));
            }
            if (verbose >= 4) {
                System.out.println("    " + iIter + ": " + VecMath.toString(center) + " -> " + VecMath.toString(scratch));
            }
            VecMath.vmv(scratch, target, scratch);
            VecMath.vxm(delta, scratch, invJacobian);
            double frac = 1.0;
            VecMath.vxs(delta, delta, frac);
            double deltaSqrd = VecMath.normsqrd(delta);
            if (!(safeRadiusSqrd > 1.0E-12)) {
                return null;
            }
            if (deltaSqrd * (double)4 > safeRadiusSqrd) {
                VecMath.vxs(delta, delta, Math.sqrt(safeRadiusSqrd / (deltaSqrd * (double)4)));
                if (verbose >= 3) {
                    System.out.print("!");
                }
            } else if (verbose >= 3) {
                System.out.print(".");
            }
            VecMath.vpv(center, center, delta);
            if (VecMath.normsqrd(scratch) < 1.0E-6) break;
            ++iIter;
        }
        if (verbose >= 1) {
            System.out.println("    " + iIter + ": " + VecMath.toString(center));
        }
        return center;
    }

    public static double[][][][] calcGrids(double[][] verts, boolean gridIsInverseMap, double[] initialGuess, int radiusMethod, double radiusIfConstant, boolean gridIsOnion) {
        double[][][] redGridPoints;
        double[][][] greenGridPoints;
        if (gridIsOnion && !gridIsInverseMap) {
            double scale0 = 0.0;
            double scale1 = 0.9999;
            int nLayers = 20;
            int nEdgeSubdivs = 20;
            return DualApplet.calcOnionGrids(verts, scale0, scale1, nLayers, nEdgeSubdivs, gridIsInverseMap, initialGuess, radiusMethod, radiusIfConstant);
        }
        dualCGOfVertsFunction dualCGfun = new dualCGOfVertsFunction();
        double[][] bbox = VecMath.bboxUniform(verts);
        if (gridIsInverseMap) {
            double coverFactor = 3;
            double[][] gridbbox = new double[][]{VecMath.lerp(bbox[0], bbox[1], (1.0 + coverFactor) * 0.5), VecMath.lerp(bbox[0], bbox[1], (1.0 - coverFactor) * 0.5)};
            int n = 10;
            greenGridPoints = new double[n + 1][n + 1][];
            redGridPoints = new double[n + 1][n + 1][];
            int i = 0;
            while (i < n + 1) {
                int j = 0;
                while (j < n + 1) {
                    greenGridPoints[i][j] = new double[]{gridbbox[0][0] + (double)j / (double)n * (gridbbox[1][0] - gridbbox[0][0]), gridbbox[0][1] + (double)i / (double)n * (gridbbox[1][1] - gridbbox[0][1])};
                    redGridPoints[i][j] = DualApplet.inverseMapDualCGToCenter(dualCGfun, verts, greenGridPoints[i][j], initialGuess, radiusMethod, radiusIfConstant);
                    ++j;
                }
                ++i;
            }
        } else {
            int n = 40;
            double coverFactor = (double)n / (double)(n + 1);
            double[][] gridbbox = new double[][]{VecMath.lerp(bbox[0], bbox[1], (1.0 + coverFactor) * 0.5), VecMath.lerp(bbox[0], bbox[1], (1.0 - coverFactor) * 0.5)};
            greenGridPoints = new double[n + 1][n + 1][];
            redGridPoints = new double[n + 1][n + 1][];
            int i = 0;
            while (i < n + 1) {
                int j = 0;
                while (j < n + 1) {
                    redGridPoints[i][j] = new double[]{gridbbox[0][0] + (double)j / (double)n * (gridbbox[1][0] - gridbbox[0][0]), gridbbox[0][1] + (double)i / (double)n * (gridbbox[1][1] - gridbbox[0][1])};
                    if (DualApplet.pointIsInPoly(redGridPoints[i][j], verts, 0.002)) {
                        greenGridPoints[i][j] = new double[2];
                        ((VectorFunctionWithVertsParam)dualCGfun).apply(greenGridPoints[i][j], redGridPoints[i][j], verts, radiusMethod, radiusIfConstant);
                    } else {
                        redGridPoints[i][j] = null;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return new double[][][][]{greenGridPoints, redGridPoints};
    }

    static boolean pointIsInPoly(double[] p, double[][] verts, double eps) {
        int windingNumber = 0;
        int n = verts.length;
        int i = 0;
        while (i < n) {
            double[] v0 = verts[i];
            double[] v1 = verts[(i + 1) % n];
            if (DualApplet.distsqrdFromPointToLine(p, v0, v1, true) < eps * eps) {
                return false;
            }
            boolean bl = false;
            if (v0[0] <= p[0]) {
                bl = true;
            }
            boolean bl2 = false;
            if (v1[0] <= p[0]) {
                bl2 = true;
            }
            if (bl != bl2) {
                double frac;
                if (p[1] > v0[1] && p[1] > v1[1]) {
                    windingNumber += v0[0] < v1[0] ? -1 : 1;
                } else if ((p[1] > v0[1] || p[1] > v1[1]) && p[1] > v0[1] + (frac = (p[0] - v0[0]) / (v1[0] - v0[0])) * (v1[1] - v0[1])) {
                    windingNumber += v0[0] < v1[0] ? -1 : 1;
                }
            }
            ++i;
        }
        boolean bl = false;
        if (windingNumber & true) {
            bl = true;
        }
        return bl;
    }

    public static void drawGrid(Graphics g, Dimension size, double[][][] gridPoints) {
        int j;
        int i = 0;
        while (i < gridPoints.length) {
            j = 0;
            while (j < gridPoints[i].length - 1) {
                if (gridPoints[i][j] != null && gridPoints[i][j + 1] != null) {
                    DualApplet.drawLine_(g, size, gridPoints[i][j], gridPoints[i][j + 1]);
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < gridPoints.length - 1) {
            j = 0;
            while (j < gridPoints[i].length) {
                if (gridPoints[i][j] != null && gridPoints[i + 1][j] != null) {
                    DualApplet.drawLine_(g, size, gridPoints[i][j], gridPoints[i + 1][j]);
                }
                ++j;
            }
            ++i;
        }
    }

    private static final void drawArrow_(Graphics g, Dimension size, double[] arrowTail, double[] unitDir, double arrowLength, double headLength) {
        double[] arrowHead = VecMath.vpsxv(arrowTail, arrowLength, unitDir);
        DualApplet.drawLine_(g, size, arrowTail, arrowHead);
        double[][] M = new double[][]{{-Math.sqrt(3) / (double)2, 0.5}, {-0.5, -Math.sqrt(3) / (double)2}};
        double[] left = VecMath.vxm(unitDir, M);
        double[] right = VecMath.mxv(M, unitDir);
        VecMath.vpsxv(left, arrowHead, headLength, left);
        VecMath.vpsxv(right, arrowHead, headLength, right);
        DualApplet.drawLine_(g, size, left, arrowHead);
        DualApplet.drawLine_(g, size, arrowHead, right);
    }

    private static final void drawLine_(Graphics g, Dimension size, double[] v0, double[] v1) {
        int w = size.width;
        int h = size.height;
        double centerX = 0.5 * (double)w;
        double centerY = 0.5 * (double)h;
        double x0 = centerX + v0[0];
        double y0 = centerY + v0[1];
        double x1 = centerX + v1[0];
        double y1 = centerY + v1[1];
        double clipLeft = -0.5;
        double clipRight = (double)w - 0.5;
        double clipTop = -0.5;
        double clipBottom = (double)h - 0.5;
        double expand = w + h;
        if (!((clipLeft -= expand) < x0 && x0 < (clipRight += expand) && (clipTop -= expand) < y0 && y0 < (clipBottom += expand) && clipLeft < x1 && x1 < clipRight && clipTop < y1 && y1 < clipBottom)) {
            double t0;
            double temp;
            if (x0 <= clipLeft && x1 <= clipLeft || x0 >= clipRight && x1 >= clipRight || y0 <= clipTop && y1 <= clipTop || y0 >= clipBottom && y1 >= clipBottom) {
                return;
            }
            double[] zero = new double[2];
            double distsqrd = DualApplet.distsqrdFromPointToLine(zero, v0, v1, false);
            if ((double)2 * distsqrd > (double)(w * w + h * h)) {
                return;
            }
            double leftT = (clipLeft - x0) / (x1 - x0);
            double rightT = (clipRight - x0) / (x1 - x0);
            double topT = (clipTop - y0) / (y1 - y0);
            double bottomT = (clipBottom - y0) / (y1 - y0);
            if (leftT > rightT) {
                temp = leftT;
                leftT = rightT;
                rightT = temp;
            }
            if (topT > bottomT) {
                temp = topT;
                topT = bottomT;
                bottomT = temp;
            }
            double d = leftT >= topT ? (leftT >= 0.0 ? leftT : 0.0) : (t0 = topT >= 0.0 ? topT : 0.0);
            double t1 = rightT <= bottomT ? (rightT <= 1.0 ? rightT : 1.0) : (bottomT <= 1.0 ? bottomT : 1.0);
            double clippedX0 = x0 + t0 * (x1 - x0);
            double clippedY0 = y0 + t0 * (y1 - y0);
            double clippedX1 = x0 + t1 * (x1 - x0);
            double clippedY1 = y0 + t1 * (y1 - y0);
            if (t0 >= t1) {
                return;
            }
            x0 = clippedX0;
            y0 = clippedY0;
            x1 = clippedX1;
            y1 = clippedY1;
        }
        g.drawLine((int)(x0 + 0.5), (int)(y0 + 0.5), (int)(x1 + 0.5), (int)(y1 + 0.5));
    }

    public static void main(String[] args) {
        System.out.println("in main");
        Frame_ frame = new Frame_("Dual Applet"){

            public final boolean handleEvent(Event event) {
                switch (event.id) {
                    case 201: {
                        System.out.println("bye!");
                        this.dispose();
                        System.exit(0);
                        return true;
                    }
                }
                return super.handleEvent(event);
            }
        };
        frame.addWindowListener(new WindowAdapter(frame){
            final /* synthetic */ Frame val$frame;

            public final void windowClosing(WindowEvent we) {
                System.out.println("ciao!");
                this.val$frame.dispose();
                System.exit(0);
            }
            {
                this.val$frame = frame;
            }
        });
        DualApplet applet = new DualApplet();
        applet.setStub(new AppletStub(args){
            final /* synthetic */ String[] val$args;

            public final void appletResize(int width, int height) {
            }

            public final AppletContext getAppletContext() {
                return null;
            }

            public final URL getCodeBase() {
                return null;
            }

            public final URL getDocumentBase() {
                return null;
            }

            public final String getParameter(String name) {
                String prefix = name.toLowerCase() + '=';
                int i = 0;
                while (i < this.val$args.length) {
                    if (this.val$args[i].toLowerCase().startsWith(prefix)) {
                        return this.val$args[i].substring(prefix.length());
                    }
                    ++i;
                }
                return null;
            }

            public final boolean isActive() {
                return true;
            }
            {
                this.val$args = stringArray;
            }
        });
        frame.add(applet);
        applet.init();
        applet.start();
        frame.move(400, 20);
        frame.resize(512, 512);
        frame.show();
        System.out.println("out main");
    }

    public static void beep() {
        try {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (NoSuchMethodError e) {
            System.out.println("\u0007BEEP!");
        }
    }

    private final /* synthetic */ void this() {
        this.verts = DualApplet.makeRegularPolygon(4, 100.0);
        this.center = VecMath.average(this.verts);
        this.mostRecentRadius = DualApplet.calcReciprocationRadius(this.verts, this.center, 1, 0.0);
        this.radiusMethod = 1;
        this.weightCGofCGs = true;
        this.showRobsCG = false;
        this.showMyCG = false;
        this.showMySpiralCG = false;
        this.showMyPaperCG = false;
        this.showMyFlatCG = false;
        this.showVertsCG = true;
        this.showEdgesCG = true;
        this.showAreaCG = true;
        this.showCurvatureCG = false;
        this.showCustomCG = false;
        this.whichCustomCGvector = 0;
        this.whichCustomCGscalar = 0;
        this.customCGfun = new VectorFunctionOfPositionAndNormal.CommonFun(this.whichCustomCGvector, this.whichCustomCGscalar);
        this.whichCustomCGvariableOfIntegration = 0;
        this.showRadiusMaximizingPoints = false;
        this.showDualAreaMinimizingPoints = false;
        this.showHalfAngleArcsCG = false;
        this.showETCcenter = false;
        int[] nArray = new int[3];
        nArray[0] = 1;
        this.ETCindex = nArray;
        this.showGrids = false;
        this.gridIsOnion = false;
        this.gridIsInverseMap = false;
        this.cachedGrids = null;
        this.showDirectionsGraph = false;
        this.showRectified = false;
        this.showRectifiedStructure = false;
        this.showAngleChangeArcs = false;
        this.showHalfAngleChangeArcs = false;
        this.showInverses = false;
        this.showHalfInverses = false;
        this.showLogHalfInverses = false;
        this.followMethod = 0;
        this.prevP = null;
        this.selectedPointIndex = -1;
        this.selectedPolygon = -1;
        this.selectedArcAngle = 0.0;
        this.myCGComponents = null;
        this.prevMyCGComponents = null;
        this.eventVerbose = 0;
        this.doDoubleBuffer = true;
        this.pickRadius = 15;
        this.backBufferImage = null;
        this.button1IsDown = false;
        this.button2IsDown = false;
        this.button3IsDown = false;
        this.controlIsDown = false;
    }

    public DualApplet() {
        String name;
        this.this();
        this.setLayout(new GridBagLayout());
        DualAppletCanvas canvas = new DualAppletCanvas();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 14;
        c.fill = 0;
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.fill = 1;
        Object[][] objectArray = new Object[1][];
        Object[] objectArray2 = new Object[4];
        Object[][] objectArray3 = new Object[2][];
        Object[] objectArray4 = new Object[7];
        objectArray4[0] = new Button_(this, "-> Squish <-", canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                DualApplet.access$0(this.this$0, Math.pow(2, -0.25), 1.0);
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        };
        objectArray4[1] = buttonConstraints;
        objectArray4[2] = new Button_(this, "Squash", canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                DualApplet.access$0(this.this$0, 1.0, Math.pow(2, -0.25));
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        };
        objectArray4[3] = buttonConstraints;
        objectArray4[4] = new Button_(this, "-", canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                DualApplet.access$0(this.this$0, Math.sqrt(0.5), Math.sqrt(0.5));
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        };
        objectArray4[5] = buttonConstraints;
        objectArray3[0] = objectArray4;
        objectArray3[1] = new Object[]{new Button_(this, "<-UnSquish->", canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                DualApplet.access$0(this.this$0, Math.pow(2, 0.25), 1.0);
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }, buttonConstraints, new Button_(this, "UnSquash", canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                DualApplet.access$0(this.this$0, 1.0, Math.pow(2, 0.25));
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }, buttonConstraints, new Button_(this, "+", canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                DualApplet.access$0(this.this$0, Math.sqrt(2), Math.sqrt(2));
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }, buttonConstraints};
        objectArray2[0] = new MyPanel(objectArray3);
        objectArray2[1] = buttonConstraints;
        objectArray2[2] = new Button_(this, "Show Control Panel"){
            final /* synthetic */ DualApplet this$0;

            public final boolean action(Event e, Object what) {
                if (this.getLabel().equals("Show Control Panel")) {
                    System.out.println("showing control panel");
                    this.this$0.controlPanelFrame.show();
                    this.setLabel("Hide Control Panel");
                } else {
                    System.out.println("hiding control panel");
                    this.this$0.controlPanelFrame.hide();
                    this.setLabel("Show Control Panel");
                }
                return true;
            }
            {
                this.this$0 = dualApplet;
            }
        };
        objectArray2[3] = buttonConstraints;
        objectArray[0] = objectArray2;
        MyPanel subPanel = new MyPanel(objectArray);
        this.add((Component)subPanel, c);
        c.fill = 1;
        this.add((Component)canvas, c);
        this.controlPanelFrame = new Frame_(this, "Dual Applet Control Panel"){
            final /* synthetic */ DualApplet this$0;

            public final boolean handleEvent(Event event) {
                switch (event.id) {
                    case 201: {
                        System.out.println("hiding control panel");
                        this.hide();
                        return true;
                    }
                }
                return super.handleEvent(event);
            }
            {
                this.this$0 = dualApplet;
            }
        };
        this.controlPanelFrame.setLayout(new GridBagLayout());
        CheckboxGroup radiusCBG = new CheckboxGroup();
        CheckboxGroup CGofCGsCBG = new CheckboxGroup();
        CheckboxGroup followsCBG = new CheckboxGroup();
        Choice_ radiusMethodChoice = new Choice_(this, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.radiusMethod = this.getSelectedIndex();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        };
        String[] strings = radiusMethodStrings;
        int i = 0;
        while (i < strings.length) {
            radiusMethodChoice.add(strings[i]);
            ++i;
        }
        radiusMethodChoice.select(this.radiusMethod);
        Choice_ vectorChoice = new Choice_(this, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                int newCustomCGvector = this.getSelectedIndex();
                VectorFunctionOfPositionAndNormal.CommonFun newCustomCGfun = new VectorFunctionOfPositionAndNormal.CommonFun(newCustomCGvector, this.this$0.whichCustomCGscalar);
                if (DualApplet.customIntegrationIsCompatible(newCustomCGfun, this.this$0.whichCustomCGvariableOfIntegration)) {
                    this.this$0.whichCustomCGvector = newCustomCGvector;
                    this.this$0.customCGfun = newCustomCGfun;
                    this.val$canvas.repaint();
                } else {
                    DualApplet.beep();
                    this.select(this.this$0.whichCustomCGvector);
                }
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        };
        Choice_ scalarChoice = new Choice_(this, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                int newCustomCGscalar = this.getSelectedIndex();
                VectorFunctionOfPositionAndNormal.CommonFun newCustomCGfun = new VectorFunctionOfPositionAndNormal.CommonFun(this.this$0.whichCustomCGvector, newCustomCGscalar);
                if (DualApplet.customIntegrationIsCompatible(newCustomCGfun, this.this$0.whichCustomCGvariableOfIntegration)) {
                    this.this$0.whichCustomCGscalar = newCustomCGscalar;
                    this.this$0.customCGfun = newCustomCGfun;
                    this.val$canvas.repaint();
                } else {
                    DualApplet.beep();
                    this.select(this.this$0.whichCustomCGscalar);
                }
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        };
        String[] strings2 = VectorFunctionOfPositionAndNormal.commonVectorStrings;
        int i2 = 0;
        while (i2 < strings2.length) {
            name = strings2[i2];
            if (name.equals("p")) {
                name = "p (position)";
            } else if (name.equals("n")) {
                name = "n (closest point on edge)";
            }
            vectorChoice.add(name);
            ++i2;
        }
        vectorChoice.select(this.whichCustomCGvector);
        strings2 = VectorFunctionOfPositionAndNormal.commonScalarStrings;
        i2 = 0;
        while (i2 < strings2.length) {
            name = strings2[i2];
            scalarChoice.add(name);
            ++i2;
        }
        scalarChoice.select(this.whichCustomCGscalar);
        Choice_ varChoice = new Choice_(this, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                int newCustomCGvar = this.getSelectedIndex();
                if (DualApplet.customIntegrationIsCompatible(this.this$0.customCGfun, newCustomCGvar)) {
                    this.this$0.whichCustomCGvariableOfIntegration = newCustomCGvar;
                    this.val$canvas.repaint();
                } else {
                    DualApplet.beep();
                    this.select(this.this$0.whichCustomCGvariableOfIntegration);
                }
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        };
        i2 = 0;
        while (i2 < variableOfIntegrationStrings.length) {
            varChoice.add(variableOfIntegrationStrings[i2]);
            ++i2;
        }
        varChoice.select(this.whichCustomCGvariableOfIntegration);
        Button_ forceRecalculationButton = new Button_(this, "Force recalculation", canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.cachedGrids = null;
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        };
        boolean bl = false;
        if (this.showGrids && this.gridIsInverseMap) {
            bl = true;
        }
        forceRecalculationButton.setEnabled(bl);
        GridBagConstraints east = new GridBagConstraints();
        east.anchor = 13;
        Object[][] objectArray5 = new Component[9][];
        objectArray5[0] = new Component[]{new MyPanel("Reciprocation Circle Radius:", "", new Component[][]{{radiusMethodChoice}})};
        Component[] componentArray = new Component[1];
        Object[][] objectArray6 = new Component[4][];
        Component[] componentArray2 = new Component[1];
        boolean bl2 = false;
        if (this.followMethod == 0) {
            bl2 = true;
        }
        componentArray2[0] = new Checkbox_(this, this, "Manual (drag with left-mouse)", followsCBG, bl2, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.getState();
                this.this$0.followMethod = 0;
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        };
        objectArray6[0] = componentArray2;
        Component[] componentArray3 = new Component[1];
        boolean bl3 = false;
        if (this.followMethod == 1) {
            bl3 = true;
        }
        componentArray3[0] = new Checkbox_(this, this, "Follow custom CG (red +)", followsCBG, bl3, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.followMethod = (int)(this.getState() ? 1 : 0);
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        };
        objectArray6[1] = componentArray3;
        Component[] componentArray4 = new Component[1];
        boolean bl4 = false;
        if (this.followMethod == 2) {
            bl4 = true;
        }
        componentArray4[0] = new Checkbox_(this, this, "Follow custom CG of CGs (yellow +) (usually unstable)", followsCBG, bl4, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.followMethod = this.getState() ? 2 : 0;
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        };
        objectArray6[2] = componentArray4;
        Component[] componentArray5 = new Component[1];
        boolean bl5 = false;
        if (this.followMethod == 3) {
            bl5 = true;
        }
        componentArray5[0] = new Checkbox_(this, this, "Follow Canonical Reciprocation Center", followsCBG, bl5, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.followMethod = this.getState() ? 3 : 0;
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        };
        objectArray6[3] = componentArray5;
        componentArray[0] = new MyPanel("Reciprocation center:", "", objectArray6);
        objectArray5[1] = componentArray;
        objectArray5[2] = new Component[]{new MyPanel("Show CGs (centers of gravity):", "", new Object[][]{{new LittleKeyCanvas(this, canvas, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            final void drawOneThing(Graphics g, double[] pos) {
                DualAppletCanvas.access$0(this.val$canvas, g, pos, 5);
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }, new Checkbox_(this, this, "Rob's", this.showRobsCG, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showRobsCG = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}, {new LittleKeyCanvas(this, canvas, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            final void drawOneThing(Graphics g, double[] pos) {
                DualAppletCanvas.access$1(this.val$canvas, g, "f", pos);
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }, new Checkbox_(this, this, "Don's (from paper)", this.showMyPaperCG, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showMyPaperCG = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}, {new LittleKeyCanvas(this, canvas, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            final void drawOneThing(Graphics g, double[] pos) {
                DualAppletCanvas.access$2(this.val$canvas, g, pos, 3);
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }, new Checkbox_(this, this, "Vertices", this.showVertsCG, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showVertsCG = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}, {new LittleKeyCanvas(this, canvas, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            final void drawOneThing(Graphics g, double[] pos) {
                DualAppletCanvas.access$3(this.val$canvas, g, pos, 7);
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }, new Checkbox_(this, this, "Edges", this.showEdgesCG, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showEdgesCG = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}, {new LittleKeyCanvas(this, canvas, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            final void drawOneThing(Graphics g, double[] pos) {
                DualAppletCanvas.access$4(this.val$canvas, g, pos, 7);
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }, new Checkbox_(this, this, "Area", this.showAreaCG, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showAreaCG = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}, {new LittleKeyCanvas(this, canvas, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            final void drawOneThing(Graphics g, double[] pos) {
                DualAppletCanvas.access$5(this.val$canvas, g, pos, 7);
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }, new Checkbox_(this, this, "Curvature (turning-angle-weighted vertices)", this.showCurvatureCG, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showCurvatureCG = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}})};
        Component[] componentArray6 = new Component[1];
        Object[][] objectArray7 = new Object[3][];
        objectArray7[0] = new Object[]{new LittleKeyCanvas(this, canvas, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            final void drawOneThing(Graphics g, double[] pos) {
                DualAppletCanvas.access$6(this.val$canvas, g, pos, 7);
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }, new Checkbox_(this, this, "Custom CG:", this.showCustomCG, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showCustomCG = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }, vectorChoice};
        Object[] objectArray8 = new Object[4];
        objectArray8[1] = new Label("times");
        objectArray8[2] = east;
        objectArray8[3] = scalarChoice;
        objectArray7[1] = objectArray8;
        Object[] objectArray9 = new Object[3];
        objectArray9[1] = new Label("integrated over");
        objectArray9[2] = varChoice;
        objectArray7[2] = objectArray9;
        componentArray6[0] = new MyPanel("", objectArray7);
        objectArray5[3] = componentArray6;
        objectArray5[4] = new Component[]{new MyPanel("", new Object[][]{{new LittleKeyCanvas(this, canvas, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            final void drawOneThing(Graphics g, double[] pos) {
                DualAppletCanvas.access$1(this.val$canvas, g, "r", pos);
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }, new Checkbox_(this, this, "Radius-maximizing point (local maximum)", this.showRadiusMaximizingPoints, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showRadiusMaximizingPoints = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}})};
        objectArray5[5] = new Component[]{new MyPanel("", new Object[][]{{new LittleKeyCanvas(this, canvas, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            final void drawOneThing(Graphics g, double[] pos) {
                DualAppletCanvas.access$1(this.val$canvas, g, "a", pos);
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }, new Checkbox_(this, this, "Dual-area-minimizing point (local minimum) (constant radius)", this.showDualAreaMinimizingPoints, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showDualAreaMinimizingPoints = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}})};
        objectArray5[6] = new Component[]{new MyPanel("", new Object[][]{{new LittleKeyCanvas(this, canvas, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            final void drawOneThing(Graphics g, double[] pos) {
                DualAppletCanvas.access$1(this.val$canvas, g, "h", pos);
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }, new Checkbox_(this, this, "Half-angle arcs", this.showHalfAngleArcsCG, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showHalfAngleArcsCG = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}})};
        objectArray5[7] = new Component[]{new MyPanel("CG of CGs:", "", new Component[][]{{new Checkbox_(this, this, "Equal Avg", CGofCGsCBG, this.weightCGofCGs ^ true, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.weightCGofCGs = this.getState() ^ true;
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}, {new Checkbox_(this, this, "Weighted Avg", CGofCGsCBG, this.weightCGofCGs, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.weightCGofCGs = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}})};
        objectArray5[8] = new Component[]{new MyPanel("Other Fascinating Stuff", "", new Component[][]{{new Checkbox_(this, this, "Show reciprocation-center-to-dual-verts-CG map", this.showGrids, forceRecalculationButton, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ Button_ val$forceRecalculationButton;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showGrids = this.getState();
                if (this.this$0.showGrids) {
                    this.this$0.gridIsInverseMap = false;
                    ((Checkbox_)((MyPanel)this.getParent().getComponent(1)).getComponent(0)).setState(false);
                }
                boolean bl = false;
                if (this.this$0.showGrids && this.this$0.gridIsInverseMap) {
                    bl = true;
                }
                this.val$forceRecalculationButton.setEnabled(bl);
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$forceRecalculationButton = button_;
                this.val$canvas = dualAppletCanvas;
            }
        }}, {new MyPanel(new Component[][]{{new Checkbox_(this, this, "Show inverse map", this.showGrids, forceRecalculationButton, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ Button_ val$forceRecalculationButton;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showGrids = this.getState();
                if (this.this$0.showGrids) {
                    this.this$0.gridIsInverseMap = true;
                    ((Checkbox_)this.getParent().getParent().getComponent(0)).setState(false);
                }
                boolean bl = false;
                if (this.this$0.showGrids && this.this$0.gridIsInverseMap) {
                    bl = true;
                }
                this.val$forceRecalculationButton.setEnabled(bl);
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$forceRecalculationButton = button_;
                this.val$canvas = dualAppletCanvas;
            }
        }, forceRecalculationButton}})}, {new Checkbox_(this, this, "Show angle changes as arcs", this.showAngleChangeArcs, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showAngleChangeArcs = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}, {new Checkbox_(this, this, "Show half-angle changes as arcs", this.showHalfAngleChangeArcs, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showHalfAngleChangeArcs = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}, {new Checkbox_(this, this, "Show rectified primal-dual", this.showRectified, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showRectified = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}, {new Checkbox_(this, this, "Show inverses", this.showInverses, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showInverses = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}, {new Checkbox_(this, this, "Show circular-arc \"half-inverses\"", this.showHalfInverses, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showHalfInverses = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}, {new Checkbox_(this, this, "Show log-spiral-arc \"half-inverses\"", this.showLogHalfInverses, canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                this.this$0.showLogHalfInverses = this.getState();
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}, {new Button_(this, "Swap primal with dual", canvas){
            final /* synthetic */ DualApplet this$0;
            final /* synthetic */ DualAppletCanvas val$canvas;

            public final boolean action(Event e, Object what) {
                double radius = DualApplet.calcReciprocationRadius(this.this$0.verts, this.this$0.center, this.this$0.radiusMethod, this.this$0.mostRecentRadius);
                double[][] dualVerts = DualApplet.calcReciprocalVerts(this.this$0.verts, this.this$0.center, radius);
                this.this$0.verts = dualVerts;
                this.val$canvas.repaint();
                return true;
            }
            {
                this.this$0 = dualApplet;
                this.val$canvas = dualAppletCanvas;
            }
        }}})};
        this.controlPanelFrame.add(new MyPanel(objectArray5));
        this.controlPanelFrame.pack();
    }

    private static abstract class LittleKeyCanvas
    extends Canvas_ {
        Canvas mainCanvas;

        abstract void drawOneThing(Graphics var1, double[] var2);

        protected void init() {
            super.init();
            this.setSize(33, 11);
        }

        public void paint(Graphics g) {
            double[] pos = new double[]{(double)(-this.mainCanvas.size().width) * 0.5 + (double)5, (double)(-this.mainCanvas.size().height) * 0.5 + (double)5};
            g.setColor(Color.red);
            this.drawOneThing(g, pos);
            pos[0] = pos[0] + 11.0;
            g.setColor(Color.green);
            this.drawOneThing(g, pos);
            pos[0] = pos[0] + 11.0;
            g.setColor(Color.yellow);
            this.drawOneThing(g, pos);
        }

        LittleKeyCanvas(Canvas mainCanvas) {
            this.mainCanvas = mainCanvas;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DualAppletCanvas
    extends Canvas
    implements MouseListener,
    MouseMotionListener,
    KeyListener {
        boolean requestedFocusYet;

        public boolean isFocusTraversable() {
            return true;
        }

        public void mousePressed(MouseEvent e) {
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("in mousePressed: " + e);
            }
            if (DualApplet.this.eventVerbose >= 1) {
                if (DualApplet.getButton(e) == 1) {
                    System.out.println("    (left mouse)");
                }
                if (DualApplet.getButton(e) == 2) {
                    System.out.println("    (middle mouse)");
                }
                if (DualApplet.getButton(e) == 3) {
                    System.out.println("    (right mouse)");
                }
            }
            double[] thisP = new double[]{(double)e.getX() - (double)this.size().width * 0.5, (double)e.getY() - (double)this.size().height * 0.5};
            int whichButton = DualApplet.getButton(e);
            if (whichButton == 1) {
                double distToCircle;
                double radius;
                double[][] dualVerts;
                int selectedDualPointIndex;
                double[] theSelectedPoint;
                DualApplet.this.button1IsDown = true;
                DualApplet.this.selectedPointIndex = DualApplet.this.findClosestVertIndex(thisP, DualApplet.this.verts, DualApplet.this.verts.length + 1, DualApplet.this.pickRadius);
                int n = 0;
                if (DualApplet.this.selectedPointIndex == -1) {
                    n = 1;
                }
                DualApplet.this.selectedPolygon = 0 - n;
                double[] dArray = DualApplet.this.selectedPointIndex == -1 ? null : (theSelectedPoint = DualApplet.this.selectedPointIndex == DualApplet.this.verts.length ? DualApplet.this.center : DualApplet.this.verts[DualApplet.this.selectedPointIndex]);
                if (DualApplet.this.verts.length >= 3 && (selectedDualPointIndex = DualApplet.this.findClosestVertIndex(thisP, dualVerts = DualApplet.calcReciprocalVerts(DualApplet.this.verts, DualApplet.this.center, radius = DualApplet.calcReciprocationRadius(DualApplet.this.verts, DualApplet.this.center, DualApplet.this.radiusMethod, DualApplet.this.mostRecentRadius)), dualVerts.length + 1, DualApplet.this.pickRadius)) != -1 && (DualApplet.this.selectedPointIndex == -1 || DualApplet.this.selectedPointIndex >= 0 && DualApplet.this.selectedPointIndex < DualApplet.this.verts.length && selectedDualPointIndex >= 0 && selectedDualPointIndex < DualApplet.this.verts.length && VecMath.distsqrd(thisP, dualVerts[selectedDualPointIndex]) < VecMath.distsqrd(thisP, DualApplet.this.verts[DualApplet.this.selectedPointIndex]))) {
                    DualApplet.this.selectedPointIndex = selectedDualPointIndex;
                    DualApplet.this.selectedPolygon = 1;
                    theSelectedPoint = dualVerts[DualApplet.this.selectedPointIndex];
                }
                if (DualApplet.this.radiusMethod == 6 && (distToCircle = Math.abs(VecMath.dist(thisP, DualApplet.this.center) - DualApplet.this.mostRecentRadius)) <= (double)DualApplet.this.pickRadius && (theSelectedPoint == null || distToCircle * distToCircle < VecMath.distsqrd(thisP, theSelectedPoint))) {
                    if (DualApplet.this.eventVerbose >= 1) {
                        System.out.println("picked circle");
                    }
                    DualApplet.this.selectedPointIndex = 1;
                    DualApplet.this.selectedPolygon = 2;
                }
                if ((DualApplet.this.showHalfAngleChangeArcs || DualApplet.this.showAngleChangeArcs) && (distToCircle = Math.abs(VecMath.dist(thisP, DualApplet.this.center) - (double)2 * DualApplet.this.mostRecentRadius)) <= (double)DualApplet.this.pickRadius && (theSelectedPoint == null || distToCircle * distToCircle < VecMath.distsqrd(thisP, theSelectedPoint))) {
                    if (DualApplet.this.eventVerbose >= 1) {
                        System.out.println("picked arcs circle");
                    }
                    DualApplet.this.selectedPointIndex = 1;
                    DualApplet.this.selectedPolygon = 3;
                    DualApplet.this.selectedArcAngle = Math.atan2(thisP[1] - DualApplet.this.center[1], thisP[0] - DualApplet.this.center[0]);
                }
                if (DualApplet.this.selectedPolygon == 0 && DualApplet.this.selectedPointIndex == DualApplet.this.verts.length) {
                    DualApplet.this.selectedPolygon = 2;
                    DualApplet.this.selectedPointIndex = 0;
                }
                if (DualApplet.this.eventVerbose >= 1) {
                    System.out.println("selectedPolygon = " + DualApplet.this.selectedPolygon);
                    System.out.println("selectedPointIndex = " + DualApplet.this.selectedPointIndex);
                }
            } else if (whichButton == 2) {
                DualApplet.this.button2IsDown = true;
                int selectedEdgeIndex = DualApplet.this.findClosestEdgeIndex(thisP, DualApplet.this.verts);
                int newInd = selectedEdgeIndex + 1;
                double[][] newVerts = new double[DualApplet.this.verts.length + 1][];
                int n = DualApplet.this.verts.length;
                int i = 0;
                while (i < newInd) {
                    newVerts[i] = DualApplet.this.verts[i];
                    ++i;
                }
                newVerts[newInd] = thisP;
                i = newInd;
                while (i < DualApplet.this.verts.length) {
                    newVerts[i + 1] = DualApplet.this.verts[i];
                    ++i;
                }
                DualApplet.this.verts = newVerts;
                DualApplet.this.selectedPointIndex = newInd;
                DualApplet.this.selectedPolygon = 0;
            } else if (whichButton == 3) {
                DualApplet.this.button3IsDown = true;
                int bestI = DualApplet.this.findClosestVertIndex(thisP, DualApplet.this.verts, DualApplet.this.verts.length, Double.POSITIVE_INFINITY);
                if (bestI != -1) {
                    double[][] newVerts = new double[DualApplet.this.verts.length - 1][];
                    int n = newVerts.length;
                    int i = 0;
                    while (i < n) {
                        newVerts[i] = DualApplet.this.verts[i >= bestI ? i + 1 : i];
                        ++i;
                    }
                    DualApplet.this.verts = newVerts;
                }
                DualApplet.this.selectedPointIndex = -1;
                DualApplet.this.selectedPolygon = -1;
            }
            DualApplet.this.prevP = thisP;
            this.repaint();
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("out mousePressed: " + e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("in mouseReleased: " + e);
            }
            double[] thisP = new double[]{(double)e.getX() - (double)this.size().width * 0.5, (double)e.getY() - (double)this.size().height * 0.5};
            int whichButton = DualApplet.getButton(e);
            if (whichButton == 1) {
                DualApplet.this.button1IsDown = false;
                this.repaint();
            } else if (whichButton == 2) {
                DualApplet.this.button2IsDown = false;
                this.repaint();
            } else if (whichButton == 3) {
                DualApplet.this.button3IsDown = false;
                this.repaint();
            }
            DualApplet.this.button3IsDown = false;
            DualApplet.this.button2IsDown = false;
            DualApplet.this.button1IsDown = false;
            DualApplet.this.selectedPolygon = -1;
            DualApplet.this.selectedPointIndex = -1;
            DualApplet.this.prevP = thisP;
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("out mouseReleased: " + e);
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (DualApplet.this.eventVerbose >= 2) {
                System.out.println("in mouseEntered: " + e);
            }
            if (DualApplet.this.eventVerbose >= 2) {
                System.out.println("out mouseEntered: " + e);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (DualApplet.this.eventVerbose >= 2) {
                System.out.println("in mouseExited: " + e);
            }
            if (DualApplet.this.eventVerbose >= 2) {
                System.out.println("out mouseExited: " + e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("in mouseClicked: " + e);
            }
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("out mouseClicked: " + e);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (DualApplet.this.eventVerbose >= 2) {
                System.out.println("  in mouseDragged: " + e);
            }
            double[] thisP = new double[]{(double)e.getX() - (double)this.size().width * 0.5, (double)e.getY() - (double)this.size().height * 0.5};
            if (DualApplet.this.button1IsDown || DualApplet.this.button2IsDown) {
                double[] delta = VecMath.vmv(thisP, DualApplet.this.prevP);
                if (DualApplet.this.selectedPolygon == 0) {
                    VecMath.vpv(DualApplet.this.verts[DualApplet.this.selectedPointIndex], DualApplet.this.verts[DualApplet.this.selectedPointIndex], delta);
                } else if (DualApplet.this.selectedPolygon == 1) {
                    double radius = DualApplet.calcReciprocationRadius(DualApplet.this.verts, DualApplet.this.center, DualApplet.this.radiusMethod, DualApplet.this.mostRecentRadius);
                    double[][] dualVerts = DualApplet.calcReciprocalVerts(DualApplet.this.verts, DualApplet.this.center, radius);
                    VecMath.vpv(dualVerts[DualApplet.this.selectedPointIndex], dualVerts[DualApplet.this.selectedPointIndex], delta);
                    radius = DualApplet.calcReciprocationRadius(dualVerts, DualApplet.this.center, DualApplet.this.radiusMethod, DualApplet.this.mostRecentRadius);
                    DualApplet.this.verts = DualApplet.calcReciprocalVerts(dualVerts, DualApplet.this.center, radius);
                    VecMath.upshift(DualApplet.this.verts, DualApplet.this.verts);
                } else if (DualApplet.this.selectedPolygon == 2) {
                    if (DualApplet.this.selectedPointIndex == 0) {
                        VecMath.vpv(DualApplet.this.center, DualApplet.this.center, delta);
                    } else if (DualApplet.this.selectedPointIndex == 1) {
                        DualApplet.this.mostRecentRadius += VecMath.dist(thisP, DualApplet.this.center) - VecMath.dist(DualApplet.this.prevP, DualApplet.this.center);
                    }
                } else if (DualApplet.this.selectedPolygon == 3) {
                    DualApplet.this.selectedArcAngle = Math.atan2(thisP[1] - DualApplet.this.center[1], thisP[0] - DualApplet.this.center[0]);
                } else {
                    DualApplet.this.pan(delta);
                }
            }
            boolean cfr_ignored_0 = DualApplet.this.button3IsDown;
            DualApplet.this.prevP = thisP;
            this.repaint();
            if (DualApplet.this.eventVerbose >= 2) {
                System.out.println("  out mouseDragged: " + e);
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (DualApplet.this.eventVerbose >= 3) {
                System.out.println("    in mouseMoved: " + e);
            }
            if (DualApplet.this.eventVerbose >= 3) {
                System.out.println("    out mouseMoved: " + e);
            }
        }

        public void keyPressed(KeyEvent e) {
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("in keyPressed: " + e);
            }
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("(int)e.getKeyChar()+0 = " + e.getKeyChar());
            }
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("e.getModifiers() = " + e.getModifiers());
            }
            DualApplet.this.controlIsDown = (e.getModifiers() & 2) != 0;
            int ind = -1;
            int dir = 0;
            int keyCode = e.getKeyCode();
            switch (keyCode) {
                case 37: {
                    ind = 0;
                    dir = -1;
                    break;
                }
                case 39: {
                    ind = 0;
                    dir = 1;
                    this.repaint();
                    break;
                }
                case 38: {
                    ind = 1;
                    dir = -1;
                    this.repaint();
                    break;
                }
                case 40: {
                    ind = 1;
                    dir = 1;
                    break;
                }
                case 17: {
                    DualApplet.this.controlIsDown = true;
                    break;
                }
                default: {
                    return;
                }
            }
            if (keyCode == 37 || keyCode == 39 || keyCode == 38 || keyCode == 40) {
                double amount;
                double d = amount = e.isControlDown() ? 1.0 : 10.0;
                if (e.isShiftDown()) {
                    double[] delta = new double[2];
                    delta[ind] = (double)dir * amount;
                    DualApplet.this.pan(delta);
                    int n = ind;
                    DualApplet.this.center[n] = DualApplet.this.center[n] - (double)dir * amount;
                } else {
                    int n = ind;
                    DualApplet.this.center[n] = DualApplet.this.center[n] + (double)dir * amount;
                }
                this.repaint();
            }
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("out keyPressed: " + e);
            }
        }

        public void keyTyped(KeyEvent e) {
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("in keyTyped: " + e);
            }
            if ((e.getModifiers() & 2) != 0) {
                DualApplet.this.controlIsDown = true;
            }
            char c = e.getKeyChar();
            switch (c) {
                case 'V': {
                    System.out.print("eventVerbose " + DualApplet.this.eventVerbose);
                    DualApplet.this.eventVerbose = (DualApplet.this.eventVerbose + 1) % 4;
                    System.out.println(" -> " + DualApplet.this.eventVerbose);
                    break;
                }
                case '\u0006': {
                    DualApplet.this.followMethod = 4;
                    System.out.print("followMethod -> " + followMethodStrings[DualApplet.this.followMethod]);
                    this.repaint();
                    break;
                }
                case '\u0014': {
                    DualApplet.this.showETCcenter ^= true;
                    System.out.println("showETCcenter -> " + DualApplet.this.showETCcenter);
                    if (DualApplet.this.showETCcenter && DualApplet.this.verts.length != 3) {
                        System.out.println("    (but of course it's only applicable to triangles)");
                    }
                    this.repaint();
                    break;
                }
                case 't': {
                    ETC.increment(DualApplet.this.ETCindex);
                    System.out.println("ETCindex = " + DualApplet.this.ETCindex[0] + ',' + DualApplet.this.ETCindex[1] + ',' + DualApplet.this.ETCindex[2] + "                            " + ETC.getName(DualApplet.this.ETCindex[0]));
                    if (ETC.isOnLineAtInfinity(DualApplet.this.ETCindex[0])) {
                        System.out.println("                (INFINITE)");
                    }
                    this.repaint();
                    break;
                }
                case 'T': {
                    ETC.decrement(DualApplet.this.ETCindex);
                    System.out.println("ETCindex = " + DualApplet.this.ETCindex[0] + ',' + DualApplet.this.ETCindex[1] + ',' + DualApplet.this.ETCindex[2] + "                            " + ETC.getName(DualApplet.this.ETCindex[0]));
                    if (ETC.isOnLineAtInfinity(DualApplet.this.ETCindex[0])) {
                        System.out.println("                (INFINITE)");
                    }
                    this.repaint();
                    break;
                }
                case 'g': {
                    DualApplet.this.showGrids ^= true;
                    System.out.println("showGrids -> " + DualApplet.this.showGrids);
                    this.repaint();
                    break;
                }
                case 'r': {
                    DualApplet.this.showRectified ^= true;
                    System.out.println("showRectified -> " + DualApplet.this.showRectified);
                    this.repaint();
                    break;
                }
                case 'R': {
                    DualApplet.this.showRectifiedStructure ^= true;
                    System.out.println("showRectifiedStructure -> " + DualApplet.this.showRectifiedStructure);
                    this.repaint();
                    break;
                }
                case 'h': {
                    DualApplet.this.showHalfAngleChangeArcs ^= true;
                    System.out.println("showHalfAngleChangeArcs -> " + DualApplet.this.showHalfAngleChangeArcs);
                    this.repaint();
                    break;
                }
                case 'f': {
                    DualApplet.this.showAngleChangeArcs ^= true;
                    System.out.println("showAngleChangeArcs -> " + DualApplet.this.showAngleChangeArcs);
                    this.repaint();
                    break;
                }
                case 'S': {
                    DualApplet.this.showMySpiralCG ^= true;
                    System.out.println("showMySpiralCG -> " + DualApplet.this.showMySpiralCG);
                    this.repaint();
                    break;
                }
                case 'P': {
                    DualApplet.this.showMyPaperCG ^= true;
                    System.out.println("showMyPaperCG -> " + DualApplet.this.showMyPaperCG);
                    this.repaint();
                    break;
                }
                case 'G': {
                    DualApplet.this.showGrids = true;
                    DualApplet.this.cachedGrids = null;
                    this.repaint();
                    break;
                }
                case 'O': {
                    DualApplet.this.gridIsOnion ^= true;
                    System.out.println("gridIsOnion -> " + DualApplet.this.gridIsOnion);
                    DualApplet.this.cachedGrids = null;
                    this.repaint();
                    break;
                }
                case 's': {
                    double radius = DualApplet.calcReciprocationRadius(DualApplet.this.verts, DualApplet.this.center, DualApplet.this.radiusMethod, DualApplet.this.mostRecentRadius);
                    double[][] dualVerts = DualApplet.calcReciprocalVerts(DualApplet.this.verts, DualApplet.this.center, radius);
                    DualApplet.this.verts = dualVerts;
                    this.repaint();
                    break;
                }
                case '\u0013': {
                    Arrays.reverse(DualApplet.this.verts, DualApplet.this.verts);
                    this.repaint();
                    break;
                }
                case ' ': {
                    this.repaint();
                    break;
                }
                case 'b': {
                    DualApplet.this.doDoubleBuffer ^= true;
                    System.out.println("doDoubleBuffer -> " + DualApplet.this.doDoubleBuffer);
                    this.repaint();
                    break;
                }
                case 'c': {
                    if (DualApplet.this.controlPanelFrame.isVisible()) {
                        DualApplet.this.controlPanelFrame.hide();
                        break;
                    }
                    DualApplet.this.controlPanelFrame.show();
                    break;
                }
                case '+': 
                case '=': 
                case 'i': {
                    DualApplet.this.zoom(Math.sqrt(2), Math.sqrt(2));
                    this.repaint();
                    break;
                }
                case '-': 
                case 'o': {
                    DualApplet.this.zoom(Math.sqrt(0.5), Math.sqrt(0.5));
                    this.repaint();
                    break;
                }
                case 'C': {
                    DualApplet.this.pan(VecMath.sxv(-1.0, DualApplet.this.center));
                    this.repaint();
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (c == '1' && DualApplet.this.controlIsDown) {
                        DualApplet.this.mostRecentRadius = 1.0;
                    } else {
                        int n = c - 48;
                        if (n < 3) {
                            n += 10;
                        }
                        if (n == 3 && DualApplet.this.controlIsDown) {
                            DualApplet.this.verts = DualApplet.makeTriangleWithGivenSides(60.0, 90.0, 130.0);
                        } else if (n == 12 && DualApplet.this.controlIsDown) {
                            double[][] dArrayArray = new double[3][];
                            dArrayArray[0] = new double[2];
                            double[] dArray = new double[2];
                            dArray[0] = 100.0;
                            dArrayArray[1] = dArray;
                            dArrayArray[2] = new double[]{50.0, 200.0};
                            DualApplet.this.verts = dArrayArray;
                        } else {
                            DualApplet.this.verts = DualApplet.makeRegularPolygon(n, 100.0);
                        }
                        DualApplet.this.center = VecMath.average(DualApplet.this.verts);
                    }
                    this.repaint();
                    break;
                }
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '@': 
                case '^': {
                    int n = ")!@#$%^&*(".indexOf(c);
                    if (n < 1) {
                        n += 10;
                    }
                    DualApplet.this.verts = DualApplet.makeRegularPolygon(n *= 10, 100.0);
                    DualApplet.this.center = VecMath.average(DualApplet.this.verts);
                    this.repaint();
                    break;
                }
                case 'Q': {
                    System.exit(0);
                    break;
                }
                default: {
                    System.out.println("Unknown key '" + c + "' typed");
                    break;
                }
            }
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("out keyTyped: " + e);
            }
        }

        public void keyReleased(KeyEvent e) {
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("in keyReleased: " + e);
            }
            switch (e.getKeyCode()) {
                case 17: {
                    DualApplet.this.controlIsDown = false;
                    return;
                }
            }
            DualApplet.this.controlIsDown = (e.getModifiers() & 2) != 0;
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("out keyReleased: " + e);
            }
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void paint(Graphics frontBufferGraphics) {
            int i;
            double[][] pointAndNormal;
            double[] allCustomAvg;
            double[] allCurvatureAvg;
            double[] allAreaAvg;
            double[] allEdgesAvg;
            double[] allVertsAvg;
            double[] dualCustomAvg;
            double[] customAvg;
            double[] dualCurvatureAvg;
            double[] dualAreaAvg;
            double[] dualEdgesAvg;
            double[] dualVertsAvg;
            double[] curvatureAvg;
            double[] areaAvg;
            double[] edgesAvg;
            double[] vertsAvg;
            double[][] dualVerts;
            double radius;
            Graphics g;
            block106: {
                block104: {
                    int j;
                    block105: {
                        boolean cacheIsGood;
                        block103: {
                            double[] paperReciprocationCenter;
                            double[] customAvg2;
                            double temp;
                            if (DualApplet.this.eventVerbose >= 1) {
                                System.out.println("in paint");
                            }
                            if (DualApplet.this.eventVerbose >= 1) {
                                System.out.println("this.size() = " + this.size());
                            }
                            if (!this.requestedFocusYet) {
                                if (DualApplet.this.eventVerbose >= 1) {
                                    System.out.println("    requesting focus!");
                                }
                                this.requestFocus();
                            }
                            this.makeSureBackBufferIsRight();
                            g = DualApplet.this.doDoubleBuffer ? DualApplet.this.backBufferImage.getGraphics() : frontBufferGraphics;
                            g.setColor(Color.black);
                            g.fillRect(0, 0, this.size().width, this.size().height);
                            if (!(DualApplet.this.followMethod != 1 || DualApplet.this.selectedPolygon != -1 && DualApplet.this.selectedPolygon != 0 || DualApplet.this.verts.length < 3 || Double.isNaN(temp = DualApplet.calcCustomCG(customAvg2 = new double[DualApplet.this.verts[0].length], DualApplet.this.verts, DualApplet.this.center, DualApplet.this.mostRecentRadius, DualApplet.this.customCGfun, DualApplet.this.whichCustomCGvariableOfIntegration)))) {
                                DualApplet.this.center = customAvg2;
                            }
                            if (DualApplet.this.followMethod == 2 && (DualApplet.this.selectedPolygon == -1 || DualApplet.this.selectedPolygon == 0) && DualApplet.this.verts.length >= 3) {
                                double savedMostRecentRadius = DualApplet.this.mostRecentRadius;
                                double[] savedCenter = DualApplet.this.center;
                                int nIters = DualApplet.this.selectedPolygon == -1 ? 100 : 10;
                                int iIter = 0;
                                while (iIter < nIters) {
                                    double[] customAvg3 = new double[DualApplet.this.verts[0].length];
                                    double[][] dualVerts2 = DualApplet.calcReciprocalVerts(DualApplet.this.verts, DualApplet.this.center, DualApplet.this.mostRecentRadius);
                                    double temp2 = DualApplet.calcCustomCGofCGs(customAvg3, DualApplet.this.verts, dualVerts2, DualApplet.this.center, DualApplet.this.mostRecentRadius, DualApplet.this.customCGfun, DualApplet.this.whichCustomCGvariableOfIntegration, DualApplet.this.weightCGofCGs);
                                    if (!Double.isNaN(temp2)) {
                                        DualApplet.this.center = customAvg3;
                                        DualApplet.this.mostRecentRadius = DualApplet.calcReciprocationRadius(DualApplet.this.verts, DualApplet.this.center, DualApplet.this.radiusMethod, DualApplet.this.mostRecentRadius);
                                        ++iIter;
                                        continue;
                                    }
                                    DualApplet.this.center = savedCenter;
                                    DualApplet.this.mostRecentRadius = savedMostRecentRadius;
                                    break;
                                }
                            } else if (DualApplet.this.followMethod == 4 && DualApplet.this.selectedPolygon == 0 && DualApplet.this.verts.length == 3) {
                                double[] primalCG = ETC.calcCenter(DualApplet.this.ETCindex[0], DualApplet.this.ETCindex[1], DualApplet.this.ETCindex[2], DualApplet.this.verts[0], DualApplet.this.verts[1], DualApplet.this.verts[2]);
                                DualApplet.this.center = primalCG;
                            } else if (DualApplet.this.followMethod == 3 && (DualApplet.this.selectedPolygon == -1 || DualApplet.this.selectedPolygon == 0) && DualApplet.this.verts.length >= 3 && (paperReciprocationCenter = DualApplet.calcMyPaperReciprocationCenter(DualApplet.this.verts, DualApplet.this.center)) != null) {
                                DualApplet.this.center = paperReciprocationCenter;
                            }
                            DualApplet.this.mostRecentRadius = radius = DualApplet.calcReciprocationRadius(DualApplet.this.verts, DualApplet.this.center, DualApplet.this.radiusMethod, DualApplet.this.mostRecentRadius);
                            dualVerts = DualApplet.calcReciprocalVerts(DualApplet.this.verts, DualApplet.this.center, radius);
                            if (DualApplet.this.showDirectionsGraph) {
                                this.drawDirectionsGraph(g, DualApplet.this.center, DualApplet.this.verts, dualVerts, 0.0, this.size().width, this.size().height, 0.0);
                            }
                            vertsAvg = VecMath.average(DualApplet.this.verts);
                            edgesAvg = DualApplet.calcEdgesAvg(DualApplet.this.verts);
                            areaAvg = DualApplet.calcAreaAvg(DualApplet.this.verts);
                            curvatureAvg = DualApplet.calcCurvatureAvg(DualApplet.this.verts);
                            dualVertsAvg = VecMath.average(dualVerts);
                            dualEdgesAvg = DualApplet.calcEdgesAvg(dualVerts);
                            dualAreaAvg = DualApplet.calcAreaAvg(dualVerts);
                            dualCurvatureAvg = DualApplet.calcCurvatureAvg(dualVerts);
                            customAvg = null;
                            dualCustomAvg = null;
                            double customWeightsSum = 1.0;
                            double dualCustomWeightsSum = 1.0;
                            if (DualApplet.this.showCustomCG && DualApplet.this.verts.length >= 1) {
                                customAvg = new double[DualApplet.this.verts[0].length];
                                dualCustomAvg = new double[DualApplet.this.verts[0].length];
                                customWeightsSum = DualApplet.calcCustomCG(customAvg, DualApplet.this.verts, DualApplet.this.center, radius, DualApplet.this.customCGfun, DualApplet.this.whichCustomCGvariableOfIntegration);
                                if (Double.isNaN(customWeightsSum)) {
                                    customAvg = null;
                                }
                                if (Double.isNaN(dualCustomWeightsSum = DualApplet.calcCustomCG(dualCustomAvg, dualVerts, DualApplet.this.center, radius, DualApplet.this.customCGfun, DualApplet.this.whichCustomCGvariableOfIntegration))) {
                                    dualCustomAvg = null;
                                }
                            }
                            allVertsAvg = vertsAvg != null && dualVertsAvg != null ? VecMath.lerp(vertsAvg, dualVertsAvg, 0.5) : null;
                            allEdgesAvg = edgesAvg != null && dualEdgesAvg != null ? VecMath.lerp(edgesAvg, dualEdgesAvg, 0.5) : null;
                            allAreaAvg = areaAvg != null && dualAreaAvg != null ? VecMath.lerp(areaAvg, dualAreaAvg, 0.5) : null;
                            allCurvatureAvg = curvatureAvg != null && dualCurvatureAvg != null ? VecMath.lerp(curvatureAvg, dualCurvatureAvg, 0.5) : null;
                            double[] dArray = allCustomAvg = customAvg != null && dualCustomAvg != null ? VecMath.lerp(customAvg, dualCustomAvg, 0.5) : null;
                            if (DualApplet.this.weightCGofCGs) {
                                if (DualApplet.this.showEdgesCG && allEdgesAvg != null) {
                                    double primalLength = DualApplet.calcPerimeter(DualApplet.this.verts);
                                    double dualLength = DualApplet.calcPerimeter(dualVerts);
                                    VecMath.lerp(allEdgesAvg, edgesAvg, dualEdgesAvg, dualLength / (primalLength + dualLength));
                                }
                                if (DualApplet.this.showAreaCG && allAreaAvg != null) {
                                    double primalArea = DualApplet.calcArea(DualApplet.this.verts);
                                    double dualArea = DualApplet.calcArea(dualVerts);
                                    VecMath.lerp(allAreaAvg, areaAvg, dualAreaAvg, dualArea / (primalArea + dualArea));
                                }
                                if (DualApplet.this.showCustomCG && allCustomAvg != null) {
                                    VecMath.lerp(allCustomAvg, customAvg, dualCustomAvg, dualCustomWeightsSum / (customWeightsSum + dualCustomWeightsSum));
                                }
                            }
                            if (!DualApplet.this.showGrids || DualApplet.this.verts.length < 3) break block105;
                            boolean bl = false;
                            if (DualApplet.this.cachedGrids != null && DualApplet.this.cachedGridIsInverseMap == DualApplet.this.gridIsInverseMap && DualApplet.this.radiusMethod == DualApplet.this.cachedGridRadiusMethod && (DualApplet.this.radiusMethod != 6 || radius - DualApplet.this.cachedGridRadiusIfConstant <= 0.01 && DualApplet.this.cachedGridRadiusIfConstant - radius <= 0.01) && VecMath.equals(DualApplet.this.verts, DualApplet.this.cachedGridVerts, 0.0)) {
                                bl = true;
                            }
                            cacheIsGood = bl;
                            boolean updateWillBeFast = DualApplet.this.gridIsInverseMap ^ true;
                            if (cacheIsGood || (DualApplet.this.button1IsDown || DualApplet.this.button2IsDown || DualApplet.this.button3IsDown) && !updateWillBeFast) break block103;
                            Cursor thisSavedCursor = null;
                            Cursor controlPanelSavedCursor = null;
                            if (!updateWillBeFast) {
                                thisSavedCursor = this.getCursor();
                                controlPanelSavedCursor = DualApplet.this.controlPanelFrame.getCursor();
                                Cursor waitcursor = Cursor.getPredefinedCursor(3);
                                this.setCursor(waitcursor);
                                DualApplet.this.controlPanelFrame.setCursor(waitcursor);
                            }
                            try {
                                try {
                                    DualApplet.this.cachedGrids = DualApplet.calcGrids(DualApplet.this.verts, DualApplet.this.gridIsInverseMap, DualApplet.this.center, DualApplet.this.radiusMethod, DualApplet.this.mostRecentRadius, DualApplet.this.gridIsOnion);
                                    DualApplet.this.cachedGridIsInverseMap = DualApplet.this.gridIsInverseMap;
                                    DualApplet.this.cachedGridRadiusMethod = DualApplet.this.radiusMethod;
                                    DualApplet.this.cachedGridRadiusIfConstant = radius;
                                    DualApplet.this.cachedGridVerts = new double[DualApplet.this.verts.length][DualApplet.this.verts[0].length];
                                    VecMath.copymat(DualApplet.this.cachedGridVerts, DualApplet.this.verts);
                                    cacheIsGood = true;
                                }
                                catch (Error t) {
                                    throw t;
                                }
                                catch (RuntimeException t) {
                                    throw t;
                                }
                            }
                            catch (Throwable waitcursor) {
                                Object var30_97 = null;
                                if (!updateWillBeFast) {
                                    this.setCursor(thisSavedCursor);
                                    DualApplet.this.controlPanelFrame.setCursor(controlPanelSavedCursor);
                                }
                                throw waitcursor;
                            }
                            {
                                Object var30_98 = null;
                                if (updateWillBeFast) break block103;
                            }
                            this.setCursor(thisSavedCursor);
                            DualApplet.this.controlPanelFrame.setCursor(controlPanelSavedCursor);
                        }
                        if (cacheIsGood) {
                            double[][][][] grids = DualApplet.this.cachedGrids;
                            g.setColor(Color.green.darker().darker().darker().darker());
                            DualApplet.drawGrid(g, this.size(), grids[0]);
                            g.setColor(Color.red.darker());
                            DualApplet.drawGrid(g, this.size(), grids[1]);
                        }
                    }
                    if (DualApplet.this.showRobsCG && DualApplet.this.verts.length >= 3) {
                        g.setColor(Color.blue);
                        double[] closest = new double[2];
                        int i2 = 0;
                        while (true) {
                            if (i2 >= DualApplet.this.verts.length) {
                                i2 = 0;
                                break;
                            }
                            if (VecMath.distsqrd(DualApplet.this.center, DualApplet.this.verts[i2]) >= radius * radius) {
                                this.drawLine(g, DualApplet.this.center, DualApplet.this.verts[i2]);
                            } else {
                                DualApplet.findClosestPointOnLine(closest, DualApplet.this.center, dualVerts[(i2 - 1 + DualApplet.this.verts.length) % DualApplet.this.verts.length], dualVerts[i2], false);
                                this.drawLine(g, DualApplet.this.center, closest);
                            }
                            ++i2;
                        }
                        while (i2 < DualApplet.this.verts.length) {
                            if (VecMath.distsqrd(DualApplet.this.center, dualVerts[i2]) >= radius * radius) {
                                this.drawLine(g, DualApplet.this.center, dualVerts[i2]);
                            } else {
                                DualApplet.findClosestPointOnLine(closest, DualApplet.this.center, DualApplet.this.verts[(i2 + 1) % DualApplet.this.verts.length], DualApplet.this.verts[i2], false);
                                this.drawLine(g, DualApplet.this.center, closest);
                            }
                            ++i2;
                        }
                    }
                    g.setColor(Color.white);
                    this.drawCircle(g, DualApplet.this.center, radius);
                    if (DualApplet.this.showRobsCG && DualApplet.this.verts.length >= 3 && DualApplet.this.verts.length > 0) {
                        double[][] normalizedVerts = new double[DualApplet.this.verts.length][DualApplet.this.verts[0].length];
                        double[][] normalizedDualVerts = new double[DualApplet.this.verts.length][DualApplet.this.verts[0].length];
                        int i3 = 0;
                        while (true) {
                            if (i3 >= DualApplet.this.verts.length) break;
                            VecMath.lerp(normalizedVerts[i3], DualApplet.this.center, DualApplet.this.verts[i3], radius / VecMath.dist(DualApplet.this.center, DualApplet.this.verts[i3]));
                            VecMath.lerp(normalizedDualVerts[i3], DualApplet.this.center, dualVerts[i3], radius / VecMath.dist(DualApplet.this.center, dualVerts[i3]));
                            ++i3;
                        }
                        g.setColor(Color.red);
                        i3 = 0;
                        while (true) {
                            if (i3 >= DualApplet.this.verts.length) break;
                            this.drawHollowDot(g, normalizedVerts[i3], 5);
                            ++i3;
                        }
                        g.setColor(Color.green);
                        i3 = 0;
                        while (true) {
                            if (i3 >= dualVerts.length) {
                                double[] primalAvg = VecMath.average(normalizedVerts);
                                double[] dualAvg = VecMath.average(normalizedDualVerts);
                                double[] avg = VecMath.lerp(primalAvg, dualAvg, 0.5);
                                g.setColor(Color.red);
                                this.drawHollowDot(g, primalAvg, 5);
                                g.setColor(Color.green);
                                this.drawHollowDot(g, dualAvg, 5);
                                g.setColor(Color.yellow);
                                this.drawHollowDot(g, avg, 5);
                                break;
                            }
                            this.drawHollowDot(g, normalizedDualVerts[i3], 5);
                            ++i3;
                        }
                    }
                    g.setColor(Color.red);
                    int n = DualApplet.this.verts.length;
                    int i4 = 0;
                    while (true) {
                        if (i4 >= n) break;
                        this.drawLine(g, DualApplet.this.verts[i4], DualApplet.this.verts[(i4 + 1) % n]);
                        ++i4;
                    }
                    i4 = 0;
                    while (true) {
                        if (i4 >= n) break;
                        this.drawDot(g, DualApplet.this.verts[i4], 3);
                        ++i4;
                    }
                    g.setColor(Color.green);
                    n = dualVerts.length;
                    i4 = 0;
                    while (true) {
                        if (i4 >= n) break;
                        this.drawLine(g, dualVerts[i4], dualVerts[(i4 + 1) % n]);
                        ++i4;
                    }
                    i4 = 0;
                    while (true) {
                        if (i4 >= n) {
                            if (DualApplet.this.showRectifiedStructure) {
                                break;
                            }
                            break block104;
                        }
                        this.drawDot(g, dualVerts[i4], 3);
                        ++i4;
                    }
                    int n2 = DualApplet.this.verts.length;
                    double[][] temp = new double[n2][2];
                    g.setColor(Color.red);
                    i4 = 0;
                    block16: while (true) {
                        if (i4 >= n2) {
                            g.setColor(Color.green);
                            i4 = 0;
                            break;
                        }
                        VecMath.mpv(temp, DualApplet.this.verts, dualVerts[i4]);
                        VecMath.mmv(temp, temp, DualApplet.this.center);
                        j = 0;
                        while (true) {
                            if (j >= n2) {
                                ++i4;
                                continue block16;
                            }
                            this.drawLine(g, temp[j], temp[(j + 1) % n2]);
                            ++j;
                        }
                        break;
                    }
                    block18: while (i4 < n2) {
                        VecMath.mpv(temp, dualVerts, DualApplet.this.verts[i4]);
                        VecMath.mmv(temp, temp, DualApplet.this.center);
                        j = 0;
                        while (true) {
                            if (j >= n2) {
                                ++i4;
                                continue block18;
                            }
                            this.drawLine(g, temp[j], temp[(j + 1) % n2]);
                            ++j;
                        }
                    }
                    break block106;
                }
                if (DualApplet.this.showRectified) {
                    double[][] rectifiedVerts = DualApplet.calcRectifiedVerts(DualApplet.this.verts, dualVerts, DualApplet.this.center);
                    int n = DualApplet.this.verts.length;
                    g.setColor(Color.red);
                    int i5 = 0;
                    while (true) {
                        if (i5 >= n) {
                            g.setColor(Color.green);
                            i5 = 0;
                            break;
                        }
                        this.drawLine(g, rectifiedVerts[2 * i5], rectifiedVerts[2 * i5 + 1]);
                        ++i5;
                    }
                    while (i5 < n) {
                        this.drawLine(g, rectifiedVerts[2 * i5 + 1], rectifiedVerts[(2 * i5 + 2) % (2 * n)]);
                        ++i5;
                    }
                }
            }
            if (DualApplet.this.showHalfAngleChangeArcs) {
                Arc[] arcs = DualApplet.calcAngleChangeArcs(DualApplet.this.verts, dualVerts, DualApplet.this.center, radius, true);
                this.drawArcs(g, arcs, Color.red, Color.green);
            }
            if (DualApplet.this.showAngleChangeArcs) {
                Arc[] arcs = DualApplet.calcAngleChangeArcs(DualApplet.this.verts, dualVerts, DualApplet.this.center, radius, false);
                this.drawArcs(g, arcs, Color.red, Color.green);
            }
            if (DualApplet.this.showInverses) {
                Arc[] arcs = DualApplet.calcInverses(DualApplet.this.verts, dualVerts, DualApplet.this.center, radius, false);
                this.drawArcs(g, arcs, Color.red, Color.green);
            }
            if (DualApplet.this.showHalfInverses) {
                Arc[] arcs = DualApplet.calcInverses(DualApplet.this.verts, dualVerts, DualApplet.this.center, radius, true);
                this.drawArcs(g, arcs, Color.yellow, Color.yellow);
            }
            boolean cfr_ignored_0 = DualApplet.this.showHalfInverses;
            if (DualApplet.this.showLogHalfInverses) {
                g.setColor(Color.orange.darker());
                int subDiv = 100;
                double[] w = new double[2];
                double[] temp = new double[2];
                int n = DualApplet.this.verts.length;
                int i6 = 0;
                block22: while (i6 < n) {
                    int j = 0;
                    block23: while (true) {
                        if (j >= 2) {
                            ++i6;
                            continue block22;
                        }
                        double[] v = DualApplet.this.verts[i6];
                        VecMath.copyvec(w, dualVerts[j == 0 ? i6 : (i6 - 1 + n) % n]);
                        double angV = Math.atan2(v[1] - DualApplet.this.center[1], v[0] - DualApplet.this.center[0]);
                        double angW = DualApplet.adjustAngle(Math.atan2(w[1] - DualApplet.this.center[1], w[0] - DualApplet.this.center[0]), angV);
                        double radV = VecMath.dist(DualApplet.this.center, v);
                        double radW = radius * radius / VecMath.dist(DualApplet.this.center, w);
                        int k = 0;
                        while (true) {
                            if (k >= subDiv + 1) {
                                ++j;
                                continue block23;
                            }
                            double t = (double)k / (double)subDiv;
                            double ang = angV + t * (angW - angV);
                            double rad = radV * Math.pow(radW / radV, t);
                            temp[0] = DualApplet.this.center[0] + rad * Math.cos(ang);
                            temp[1] = DualApplet.this.center[1] + rad * Math.sin(ang);
                            this.drawDot(g, temp, 1);
                            VecMath.lerp(temp, DualApplet.this.center, temp, radius * radius / (rad * rad));
                            this.drawDot(g, temp, 1);
                            ++k;
                        }
                        break;
                    }
                }
            }
            if (DualApplet.this.selectedPolygon == 3 && DualApplet.this.verts.length >= 3 && (pointAndNormal = DualApplet.this.findPointAndNormalFromPickAngle(DualApplet.this.selectedArcAngle, DualApplet.this.verts, dualVerts, DualApplet.this.center)) != null) {
                g.setColor(Color.red);
                this.drawHollowDot(g, pointAndNormal[0], 7);
                g.setColor(Color.green);
                this.drawHollowDot(g, pointAndNormal[1], 7);
                double[] centralDir = VecMath.vmv(pointAndNormal[0], DualApplet.this.center);
                double[] normalDir = VecMath.vmv(pointAndNormal[1], DualApplet.this.center);
                VecMath.normalize(centralDir, centralDir);
                VecMath.normalize(normalDir, normalDir);
                double[][] arrowTails = new double[][]{DualApplet.this.center, pointAndNormal[0], pointAndNormal[1]};
                double arrowLength = 25.0;
                double arrowHeadLength = 5;
                g.setColor(Color.green);
                i = 0;
                while (true) {
                    if (i >= arrowTails.length) {
                        g.setColor(Color.red);
                        i = 0;
                        break;
                    }
                    this.drawArrow(g, arrowTails[i], normalDir, arrowLength, arrowHeadLength);
                    ++i;
                }
                while (i < arrowTails.length) {
                    this.drawArrow(g, arrowTails[i], centralDir, arrowLength, arrowHeadLength);
                    ++i;
                }
            }
            if (DualApplet.this.verts.length >= 3) {
                if (DualApplet.this.showVertsCG) {
                    g.setColor(Color.red);
                    this.drawDot(g, vertsAvg, 3);
                    g.setColor(Color.green);
                    this.drawDot(g, dualVertsAvg, 3);
                    g.setColor(Color.yellow);
                    this.drawDot(g, allVertsAvg, 3);
                    if (DualApplet.this.eventVerbose >= 1 && DualApplet.this.verts.length == 3) {
                        System.out.println("calcReferenceNumber(verts, vertsAvg) = " + DualApplet.calcReferenceNumber(DualApplet.this.verts, vertsAvg));
                    }
                }
                if (DualApplet.this.showEdgesCG) {
                    g.setColor(Color.red);
                    this.drawSlash(g, edgesAvg, 7);
                    g.setColor(Color.green);
                    this.drawSlash(g, dualEdgesAvg, 7);
                    g.setColor(Color.yellow);
                    this.drawSlash(g, allEdgesAvg, 7);
                    if (DualApplet.this.eventVerbose >= 1 && DualApplet.this.verts.length == 3) {
                        System.out.println("calcReferenceNumber(verts, edgesAvg) = " + DualApplet.calcReferenceNumber(DualApplet.this.verts, edgesAvg));
                    }
                }
                if (DualApplet.this.showAreaCG) {
                    g.setColor(Color.red);
                    this.drawRect(g, areaAvg, 7);
                    g.setColor(Color.green);
                    this.drawRect(g, dualAreaAvg, 7);
                    g.setColor(Color.yellow);
                    this.drawRect(g, allAreaAvg, 7);
                    if (DualApplet.this.eventVerbose >= 1 && DualApplet.this.verts.length == 3) {
                        System.out.println("calcReferenceNumber(verts, areaAvg) = " + DualApplet.calcReferenceNumber(DualApplet.this.verts, areaAvg));
                    }
                }
                if (DualApplet.this.showCurvatureCG) {
                    g.setColor(Color.red);
                    this.drawCurl(g, curvatureAvg, 7);
                    g.setColor(Color.green);
                    this.drawCurl(g, dualCurvatureAvg, 7);
                    g.setColor(Color.yellow);
                    this.drawCurl(g, allCurvatureAvg, 7);
                    if (DualApplet.this.eventVerbose >= 1 && DualApplet.this.verts.length == 3) {
                        System.out.println("calcReferenceNumber(verts, curvatureAvg) = " + DualApplet.calcReferenceNumber(DualApplet.this.verts, curvatureAvg));
                    }
                }
                if (DualApplet.this.showMyCG) {
                    boolean myCGVerbose = false;
                    MyCGComponents temp = DualApplet.this.myCGComponents;
                    DualApplet.this.myCGComponents = DualApplet.this.prevMyCGComponents;
                    DualApplet.this.prevMyCGComponents = temp;
                    if (DualApplet.this.myCGComponents == null || DualApplet.this.myCGComponents.n != DualApplet.this.verts.length) {
                        DualApplet.this.myCGComponents = new MyCGComponents(DualApplet.this.verts.length);
                    }
                    double[] myCG = DualApplet.calcMyCG(DualApplet.this.verts, DualApplet.this.center, radius, myCGVerbose, DualApplet.this.myCGComponents);
                    double[] myDualCG = DualApplet.calcMyCG(dualVerts, DualApplet.this.center, radius, false, null);
                    double[] avg = VecMath.lerp(myCG, myDualCG, 0.5);
                    double[] target = DualApplet.calcMyReciprocationCenter(DualApplet.this.verts);
                    if ((DualApplet.this.eventVerbose >= 1 || myCGVerbose) && DualApplet.this.verts.length == 3) {
                        System.out.println("calcReferenceNumber(verts, center) = " + DualApplet.calcReferenceNumber(DualApplet.this.verts, DualApplet.this.center));
                        System.out.println("calcReferenceNumber(verts, target) = " + DualApplet.calcReferenceNumber(DualApplet.this.verts, target));
                    }
                    g.setColor(Color.red);
                    this.drawStringCentered(g, "m", myCG);
                    g.setColor(Color.green);
                    this.drawStringCentered(g, "m", myDualCG);
                    g.setColor(Color.yellow);
                    this.drawStringCentered(g, "m", avg);
                    g.setColor(Color.yellow);
                    this.drawStringCentered(g, "x", target);
                    if (myCGVerbose) {
                        DualApplet.printStuffAboutMyCG(DualApplet.this.prevMyCGComponents, DualApplet.this.myCGComponents);
                    }
                }
                if (DualApplet.this.showMySpiralCG) {
                    double[] myCG = DualApplet.calcMySpiralCG(DualApplet.this.verts, DualApplet.this.center, radius);
                    VecMath.upshift(dualVerts, dualVerts);
                    double[] myDualCG = DualApplet.calcMySpiralCG(dualVerts, DualApplet.this.center, radius);
                    VecMath.downshift(dualVerts, dualVerts);
                    double[] avg = VecMath.lerp(myCG, myDualCG, 0.5);
                    double[] target = DualApplet.calcMySpiralReciprocationCenter(DualApplet.this.verts, DualApplet.this.center);
                    g.setColor(Color.red);
                    this.drawStringCentered(g, "M", myCG);
                    g.setColor(Color.green);
                    this.drawStringCentered(g, "M", myDualCG);
                    g.setColor(Color.yellow);
                    this.drawStringCentered(g, "M", avg);
                    g.setColor(Color.yellow);
                    this.drawStringCentered(g, "X", target);
                }
                if (DualApplet.this.showMyPaperCG) {
                    double[] myCG = DualApplet.calcMyPaperCG(DualApplet.this.verts, dualVerts, DualApplet.this.center, radius, false);
                    VecMath.upshift(dualVerts, dualVerts);
                    double[] myDualCG = DualApplet.calcMyPaperCG(dualVerts, DualApplet.this.verts, DualApplet.this.center, radius, false);
                    VecMath.downshift(dualVerts, dualVerts);
                    double[] avg = VecMath.lerp(myCG, myDualCG, 0.5);
                    double[] symmetric = DualApplet.calcMyPaperCG(DualApplet.this.verts, dualVerts, DualApplet.this.center, radius, true);
                    double[] target = DualApplet.calcMyPaperReciprocationCenter(DualApplet.this.verts, DualApplet.this.center);
                    g.setColor(Color.red);
                    this.drawStringCentered(g, "f", myCG);
                    g.setColor(Color.green);
                    this.drawStringCentered(g, "f", myDualCG);
                    g.setColor(Color.yellow);
                    this.drawStringCentered(g, "f", avg);
                    g.setColor(Color.yellow);
                    this.drawStringCentered(g, "F", symmetric);
                    this.drawStringCentered(g, "X", target);
                    if (DualApplet.this.eventVerbose >= 1) {
                        if (DualApplet.this.verts.length == 3) {
                            System.out.println("calcReferenceNumber(verts, myCG) = " + DualApplet.calcReferenceNumber(DualApplet.this.verts, myCG));
                        }
                        System.out.println("verts =\n" + VecMath.toString(DualApplet.this.verts));
                        System.out.println("myCG = " + VecMath.toString(myCG));
                        System.out.println("radius = " + radius);
                        System.out.println("(myCG[0]-center[0])/radius = " + (myCG[0] - DualApplet.this.center[0]) / radius);
                        System.out.println("(myCG[1]-center[1])/radius = " + (myCG[1] - DualApplet.this.center[1]) / radius);
                        System.out.println("target = " + VecMath.toString(target));
                        if (target != null && DualApplet.this.verts.length == 3) {
                            System.out.println("calcReferenceNumber(verts, target) = " + DualApplet.calcReferenceNumber(DualApplet.this.verts, target));
                        }
                        DualApplet.calcMyPaperF(DualApplet.this.verts, DualApplet.this.center, radius);
                    }
                }
                if (DualApplet.this.showMyFlatCG) {
                    double[] primalCG = DualApplet.calcMyFlatCG(DualApplet.this.verts, DualApplet.this.center, radius);
                    double[] dualCG = DualApplet.calcMyFlatCG(dualVerts, DualApplet.this.center, radius);
                    double[] avg = VecMath.lerp(primalCG, dualCG, 0.5);
                    g.setColor(Color.red);
                    this.drawStringCentered(g, "M", primalCG);
                    g.setColor(Color.green);
                    this.drawStringCentered(g, "M", dualCG);
                    g.setColor(Color.yellow);
                    this.drawStringCentered(g, "M", avg);
                }
                if (DualApplet.this.showCustomCG) {
                    g.setColor(Color.red);
                    this.drawPlus(g, customAvg, 7);
                    g.setColor(Color.green);
                    this.drawPlus(g, dualCustomAvg, 7);
                    g.setColor(Color.yellow);
                    this.drawPlus(g, allCustomAvg, 7);
                }
                if (DualApplet.this.showRadiusMaximizingPoints) {
                    double initialDelta = 0.001;
                    double[] pointThatMaximizesRadius = Minimizer.minimize(new Minimizer.VectorFunction(this){
                        final /* synthetic */ DualAppletCanvas this$0;

                        public final double apply(double[] v) {
                            return -DualApplet.calcReciprocationRadius(this.this$0.DualApplet.this.verts, v, this.this$0.DualApplet.this.radiusMethod, this.this$0.DualApplet.this.mostRecentRadius);
                        }
                        {
                            this.this$0 = dualAppletCanvas;
                        }
                    }, DualApplet.this.center, initialDelta, 500);
                    double[] pointThatMaximizesDualRadius = Minimizer.minimize(new Minimizer.VectorFunction(this, dualVerts){
                        final /* synthetic */ DualAppletCanvas this$0;
                        final /* synthetic */ double[][] val$dualVerts;

                        public final double apply(double[] v) {
                            return -DualApplet.calcReciprocationRadius(this.val$dualVerts, v, this.this$0.DualApplet.this.radiusMethod, this.this$0.DualApplet.this.mostRecentRadius);
                        }
                        {
                            this.this$0 = dualAppletCanvas;
                            this.val$dualVerts = dArray;
                        }
                    }, DualApplet.this.center, initialDelta, 500);
                    double[] pointThatMaximizesProductOfRadii = DualApplet.this.weightCGofCGs ? Minimizer.minimize(new Minimizer.VectorFunction(this, dualVerts){
                        final /* synthetic */ DualAppletCanvas this$0;
                        final /* synthetic */ double[][] val$dualVerts;

                        public final double apply(double[] v) {
                            return -DualApplet.calcReciprocationRadius(this.this$0.DualApplet.this.verts, v, this.this$0.DualApplet.this.radiusMethod, this.this$0.DualApplet.this.mostRecentRadius) * DualApplet.calcReciprocationRadius(this.val$dualVerts, v, this.this$0.DualApplet.this.radiusMethod, this.this$0.DualApplet.this.mostRecentRadius);
                        }
                        {
                            this.this$0 = dualAppletCanvas;
                            this.val$dualVerts = dArray;
                        }
                    }, DualApplet.this.center, initialDelta, 500) : VecMath.lerp(pointThatMaximizesRadius, pointThatMaximizesDualRadius, 0.5);
                    g.setColor(Color.red);
                    this.drawStringCentered(g, "r", pointThatMaximizesRadius);
                    g.setColor(Color.green);
                    this.drawStringCentered(g, "r", pointThatMaximizesDualRadius);
                    g.setColor(Color.yellow);
                    this.drawStringCentered(g, "r", pointThatMaximizesProductOfRadii);
                }
                if (DualApplet.this.showDualAreaMinimizingPoints) {
                    double initialDelta = 0.001;
                    double[] pointThatMinimizesDualArea = Minimizer.minimize(new Minimizer.VectorFunction(this){
                        final /* synthetic */ DualAppletCanvas this$0;

                        public final double apply(double[] v) {
                            double[][] dualVerts = DualApplet.calcReciprocalVerts(this.this$0.DualApplet.this.verts, v, 1.0);
                            return Math.abs(DualApplet.calcArea(dualVerts));
                        }
                        {
                            this.this$0 = dualAppletCanvas;
                        }
                    }, DualApplet.this.center, initialDelta, 500);
                    double[] pointThatMinimizesDualDualArea = Minimizer.minimize(new Minimizer.VectorFunction(this, dualVerts){
                        final /* synthetic */ DualAppletCanvas this$0;
                        final /* synthetic */ double[][] val$dualVerts;

                        public final double apply(double[] v) {
                            double[][] dualDualVerts = DualApplet.calcReciprocalVerts(this.val$dualVerts, v, 1.0);
                            return Math.abs(DualApplet.calcArea(dualDualVerts));
                        }
                        {
                            this.this$0 = dualAppletCanvas;
                            this.val$dualVerts = dArray;
                        }
                    }, DualApplet.this.center, initialDelta, 500);
                    g.setColor(Color.red);
                    this.drawStringCentered(g, "a", pointThatMinimizesDualArea);
                    g.setColor(Color.green);
                    this.drawStringCentered(g, "a", pointThatMinimizesDualDualArea);
                }
                if (DualApplet.this.showHalfAngleArcsCG) {
                    Arc[] arcs = DualApplet.calcAngleChangeArcs(DualApplet.this.verts, dualVerts, DualApplet.this.center, radius, true);
                    double[] primalCG = VecMath.zerovec(2);
                    double[] dualCG = VecMath.zerovec(2);
                    double primalAngleSum = 0.0;
                    double dualAngleSum = 0.0;
                    double[] temp = new double[2];
                    i = 0;
                    while (true) {
                        if (i >= DualApplet.this.verts.length) {
                            VecMath.vxs(primalCG, primalCG, 1.0 / primalAngleSum);
                            VecMath.vxs(dualCG, dualCG, 1.0 / dualAngleSum);
                            double[] avgCG = VecMath.lerp(primalCG, dualCG, 0.5);
                            g.setColor(Color.red);
                            this.drawStringCentered(g, "h", primalCG);
                            g.setColor(Color.green);
                            this.drawStringCentered(g, "h", dualCG);
                            g.setColor(Color.yellow);
                            this.drawStringCentered(g, "h", avgCG);
                            break;
                        }
                        Arc arc = arcs[2 * i];
                        arc.calcCG(temp);
                        double arcLength = Math.abs(arc.ang1 - arc.ang0);
                        primalAngleSum += arcLength;
                        VecMath.vpsxv(primalCG, primalCG, arcLength, temp);
                        arc = arcs[2 * i + 1];
                        arc.calcCG(temp);
                        arcLength = Math.abs(arc.ang1 - arc.ang0);
                        dualAngleSum += arcLength;
                        VecMath.vpsxv(dualCG, dualCG, arcLength, temp);
                        ++i;
                    }
                }
            }
            if (DualApplet.this.verts.length == 3 && DualApplet.this.showETCcenter) {
                double[] primalCG = ETC.calcCenter(DualApplet.this.ETCindex[0], DualApplet.this.ETCindex[1], DualApplet.this.ETCindex[2], DualApplet.this.verts[0], DualApplet.this.verts[1], DualApplet.this.verts[2]);
                double[] dualCG = ETC.calcCenter(DualApplet.this.ETCindex[0], DualApplet.this.ETCindex[1], DualApplet.this.ETCindex[2], dualVerts[0], dualVerts[1], dualVerts[2]);
                double[] avg = VecMath.lerp(primalCG, dualCG, 0.5);
                System.out.println("primalCG = " + VecMath.toString(primalCG));
                System.out.println("dualCG = " + VecMath.toString(dualCG));
                String label = "" + DualApplet.this.ETCindex[0];
                g.setColor(Color.red);
                this.drawStringCentered(g, label, primalCG);
                g.setColor(Color.green);
                this.drawStringCentered(g, label, dualCG);
                g.setColor(Color.yellow);
                this.drawStringCentered(g, label, avg);
            }
            g.setColor(Color.white);
            this.drawDot(g, DualApplet.this.center, 3);
            g.setColor(Color.red);
            g.drawString("Primal polygon", 10, this.size().height - 30 - (int)(1.5 * (double)g.getFontMetrics().getHeight()));
            g.setColor(Color.green);
            g.drawString("Dual polygon", 10, this.size().height - 30);
            if (g != frontBufferGraphics) {
                frontBufferGraphics.drawImage(DualApplet.this.backBufferImage, 0, 0, this);
            }
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("out paint");
            }
        }

        private final void drawPlus(Graphics g, double[] v, int width) {
            if (v == null) {
                return;
            }
            Dimension size = this.size();
            double centerX = 0.5 * (double)size.width + 0.5;
            double centerY = 0.5 * (double)size.height + 0.5;
            g.fillRect((int)(centerX + v[0]) - width / 2, (int)(centerY + v[1]), width, 1);
            g.fillRect((int)(centerX + v[0]), (int)(centerY + v[1]) - width / 2, 1, width);
        }

        private final void drawDot(Graphics g, double[] v, int width) {
            if (v == null) {
                return;
            }
            Dimension size = this.size();
            double centerX = 0.5 * (double)size.width + 0.5;
            double centerY = 0.5 * (double)size.height + 0.5;
            g.fillRect((int)(centerX + v[0]) - width / 2, (int)(centerY + v[1]) - width / 2, width, width);
        }

        private final void drawSlash(Graphics g, double[] v, int width) {
            if (v == null) {
                return;
            }
            Dimension size = this.size();
            double centerX = 0.5 * (double)size.width + 0.5;
            double centerY = 0.5 * (double)size.height + 0.5;
            g.drawLine((int)(centerX + v[0]) - width / 2, (int)(centerY + v[1]) + width / 2, (int)(centerX + v[0]) + width / 2, (int)(centerY + v[1]) - width / 2);
        }

        private final void drawCurl(Graphics g, double[] v, int width) {
            if (v == null) {
                return;
            }
            Dimension size = this.size();
            double centerX = 0.5 * (double)size.width + 0.5;
            double centerY = 0.5 * (double)size.height + 0.5;
            if (width != 7) {
                throw new Error("Assertion failed at DualApplet.prejava(2506): width == 7");
            }
            int[][] nArrayArray = new int[13][];
            int[] nArray = new int[2];
            nArray[0] = -3;
            nArrayArray[0] = nArray;
            nArrayArray[1] = new int[]{-3, 1};
            nArrayArray[2] = new int[]{-2, 2};
            nArrayArray[3] = new int[]{-1, 3};
            int[] nArray2 = new int[2];
            nArray2[1] = 3;
            nArrayArray[4] = nArray2;
            nArrayArray[5] = new int[]{1, 3};
            nArrayArray[6] = new int[]{2, 2};
            nArrayArray[7] = new int[]{2, -2};
            nArrayArray[8] = new int[]{1, -3};
            int[] nArray3 = new int[2];
            nArray3[1] = -3;
            nArrayArray[9] = nArray3;
            nArrayArray[10] = new int[]{-1, -3};
            nArrayArray[11] = new int[]{-2, -2};
            nArrayArray[12] = new int[]{-3, -1};
            int[][] offsets = nArrayArray;
            int x = (int)(centerX + v[0]);
            int y = (int)(centerY + v[1]);
            int i = 0;
            while (i < offsets.length) {
                g.fillRect(x + offsets[i][0], y + offsets[i][1], 1, 1);
                ++i;
            }
        }

        private final void drawRect(Graphics g, double[] v, int width) {
            if (v == null) {
                return;
            }
            Dimension size = this.size();
            double centerX = 0.5 * (double)size.width + 0.5;
            double centerY = 0.5 * (double)size.height + 0.5;
            g.drawRect((int)(centerX + v[0]) - width / 2, (int)(centerY + v[1]) - width / 2, width - 1, width - 1);
        }

        private final void drawHollowDot(Graphics g, double[] v, int width) {
            if (v == null) {
                return;
            }
            Dimension size = this.size();
            double centerX = 0.5 * (double)size.width + 0.5;
            double centerY = 0.5 * (double)size.height + 0.5;
            g.fillRect((int)(centerX + v[0]) - width / 2 + 1, (int)(centerY + v[1]) - width / 2, width - 2, 1);
            g.fillRect((int)(centerX + v[0]) - width / 2 + 1, (int)(centerY + v[1]) - width / 2 + width - 1, width - 2, 1);
            g.fillRect((int)(centerX + v[0]) - width / 2, (int)(centerY + v[1]) - width / 2 + 1, 1, width - 2);
            g.fillRect((int)(centerX + v[0]) - width / 2 + width - 1, (int)(centerY + v[1]) - width / 2 + 1, 1, width - 2);
        }

        private final void drawLine(Graphics g, double[] v0, double[] v1) {
            DualApplet.drawLine_(g, this.size(), v0, v1);
        }

        private final void drawArrow(Graphics g, double[] tail, double[] unitDir, double arrowLength, double headLength) {
            DualApplet.drawArrow_(g, this.size(), tail, unitDir, arrowLength, headLength);
        }

        private final void drawCircle(Graphics g, double[] center, double radius) {
            Dimension size = this.size();
            double centerX = 0.5 * (double)size.width + 0.5;
            double centerY = 0.5 * (double)size.height + 0.5;
            g.drawArc((int)(centerX + center[0] - radius), (int)(centerY + center[1] - radius), (int)((double)2 * radius), (int)((double)2 * radius), 0, 360);
        }

        private final void drawStringCentered(Graphics g, String s, double[] v) {
            if (v == null) {
                return;
            }
            Dimension size = this.size();
            double centerX = 0.5 * (double)size.width + 0.5;
            double centerY = 0.5 * (double)size.height + 0.5;
            FontMetrics fm = g.getFontMetrics();
            g.drawString(s, (int)(centerX + v[0] - (double)fm.stringWidth(s) * 0.5), (int)(centerY + v[1] - (double)fm.getHeight() * 0.5 + (double)fm.getAscent() + (double)fm.getLeading()));
        }

        private final void drawString(Graphics g, String s, double[] v) {
            if (v == null) {
                return;
            }
            Dimension size = this.size();
            double centerX = 0.5 * (double)size.width + 0.5;
            double centerY = 0.5 * (double)size.height + 0.5;
            g.drawString(s, (int)(centerX + v[0]), (int)(centerY + v[1]));
        }

        private final void drawArcs(Graphics g, Arc[] arcs, Color evenColor, Color oddColor) {
            Dimension size = this.size();
            double centerX = 0.5 * (double)size.width + 0.5;
            double centerY = 0.5 * (double)size.height + 0.5;
            int n = arcs.length;
            int i = 0;
            while (i < n) {
                if ((i & 1) == 0) {
                    g.setColor(evenColor);
                } else {
                    g.setColor(oddColor);
                }
                Arc arc = arcs[i];
                double ang0 = arc.ang0;
                double ang1 = arc.ang1;
                double radius = arc.radius;
                ang0 = -ang0;
                ang1 = -ang1;
                g.drawArc((int)(centerX + arc.centerX - radius), (int)(centerY + arc.centerY - radius), (int)((double)2 * radius), (int)((double)2 * radius), (int)(ang0 * 57.29577951308232), (int)((ang1 - ang0) * 57.29577951308232));
                ++i;
            }
        }

        private final void drawDirectionsGraph(Graphics g, double[] center, double[][] verts, double[][] dualVerts, double x0, double x1, double y0, double y1) {
            int n = verts.length;
            if (n < 2) {
                return;
            }
            double[] dirs = new double[n + 1];
            double[] dualDirs = new double[n + 1];
            int i = 0;
            while (i < n) {
                dirs[i] = Math.atan2(verts[i][1] - center[1], verts[i][0] - center[0]);
                dualDirs[i] = Math.atan2(dualVerts[i][1] - center[1], dualVerts[i][0] - center[0]);
                ++i;
            }
            dirs[n] = dirs[0];
            dualDirs[n] = dualDirs[0];
            i = 0;
            while (i < n) {
                if (dirs[i + 1] > dirs[i] + Math.PI) {
                    int n2 = i + 1;
                    dirs[n2] = dirs[n2] - Math.PI * 2;
                } else if (dirs[i + 1] < dirs[i] - Math.PI) {
                    int n3 = i + 1;
                    dirs[n3] = dirs[n3] + Math.PI * 2;
                }
                if (dualDirs[i + 1] > dualDirs[i] + Math.PI) {
                    int n4 = i + 1;
                    dualDirs[n4] = dualDirs[n4] - Math.PI * 2;
                } else if (dualDirs[i + 1] < dualDirs[i] - Math.PI) {
                    int n5 = i + 1;
                    dualDirs[n5] = dualDirs[n5] + Math.PI * 2;
                }
                ++i;
            }
            double dir0 = VecMath.min(dirs);
            double dir1 = VecMath.max(dirs);
            double dualDir0 = VecMath.min(dualDirs);
            double dualDir1 = VecMath.max(dualDirs);
            double xscale = (x1 - x0) / (dir1 - dir0);
            double yscale = (y1 - y0) / (dualDir1 - dualDir0);
            g.setColor(Color.red);
            i = 0;
            while (i < n) {
                g.drawLine((int)(x0 + (dirs[i] - dir0) * xscale - 0.5), (int)(y0 + (dualDirs[i] - dualDir0) * yscale - 0.5), (int)(x0 + (dirs[i + 1] - dir0) * xscale - 0.5), (int)(y0 + (dualDirs[i] - dualDir0) * yscale - 0.5));
                ++i;
            }
            g.setColor(Color.green);
            i = 0;
            while (i < n) {
                g.drawLine((int)(x0 + (dirs[i + 1] - dir0) * xscale - 0.5), (int)(y0 + (dualDirs[i] - dualDir0) * yscale - 0.5), (int)(x0 + (dirs[i + 1] - dir0) * xscale - 0.5), (int)(y0 + (dualDirs[i + 1] - dualDir0) * yscale - 0.5));
                ++i;
            }
        }

        private final void makeSureBackBufferIsRight() {
            if (DualApplet.this.doDoubleBuffer) {
                Dimension size = this.size();
                if (DualApplet.this.backBufferImage == null || DualApplet.this.backBufferImage.getWidth(this) != size.width || DualApplet.this.backBufferImage.getHeight(this) != size.height) {
                    if (DualApplet.this.eventVerbose >= 1) {
                        System.out.println("Creating back buffer " + size.width + 'x' + size.height);
                    }
                    DualApplet.this.backBufferImage = this.createImage(size.width, size.height);
                }
            } else {
                DualApplet.this.backBufferImage = null;
            }
        }

        static /* synthetic */ void access$0(DualAppletCanvas dualAppletCanvas, Graphics graphics, double[] dArray, int n) {
            dualAppletCanvas.drawHollowDot(graphics, dArray, n);
        }

        static /* synthetic */ void access$1(DualAppletCanvas dualAppletCanvas, Graphics graphics, String string, double[] dArray) {
            dualAppletCanvas.drawStringCentered(graphics, string, dArray);
        }

        static /* synthetic */ void access$2(DualAppletCanvas dualAppletCanvas, Graphics graphics, double[] dArray, int n) {
            dualAppletCanvas.drawDot(graphics, dArray, n);
        }

        static /* synthetic */ void access$3(DualAppletCanvas dualAppletCanvas, Graphics graphics, double[] dArray, int n) {
            dualAppletCanvas.drawSlash(graphics, dArray, n);
        }

        static /* synthetic */ void access$4(DualAppletCanvas dualAppletCanvas, Graphics graphics, double[] dArray, int n) {
            dualAppletCanvas.drawRect(graphics, dArray, n);
        }

        static /* synthetic */ void access$5(DualAppletCanvas dualAppletCanvas, Graphics graphics, double[] dArray, int n) {
            dualAppletCanvas.drawCurl(graphics, dArray, n);
        }

        static /* synthetic */ void access$6(DualAppletCanvas dualAppletCanvas, Graphics graphics, double[] dArray, int n) {
            dualAppletCanvas.drawPlus(graphics, dArray, n);
        }

        private final /* synthetic */ void this() {
            this.requestedFocusYet = false;
        }

        DualAppletCanvas() {
            this.this();
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("in DualAppletCanvas()");
            }
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addKeyListener(this);
            if (DualApplet.this.eventVerbose >= 1) {
                System.out.println("out DualAppletCanvas()");
            }
        }
    }

    static class Arc {
        public double centerX;
        public double centerY;
        public double radius;
        public double ang0;
        public double ang1;

        public void calcCG(double[] result) {
            VecMath.zerovec(result);
            double halfAngleDiff = (this.ang0 - this.ang1) * 0.5;
            double ang = (this.ang0 + this.ang1) * 0.5;
            double frac = Math.sin(halfAngleDiff) / halfAngleDiff;
            result[0] = this.centerX + this.radius * frac * Math.cos(ang);
            result[1] = this.centerY + this.radius * frac * Math.sin(ang);
        }

        Arc() {
        }
    }

    static class MyCGComponents {
        int n;
        public double[][] verts;
        public double[] logMeanDists;
        public double[] angles;
        public double[] centroidLengths;
        public double[][] centroidDirs;

        MyCGComponents(int n) {
            this.n = n;
            this.verts = new double[n][2];
            this.logMeanDists = new double[2 * n];
            this.angles = new double[2 * n];
            this.centroidLengths = new double[2 * n];
            this.centroidDirs = new double[2 * n][2];
        }
    }

    private static abstract class VectorFunctionWithVertsParam {
        public abstract double apply(double[] var1, double[] var2, double[][] var3, int var4, double var5);

        private VectorFunctionWithVertsParam() {
        }
    }

    private static class dualCGOfVertsFunction
    extends VectorFunctionWithVertsParam {
        public double apply(double[] result, double[] center, double[][] verts, int radiusMethod, double radiusIfConstant) {
            return dualCGOfVertsFunction.apply_static(result, center, verts, radiusMethod, radiusIfConstant);
        }

        public static double apply_static(double[] result, double[] center, double[][] verts, int radiusMethod, double radiusIfConstant) {
            double radius = DualApplet.calcReciprocationRadius(verts, center, radiusMethod, radiusIfConstant);
            double[][] dualVerts = DualApplet.calcReciprocalVerts(verts, center, radius);
            VecMath.average(result, dualVerts);
            double minDistanceSquaredToEdge = Double.POSITIVE_INFINITY;
            int i = 0;
            while (i < verts.length) {
                double distSqrdToThisEdge = radius * radius * radius * radius / VecMath.distsqrd(dualVerts[i], center);
                minDistanceSquaredToEdge = Math.min(minDistanceSquaredToEdge, distSqrdToThisEdge);
                ++i;
            }
            return minDistanceSquaredToEdge;
        }

        private dualCGOfVertsFunction() {
        }
    }

    private static class dualCGOfCurvatureFunction
    extends VectorFunctionWithVertsParam {
        public double apply(double[] result, double[] center, double[][] verts, int radiusMethod, double radiusIfConstant) {
            return dualCGOfCurvatureFunction.apply_static(result, center, verts, radiusMethod, radiusIfConstant);
        }

        public static double apply_static(double[] result, double[] center, double[][] verts, int radiusMethod, double radiusIfConstant) {
            double radius = DualApplet.calcReciprocationRadius(verts, center, radiusMethod, radiusIfConstant);
            double[][] dualVerts = DualApplet.calcReciprocalVerts(verts, center, radius);
            double[] curvatureAvg = DualApplet.calcCurvatureAvg(dualVerts);
            if (curvatureAvg == null) {
                VecMath.zerovec(result);
                return Double.NaN;
            }
            VecMath.copyvec(result, curvatureAvg);
            double minDistanceSquaredToEdge = Double.POSITIVE_INFINITY;
            int i = 0;
            while (i < verts.length) {
                double distSqrdToThisEdge = radius * radius * radius * radius / VecMath.distsqrd(dualVerts[i], center);
                minDistanceSquaredToEdge = Math.min(minDistanceSquaredToEdge, distSqrdToThisEdge);
                ++i;
            }
            return minDistanceSquaredToEdge;
        }

        private dualCGOfCurvatureFunction() {
        }
    }

    private static class dualMyCGFunction
    extends VectorFunctionWithVertsParam {
        public double apply(double[] result, double[] center, double[][] verts, int radiusMethod, double radiusIfConstant) {
            return dualMyCGFunction.apply_static(result, center, verts, radiusMethod, radiusIfConstant);
        }

        public static double apply_static(double[] result, double[] center, double[][] verts, int radiusMethod, double radiusIfConstant) {
            double radius = DualApplet.calcReciprocationRadius(verts, center, radiusMethod, radiusIfConstant);
            double[][] dualVerts = DualApplet.calcReciprocalVerts(verts, center, radius);
            double[] avg = DualApplet.calcMyCG(dualVerts, center, radius, false, null);
            if (avg == null) {
                VecMath.zerovec(result);
                return Double.NaN;
            }
            VecMath.copyvec(result, avg);
            double minDistanceSquaredToEdge = Double.POSITIVE_INFINITY;
            int i = 0;
            while (i < verts.length) {
                double distSqrdToThisEdge = radius * radius * radius * radius / VecMath.distsqrd(dualVerts[i], center);
                minDistanceSquaredToEdge = Math.min(minDistanceSquaredToEdge, distSqrdToThisEdge);
                ++i;
            }
            return minDistanceSquaredToEdge;
        }

        private dualMyCGFunction() {
        }
    }

    private static class Frame_
    extends Frame {
        protected void init() {
        }

        public Frame_() {
            this.init();
        }

        public Frame_(String title) {
            super(title);
            this.init();
        }
    }

    class Checkbox_
    extends Checkbox {
        protected void init() {
        }

        Checkbox_(String s, boolean state) {
            super(s, state);
            this.init();
        }

        Checkbox_(String s, CheckboxGroup cbg, boolean state) {
            super(s, cbg, state);
            this.init();
        }
    }

    private static class Button_
    extends Button {
        protected void init() {
        }

        Button_(String s) {
            super(s);
            this.init();
        }
    }

    private static class Canvas_
    extends Canvas {
        protected void init() {
        }

        Canvas_() {
            this.init();
        }
    }

    private static class Choice_
    extends Choice {
        protected void init() {
        }

        Choice_() {
            this.init();
        }
    }
}

