#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "GL/glut.h"

float	sceneRot = 0.0f;
float	sceneTrans = 20.0f;
int 	winWidth, winHeight;

void init(void)
{
    float light0Pos[4] = {1.0f, 1.0f, 1.0f, 0.0f};

    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);
    glLightfv(GL_LIGHT0, GL_POSITION, light0Pos);

    glEnable(GL_DEPTH_TEST);

    glEnable(GL_COLOR_MATERIAL);
    glEnable(GL_NORMALIZE);
    glColorMaterial(GL_FRONT_AND_BACK, GL_DIFFUSE);

    glClearColor(0.1f, 0.1f, 0.2f, 0.0f);
}

void drawTeapot(float x, float y, float z)
{
    glPushMatrix();
    glTranslatef(x, y, z);
    glutSolidTeapot(1);
    glPopMatrix();
}

extern void redraw(void);

void startViewing(float sceneRot, float sceneTrans);

void finishViewing(void);

void maindraw(void)
{
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	startViewing(sceneRot, sceneTrans);

    redraw();

	finishViewing();

    glutSwapBuffers();
}


static int ox, oy;


void button(int b, int state, int x, int y)
{
    ox = x;
    oy = y;
}


void motion(int x, int y)
{
    int dx, dy;

    dx = x - ox;
    dy = y - oy;

    ox = x;
    oy = y;

    sceneRot += 360 * (dx / 2400.0f);
    sceneTrans -= 5 * (dy / 600.0f);
    glutPostRedisplay();
}


void reshape(int width, int height)
{
    glViewport(0, 0, width, height);
    winWidth = width;
    winHeight = height;
    glutPostRedisplay();
}

int isFlatShaded = 0;
int isWireframe = 0;

void keyboard(unsigned char key, int x, int y);

int main(int argc, char **argv)
{
    glutInit(&argc, argv);
    glutInitWindowSize(512,512);
    glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH);
    glutCreateWindow("lab 1");
    glutDisplayFunc(maindraw);
    glutKeyboardFunc(keyboard);
    glutMotionFunc(motion);
    glutMouseFunc(button);
    glutReshapeFunc(reshape);

    init();
    glutMainLoop();
    return(0);
}